/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.web.struts.form.pojo;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kns.web.struts.form.pojo.PojoPlugin;
import org.kuali.rice.kns.web.struts.form.pojo.PojoPropertyUtilsBean;
import org.kuali.rice.krad.bo.DocumentAttachment;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.util.ObjectUtils;

public class PojoPluginTest {
    @Test
    public void testGetChildCollectionThrowsNestedNullException() throws Exception {
        new PojoPlugin().init(null, (ModuleConfig)new ModuleConfigImpl());
        TestCollectionHolderHolder tchh = new TestCollectionHolderHolder();
        tchh.setTch(new TestCollectionHolder());
        Object result = ObjectUtils.getPropertyValue((Object)((Object)tchh), (String)"tch.collection");
        Assert.assertFalse((boolean)"".equals(result));
        Assert.assertTrue((null == result ? 1 : 0) != 0);
    }

    @Test
    public void testNestedNullIsWriteable() throws Exception {
        new PojoPlugin().init(null, (ModuleConfig)new ModuleConfigImpl());
        TestCollectionHolderHolder tchh = new TestCollectionHolderHolder();
        Assert.assertTrue((boolean)PropertyUtils.isWriteable((Object)((Object)tchh), (String)"tch2.collection"));
    }

    @Test
    public void testGenerateIndexedPropertyNonPBO() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        IndexOutOfBoundsException ioobe = new IndexOutOfBoundsException("test exception");
        try {
            new PojoPropertyUtilsBean().generateIndexedProperty((Object)new TestCollectionHolder(), "collection", 0, ioobe);
            Assert.fail((String)"Expected to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)ioobe, (Object)e);
        }
    }

    @Test
    public void testGenerateIndexedPropertyNonList() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        IndexOutOfBoundsException ioobe = new IndexOutOfBoundsException("test exception");
        try {
            new PojoPropertyUtilsBean().generateIndexedProperty((Object)new DocumentAttachment(), "attachmentContent", 0, ioobe);
            Assert.fail((String)"Expected to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)ioobe, (Object)e);
        }
    }

    @Test
    public void testUndefinedOJBClass() {
        HashMap notAnOjbObject = new HashMap();
        PojoPropertyUtilsBean.PersistenceStructureServiceProvider.persistenceStructureService = (PersistenceStructureService)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{PersistenceStructureService.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("listCollectionObjectTypes".equals(method.getName())) {
                    return new HashMap();
                }
                return null;
            }
        });
        Assert.assertNull((Object)new PojoPropertyUtilsBean.PersistenceStructureServiceProvider().getCollectionItemClass(notAnOjbObject, "abcd"));
    }

    public static class TestCollectionHolder2
    extends PersistableBusinessObjectBase {
        private Collection collection = Collections.emptyList();

        public Collection getCollection() {
            return this.collection;
        }

        public void setCollection(Collection collection) {
            this.collection = collection;
        }
    }

    public static class TestCollectionHolder
    extends PersistableBusinessObjectBase {
        private Collection collection = Collections.emptyList();

        public Collection getCollection() {
            throw new NestedNullException();
        }

        public void setCollection(Collection collection) {
            this.collection = collection;
        }
    }

    public static class TestCollectionHolderHolder
    extends PersistableBusinessObjectBase {
        private TestCollectionHolder tch = null;
        private TestCollectionHolder2 tch2;

        public TestCollectionHolder getTch() {
            return this.tch;
        }

        public void setTch(TestCollectionHolder tch) {
            this.tch = tch;
        }

        public TestCollectionHolder2 getTch2() {
            return this.tch2;
        }

        public void setTch2(TestCollectionHolder2 tch2) {
            this.tch2 = tch2;
        }
    }
}

