/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableFieldDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.rice.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.datadictionary.AttributeSecurity;
import org.kuali.rice.krad.lookup.SelectiveReferenceRefresher;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiExceptionIncidentService;
import org.kuali.rice.krad.service.MaintenanceDocumentService;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;

public final class MaintenanceUtils {
    private static final Logger LOG = Logger.getLogger(MaintenanceUtils.class);
    private static MaintenanceDocumentService maintenanceDocumentService;
    private static WorkflowDocumentService workflowDocumentService;
    private static ConfigurationService kualiConfigurationService;
    private static KualiExceptionIncidentService kualiExceptionIncidentService;
    private static MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;
    private static DataDictionaryService dataDictionaryService;

    private MaintenanceUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static Map<String, String> generateMultipleValueLookupBOTemplate(List<MaintainableSectionDefinition> sections, String collectionName) {
        MaintainableCollectionDefinition definition = MaintenanceUtils.findMaintainableCollectionDefinition(sections, collectionName);
        if (definition == null) {
            return null;
        }
        HashMap<String, String> template = null;
        for (MaintainableFieldDefinition maintainableField : definition.getMaintainableFields()) {
            String templateString = maintainableField.getTemplate();
            if (!StringUtils.isNotBlank((String)templateString)) continue;
            if (template == null) {
                template = new HashMap<String, String>();
            }
            template.put(maintainableField.getName(), templateString);
        }
        return template;
    }

    public static MaintainableCollectionDefinition findMaintainableCollectionDefinition(List<MaintainableSectionDefinition> sections, String collectionName) {
        String[] collectionNameParts = StringUtils.split((String)collectionName, (String)".");
        for (MaintainableSectionDefinition section : sections) {
            MaintainableCollectionDefinition collDefinition = MaintenanceUtils.findMaintainableCollectionDefinitionHelper(section.getMaintainableItems(), collectionNameParts, 0);
            if (collDefinition == null) continue;
            return collDefinition;
        }
        return null;
    }

    private static <E extends MaintainableItemDefinition> MaintainableCollectionDefinition findMaintainableCollectionDefinitionHelper(Collection<E> items, String[] collectionNameParts, int collectionNameIndex) {
        if (collectionNameParts.length <= collectionNameIndex) {
            return null;
        }
        String collectionToFind = StringUtils.substringBefore((String)collectionNameParts[collectionNameIndex], (String)"[");
        for (MaintainableItemDefinition item : items) {
            MaintainableCollectionDefinition collection;
            if (!(item instanceof MaintainableCollectionDefinition) || !(collection = (MaintainableCollectionDefinition)item).getName().equals(collectionToFind)) continue;
            if (collectionNameIndex == collectionNameParts.length - 1) {
                return collection;
            }
            return MaintenanceUtils.findMaintainableCollectionDefinitionHelper(collection.getMaintainableCollections(), collectionNameParts, collectionNameIndex + 1);
        }
        return null;
    }

    public static final Field setFieldQuickfinder(BusinessObject businessObject, String attributeName, MaintainableFieldDefinition maintainableFieldDefinition, Field field, List<String> displayedFieldNames, SelectiveReferenceRefresher srr) {
        if (maintainableFieldDefinition.getOverrideLookupClass() != null && StringUtils.isNotBlank((String)maintainableFieldDefinition.getOverrideFieldConversions())) {
            field.setQuickFinderClassNameImpl(maintainableFieldDefinition.getOverrideLookupClass().getName());
            field.setFieldConversions(maintainableFieldDefinition.getOverrideFieldConversions());
            field.setBaseLookupUrl(LookupUtils.getBaseLookupUrl(false));
            field.setReferencesToRefresh(LookupUtils.convertReferencesToSelectCollectionToString(srr.getAffectedReferencesFromLookup(businessObject, attributeName, "")));
            return field;
        }
        if (maintainableFieldDefinition.isNoLookup()) {
            return field;
        }
        return LookupUtils.setFieldQuickfinder(businessObject, null, false, 0, attributeName, field, displayedFieldNames, maintainableFieldDefinition.isNoLookup());
    }

    public static final Field setFieldQuickfinder(BusinessObject businessObject, String collectionName, boolean addLine, int index, String attributeName, Field field, List<String> displayedFieldNames, Maintainable maintainable, MaintainableFieldDefinition maintainableFieldDefinition) {
        if (maintainableFieldDefinition.getOverrideLookupClass() != null && StringUtils.isNotBlank((String)maintainableFieldDefinition.getOverrideFieldConversions())) {
            if (maintainable != null) {
                String collectionPrefix = "";
                if (collectionName != null) {
                    collectionPrefix = addLine ? "add." + collectionName + "." : collectionName + "[" + index + "].";
                }
                field.setQuickFinderClassNameImpl(maintainableFieldDefinition.getOverrideLookupClass().getName());
                String prefixedFieldConversions = MaintenanceUtils.prefixFieldConversionsDestinationsWithCollectionPrefix(maintainableFieldDefinition.getOverrideFieldConversions(), collectionPrefix);
                field.setFieldConversions(prefixedFieldConversions);
                field.setBaseLookupUrl(LookupUtils.getBaseLookupUrl(false));
                field.setReferencesToRefresh(LookupUtils.convertReferencesToSelectCollectionToString(maintainable.getAffectedReferencesFromLookup(businessObject, attributeName, collectionPrefix)));
            }
            return field;
        }
        if (maintainableFieldDefinition.isNoLookup()) {
            return field;
        }
        return LookupUtils.setFieldQuickfinder(businessObject, collectionName, addLine, index, attributeName, field, displayedFieldNames, maintainable);
    }

    private static String prefixFieldConversionsDestinationsWithCollectionPrefix(String originalFieldConversions, String collectionPrefix) {
        StringBuilder buf = new StringBuilder();
        StringTokenizer tok = new StringTokenizer(originalFieldConversions, ",");
        boolean needsSeparator = false;
        while (tok.hasMoreTokens()) {
            String conversionPair = tok.nextToken();
            if (StringUtils.isBlank((String)conversionPair)) continue;
            String fromValue = StringUtils.substringBefore((String)conversionPair, (String)":");
            String toValue = StringUtils.substringAfter((String)conversionPair, (String)":");
            if (needsSeparator) {
                buf.append(",");
            }
            needsSeparator = true;
            buf.append(fromValue).append(":").append(collectionPrefix).append(toValue);
        }
        return buf.toString();
    }

    public static final void setFieldDirectInquiry(BusinessObject businessObject, String attributeName, MaintainableFieldDefinition maintainableFieldDefinition, Field field, List<String> displayedFieldNames) {
        LookupUtils.setFieldDirectInquiry(businessObject, attributeName, field);
    }

    public static final void setFieldDirectInquiry(BusinessObject businessObject, String collectionName, boolean addLine, int index, String attributeName, Field field, List<String> displayedFieldNames, Maintainable maintainable, MaintainableFieldDefinition maintainableFieldDefinition) {
        LookupUtils.setFieldDirectInquiry(businessObject, attributeName, field);
    }

    public static String generateErrorKeyForSection(Section section) {
        HashSet<String> fieldPropertyNames = new HashSet<String>();
        MaintenanceUtils.addRowsToErrorKeySet(section.getRows(), fieldPropertyNames);
        StringBuilder buf = new StringBuilder();
        buf.append(section.getSectionId()).append(",");
        Iterator nameIter = fieldPropertyNames.iterator();
        while (nameIter.hasNext()) {
            buf.append((String)nameIter.next());
            if (!nameIter.hasNext()) continue;
            buf.append(",");
        }
        if (section.getContainedCollectionNames() != null && section.getContainedCollectionNames().size() > 0) {
            buf.append(",");
            Iterator<String> collectionIter = section.getContainedCollectionNames().iterator();
            while (collectionIter.hasNext()) {
                buf.append("document.newMaintainableObject." + collectionIter.next());
                if (!collectionIter.hasNext()) continue;
                buf.append(",");
            }
        }
        return buf.toString();
    }

    protected static void addRowsToErrorKeySet(List<Row> listOfRows, Set<String> errorKeys) {
        if (listOfRows == null) {
            return;
        }
        for (Row row : listOfRows) {
            List<Field> fields = row.getFields();
            if (fields == null) continue;
            for (Field field : fields) {
                String fieldPropertyName = field.getPropertyName();
                if (fieldPropertyName != null && fieldPropertyName.startsWith("document.newMaintainableObject.")) {
                    errorKeys.add(field.getPropertyName());
                }
                MaintenanceUtils.addRowsToErrorKeySet(field.getContainerRows(), errorKeys);
            }
        }
    }

    public static void checkForLockingDocument(Maintainable maintainable, boolean throwExceptionIfLocked) {
        LOG.info((Object)"starting checkForLockingDocument (by Maintainable)");
        String blockingDocId = maintainable.getLockingDocumentId();
        org.kuali.rice.krad.maintenance.MaintenanceUtils.checkDocumentBlockingDocumentId((String)blockingDocId, (boolean)throwExceptionIfLocked);
    }

    private static MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        if (maintenanceDocumentDictionaryService == null) {
            maintenanceDocumentDictionaryService = KNSServiceLocator.getMaintenanceDocumentDictionaryService();
        }
        return maintenanceDocumentDictionaryService;
    }

    private static DataDictionaryService getDataDictionaryService() {
        if (dataDictionaryService == null) {
            dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return dataDictionaryService;
    }

    public static Map<String, AttributeSecurity> retrievePropertyPathToAttributeSecurityMappings(String docTypeName) {
        HashMap<String, AttributeSecurity> results = new HashMap<String, AttributeSecurity>();
        MaintenanceDocumentEntry entry = MaintenanceUtils.getMaintenanceDocumentDictionaryService().getMaintenanceDocumentEntry(docTypeName);
        String className = entry.getDataObjectClass().getName();
        for (MaintainableSectionDefinition section : entry.getMaintainableSections()) {
            for (MaintainableItemDefinition item : section.getMaintainableItems()) {
                if (item instanceof MaintainableFieldDefinition) {
                    MaintainableFieldDefinition field = (MaintainableFieldDefinition)item;
                    AttributeSecurity attributeSecurity = MaintenanceUtils.getDataDictionaryService().getAttributeSecurity(className, field.getName());
                    if (attributeSecurity == null) continue;
                    results.put(field.getName(), attributeSecurity);
                    continue;
                }
                if (!(item instanceof MaintainableCollectionDefinition)) continue;
                MaintenanceUtils.addMaintenanceDocumentCollectionPathToSecurityMappings(results, "", (MaintainableCollectionDefinition)item);
            }
        }
        return results;
    }

    private static void addMaintenanceDocumentCollectionPathToSecurityMappings(Map<String, AttributeSecurity> mappings, String propertyPathPrefix, MaintainableCollectionDefinition collectionDefinition) {
        propertyPathPrefix = propertyPathPrefix + collectionDefinition.getName() + ".";
        String boClassName = collectionDefinition.getBusinessObjectClass().getName();
        for (MaintainableFieldDefinition field : collectionDefinition.getMaintainableFields()) {
            AttributeSecurity attributeSecurity = MaintenanceUtils.getDataDictionaryService().getAttributeSecurity(boClassName, field.getName());
            if (attributeSecurity == null) continue;
            mappings.put(propertyPathPrefix + field.getName(), attributeSecurity);
        }
        for (MaintainableCollectionDefinition nestedCollection : collectionDefinition.getMaintainableCollections()) {
            MaintenanceUtils.addMaintenanceDocumentCollectionPathToSecurityMappings(mappings, propertyPathPrefix, nestedCollection);
        }
    }

    private static MaintenanceDocumentService getMaintenanceDocumentService() {
        if (maintenanceDocumentService == null) {
            maintenanceDocumentService = KRADServiceLocatorWeb.getMaintenanceDocumentService();
        }
        return maintenanceDocumentService;
    }

    private static WorkflowDocumentService getWorkflowDocumentService() {
        if (workflowDocumentService == null) {
            workflowDocumentService = KRADServiceLocatorWeb.getWorkflowDocumentService();
        }
        return workflowDocumentService;
    }

    private static ConfigurationService getKualiConfigurationService() {
        if (kualiConfigurationService == null) {
            kualiConfigurationService = CoreApiServiceLocator.getKualiConfigurationService();
        }
        return kualiConfigurationService;
    }

    private static KualiExceptionIncidentService getKualiExceptionIncidentService() {
        if (kualiExceptionIncidentService == null) {
            kualiExceptionIncidentService = KRADServiceLocatorWeb.getKualiExceptionIncidentService();
        }
        return kualiExceptionIncidentService;
    }
}

