/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.kim.type;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.beans.PropertyDescriptor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeAttribute;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kns.kim.type.DataDictionaryTypeServiceHelper;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.util.FieldUtils;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.comparator.StringValueComparator;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.ExternalizableBusinessObjectUtils;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.util.AutoPopulatingList;

public class DataDictionaryTypeServiceBase
implements KimTypeService {
    private static final Logger LOG = Logger.getLogger(DataDictionaryTypeServiceBase.class);
    private static final String ANY_CHAR_PATTERN_S = ".*";
    private static final Pattern ANY_CHAR_PATTERN = Pattern.compile(".*");
    private BusinessObjectService businessObjectService;
    private DictionaryValidationService dictionaryValidationService;
    private DataDictionaryService dataDictionaryService;
    private KimTypeInfoService typeInfoService;
    private DocumentTypeService documentTypeService;
    protected static final String COMMA_SEPARATOR = ", ";

    public String getWorkflowDocumentTypeName() {
        return null;
    }

    public List<String> getWorkflowRoutingAttributes(String routeLevel) {
        if (StringUtils.isBlank((String)routeLevel)) {
            throw new RiceIllegalArgumentException("routeLevel was blank or null");
        }
        return Collections.emptyList();
    }

    public List<KimAttributeField> getAttributeDefinitions(String kimTypeId) {
        List<String> uniqueAttributes = this.getUniqueAttributes(kimTypeId);
        ArrayList<AbstractMap.SimpleEntry<String, KimAttributeField>> definitions = new ArrayList<AbstractMap.SimpleEntry<String, KimAttributeField>>();
        KimType kimType = this.getTypeInfoService().getKimType(kimTypeId);
        String nsCode = kimType.getNamespaceCode();
        for (KimTypeAttribute typeAttribute : kimType.getAttributeDefinitions()) {
            KimAttributeField definition = typeAttribute.getKimAttribute().getComponentName() == null ? this.getNonDataDictionaryAttributeDefinition(nsCode, kimTypeId, typeAttribute, uniqueAttributes) : this.getDataDictionaryAttributeDefinition(nsCode, kimTypeId, typeAttribute, uniqueAttributes);
            if (definition == null) continue;
            definitions.add(new AbstractMap.SimpleEntry<String, KimAttributeField>(typeAttribute.getSortCode() != null ? typeAttribute.getSortCode() : "", definition));
        }
        Collections.sort(definitions, new Comparator<Map.Entry<String, KimAttributeField>>(){

            @Override
            public int compare(Map.Entry<String, KimAttributeField> o1, Map.Entry<String, KimAttributeField> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return Collections.unmodifiableList(Lists.transform(definitions, (Function)new Function<Map.Entry<String, KimAttributeField>, KimAttributeField>(){

            public KimAttributeField apply(Map.Entry<String, KimAttributeField> v) {
                return v.getValue();
            }
        }));
    }

    public List<RemotableAttributeError> validateAttributes(String kimTypeId, Map<String, String> attributes) {
        if (StringUtils.isBlank((String)kimTypeId)) {
            throw new RiceIllegalArgumentException("kimTypeId was null or blank");
        }
        if (attributes == null) {
            throw new RiceIllegalArgumentException("attributes was null or blank");
        }
        ArrayList<RemotableAttributeError> validationErrors = new ArrayList<RemotableAttributeError>();
        KimType kimType = this.getTypeInfoService().getKimType(kimTypeId);
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            KimTypeAttribute attr = kimType.getAttributeDefinitionByName(entry.getKey());
            List<RemotableAttributeError> attributeErrors = attr.getKimAttribute().getComponentName() == null ? this.validateNonDataDictionaryAttribute(attr, entry.getKey(), entry.getValue()) : this.validateDataDictionaryAttribute(attr, entry.getKey(), entry.getValue());
            if (attributeErrors == null) continue;
            validationErrors.addAll(attributeErrors);
        }
        List<RemotableAttributeError> referenceCheckErrors = this.validateReferencesExistAndActive(kimType, attributes, validationErrors);
        validationErrors.addAll(referenceCheckErrors);
        return Collections.unmodifiableList(validationErrors);
    }

    public List<RemotableAttributeError> validateAttributesAgainstExisting(String kimTypeId, Map<String, String> newAttributes, Map<String, String> oldAttributes) {
        if (StringUtils.isBlank((String)kimTypeId)) {
            throw new RiceIllegalArgumentException("kimTypeId was null or blank");
        }
        if (newAttributes == null) {
            throw new RiceIllegalArgumentException("newAttributes was null or blank");
        }
        if (oldAttributes == null) {
            throw new RiceIllegalArgumentException("oldAttributes was null or blank");
        }
        return Collections.emptyList();
    }

    protected boolean performMatch(Map<String, String> inputAttributes, Map<String, String> storedAttributes) {
        if (storedAttributes == null || inputAttributes == null) {
            return true;
        }
        for (Map.Entry<String, String> entry : storedAttributes.entrySet()) {
            if (!inputAttributes.containsKey(entry.getKey()) || StringUtils.equals((String)inputAttributes.get(entry.getKey()), (String)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    protected Map<String, String> translateInputAttributes(Map<String, String> qualification) {
        return qualification;
    }

    protected List<RemotableAttributeError> validateReferencesExistAndActive(KimType kimType, Map<String, String> attributes, List<RemotableAttributeError> previousValidationErrors) {
        HashMap<String, BusinessObject> componentClassInstances = new HashMap<String, BusinessObject>();
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        for (String string : attributes.keySet()) {
            KimTypeAttribute attr = kimType.getAttributeDefinitionByName(string);
            if (!StringUtils.isNotBlank((String)attr.getKimAttribute().getComponentName()) || componentClassInstances.containsKey(attr.getKimAttribute().getComponentName())) continue;
            try {
                Class<?> componentClass = Class.forName(attr.getKimAttribute().getComponentName());
                if (!BusinessObject.class.isAssignableFrom(componentClass)) {
                    LOG.warn((Object)("Class " + componentClass.getName() + " does not implement BusinessObject.  Unable to perform reference existence and active validation"));
                    continue;
                }
                BusinessObject componentInstance = (BusinessObject)componentClass.newInstance();
                componentClassInstances.put(attr.getKimAttribute().getComponentName(), componentInstance);
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to instantiate class for attribute: " + string), (Throwable)e);
            }
        }
        for (Map.Entry entry : attributes.entrySet()) {
            if (RemotableAttributeError.containsAttribute((String)((String)entry.getKey()), previousValidationErrors)) continue;
            for (BusinessObject componentInstance : componentClassInstances.values()) {
                try {
                    ObjectUtils.setObjectProperty((Object)componentInstance, (String)((String)entry.getKey()), entry.getValue());
                }
                catch (NoSuchMethodException e) {
                }
                catch (Exception e) {
                    LOG.error((Object)("Unable to set object property class: " + componentInstance.getClass().getName() + " property: " + (String)entry.getKey()), (Throwable)e);
                }
            }
        }
        for (Map.Entry entry : componentClassInstances.entrySet()) {
            List relationships = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry((String)entry.getKey()).getRelationships();
            if (relationships == null && (relationships = this.getDataDictionaryService().getDataDictionary().getDataObjectEntry((String)entry.getKey()).getRelationships()) == null) continue;
            for (RelationshipDefinition relationshipDefinition : relationships) {
                List<String> extractedErrors;
                List primitiveAttributes = relationshipDefinition.getPrimitiveAttributes();
                String attributeToHighlightOnFail = ((PrimitiveAttributeDefinition)primitiveAttributes.get(primitiveAttributes.size() - 1)).getSourceName();
                if (!attributes.containsKey(attributeToHighlightOnFail)) continue;
                KimTypeAttribute attr = kimType.getAttributeDefinitionByName(attributeToHighlightOnFail);
                if (attr != null) {
                    String attributeDisplayLabel = StringUtils.isNotBlank((String)attr.getKimAttribute().getComponentName()) ? this.getDataDictionaryService().getAttributeLabel(attr.getKimAttribute().getComponentName(), attributeToHighlightOnFail) : attr.getKimAttribute().getAttributeLabel();
                    this.getDictionaryValidationService().validateReferenceExistsAndIsActive((BusinessObject)entry.getValue(), relationshipDefinition.getObjectAttributeName(), attributeToHighlightOnFail, attributeDisplayLabel);
                }
                if (!CollectionUtils.isNotEmpty(extractedErrors = this.extractErrorsFromGlobalVariablesErrorMap(attributeToHighlightOnFail))) continue;
                errors.add(RemotableAttributeError.Builder.create((String)attributeToHighlightOnFail, extractedErrors).build());
            }
        }
        return errors;
    }

    protected List<RemotableAttributeError> validateAttributeRequired(String kimTypeId, String objectClassName, String attributeName, Object attributeValue, String errorKey) {
        List<KimAttributeField> map;
        KimAttributeField definition;
        boolean required;
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        if ((attributeValue == null || attributeValue instanceof String && StringUtils.isBlank((String)((String)attributeValue))) && (required = (definition = DataDictionaryTypeServiceHelper.findAttributeField(attributeName, map = this.getAttributeDefinitions(kimTypeId))).getAttributeField().isRequired())) {
            String errorLabel = DataDictionaryTypeServiceHelper.getAttributeErrorLabel(definition);
            errors.add(RemotableAttributeError.Builder.create((String)errorKey, (String[])new String[]{DataDictionaryTypeServiceHelper.createErrorString("error.required", errorLabel)}).build());
        }
        return errors;
    }

    protected List<RemotableAttributeError> validateDataDictionaryAttribute(String kimTypeId, String entryName, Object object, PropertyDescriptor propertyDescriptor) {
        return this.validatePrimitiveFromDescriptor(kimTypeId, entryName, object, propertyDescriptor);
    }

    protected List<RemotableAttributeError> validatePrimitiveFromDescriptor(String kimTypeId, String entryName, Object object, PropertyDescriptor propertyDescriptor) {
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        if (null != propertyDescriptor && this.getDataDictionaryService().isAttributeDefined(entryName, propertyDescriptor.getName()).booleanValue()) {
            Object value = ObjectUtils.getPropertyValue((Object)object, (String)propertyDescriptor.getName());
            Class<?> propertyType = propertyDescriptor.getPropertyType();
            if (TypeUtils.isStringClass(propertyType) || TypeUtils.isIntegralClass(propertyType) || TypeUtils.isDecimalClass(propertyType) || TypeUtils.isTemporalClass(propertyType)) {
                if (value != null && StringUtils.isNotBlank((String)value.toString())) {
                    if (!TypeUtils.isTemporalClass(propertyType)) {
                        errors.addAll(this.validateAttributeFormat(kimTypeId, entryName, propertyDescriptor.getName(), value.toString(), propertyDescriptor.getName()));
                    }
                } else {
                    errors.addAll(this.validateAttributeRequired(kimTypeId, entryName, propertyDescriptor.getName(), value, propertyDescriptor.getName()));
                }
            }
        }
        return errors;
    }

    protected Pattern getAttributeValidatingExpression(KimAttributeField definition) {
        if (definition == null || StringUtils.isBlank((String)definition.getAttributeField().getRegexConstraint())) {
            return ANY_CHAR_PATTERN;
        }
        return Pattern.compile(definition.getAttributeField().getRegexConstraint());
    }

    protected Formatter getAttributeFormatter(KimAttributeField definition) {
        if (definition.getAttributeField().getDataType() == null) {
            return null;
        }
        return Formatter.getFormatter((Class)definition.getAttributeField().getDataType().getType());
    }

    protected Double getAttributeMinValue(KimAttributeField definition) {
        return definition == null ? null : definition.getAttributeField().getMinValue();
    }

    protected Double getAttributeMaxValue(KimAttributeField definition) {
        return definition == null ? null : definition.getAttributeField().getMaxValue();
    }

    protected List<RemotableAttributeError> validateAttributeFormat(String kimTypeId, String objectClassName, String attributeName, String attributeValue, String errorKey) {
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        List<KimAttributeField> attributeDefinitions = this.getAttributeDefinitions(kimTypeId);
        KimAttributeField definition = DataDictionaryTypeServiceHelper.findAttributeField(attributeName, attributeDefinitions);
        String errorLabel = DataDictionaryTypeServiceHelper.getAttributeErrorLabel(definition);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("(bo, attributeName, attributeValue) = (" + objectClassName + "," + attributeName + "," + attributeValue + ")"));
        }
        if (StringUtils.isNotBlank((String)attributeValue)) {
            Double max;
            Double min;
            Integer maxLength = definition.getAttributeField().getMaxLength();
            if (maxLength != null && maxLength < attributeValue.length()) {
                errors.add(RemotableAttributeError.Builder.create((String)errorKey, (String[])new String[]{DataDictionaryTypeServiceHelper.createErrorString("error.maxLength", errorLabel, maxLength.toString())}).build());
                return errors;
            }
            Pattern validationExpression = this.getAttributeValidatingExpression(definition);
            if (!ANY_CHAR_PATTERN_S.equals(validationExpression.pattern())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("(bo, attributeName, validationExpression) = (" + objectClassName + "," + attributeName + "," + validationExpression + ")"));
                }
                if (!validationExpression.matcher(attributeValue).matches()) {
                    boolean isError = true;
                    Formatter formatter = this.getAttributeFormatter(definition);
                    if (formatter != null) {
                        Object o = formatter.format((Object)attributeValue);
                        boolean bl = isError = !validationExpression.matcher(String.valueOf(o)).matches();
                    }
                    if (isError) {
                        errors.add(RemotableAttributeError.Builder.create((String)errorKey, (String[])new String[]{DataDictionaryTypeServiceHelper.createErrorString(definition)}).build());
                    }
                    return errors;
                }
            }
            if ((min = this.getAttributeMinValue(definition)) != null) {
                try {
                    if (Double.parseDouble(attributeValue) < min) {
                        errors.add(RemotableAttributeError.Builder.create((String)errorKey, (String[])new String[]{DataDictionaryTypeServiceHelper.createErrorString("error.inclusiveMin", errorLabel, min.toString())}).build());
                        return errors;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((max = this.getAttributeMaxValue(definition)) != null) {
                try {
                    if (Double.parseDouble(attributeValue) > max) {
                        errors.add(RemotableAttributeError.Builder.create((String)errorKey, (String[])new String[]{DataDictionaryTypeServiceHelper.createErrorString("error.inclusiveMax", errorLabel, max.toString())}).build());
                        return errors;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return errors;
    }

    protected List<String> extractErrorsFromGlobalVariablesErrorMap(String attributeName) {
        AutoPopulatingList results = GlobalVariables.getMessageMap().getErrorMessagesForProperty(attributeName);
        ArrayList<String> errors = new ArrayList<String>();
        if (results instanceof String) {
            errors.add((String)results);
        } else if (results != null) {
            if (results instanceof List) {
                List errorList = (List)results;
                for (Object msg : errorList) {
                    ErrorMessage errorMessage = (ErrorMessage)msg;
                    errors.add(DataDictionaryTypeServiceHelper.createErrorString(errorMessage.getErrorKey(), errorMessage.getMessageParameters()));
                }
            } else {
                String[] temp;
                for (String string : temp = (String[])results) {
                    errors.add(string);
                }
            }
        }
        GlobalVariables.getMessageMap().removeAllErrorMessagesForProperty(attributeName);
        return errors;
    }

    protected List<RemotableAttributeError> validateNonDataDictionaryAttribute(KimTypeAttribute attr, String key, String value) {
        return Collections.emptyList();
    }

    protected List<RemotableAttributeError> validateDataDictionaryAttribute(KimTypeAttribute attr, String key, String value) {
        try {
            PropertyDescriptor propertyDescriptor;
            Object componentObject = Class.forName(attr.getKimAttribute().getComponentName()).newInstance();
            if (attr.getKimAttribute().getAttributeName() != null && (propertyDescriptor = PropertyUtils.getPropertyDescriptor(componentObject, (String)attr.getKimAttribute().getAttributeName())) != null) {
                Object attributeValue = KRADUtils.hydrateAttributeValue(propertyDescriptor.getPropertyType(), (String)value);
                if (attributeValue == null) {
                    attributeValue = value;
                }
                propertyDescriptor.getWriteMethod().invoke(componentObject, attributeValue);
                return this.validateDataDictionaryAttribute(attr.getKimTypeId(), attr.getKimAttribute().getComponentName(), componentObject, propertyDescriptor);
            }
        }
        catch (Exception e) {
            throw new KimTypeAttributeValidationException(e);
        }
        return Collections.emptyList();
    }

    protected KimAttributeField getDataDictionaryAttributeDefinition(String namespaceCode, String kimTypeId, KimTypeAttribute typeAttribute, List<String> uniqueAttributes) {
        AttributeDefinition baseDefinition;
        Class<?> componentClass;
        String componentClassName = typeAttribute.getKimAttribute().getComponentName();
        String attributeName = typeAttribute.getKimAttribute().getAttributeName();
        try {
            if (StringUtils.isNotBlank((String)componentClassName)) {
                componentClass = Class.forName(componentClassName);
                AttributeDefinition baseDefinitionTemp = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(componentClassName).getAttributeDefinition(attributeName);
                baseDefinition = baseDefinitionTemp == null ? this.getDataDictionaryService().getDataDictionary().getDataObjectEntry(componentClassName).getAttributeDefinition(attributeName) : baseDefinitionTemp;
            } else {
                baseDefinition = null;
                componentClass = null;
            }
        }
        catch (ClassNotFoundException ex) {
            throw new KimTypeAttributeException(ex);
        }
        if (baseDefinition == null) {
            return null;
        }
        RemotableAttributeField.Builder definition = RemotableAttributeField.Builder.create((String)baseDefinition.getName());
        definition.setLongLabel(baseDefinition.getLabel());
        definition.setShortLabel(baseDefinition.getShortLabel());
        definition.setMaxLength(baseDefinition.getMaxLength());
        if (baseDefinition.isRequired() != null) {
            definition.setRequired(baseDefinition.isRequired().booleanValue());
        } else {
            definition.setRequired(false);
        }
        if (baseDefinition.getForceUppercase() != null) {
            definition.setForceUpperCase(baseDefinition.getForceUppercase().booleanValue());
        }
        definition.setControl(DataDictionaryTypeServiceHelper.toRemotableAbstractControlBuilder(baseDefinition));
        RemotableQuickFinder.Builder qf = this.createQuickFinder(componentClass, attributeName);
        if (qf != null) {
            definition.setWidgets(Collections.singletonList(qf));
        }
        KimAttributeField.Builder kimField = KimAttributeField.Builder.create((RemotableAttributeField.Builder)definition, (String)typeAttribute.getKimAttribute().getId());
        if (uniqueAttributes != null && uniqueAttributes.contains(definition.getName())) {
            kimField.setUnique(true);
        }
        return kimField.build();
    }

    private RemotableQuickFinder.Builder createQuickFinder(Class<? extends BusinessObject> componentClass, String attributeName) {
        Field field = FieldUtils.getPropertyField(componentClass, attributeName, false);
        if (field != null) {
            BusinessObject sampleComponent;
            try {
                sampleComponent = componentClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new KimTypeAttributeException(e);
            }
            catch (IllegalAccessException e) {
                throw new KimTypeAttributeException(e);
            }
            field = LookupUtils.setFieldQuickfinder(sampleComponent, attributeName, field, Collections.singletonList(attributeName));
            if (StringUtils.isNotBlank((String)field.getQuickFinderClassNameImpl())) {
                ModuleService moduleService;
                Class<?> lookupClass;
                try {
                    lookupClass = Class.forName(field.getQuickFinderClassNameImpl());
                }
                catch (ClassNotFoundException e) {
                    throw new KimTypeAttributeException(e);
                }
                String baseLookupUrl = LookupUtils.getBaseLookupUrl(false) + "?methodToCall=start";
                if (ExternalizableBusinessObjectUtils.isExternalizableBusinessObject(lookupClass) && (moduleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(lookupClass)).isExternalizableBusinessObjectLookupable(lookupClass)) {
                    baseLookupUrl = moduleService.getExternalizableBusinessObjectLookupUrl(lookupClass, Collections.emptyMap());
                    baseLookupUrl = baseLookupUrl.substring(0, baseLookupUrl.indexOf("?")) + "?methodToCall=start";
                }
                RemotableQuickFinder.Builder builder = RemotableQuickFinder.Builder.create((String)baseLookupUrl, (String)lookupClass.getName());
                builder.setLookupParameters(DataDictionaryTypeServiceBase.toMap(field.getLookupParameters()));
                builder.setFieldConversions(DataDictionaryTypeServiceBase.toMap(field.getFieldConversions()));
                return builder;
            }
        }
        return null;
    }

    private static Map<String, String> toMap(String s) {
        if (StringUtils.isBlank((String)s)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String string : s.split(",")) {
            String[] keyVal = string.split(":");
            map.put(keyVal[0], keyVal[1]);
        }
        return Collections.unmodifiableMap(map);
    }

    protected KimAttributeField getNonDataDictionaryAttributeDefinition(String namespaceCode, String kimTypeId, KimTypeAttribute typeAttribute, List<String> uniqueAttributes) {
        RemotableAttributeField.Builder field = RemotableAttributeField.Builder.create((String)typeAttribute.getKimAttribute().getAttributeName());
        field.setLongLabel(typeAttribute.getKimAttribute().getAttributeLabel());
        field.setShortLabel(typeAttribute.getKimAttribute().getAttributeLabel());
        KimAttributeField.Builder definition = KimAttributeField.Builder.create((RemotableAttributeField.Builder)field, (String)typeAttribute.getKimAttribute().getId());
        if (uniqueAttributes != null && uniqueAttributes.contains(typeAttribute.getKimAttribute().getAttributeName())) {
            definition.setUnique(true);
        }
        return definition.build();
    }

    protected void validateRequiredAttributesAgainstReceived(Map<String, String> receivedAttributes) {
        if (!this.isCheckRequiredAttributes()) {
            return;
        }
        if (this.getRequiredAttributes() == null || this.getRequiredAttributes().isEmpty()) {
            return;
        }
        ArrayList<String> missingAttributes = new ArrayList<String>();
        if (receivedAttributes == null || receivedAttributes.isEmpty()) {
            return;
        }
        for (String requiredAttribute : this.getRequiredAttributes()) {
            if (receivedAttributes.containsKey(requiredAttribute)) continue;
            missingAttributes.add(requiredAttribute);
        }
        if (!missingAttributes.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder();
            Iterator attribIter = missingAttributes.iterator();
            while (attribIter.hasNext()) {
                errorMessage.append((String)attribIter.next());
                if (!attribIter.hasNext()) continue;
                errorMessage.append(COMMA_SEPARATOR);
            }
            errorMessage.append(" not found in required attributes for this type.");
            throw new KimTypeAttributeValidationException(errorMessage.toString());
        }
    }

    public List<RemotableAttributeError> validateUniqueAttributes(String kimTypeId, Map<String, String> newAttributes, Map<String, String> oldAttributes) {
        if (StringUtils.isBlank((String)kimTypeId)) {
            throw new RiceIllegalArgumentException("kimTypeId was null or blank");
        }
        if (newAttributes == null) {
            throw new RiceIllegalArgumentException("newAttributes was null or blank");
        }
        if (oldAttributes == null) {
            throw new RiceIllegalArgumentException("oldAttributes was null or blank");
        }
        List<String> uniqueAttributes = this.getUniqueAttributes(kimTypeId);
        if (uniqueAttributes == null || uniqueAttributes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RemotableAttributeError> m = new ArrayList<RemotableAttributeError>();
        if (this.areAttributesEqual(uniqueAttributes, newAttributes, oldAttributes)) {
            for (String a : uniqueAttributes) {
                m.add(RemotableAttributeError.Builder.create((String)a, (String[])new String[]{"error.duplicate.entry"}).build());
            }
            return m;
        }
        return Collections.emptyList();
    }

    protected boolean areAttributesEqual(List<String> uniqueAttributeNames, Map<String, String> aSet1, Map<String, String> aSet2) {
        StringValueComparator comparator = StringValueComparator.getInstance();
        for (String uniqueAttributeName : uniqueAttributeNames) {
            String attrVal2;
            String attrVal1 = this.getAttributeValue(aSet1, uniqueAttributeName);
            if (comparator.compare(attrVal1, attrVal2 = this.getAttributeValue(aSet2, uniqueAttributeName)) == 0) continue;
            return false;
        }
        return true;
    }

    protected String getAttributeValue(Map<String, String> aSet, String attributeName) {
        if (StringUtils.isEmpty((String)attributeName)) {
            return null;
        }
        for (Map.Entry<String, String> entry : aSet.entrySet()) {
            if (!attributeName.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    protected List<String> getUniqueAttributes(String kimTypeId) {
        KimType kimType = this.getTypeInfoService().getKimType(kimTypeId);
        ArrayList<String> uniqueAttributes = new ArrayList<String>();
        if (kimType != null) {
            for (KimTypeAttribute attributeDefinition : kimType.getAttributeDefinitions()) {
                uniqueAttributes.add(attributeDefinition.getKimAttribute().getAttributeName());
            }
        } else {
            LOG.error((Object)"Unable to retrieve a KimTypeInfo for a null kimTypeId in getUniqueAttributes()");
        }
        return Collections.unmodifiableList(uniqueAttributes);
    }

    public List<RemotableAttributeError> validateUnmodifiableAttributes(String kimTypeId, Map<String, String> originalAttributes, Map<String, String> newAttributes) {
        if (StringUtils.isBlank((String)kimTypeId)) {
            throw new RiceIllegalArgumentException("kimTypeId was null or blank");
        }
        if (newAttributes == null) {
            throw new RiceIllegalArgumentException("newAttributes was null or blank");
        }
        if (originalAttributes == null) {
            throw new RiceIllegalArgumentException("oldAttributes was null or blank");
        }
        ArrayList<RemotableAttributeError> validationErrors = new ArrayList<RemotableAttributeError>();
        KimType kimType = this.getTypeInfoService().getKimType(kimTypeId);
        List<String> uniqueAttributes = this.getUniqueAttributes(kimTypeId);
        for (String attributeNameKey : uniqueAttributes) {
            String delegationAttributeValue;
            KimTypeAttribute attr = kimType.getAttributeDefinitionByName(attributeNameKey);
            String mainAttributeValue = this.getAttributeValue(originalAttributes, attributeNameKey);
            if (StringUtils.equals((String)mainAttributeValue, (String)(delegationAttributeValue = this.getAttributeValue(newAttributes, attributeNameKey)))) continue;
            validationErrors.add(RemotableAttributeError.Builder.create((String)attributeNameKey, (String[])new String[]{DataDictionaryTypeServiceHelper.createErrorString("error.unmodifiable.attribute", this.dataDictionaryService.getAttributeLabel(attr.getKimAttribute().getComponentName(), attributeNameKey))}).build());
        }
        return validationErrors;
    }

    protected List<String> getRequiredAttributes() {
        return Collections.emptyList();
    }

    protected boolean isCheckRequiredAttributes() {
        return false;
    }

    protected String getClosestParentDocumentTypeName(DocumentType documentType, Set<String> potentialParentDocumentTypeNames) {
        if (potentialParentDocumentTypeNames == null || documentType == null) {
            return null;
        }
        if (potentialParentDocumentTypeNames.contains(documentType.getName())) {
            return documentType.getName();
        }
        if (documentType.getParentId() == null || documentType.getParentId().equals(documentType.getId())) {
            return null;
        }
        return this.getClosestParentDocumentTypeName(this.getDocumentTypeService().getDocumentTypeById(documentType.getParentId()), potentialParentDocumentTypeNames);
    }

    protected KimTypeInfoService getTypeInfoService() {
        if (this.typeInfoService == null) {
            this.typeInfoService = KimApiServiceLocator.getKimTypeInfoService();
        }
        return this.typeInfoService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    protected DictionaryValidationService getDictionaryValidationService() {
        if (this.dictionaryValidationService == null) {
            this.dictionaryValidationService = KNSServiceLocator.getKNSDictionaryValidationService();
        }
        return this.dictionaryValidationService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    protected DocumentTypeService getDocumentTypeService() {
        if (this.documentTypeService == null) {
            this.documentTypeService = KewApiServiceLocator.getDocumentTypeService();
        }
        return this.documentTypeService;
    }

    protected static class KimTypeAttributeException
    extends RuntimeException {
        private static final long serialVersionUID = 8220618846321607801L;

        protected KimTypeAttributeException(String message) {
            super(message);
        }

        protected KimTypeAttributeException(Throwable cause) {
            super(cause);
        }
    }

    protected static class KimTypeAttributeValidationException
    extends RuntimeException {
        private static final long serialVersionUID = 8220618846321607801L;

        protected KimTypeAttributeValidationException(String message) {
            super(message);
        }

        protected KimTypeAttributeValidationException(Throwable cause) {
            super(cause);
        }
    }
}

