/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.datadictionary.validation.charlevel;

import org.kuali.rice.krad.datadictionary.exporter.ExportMap;
import org.kuali.rice.krad.datadictionary.validation.CharacterLevelValidationPattern;

public class AlphaNumericValidationPattern
extends CharacterLevelValidationPattern {
    protected boolean allowWhitespace = false;
    protected boolean allowUnderscore = false;
    protected boolean allowPeriod = false;
    protected boolean allowParenthesis = false;
    protected boolean allowDollar = false;
    protected boolean allowForwardSlash = false;
    protected boolean lowerCase = false;
    protected boolean allowDash = false;

    public boolean getAllowPeriod() {
        return this.allowPeriod;
    }

    public void setAllowPeriod(boolean allowPeriod) {
        this.allowPeriod = allowPeriod;
    }

    public boolean isAllowPeriod() {
        return this.allowPeriod;
    }

    public boolean isAllowParenthesis() {
        return this.allowParenthesis;
    }

    public void setAllowParenthesis(boolean allowParenthesis) {
        this.allowParenthesis = allowParenthesis;
    }

    public boolean isAllowDollar() {
        return this.allowDollar;
    }

    public void setAllowDollar(boolean allowDollar) {
        this.allowDollar = allowDollar;
    }

    public boolean isAllowForwardSlash() {
        return this.allowForwardSlash;
    }

    public void setAllowForwardSlash(boolean allowForwardSlash) {
        this.allowForwardSlash = allowForwardSlash;
    }

    public boolean getAllowWhitespace() {
        return this.allowWhitespace;
    }

    public void setAllowWhitespace(boolean allowWhitespace) {
        this.allowWhitespace = allowWhitespace;
    }

    public boolean getAllowUnderscore() {
        return this.allowUnderscore;
    }

    public void setAllowUnderscore(boolean allowUnderscore) {
        this.allowUnderscore = allowUnderscore;
    }

    public boolean isLowerCase() {
        return this.lowerCase;
    }

    public void setLowerCase(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    public boolean getAllowDash() {
        return this.allowDash;
    }

    public void setAllowDash(boolean allowDash) {
        this.allowDash = allowDash;
    }

    protected String getRegexString() {
        StringBuilder regexString = new StringBuilder("[A-Za-z0-9");
        if (this.lowerCase) {
            regexString = new StringBuilder("[a-z0-9");
        }
        if (this.allowWhitespace) {
            regexString.append("\\s");
        }
        if (this.allowUnderscore) {
            regexString.append("_");
        }
        if (this.allowPeriod) {
            regexString.append(".");
        }
        if (this.allowParenthesis) {
            regexString.append("(");
            regexString.append(")");
        }
        if (this.allowDollar) {
            regexString.append("$");
        }
        if (this.allowForwardSlash) {
            regexString.append("/");
        }
        if (this.allowDash) {
            regexString.append("-");
        }
        regexString.append("]");
        return regexString.toString();
    }

    public void extendExportMap(ExportMap exportMap) {
        exportMap.set("type", "alphaNumeric");
        if (this.lowerCase) {
            exportMap.set("allowUpperCase", "true");
        }
        if (this.allowWhitespace) {
            exportMap.set("allowWhitespace", "true");
        }
        if (this.allowUnderscore) {
            exportMap.set("allowUnderscore", "true");
        }
        if (this.allowPeriod) {
            exportMap.set("allowPeriod", "true");
        }
        if (this.allowParenthesis) {
            exportMap.set("allowParenthesis", "true");
        }
        if (this.allowDollar) {
            exportMap.set("allowDollar", "true");
        }
        if (this.allowForwardSlash) {
            exportMap.set("allowForwardSlash", "true");
        }
        if (this.allowDash) {
            exportMap.set("allowDash", "true");
        }
    }

    protected String getValidationErrorMessageKeyOptions() {
        StringBuilder opts = new StringBuilder();
        if (this.lowerCase) {
            opts.append(".lowerCase");
        }
        if (this.allowWhitespace) {
            opts.append(".allowWhitespace");
        }
        if (this.allowUnderscore) {
            opts.append(".allowUnderscore");
        }
        if (this.allowPeriod) {
            opts.append(".allowPeriod");
        }
        if (this.allowParenthesis) {
            opts.append(".allowParenthesis");
        }
        if (this.allowDollar) {
            opts.append(".allowDollar");
        }
        if (this.allowForwardSlash) {
            opts.append(".allowForwardSlash");
        }
        if (this.allowDash) {
            opts.append(".allowDash");
        }
        return opts.toString();
    }
}

