/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.lookup;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.directwebremoting.util.WriterOutputStream;
import org.displaytag.model.Row;
import org.displaytag.model.TableModel;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.ResultRow;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.Exporter;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.exception.ExportNotSupportedException;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

public class ExportViewHelper {
    private BusinessObjectEntry businessObjectEntry = this.loadBusinessObjectEntry();
    private List<BusinessObject> businessObjects;

    public ExportViewHelper(TableModel tableModel) {
        this.businessObjects = this.loadBusinessObjects(tableModel);
    }

    protected BusinessObjectEntry loadBusinessObjectEntry() {
        LookupForm lookupForm;
        KualiForm kualiForm = KNSGlobalVariables.getKualiForm();
        if (kualiForm instanceof LookupForm && !StringUtils.isBlank((String)(lookupForm = (LookupForm)kualiForm).getBusinessObjectClassName())) {
            return KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(lookupForm.getBusinessObjectClassName());
        }
        return null;
    }

    protected List<BusinessObject> loadBusinessObjects(TableModel tableModel) {
        ArrayList<BusinessObject> businessObjects = new ArrayList<BusinessObject>();
        List rowList = tableModel.getRowListFull();
        for (Row row : rowList) {
            ResultRow resultRow = (ResultRow)row.getObject();
            if (resultRow.getBusinessObject() == null) continue;
            businessObjects.add(resultRow.getBusinessObject());
        }
        return businessObjects;
    }

    public BusinessObjectEntry getBusinessObjectEntry() {
        return this.businessObjectEntry;
    }

    public List<BusinessObject> getBusinessObjects() {
        return this.businessObjects;
    }

    public boolean attemptCustomExport(OutputStream outputStream, String exportFormat) throws IOException {
        if (this.getBusinessObjectEntry() != null && this.getBusinessObjectEntry().getExporterClass() != null) {
            Exporter exporter;
            try {
                exporter = (Exporter)this.getBusinessObjectEntry().getExporterClass().newInstance();
            }
            catch (Exception e) {
                throw new ExportNotSupportedException("Failed to load export class: " + this.businessObjectEntry.getExporterClass(), (Throwable)e);
            }
            List supportedFormats = exporter.getSupportedFormats(this.businessObjectEntry.getBusinessObjectClass());
            if (supportedFormats.contains(exportFormat)) {
                exporter.export(this.businessObjectEntry.getBusinessObjectClass(), this.getBusinessObjects(), exportFormat, outputStream);
                return true;
            }
        }
        return false;
    }

    public boolean attemptCustomExport(Writer writer, String exportFormat) throws IOException {
        return this.attemptCustomExport((OutputStream)new WriterOutputStream(writer), exportFormat);
    }
}

