/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.maintenance;

import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.GlobalBusinessObject;
import org.kuali.rice.krad.bo.GlobalBusinessObjectDetail;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.maintenance.MaintenanceLock;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class KualiGlobalMaintainableImpl
extends KualiMaintainableImpl {
    private static final long serialVersionUID = 4814145799502207182L;
    private static final Logger LOG = Logger.getLogger(KualiGlobalMaintainableImpl.class);

    public void prepareForSave() {
        if (this.businessObject != null) {
            this.prepareGlobalsForSave();
        }
    }

    public void processAfterRetrieve() {
        if (this.businessObject != null) {
            this.processGlobalsAfterRetrieve();
        }
    }

    protected void processGlobalsAfterRetrieve() {
        GlobalBusinessObject gbo = (GlobalBusinessObject)this.businessObject;
        Class<?> gboClass = this.businessObject.getClass();
        String finDocNumber = gbo.getDocumentNumber();
        boolean assumptionIsWrong = false;
        List primaryKeys = KNSServiceLocator.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(gboClass);
        if (primaryKeys == null) {
            assumptionIsWrong = true;
        } else if (primaryKeys.isEmpty()) {
            assumptionIsWrong = true;
        } else if (primaryKeys.size() != 1) {
            assumptionIsWrong = true;
        } else if (!primaryKeys.get(0).getClass().equals(String.class)) {
            assumptionIsWrong = true;
        } else if (!"documentNumber".equalsIgnoreCase((String)primaryKeys.get(0))) {
            assumptionIsWrong = true;
        }
        if (assumptionIsWrong) {
            throw new RuntimeException("An assertion about the nature of the primary keys for this GBO has failed, and processing cannot continue.");
        }
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("documentNumber", finDocNumber);
        PersistableBusinessObject newBo = null;
        newBo = (PersistableBusinessObject)KRADServiceLocator.getBusinessObjectService().findByPrimaryKey(gboClass, pkMap);
        if (newBo == null) {
            throw new RuntimeException("The Global Business Object could not be retrieved from the DB.  This should never happen under normal circumstances.  If this is a legitimate case Then this exception should be removed.");
        }
        try {
            ObjectUtils.setObjectPropertyDeep((Object)newBo, (String)"newCollectionRecord", Boolean.TYPE, (Object)true, (int)2);
        }
        catch (Exception e) {
            LOG.error((Object)("unable to set newCollectionRecord property: " + e.getMessage()));
            throw new RuntimeException("unable to set newCollectionRecord property: " + e.getMessage());
        }
        this.setBusinessObject(newBo);
    }

    protected void prepareGlobalsForSave() {
        GlobalBusinessObject gbo = (GlobalBusinessObject)this.businessObject;
        gbo.setDocumentNumber(this.getDocumentNumber());
        List details = gbo.getAllDetailObjects();
        for (GlobalBusinessObjectDetail detail : details) {
            detail.setDocumentNumber(this.getDocumentNumber());
        }
    }

    public abstract List<MaintenanceLock> generateMaintenanceLocks();

    @Override
    public void saveBusinessObject() {
        List bosToPersist;
        BusinessObjectService boService = KRADServiceLocator.getBusinessObjectService();
        GlobalBusinessObject gbo = (GlobalBusinessObject)this.businessObject;
        List bosToDeactivate = gbo.generateDeactivationsToPersist();
        if (bosToDeactivate != null && !bosToDeactivate.isEmpty()) {
            boService.save(bosToDeactivate);
        }
        if ((bosToPersist = gbo.generateGlobalChangesToPersist()) != null && !bosToPersist.isEmpty()) {
            boService.save(bosToPersist);
        }
    }

    public abstract Class<? extends PersistableBusinessObject> getPrimaryEditedBusinessObjectClass();
}

