/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.document.authorization;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.doctype.ProcessDefinition;
import org.kuali.rice.kew.api.doctype.RoutePath;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.bo.authorization.BusinessObjectAuthorizerBase;
import org.kuali.rice.kns.document.authorization.DocumentAuthorizer;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentRequestAuthorizationCache;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

@Deprecated
public class DocumentAuthorizerBase
extends BusinessObjectAuthorizerBase
implements DocumentAuthorizer {
    protected static Log LOG = LogFactory.getLog(DocumentAuthorizerBase.class);
    public static final String PRE_ROUTING_ROUTE_NAME = "PreRoute";
    public static final String EDIT_MODE_DEFAULT_TRUE_VALUE = "TRUE";
    public static final String USER_SESSION_METHOD_TO_CALL_OBJECT_KEY = "METHOD_TO_CALL_KEYS_METHOD_OBJECT_KEY";
    public static final String USER_SESSION_METHOD_TO_CALL_COMPLETE_OBJECT_KEY = "METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY";
    public static final String USER_SESSION_METHOD_TO_CALL_COMPLETE_MARKER = "_EXITING";

    @Override
    public Set<String> getDocumentActions(Document document, Person user, Set<String> documentActions) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("calling DocumentAuthorizerBase.getDocumentActionFlags for document '" + document.getDocumentNumber() + "'. user '" + user.getPrincipalName() + "'"));
        }
        if (documentActions.contains("canEdit") && !this.canEdit(document, user)) {
            documentActions.remove("canEdit");
        }
        if (documentActions.contains("canCopy") && !this.canCopy(document, user)) {
            documentActions.remove("canCopy");
        }
        if (documentActions.contains("canClose") && !this.canClose(document, user)) {
            documentActions.remove("canClose");
        }
        if (documentActions.contains("canReload") && !this.canReload(document, user)) {
            documentActions.remove("canReload");
        }
        if (documentActions.contains("canBlanketApprove") && !this.canBlanketApprove(document, user)) {
            documentActions.remove("canBlanketApprove");
        }
        if (documentActions.contains("canCancel") && !this.canCancel(document, user)) {
            documentActions.remove("canCancel");
        }
        if (documentActions.contains("canRecall") && !this.canRecall(document, user)) {
            documentActions.remove("canRecall");
        }
        if (documentActions.contains("canSave") && !this.canSave(document, user)) {
            documentActions.remove("canSave");
        }
        if (documentActions.contains("canRoute") && !this.canRoute(document, user)) {
            documentActions.remove("canRoute");
        }
        if (documentActions.contains("canAcknowledge") && !this.canAcknowledge(document, user)) {
            documentActions.remove("canAcknowledge");
        }
        if (documentActions.contains("canFYI") && !this.canFyi(document, user)) {
            documentActions.remove("canFYI");
        }
        if (documentActions.contains("canApprove") && !this.canApprove(document, user)) {
            documentActions.remove("canApprove");
        }
        if (documentActions.contains("canDisapprove") && !this.canDisapprove(document, user)) {
            documentActions.remove("canDisapprove");
        }
        if (!this.canSendAnyTypeAdHocRequests(document, user)) {
            documentActions.remove("canAddAdHocRequests");
            documentActions.remove("canSendAdHocRequests");
            documentActions.remove("canSendNoteFyi");
        }
        if (documentActions.contains("canSendNoteFyi") && !this.canSendNoteFyi(document, user)) {
            documentActions.remove("canSendNoteFyi");
        }
        if (documentActions.contains("canAnnotate") && !this.canAnnotate(document, user)) {
            documentActions.remove("canAnnotate");
        }
        if (documentActions.contains("canEditDocumentOverview") && !this.canEditDocumentOverview(document, user)) {
            documentActions.remove("canEditDocumentOverview");
        }
        if (documentActions.contains("canPerformRouteReport") && !this.canPerformRouteReport(document, user)) {
            documentActions.remove("canPerformRouteReport");
        }
        if (documentActions.contains("canSuperUserTakeAction") && !this.canSuperUserTakeAction(document, user)) {
            documentActions.remove("canSuperUserTakeAction");
        }
        if (documentActions.contains("canSuperUserApprove") && !this.canSuperUserApprove(document, user)) {
            documentActions.remove("canSuperUserApprove");
        }
        if (documentActions.contains("canSuperUserDisapprove") && !this.canSuperUserDisapprove(document, user)) {
            documentActions.remove("canSuperUserDisapprove");
        }
        return documentActions;
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        String nameSpaceCode = "KR-SYS";
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("documentTypeName", documentTypeName);
        return DocumentAuthorizerBase.getPermissionService().isAuthorizedByTemplate(user.getPrincipalId(), nameSpaceCode, "Initiate Document", permissionDetails, Collections.emptyMap());
    }

    public boolean canEdit(Document document, Person user) {
        return document.getDocumentHeader().getWorkflowDocument().isCompletionRequested() || this.isAuthorizedByTemplate(document, "KR-NS", "Edit Document", user.getPrincipalId());
    }

    public boolean canAnnotate(Document document, Person user) {
        return this.canEdit(document, user);
    }

    public boolean canReload(Document document, Person user) {
        return true;
    }

    public boolean canClose(Document document, Person user) {
        return true;
    }

    public boolean canSave(Document document, Person user) {
        return this.isAuthorizedByTemplate(document, "KR-WKFLW", "Save Document", user.getPrincipalId());
    }

    public boolean canRoute(Document document, Person user) {
        return this.isAuthorizedByTemplate(document, "KR-WKFLW", "Route Document", user.getPrincipalId());
    }

    public boolean canCancel(Document document, Person user) {
        boolean isCompletionRequested = document.getDocumentHeader().getWorkflowDocument().isCompletionRequested();
        return isCompletionRequested || this.isAuthorizedByTemplate(document, "KR-WKFLW", "Cancel Document", user.getPrincipalId());
    }

    public boolean canRecall(Document document, Person user) {
        return KewApiServiceLocator.getWorkflowDocumentActionsService().determineValidActions(document.getDocumentNumber(), user.getPrincipalId()).getValidActions().contains(ActionType.RECALL);
    }

    public boolean canCopy(Document document, Person user) {
        return this.isAuthorizedByTemplate(document, "KR-NS", "Copy Document", user.getPrincipalId());
    }

    public boolean canPerformRouteReport(Document document, Person user) {
        return true;
    }

    public boolean canBlanketApprove(Document document, Person user) {
        return this.isAuthorizedByTemplate(document, "KR-WKFLW", "Blanket Approve Document", user.getPrincipalId());
    }

    public boolean canApprove(Document document, Person user) {
        return this.canTakeRequestedAction(document, "A", user);
    }

    public boolean canDisapprove(Document document, Person user) {
        return this.canApprove(document, user);
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return this.canSendAdHocRequests(document, "F", user);
    }

    public boolean canFyi(Document document, Person user) {
        return this.canTakeRequestedAction(document, "F", user);
    }

    public boolean canAcknowledge(Document document, Person user) {
        return this.canTakeRequestedAction(document, "K", user);
    }

    public boolean canReceiveAdHoc(Document document, Person user, String actionRequestCode) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("actionRequestCd", actionRequestCode);
        return this.isAuthorizedByTemplate(document, "KR-WKFLW", "Ad Hoc Review Document", user.getPrincipalId(), additionalPermissionDetails, Collections.emptyMap());
    }

    public boolean canOpen(Document document, Person user) {
        return this.isAuthorizedByTemplate(document, "KR-NS", "Open Document", user.getPrincipalId());
    }

    public boolean canAddNoteAttachment(Document document, String attachmentTypeCode, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        if (attachmentTypeCode != null) {
            additionalPermissionDetails.put("attachmentTypeCode", attachmentTypeCode);
        }
        return this.isAuthorizedByTemplate(document, "KR-NS", "Add Note / Attachment", user.getPrincipalId(), additionalPermissionDetails, Collections.emptyMap());
    }

    @Override
    public boolean canDeleteNoteAttachment(Document document, String attachmentTypeCode, String createdBySelfOnly, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        if (attachmentTypeCode != null) {
            additionalPermissionDetails.put("attachmentTypeCode", attachmentTypeCode);
        }
        additionalPermissionDetails.put("createdBySelf", createdBySelfOnly);
        return this.isAuthorizedByTemplate(document, "KR-NS", "Delete Note / Attachment", user.getPrincipalId(), additionalPermissionDetails, Collections.emptyMap());
    }

    @Override
    public boolean canViewNoteAttachment(Document document, String attachmentTypeCode, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        if (attachmentTypeCode != null) {
            additionalPermissionDetails.put("attachmentTypeCode", attachmentTypeCode);
        }
        return this.isAuthorizedByTemplate(document, "KR-NS", "View Note / Attachment", user.getPrincipalId(), additionalPermissionDetails, Collections.emptyMap());
    }

    public boolean canViewNoteAttachment(Document document, String attachmentTypeCode, String authorUniversalIdentifier, Person user) {
        return this.canViewNoteAttachment(document, attachmentTypeCode, user);
    }

    public boolean canSendAdHocRequests(Document document, String actionRequestCd, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        if (actionRequestCd != null) {
            additionalPermissionDetails.put("actionRequestCd", actionRequestCd);
        }
        return this.isAuthorizedByTemplate(document, "KR-NS", "Send Ad Hoc Request", user.getPrincipalId(), additionalPermissionDetails, Collections.emptyMap());
    }

    public boolean canEditDocumentOverview(Document document, Person user) {
        return this.isAuthorizedByTemplate(document, "KR-NS", "Edit Document", user.getPrincipalId()) && this.isDocumentInitiator(document, user);
    }

    public boolean canSendAnyTypeAdHocRequests(Document document, Person user) {
        if (this.canSendAdHocRequests(document, "F", user)) {
            RoutePath routePath = KewApiServiceLocator.getDocumentTypeService().getRoutePathForDocumentTypeName(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            ProcessDefinition processDefinition = routePath.getPrimaryProcess();
            if (processDefinition != null) {
                return processDefinition.getInitialRouteNode() != null;
            }
            return false;
        }
        if (this.canSendAdHocRequests(document, "K", user)) {
            return true;
        }
        return this.canSendAdHocRequests(document, "A", user);
    }

    public boolean canTakeRequestedAction(Document document, String actionRequestCode, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("actionRequestCd", actionRequestCode);
        return this.isAuthorizedByTemplate(document, "KR-NS", "Take Requested Action", user.getPrincipalId(), additionalPermissionDetails, Collections.emptyMap());
    }

    public boolean canSuperUserTakeAction(Document document, Person user) {
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            return false;
        }
        String principalId = user.getPrincipalId();
        String documentTypeId = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeId();
        if (KewApiServiceLocator.getDocumentTypeService().isSuperUserForDocumentTypeId(principalId, documentTypeId)) {
            return true;
        }
        String documentTypeName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        List routeNodeInstances = document.getDocumentHeader().getWorkflowDocument().getRouteNodeInstances();
        String documentStatus = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        return KewApiServiceLocator.getDocumentTypeService().canSuperUserApproveSingleActionRequest(principalId, documentTypeName, routeNodeInstances, documentStatus);
    }

    public boolean canSuperUserApprove(Document document, Person user) {
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            return false;
        }
        String principalId = user.getPrincipalId();
        String documentTypeId = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeId();
        if (KewApiServiceLocator.getDocumentTypeService().isSuperUserForDocumentTypeId(principalId, documentTypeId)) {
            return true;
        }
        String documentTypeName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        List routeNodeInstances = document.getDocumentHeader().getWorkflowDocument().getRouteNodeInstances();
        String documentStatus = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        return KewApiServiceLocator.getDocumentTypeService().canSuperUserApproveDocument(principalId, documentTypeName, routeNodeInstances, documentStatus);
    }

    public boolean canSuperUserDisapprove(Document document, Person user) {
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            return false;
        }
        String principalId = user.getPrincipalId();
        String documentTypeId = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeId();
        if (KewApiServiceLocator.getDocumentTypeService().isSuperUserForDocumentTypeId(principalId, documentTypeId)) {
            return true;
        }
        String documentTypeName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        List routeNodeInstances = document.getDocumentHeader().getWorkflowDocument().getRouteNodeInstances();
        String documentStatus = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        return KewApiServiceLocator.getDocumentTypeService().canSuperUserDisapproveDocument(principalId, documentTypeName, routeNodeInstances, documentStatus);
    }

    protected void addPermissionDetails(Object dataObject, Map<String, String> attributes) {
        super.addPermissionDetails(dataObject, attributes);
        if (dataObject instanceof Document) {
            this.addStandardAttributes((Document)dataObject, attributes);
        }
    }

    protected void addRoleQualification(Object dataObject, Map<String, String> attributes) {
        super.addRoleQualification(dataObject, attributes);
        if (dataObject instanceof Document) {
            this.addStandardAttributes((Document)dataObject, attributes);
        }
    }

    protected void addStandardAttributes(Document document, Map<String, String> attributes) {
        WorkflowDocument wd = document.getDocumentHeader().getWorkflowDocument();
        attributes.put("documentNumber", document.getDocumentNumber());
        attributes.put("documentTypeName", wd.getDocumentTypeName());
        if (wd.isInitiated() || wd.isSaved()) {
            attributes.put("routeNodeName", PRE_ROUTING_ROUTE_NAME);
        } else {
            attributes.put("routeNodeName", KRADServiceLocatorWeb.getWorkflowDocumentService().getCurrentRouteNodeNames(wd));
        }
        attributes.put("routeStatusCode", wd.getStatus().getCode());
    }

    protected boolean isDocumentInitiator(Document document, Person user) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        return workflowDocument.getInitiatorPrincipalId().equalsIgnoreCase(user.getPrincipalId());
    }

    public void setDocumentRequestAuthorizationCache(DocumentRequestAuthorizationCache documentRequestAuthorizationCache) {
    }
}

