/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServletWrapper;
import org.apache.struts.upload.CommonsMultipartRequestHandler;
import org.apache.struts.upload.FormFile;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.datadictionary.KNSDocumentEntry;
import org.kuali.rice.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.rice.kns.document.authorization.DocumentAuthorizer;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.util.FieldUtils;
import org.kuali.rice.kns.web.struts.action.KualiMultipartRequestHandler;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.kns.web.struts.form.KualiMaintenanceForm;
import org.kuali.rice.kns.web.struts.form.pojo.PojoFormBase;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.AttributeSecurity;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntryBase;
import org.kuali.rice.krad.datadictionary.mask.MaskFormatter;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.ObjectUtils;

@Deprecated
public class WebUtils {
    private static final Logger LOG = Logger.getLogger(WebUtils.class);
    private static final String IMAGE_COORDINATE_CLICKED_X_EXTENSION = ".x";
    private static final String IMAGE_COORDINATE_CLICKED_Y_EXTENSION = ".y";
    private static final String APPLICATION_IMAGE_URL_PROPERTY_PREFIX = "application.custom.image.url";
    private static final String DEFAULT_IMAGE_URL_PROPERTY_NAME = "kr.externalizable.images.url";
    private static final String[] SCHEMES = new String[]{"http://", "https://"};
    public static final String FILE_UPLOAD_LIMIT_EXCEEDED_EXCEPTION_ALREADY_THROWN = "fileUploadLimitExceededExceptionAlreadyThrown";
    private static ConfigurationService configurationService;
    public static String KEY_KUALI_FORM_IN_SESSION;

    public static String parseMethodToCall(ActionForm form, HttpServletRequest request) {
        String methodToCall = null;
        if (StringUtils.isNotBlank((String)request.getParameter("methodToCall"))) {
            if (form instanceof KualiForm && !((KualiForm)form).shouldMethodToCallParameterBeUsed("methodToCall", request.getParameter("methodToCall"), request)) {
                throw new RuntimeException("Cannot verify that the methodToCall should be " + request.getParameter("methodToCall"));
            }
            methodToCall = request.getParameter("methodToCall");
            request.setAttribute("methodToCallAttribute", (Object)("methodToCall." + methodToCall + IMAGE_COORDINATE_CLICKED_X_EXTENSION));
        }
        if (methodToCall == null) {
            Enumeration i = request.getParameterNames();
            while (i.hasMoreElements()) {
                String parameterName = (String)i.nextElement();
                if (WebUtils.isMethodToCall(parameterName)) {
                    methodToCall = WebUtils.getMethodToCallSettingAttribute(form, request, parameterName);
                    break;
                }
                for (String value : request.getParameterValues(parameterName)) {
                    if (!WebUtils.isMethodToCall(value)) continue;
                    methodToCall = WebUtils.getMethodToCallSettingAttribute(form, request, value);
                }
            }
        }
        return methodToCall;
    }

    private static boolean isMethodToCall(String string) {
        return string.startsWith("methodToCall.");
    }

    private static String getMethodToCallSettingAttribute(ActionForm form, HttpServletRequest request, String string) {
        if (form instanceof KualiForm && !((KualiForm)form).shouldMethodToCallParameterBeUsed(string, request.getParameter(string), request)) {
            throw new RuntimeException("Cannot verify that the methodToCall should be " + string);
        }
        String attributeValue = WebUtils.endsWithCoordinates(string) ? string : string + IMAGE_COORDINATE_CLICKED_X_EXTENSION;
        String methodToCall = StringUtils.substringBetween((String)attributeValue, (String)"methodToCall.", (String)".");
        request.setAttribute("methodToCallAttribute", (Object)attributeValue);
        return methodToCall;
    }

    public static void logRequestContents(Logger logger, Level level, HttpServletRequest request) {
        if (logger.isEnabledFor((Priority)level)) {
            logger.log((Priority)level, (Object)"--------------------");
            logger.log((Priority)level, (Object)"HttpRequest attributes:");
            Enumeration e = request.getAttributeNames();
            while (e.hasMoreElements()) {
                String attrName = (String)e.nextElement();
                Object attrValue = request.getAttribute(attrName);
                if (attrValue.getClass().isArray()) {
                    WebUtils.logCollection(logger, level, attrName, Arrays.asList((Object[])attrValue));
                    continue;
                }
                if (attrValue instanceof Collection) {
                    WebUtils.logCollection(logger, level, attrName, (Collection)attrValue);
                    continue;
                }
                if (attrValue instanceof Map) {
                    WebUtils.logMap(logger, level, attrName, (Map)attrValue);
                    continue;
                }
                WebUtils.logObject(logger, level, attrName, attrValue);
            }
            logger.log((Priority)level, (Object)"--------------------");
            logger.log((Priority)level, (Object)"HttpRequest parameters:");
            Enumeration i = request.getParameterNames();
            while (i.hasMoreElements()) {
                String paramName = (String)i.nextElement();
                Object[] paramValues = request.getParameterValues(paramName);
                WebUtils.logArray(logger, level, paramName, paramValues);
            }
            logger.log((Priority)level, (Object)"--------------------");
        }
    }

    private static void logArray(Logger logger, Level level, String arrayName, Object[] array) {
        StringBuffer value = new StringBuffer("[");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                value.append(",");
            }
            value.append(array[i]);
        }
        value.append("]");
        WebUtils.logThing(logger, level, arrayName, value);
    }

    private static void logCollection(Logger logger, Level level, String collectionName, Collection c) {
        StringBuffer value = new StringBuffer("{");
        Iterator i = c.iterator();
        while (i.hasNext()) {
            value.append(i.next());
            if (!i.hasNext()) continue;
            value.append(",");
        }
        value.append("}");
        WebUtils.logThing(logger, level, collectionName, value);
    }

    private static void logMap(Logger logger, Level level, String mapName, Map m) {
        StringBuffer value = new StringBuffer("{");
        for (Map.Entry e : m.entrySet()) {
            value.append("('" + e.getKey() + "','" + e.getValue() + "')");
        }
        value.append("}");
        WebUtils.logThing(logger, level, mapName, value);
    }

    private static void logObject(Logger logger, Level level, String objectName, Object o) {
        WebUtils.logThing(logger, level, objectName, "'" + o + "'");
    }

    private static void logThing(Logger logger, Level level, String thingName, Object thing) {
        logger.log((Priority)level, (Object)("    '" + thingName + "' => " + thing));
    }

    public static void saveMimeOutputStreamAsFile(HttpServletResponse response, String contentType, ByteArrayOutputStream byteArrayOutputStream, String fileName) throws IOException {
        String updateFileName = fileName.contains("\"") ? fileName.replaceAll("\"", "") : fileName;
        response.setContentType(contentType);
        response.setHeader("Content-disposition", "attachment; filename=\"" + updateFileName + "\"");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setContentLength(byteArrayOutputStream.size());
        ServletOutputStream outputStream = response.getOutputStream();
        byteArrayOutputStream.writeTo((OutputStream)response.getOutputStream());
        outputStream.flush();
        outputStream.close();
    }

    public static void saveMimeInputStreamAsFile(HttpServletResponse response, String contentType, InputStream inStream, String fileName, int fileSize) throws IOException {
        String updateFileName = fileName.contains("\"") ? fileName.replaceAll("\"", "") : fileName;
        response.setContentType(contentType);
        response.setHeader("Content-disposition", "attachment; filename=\"" + updateFileName + "\"");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setContentLength(fileSize);
        ServletOutputStream out = response.getOutputStream();
        while (inStream.available() > 0) {
            out.write(inStream.read());
        }
        out.flush();
    }

    public static String getTabState(KualiForm form, String tabKey) {
        return form.getTabState(tabKey);
    }

    public static void incrementTabIndex(KualiForm form, String tabKey) {
        form.incrementTabIndex();
    }

    public static void reopenInactiveRecords(List<Section> sections, Map<String, String> tabStates, String collectionName) {
        for (Section section : sections) {
            for (Row row : section.getRows()) {
                for (Field field : row.getFields()) {
                    if (field == null || !"container".equals(field.getFieldType()) || !StringUtils.startsWith((String)field.getContainerName(), (String)collectionName)) continue;
                    String tabKey = WebUtils.generateTabKey(FieldUtils.generateCollectionSubTabName(field));
                    tabStates.put(tabKey, KualiForm.TabState.OPEN.name());
                }
            }
        }
    }

    public static String generateTabKey(String tabTitle) {
        String key = "";
        if (!StringUtils.isBlank((String)tabTitle)) {
            key = tabTitle.replaceAll("\\W", "");
        }
        return key;
    }

    public static void getMultipartParameters(HttpServletRequest request, ActionServletWrapper servletWrapper, ActionForm form, ActionMapping mapping) {
        HashMap params = new HashMap();
        try {
            CommonsMultipartRequestHandler multipartHandler = new CommonsMultipartRequestHandler();
            if (multipartHandler != null) {
                if (servletWrapper != null) {
                    servletWrapper.setServletFor((MultipartRequestHandler)multipartHandler);
                }
                multipartHandler.setMapping((ActionMapping)request.getAttribute("org.apache.struts.action.mapping.instance"));
                multipartHandler.handleRequest(request);
                Collection files = multipartHandler.getFileElements().values();
                Enumeration keys = multipartHandler.getFileElements().keys();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    FormFile file = (FormFile)multipartHandler.getFileElements().get(key);
                    long maxSize = WebUtils.getMaxUploadSize(form);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)file.getFileSize());
                    }
                    if (maxSize <= 0L || Long.parseLong(file.getFileSize() + "") <= maxSize) continue;
                    GlobalVariables.getMessageMap().putError(key.toString(), "error.uploadFile.size", new String[]{file.getFileName(), Long.toString(maxSize)});
                }
                if (servletWrapper == null) {
                    request.setAttribute("org.kuali.rice.krad.util.WebUtils.uploadedFiles", (Object)WebUtils.getFileParametersForMultipartRequest(request, (MultipartRequestHandler)multipartHandler));
                }
            }
        }
        catch (ServletException e) {
            throw new ValidationException("unable to handle multipart request " + e.getMessage(), (Throwable)e);
        }
    }

    public static long getMaxUploadSize(ActionForm form) {
        long max = 0L;
        KualiMultipartRequestHandler multipartHandler = new KualiMultipartRequestHandler();
        if (form instanceof PojoFormBase) {
            max = multipartHandler.calculateMaxUploadSizeToMaxOfList(((PojoFormBase)form).getMaxUploadSizes());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Max File Upload Size: " + max));
        }
        return max;
    }

    private static Map getFileParametersForMultipartRequest(HttpServletRequest request, MultipartRequestHandler multipartHandler) {
        String key;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Hashtable elements = multipartHandler.getFileElements();
        Enumeration e = elements.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            parameters.put(key, elements.get(key));
        }
        if (request instanceof MultipartRequestWrapper) {
            request = (HttpServletRequest)((MultipartRequestWrapper)request).getRequest();
            e = request.getParameterNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                parameters.put(key, request.getParameterValues(key));
            }
        } else {
            LOG.debug((Object)"Gathering multipart parameters for unwrapped request");
        }
        return parameters;
    }

    public static void registerEditableProperty(PojoFormBase form, String editablePropertyName) {
        form.registerEditableProperty(editablePropertyName);
    }

    public static boolean isDocumentSession(Document document, PojoFormBase docForm) {
        boolean sessionDoc = document instanceof SessionDocument;
        boolean dataDictionarySessionDoc = false;
        if (!sessionDoc) {
            DataDictionary dataDictionary = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary();
            if (docForm instanceof KualiMaintenanceForm) {
                KualiMaintenanceForm maintenanceForm = (KualiMaintenanceForm)docForm;
                if (dataDictionary != null && maintenanceForm.getDocTypeName() != null) {
                    MaintenanceDocumentEntry maintenanceDocumentEntry = (MaintenanceDocumentEntry)dataDictionary.getDocumentEntry(maintenanceForm.getDocTypeName());
                    dataDictionarySessionDoc = maintenanceDocumentEntry.isSessionDocument();
                }
            } else if (document != null && dataDictionary != null) {
                KNSDocumentEntry documentEntry = (KNSDocumentEntry)dataDictionary.getDocumentEntry(document.getClass().getName());
                dataDictionarySessionDoc = documentEntry.isSessionDocument();
            }
        }
        return sessionDoc || dataDictionarySessionDoc;
    }

    public static boolean isFormSessionDocument(PojoFormBase form) {
        Document document = null;
        if (KualiDocumentFormBase.class.isAssignableFrom(form.getClass())) {
            KualiDocumentFormBase docForm = (KualiDocumentFormBase)form;
            document = docForm.getDocument();
        }
        return WebUtils.isDocumentSession(document, form);
    }

    public static ActionForm getKualiForm(PageContext pageContext) {
        return WebUtils.getKualiForm((HttpServletRequest)pageContext.getRequest());
    }

    public static ActionForm getKualiForm(HttpServletRequest request) {
        if (request.getAttribute(KEY_KUALI_FORM_IN_SESSION) != null) {
            return (ActionForm)request.getAttribute(KEY_KUALI_FORM_IN_SESSION);
        }
        HttpSession session = request.getSession(false);
        return session != null ? (ActionForm)session.getAttribute(KEY_KUALI_FORM_IN_SESSION) : null;
    }

    public static boolean isPropertyEditable(Set<String> editableProperties, String propertyName) {
        boolean returnVal;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isPropertyEditable(" + propertyName + ")"));
        }
        boolean bl = returnVal = editableProperties == null || editableProperties.contains(propertyName) || WebUtils.getIndexOfCoordinateExtension(propertyName) != -1 && editableProperties.contains(propertyName.substring(0, WebUtils.getIndexOfCoordinateExtension(propertyName)));
        if (!returnVal && LOG.isDebugEnabled()) {
            LOG.debug((Object)("isPropertyEditable(" + propertyName + ") == false / editableProperties: " + editableProperties));
        }
        return returnVal;
    }

    public static boolean endsWithCoordinates(String parameter) {
        return parameter.endsWith(IMAGE_COORDINATE_CLICKED_X_EXTENSION) || parameter.endsWith(IMAGE_COORDINATE_CLICKED_Y_EXTENSION);
    }

    public static int getIndexOfCoordinateExtension(String parameter) {
        int indexOfCoordinateExtension = parameter.lastIndexOf(IMAGE_COORDINATE_CLICKED_X_EXTENSION);
        if (indexOfCoordinateExtension == -1) {
            indexOfCoordinateExtension = parameter.lastIndexOf(IMAGE_COORDINATE_CLICKED_Y_EXTENSION);
        }
        return indexOfCoordinateExtension;
    }

    public static boolean isInquiryHiddenField(String className, String fieldName, Object formObject, String propertyName) {
        boolean isHidden = false;
        String hiddenInquiryFields = WebUtils.getKualiConfigurationService().getPropertyValueAsString(className + ".hidden");
        if (StringUtils.isEmpty((String)hiddenInquiryFields)) {
            return isHidden;
        }
        List<String> hiddenFields = Arrays.asList(hiddenInquiryFields.replaceAll(" ", "").split(","));
        if (hiddenFields.contains(fieldName.trim())) {
            isHidden = true;
        }
        return isHidden;
    }

    public static boolean isHiddenKimObjectType(String type, String configParameter) {
        boolean hideType = false;
        String hiddenTypes = WebUtils.getKualiConfigurationService().getPropertyValueAsString(configParameter);
        if (StringUtils.isEmpty((String)hiddenTypes)) {
            return hideType;
        }
        List<String> hiddenTypeValues = Arrays.asList(hiddenTypes.replaceAll(" ", "").split(","));
        if (hiddenTypeValues.contains(type.trim())) {
            hideType = true;
        }
        return hideType;
    }

    public static String getFullyMaskedValue(String className, String fieldName, Object formObject, String propertyName) {
        String displayMaskValue = null;
        Object propertyValue = ObjectUtils.getPropertyValue(formObject, propertyName);
        DataDictionaryEntryBase entry = (DataDictionaryEntryBase)KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(className);
        AttributeDefinition a = entry.getAttributeDefinition(fieldName);
        AttributeSecurity attributeSecurity = a.getAttributeSecurity();
        if (attributeSecurity != null && attributeSecurity.isMask()) {
            MaskFormatter maskFormatter = attributeSecurity.getMaskFormatter();
            displayMaskValue = maskFormatter.maskValue(propertyValue);
        }
        return displayMaskValue;
    }

    public static String getPartiallyMaskedValue(String className, String fieldName, Object formObject, String propertyName) {
        String displayMaskValue = null;
        Object propertyValue = ObjectUtils.getPropertyValue(formObject, propertyName);
        DataDictionaryEntryBase entry = (DataDictionaryEntryBase)KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(className);
        AttributeDefinition a = entry.getAttributeDefinition(fieldName);
        AttributeSecurity attributeSecurity = a.getAttributeSecurity();
        if (attributeSecurity != null && attributeSecurity.isPartialMask()) {
            MaskFormatter partialMaskFormatter = attributeSecurity.getPartialMaskFormatter();
            displayMaskValue = partialMaskFormatter.maskValue(propertyValue);
        }
        return displayMaskValue;
    }

    public static boolean canFullyUnmaskField(String businessObjectClassName, String fieldName, KualiForm form) {
        Class<?> businessObjClass = null;
        try {
            businessObjClass = Class.forName(businessObjectClassName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to resolve class name: " + businessObjectClassName);
        }
        if (form instanceof KualiDocumentFormBase) {
            return KNSServiceLocator.getBusinessObjectAuthorizationService().canFullyUnmaskField(GlobalVariables.getUserSession().getPerson(), businessObjClass, fieldName, ((KualiDocumentFormBase)form).getDocument());
        }
        return KNSServiceLocator.getBusinessObjectAuthorizationService().canFullyUnmaskField(GlobalVariables.getUserSession().getPerson(), businessObjClass, fieldName, null);
    }

    public static boolean canPartiallyUnmaskField(String businessObjectClassName, String fieldName, KualiForm form) {
        Class<?> businessObjClass = null;
        try {
            businessObjClass = Class.forName(businessObjectClassName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to resolve class name: " + businessObjectClassName);
        }
        if (form instanceof KualiDocumentFormBase) {
            return KNSServiceLocator.getBusinessObjectAuthorizationService().canPartiallyUnmaskField(GlobalVariables.getUserSession().getPerson(), businessObjClass, fieldName, ((KualiDocumentFormBase)form).getDocument());
        }
        return KNSServiceLocator.getBusinessObjectAuthorizationService().canPartiallyUnmaskField(GlobalVariables.getUserSession().getPerson(), businessObjClass, fieldName, null);
    }

    public static boolean canAddNoteAttachment(Document document) {
        boolean canViewNoteAttachment = false;
        DocumentAuthorizer documentAuthorizer = KNSServiceLocator.getDocumentHelperService().getDocumentAuthorizer(document);
        canViewNoteAttachment = documentAuthorizer.canAddNoteAttachment(document, null, GlobalVariables.getUserSession().getPerson());
        return canViewNoteAttachment;
    }

    public static boolean canViewNoteAttachment(Document document, String attachmentTypeCode) {
        boolean canViewNoteAttachment = false;
        DocumentAuthorizer documentAuthorizer = KNSServiceLocator.getDocumentHelperService().getDocumentAuthorizer(document);
        canViewNoteAttachment = documentAuthorizer.canViewNoteAttachment(document, attachmentTypeCode, GlobalVariables.getUserSession().getPerson());
        return canViewNoteAttachment;
    }

    public static boolean canDeleteNoteAttachment(Document document, String attachmentTypeCode, String authorUniversalIdentifier) {
        boolean canDeleteNoteAttachment = false;
        DocumentAuthorizer documentAuthorizer = KNSServiceLocator.getDocumentHelperService().getDocumentAuthorizer(document);
        canDeleteNoteAttachment = documentAuthorizer.canDeleteNoteAttachment(document, attachmentTypeCode, "false", GlobalVariables.getUserSession().getPerson());
        if (canDeleteNoteAttachment) {
            return canDeleteNoteAttachment;
        }
        canDeleteNoteAttachment = documentAuthorizer.canDeleteNoteAttachment(document, attachmentTypeCode, "true", GlobalVariables.getUserSession().getPerson());
        if (canDeleteNoteAttachment && !authorUniversalIdentifier.equals(GlobalVariables.getUserSession().getPerson().getPrincipalId())) {
            canDeleteNoteAttachment = false;
        }
        return canDeleteNoteAttachment;
    }

    public static void reuseErrorMapFromPreviousRequest(KualiDocumentFormBase kualiDocumentFormBase) {
        if (kualiDocumentFormBase.getMessageMapFromPreviousRequest() == null) {
            LOG.error((Object)"Error map from previous request is null!");
            return;
        }
        MessageMap errorMapFromGlobalVariables = GlobalVariables.getMessageMap();
        if (kualiDocumentFormBase.getMessageMapFromPreviousRequest() == errorMapFromGlobalVariables) {
            return;
        }
        if (!errorMapFromGlobalVariables.hasNoErrors()) {
            throw new RuntimeException("Cannot replace error map because it is not empty");
        }
        GlobalVariables.setMessageMap((MessageMap)kualiDocumentFormBase.getMessageMapFromPreviousRequest());
        GlobalVariables.getMessageMap().clearErrorPath();
    }

    public static String filterHtmlAndReplaceRiceMarkup(String inputString) {
        String outputString = StringEscapeUtils.escapeHtml((String)inputString);
        LinkedHashMap<String, String> findAndReplacePatterns = new LinkedHashMap<String, String>();
        findAndReplacePatterns.put("\\[a ((javascript|JAVASCRIPT|JavaScript).+)\\]", "");
        findAndReplacePatterns.put("\\[a (.+)\\]", "<a href=\"$1\">");
        findAndReplacePatterns.put("\\[/a\\]", "</a>");
        findAndReplacePatterns.put("\\[([A-Za-z])\\]", "<$1>");
        findAndReplacePatterns.put("\\[/([A-Za-z])\\]", "</$1>");
        findAndReplacePatterns.put("\\[([A-Za-z]{2})\\]", "<$1>");
        findAndReplacePatterns.put("\\[/([A-Za-z]{2})\\]", "</$1>");
        findAndReplacePatterns.put("\\[font (#[0-9A-Fa-f]{1,6}|[A-Za-z]+)\\]", "<font color=\"$1\">");
        findAndReplacePatterns.put("\\[/font\\]", "</font>");
        findAndReplacePatterns.put("\\[table\\]", "<table>");
        findAndReplacePatterns.put("\\[table ([A-Za-z]+)\\]", "<table class=\"$1\">");
        findAndReplacePatterns.put("\\[/table\\]", "</table>");
        findAndReplacePatterns.put("\\[td ([A-Za-z]+)\\]", "<td class=\"$1\">");
        for (String findPattern : findAndReplacePatterns.keySet()) {
            Pattern p = Pattern.compile(findPattern);
            Matcher m = p.matcher(outputString);
            if (!m.find()) continue;
            String replacePattern = (String)findAndReplacePatterns.get(findPattern);
            outputString = m.replaceAll(replacePattern);
        }
        return outputString;
    }

    public static String getButtonImageUrl(String imageName) {
        String buttonImageUrl = WebUtils.getKualiConfigurationService().getPropertyValueAsString("application.custom.image.url." + imageName);
        if (StringUtils.isBlank((String)buttonImageUrl)) {
            buttonImageUrl = WebUtils.getDefaultButtonImageUrl(imageName);
        }
        return buttonImageUrl;
    }

    public static String getAttachmentImageForUrl(String contentType) {
        String image = WebUtils.getKualiConfigurationService().getPropertyValueAsString("attach.img." + contentType);
        if (StringUtils.isEmpty((String)image)) {
            return WebUtils.getKualiConfigurationService().getPropertyValueAsString("attach.img.default");
        }
        return image;
    }

    public static String getDefaultButtonImageUrl(String imageName) {
        return WebUtils.getKualiConfigurationService().getPropertyValueAsString(DEFAULT_IMAGE_URL_PROPERTY_NAME) + "buttonsmall_" + imageName + ".gif";
    }

    public static ConfigurationService getKualiConfigurationService() {
        if (configurationService == null) {
            configurationService = CoreApiServiceLocator.getKualiConfigurationService();
        }
        return configurationService;
    }

    public static String preserveWhitespace(String startingString) {
        String convertedString = startingString.replaceAll("\n", "<br />");
        convertedString = convertedString.replaceAll("  ", "&nbsp;&nbsp;").replaceAll("(&nbsp; | &nbsp;)", "&nbsp;&nbsp;");
        return convertedString;
    }

    public static String getKimGroupDisplayName(String groupId) {
        if (StringUtils.isBlank((String)groupId)) {
            throw new IllegalArgumentException("Group ID must have a value");
        }
        return KimApiServiceLocator.getGroupService().getGroup(groupId).getName();
    }

    public static String getPrincipalDisplayName(String principalId) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new IllegalArgumentException("Principal ID must have a value");
        }
        if (KimApiServiceLocator.getIdentityService().getDefaultNamesForPrincipalId(principalId) == null) {
            return "";
        }
        return KimApiServiceLocator.getIdentityService().getDefaultNamesForPrincipalId(principalId).getDefaultName().getCompositeName();
    }

    public static String getRoleDisplayName(ActionRequest actionRequest) {
        if (actionRequest == null) {
            throw new IllegalArgumentException("actionRequest must be non-null");
        }
        if (RecipientType.ROLE != actionRequest.getRecipientType()) {
            throw new IllegalArgumentException("actionRequest recipient must be a Role");
        }
        Role role = KimApiServiceLocator.getRoleService().getRole(actionRequest.getRoleName());
        String result = role != null ? role.getName() : (!StringUtils.isBlank((String)actionRequest.getQualifiedRoleNameLabel()) ? actionRequest.getQualifiedRoleNameLabel() : actionRequest.getRoleName());
        return result;
    }

    public static String toAbsoluteURL(String base, String path) {
        boolean abs = false;
        if (StringUtils.isBlank((String)path)) {
            path = "";
        } else {
            for (String scheme : SCHEMES) {
                if (!path.startsWith(scheme)) continue;
                abs = true;
                break;
            }
        }
        if (abs) {
            return path;
        }
        return base + path;
    }

    public static String sanitizeBackLocation(String backLocation) {
        if (StringUtils.isBlank((String)backLocation)) {
            return backLocation;
        }
        try {
            URI uri = new URI(backLocation);
            if (!uri.isAbsolute()) {
                return backLocation;
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        Pattern pattern = Pattern.compile(ConfigContext.getCurrentContextConfig().getProperty("rice.backLocation.allowed.regex"));
        if (pattern.matcher(backLocation).matches()) {
            return backLocation;
        }
        return ConfigContext.getCurrentContextConfig().getProperty("rice.backLocation.default.url");
    }

    static {
        KEY_KUALI_FORM_IN_SESSION = "KualiForm";
    }
}

