/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.web.comparator;

import org.displaytag.model.Cell;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kns.web.comparator.CellComparatorHelper;

public class CellComparatorHelperTest {
    @Test
    public void testExtractFromHref() {
        String href = "<a style=\"color: red;\" href=\"inquiry.do?businessObjectClassName=org.kuali.rice.krad.bo.Options&amp;universityFiscalYear=2004&amp;methodToCall=start\" target=\"blank\">needle</a>";
        Cell cell = new Cell((Object)href);
        Assert.assertEquals((Object)CellComparatorHelper.getSanitizedStaticValue((Cell)cell), (Object)"needle");
    }

    @Test
    public void testExtractFromHrefAndRemoveNbsp() {
        String href = "<a href=\"haystack\">needle&nbsp;</a>";
        Cell cell = new Cell((Object)href);
        Assert.assertEquals((Object)CellComparatorHelper.getSanitizedStaticValue((Cell)cell), (Object)"needle");
    }

    @Test
    public void testRemoveNbsp() {
        String bad = "needle&nbsp;";
        Cell cell = new Cell((Object)bad);
        Assert.assertEquals((Object)CellComparatorHelper.getSanitizedStaticValue((Cell)cell), (Object)"needle");
    }

    @Test
    public void testLeaveSimpleValueAlone() {
        String good = "needle";
        Cell cell = new Cell((Object)good);
        Assert.assertEquals((Object)CellComparatorHelper.getSanitizedStaticValue((Cell)cell), (Object)"needle");
    }

    @Test
    public void testMessyHref() {
        String href = "<a onClick=\"foo();\" href=\"haystack\" class=\"my favorite class\" >needle</a>&nbsp;";
        Cell cell = new Cell((Object)href);
        Assert.assertEquals((Object)CellComparatorHelper.getSanitizedStaticValue((Cell)cell), (Object)"needle");
    }
}

