/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa.eclipselink;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ConverterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kuali.rice.krad.data.jpa.eclipselink.EclipseLinkJpaMetadataProviderImpl;
import org.kuali.rice.krad.data.jpa.testbo.TestDataObject;
import org.kuali.rice.krad.data.jpa.testbo.TestDataObjectExtension;
import org.kuali.rice.krad.data.provider.annotation.impl.AnnotationMetadataProviderImpl;
import org.kuali.rice.krad.data.provider.impl.CompositeMetadataProviderImpl;

public class EclipseLinkAnnotationMetadataProviderImplTest {
    static EclipseLinkJpaMetadataProviderImpl jpaMetadataProvider;
    CompositeMetadataProviderImpl compositeProvider;
    AnnotationMetadataProviderImpl annotationMetadataProvider;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        BasicConfigurator.configure();
        Logger.getLogger(CompositeMetadataProviderImpl.class).setLevel(Level.DEBUG);
        Logger.getLogger(AnnotationMetadataProviderImpl.class).setLevel(Level.DEBUG);
        Logger.getLogger(EclipseLinkJpaMetadataProviderImpl.class).setLevel(Level.DEBUG);
        jpaMetadataProvider = new EclipseLinkJpaMetadataProviderImpl();
        EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)"krad-data-unit-test");
        jpaMetadataProvider.setEntityManager(entityManagerFactory.createEntityManager());
    }

    @Before
    public void setUp() throws Exception {
        if (this.annotationMetadataProvider == null) {
            this.annotationMetadataProvider = new AnnotationMetadataProviderImpl();
            ArrayList<Object> providers = new ArrayList<Object>();
            providers.add(jpaMetadataProvider);
            providers.add(this.annotationMetadataProvider);
            this.compositeProvider = new CompositeMetadataProviderImpl();
            this.compositeProvider.setProviders(providers);
            this.compositeProvider.provideMetadata();
        }
    }

    @Test
    public void testConvertersEstabished_directAssignment() throws Exception {
        ClassDescriptor classDescriptor = jpaMetadataProvider.getClassDescriptor(TestDataObject.class);
        DatabaseMapping attribute = classDescriptor.getMappingForAttributeName("nonStandardDataType");
        Assert.assertEquals((String)"attribute data type mismatch", DirectToFieldMapping.class, attribute.getClass());
        Converter converter = ((DirectToFieldMapping)attribute).getConverter();
        Assert.assertNotNull((String)"converter not assigned", (Object)converter);
        Assert.assertEquals((String)"Mismatch - converter should have been the EclipseLink JPA wrapper class", ConverterClass.class, converter.getClass());
        Field f = ConverterClass.class.getDeclaredField("attributeConverterClassName");
        f.setAccessible(true);
        String attributeConverterClassName = (String)f.get(converter);
        Assert.assertNotNull((String)"attributeConverterClassName missing", (Object)attributeConverterClassName);
        Assert.assertEquals((String)"Converter class incorrect", (Object)"org.kuali.rice.krad.data.jpa.testbo.NonStandardDataTypeConverter", (Object)attributeConverterClassName);
    }

    @Test
    public void testConvertersEstabished_autoApply() throws Exception {
        ClassDescriptor classDescriptor = jpaMetadataProvider.getClassDescriptor(TestDataObject.class);
        DatabaseMapping attribute = classDescriptor.getMappingForAttributeName("currencyProperty");
        Assert.assertEquals((String)"attribute data type mismatch", DirectToFieldMapping.class, attribute.getClass());
        Converter converter = ((DirectToFieldMapping)attribute).getConverter();
        Assert.assertNotNull((String)"converter not assigned", (Object)converter);
        Assert.assertEquals((String)"Mismatch - converter should have been the EclipseLink JPA wrapper class", ConverterClass.class, converter.getClass());
        Field f = ConverterClass.class.getDeclaredField("attributeConverterClassName");
        f.setAccessible(true);
        String attributeConverterClassName = (String)f.get(converter);
        Assert.assertNotNull((String)"attributeConverterClassName missing", (Object)attributeConverterClassName);
        Assert.assertEquals((String)"Converter class incorrect", (Object)"org.kuali.rice.krad.data.jpa.converters.KualiDecimalConverter", (Object)attributeConverterClassName);
    }

    @Test
    public void testConvertersEstabished_autoApply_Boolean() throws Exception {
        ClassDescriptor classDescriptor = jpaMetadataProvider.getClassDescriptor(TestDataObject.class);
        DatabaseMapping attribute = classDescriptor.getMappingForAttributeName("booleanProperty");
        Assert.assertEquals((String)"attribute data type mismatch", DirectToFieldMapping.class, attribute.getClass());
        Converter converter = ((DirectToFieldMapping)attribute).getConverter();
        Assert.assertNotNull((String)"converter not assigned", (Object)converter);
        Assert.assertEquals((String)"Mismatch - converter should have been the EclipseLink JPA wrapper class", ConverterClass.class, converter.getClass());
        Field f = ConverterClass.class.getDeclaredField("attributeConverterClassName");
        f.setAccessible(true);
        String attributeConverterClassName = (String)f.get(converter);
        Assert.assertNotNull((String)"attributeConverterClassName missing", (Object)attributeConverterClassName);
        Assert.assertEquals((String)"Converter class incorrect", (Object)"org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter", (Object)attributeConverterClassName);
    }

    @Test
    public void testExtensionAttribute_eclipselink_data() {
        ClassDescriptor classDescriptor = jpaMetadataProvider.getClassDescriptor(TestDataObject.class);
        ClassDescriptor referenceDescriptor = jpaMetadataProvider.getClassDescriptor(TestDataObjectExtension.class);
        Assert.assertNotNull((String)"A classDescriptor should have been retrieved from JPA for TestDataObject", (Object)classDescriptor);
        Assert.assertNotNull((String)"A classDescriptor should have been retrieved from JPA for TestDataObjectExtension", (Object)referenceDescriptor);
        DatabaseMapping databaseMapping = classDescriptor.getMappingForAttributeName("extension");
        Assert.assertNotNull((String)"extension mapping missing from metamodel", (Object)databaseMapping);
        Assert.assertTrue((String)"Should be a OneToOne mapping", (boolean)(databaseMapping instanceof OneToOneMapping));
        OneToOneMapping mapping = (OneToOneMapping)databaseMapping;
        Assert.assertEquals((String)"Should be mapped by primaryKeyProperty", (Object)"primaryKeyProperty", (Object)mapping.getMappedBy());
        Map databaseFields = mapping.getSourceToTargetKeyFields();
        Assert.assertEquals((long)1L, (long)databaseFields.size());
        for (DatabaseField sourceField : databaseFields.keySet()) {
            DatabaseField targetField = (DatabaseField)databaseFields.get(sourceField);
            Assert.assertEquals((Object)"PK_PROP", (Object)sourceField.getName());
            Assert.assertEquals((Object)"PK_PROP", (Object)targetField.getName());
        }
        Assert.assertNotNull((String)"Reference descriptor missing from relationship", (Object)mapping.getReferenceDescriptor());
        Assert.assertEquals((String)"Reference descriptor should be the one for TestDataObjectExtension", (Object)referenceDescriptor, (Object)mapping.getReferenceDescriptor());
        Assert.assertNotNull((String)"selection query relationship missing", (Object)mapping.getSelectionQuery());
        Assert.assertNotNull((String)"selection query missing name", (Object)mapping.getSelectionQuery().getName());
        Assert.assertEquals((String)"selection query name incorrect", (Object)"extension", (Object)mapping.getSelectionQuery().getName());
        Assert.assertNotNull((String)"selection query reference class", (Object)mapping.getSelectionQuery().getReferenceClass());
        Assert.assertEquals((String)"selection query reference class incorrect", TestDataObjectExtension.class, (Object)mapping.getSelectionQuery().getReferenceClass());
        Assert.assertNotNull((String)"selection query reference class name", (Object)mapping.getSelectionQuery().getReferenceClassName());
        Assert.assertNotNull((String)"selection query source mapping missing", (Object)mapping.getSelectionQuery().getSourceMapping());
        Assert.assertEquals((String)"selection query source mapping incorrect", (Object)mapping, (Object)mapping.getSelectionQuery().getSourceMapping());
    }
}

