/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa.eclipselink;

import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.eclipse.persistence.exceptions.TransactionException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.framework.persistence.jta.Jta;
import org.kuali.rice.krad.data.jpa.eclipselink.JtaTransactionController;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class JtaTransactionControllerTest {
    @Mock
    private TransactionManager transactionManager;
    @Mock
    private UserTransaction userTransaction;

    @Test
    public void testAcquireTransactionManager_JtaDisabled() throws Exception {
        Assert.assertFalse((boolean)Jta.isEnabled());
        try {
            new JtaTransactionController();
            Assert.fail((String)"A TransactionException should have been thrown");
        }
        catch (TransactionException e) {
            Assert.assertEquals((long)23004L, (long)e.getErrorCode());
            Assert.assertEquals(IllegalStateException.class, e.getInternalException().getClass());
        }
    }

    @Test
    public void testAcquireTransactionManager() throws Exception {
        Jta.configure((TransactionManager)this.transactionManager, (UserTransaction)this.userTransaction);
        try {
            Assert.assertTrue((boolean)Jta.isEnabled());
            JtaTransactionController controller = new JtaTransactionController();
            Assert.assertEquals((Object)this.transactionManager, (Object)controller.acquireTransactionManager());
        }
        finally {
            Jta.reset();
        }
    }
}

