/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.provider;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kuali.rice.krad.data.jpa.eclipselink.EclipseLinkJpaMetadataProviderImpl;
import org.kuali.rice.krad.data.jpa.testbo.TestDataObject;
import org.kuali.rice.krad.data.metadata.DataObjectAttribute;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.provider.impl.CompositeMetadataProviderImpl;
import org.kuali.rice.krad.data.provider.spring.SpringMetadataProviderImpl;

public class CompositeMetadataProviderImplTest {
    static EclipseLinkJpaMetadataProviderImpl metadataProvider;
    CompositeMetadataProviderImpl compositeProvider;
    SpringMetadataProviderImpl springProvider;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        BasicConfigurator.configure();
        Logger.getLogger(CompositeMetadataProviderImpl.class).setLevel(Level.DEBUG);
        Logger.getLogger(SpringMetadataProviderImpl.class).setLevel(Level.DEBUG);
        metadataProvider = new EclipseLinkJpaMetadataProviderImpl();
        EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)"krad-data-unit-test");
        metadataProvider.setEntityManager(entityManagerFactory.createEntityManager());
    }

    @Before
    public void setUp() throws Exception {
        this.springProvider = new SpringMetadataProviderImpl();
        ArrayList<String> springFileLocations = new ArrayList<String>();
        springFileLocations.add("classpath:org/kuali/rice/krad/data/provider/spring/krad-metadata-parent-beans.xml");
        springFileLocations.add("classpath:org/kuali/rice/krad/data/provider/spring/*.xml");
        this.springProvider.setResourceLocations(springFileLocations);
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(metadataProvider);
        providers.add(this.springProvider);
        this.compositeProvider = new CompositeMetadataProviderImpl();
        this.compositeProvider.setProviders(providers);
    }

    @Test
    public void testProvideMetadata() {
        Assert.assertNotNull((String)"Metadata map should not be null", (Object)this.compositeProvider.provideMetadata());
        Assert.assertFalse((String)"Metadata map should not have been empty", (boolean)this.compositeProvider.provideMetadata().isEmpty());
        DataObjectMetadata metadata = (DataObjectMetadata)this.compositeProvider.provideMetadata().get(TestDataObject.class);
        Assert.assertNotNull((String)"Metadata should have been retrieved for TestDataObject", (Object)metadata);
        Assert.assertEquals((String)"Label not read properly from metadata provider", (Object)"A Spring-Provided Label", (Object)metadata.getLabel());
        Assert.assertEquals((String)"backing object name not read properly from metadata provider", (Object)"ANOTHER_TABLE_NAME_T", (Object)metadata.getBackingObjectName());
        Assert.assertFalse((String)"Attributes should still be present from the OJB metadata", (boolean)metadata.getAttributes().isEmpty());
        System.err.println(metadata);
    }

    @Test
    public void testMergedSpringAttribute() {
        DataObjectMetadata metadata = (DataObjectMetadata)this.compositeProvider.provideMetadata().get(TestDataObject.class);
        Assert.assertNotNull((String)"Metadata should have been retrieved for TestDataObject", (Object)metadata);
        List attributes = metadata.getAttributes();
        Assert.assertFalse((String)"Attributes should still be present from the OJB metadata", (boolean)attributes.isEmpty());
        boolean listContainsStringProperty = false;
        boolean listContainsNewProperty = false;
        for (DataObjectAttribute attr : attributes) {
            if (attr.getName().equals("stringProperty")) {
                listContainsStringProperty = true;
            }
            if (!attr.getName().equals("nonPersistedProperty")) continue;
            listContainsNewProperty = true;
        }
        System.err.println(attributes);
        Assert.assertTrue((String)"stringProperty should still have been in the attribute list", (boolean)listContainsStringProperty);
        Assert.assertTrue((String)"nonPersistedProperty should have been added to the attribute list", (boolean)listContainsNewProperty);
        Assert.assertNotNull((String)"getAttribute(stringProperty) should not have returned null", (Object)metadata.getAttribute("stringProperty"));
        Assert.assertNotNull((String)"getAttribute(nonPersistedProperty) should not have returned null", (Object)metadata.getAttribute("nonPersistedProperty"));
        Assert.assertNotNull((String)"getAttribute(nonStandardDataType) should not have returned null", (Object)metadata.getAttribute("nonStandardDataType"));
        Assert.assertEquals((String)"getAttribute(nonPersistedProperty) label incorrect", (Object)"Attribute Added via Spring", (Object)metadata.getAttribute("nonPersistedProperty").getLabel());
        Assert.assertEquals((String)"getAttribute(nonStandardDataType) label incorrect", (Object)"Non Standard Label-Spring", (Object)metadata.getAttribute("nonStandardDataType").getLabel());
        Assert.assertEquals((String)"getAttribute(nonStandardDataType) backing object incorrect", (Object)"NON_STANDARD", (Object)metadata.getAttribute("nonStandardDataType").getBackingObjectName());
    }

    @Test
    public void testMergedSpringAttribute_Remove() {
        DataObjectMetadata metadata = (DataObjectMetadata)this.compositeProvider.provideMetadata().get(TestDataObject.class);
        Assert.assertNotNull((String)"Metadata should have been retrieved for TestDataObject", (Object)metadata);
        List attributes = metadata.getAttributes();
        Assert.assertFalse((String)"Attributes should still be present from the OJB metadata", (boolean)attributes.isEmpty());
        boolean listContainsDateProperty = false;
        for (DataObjectAttribute attr : attributes) {
            if (!attr.getName().equals("dateProperty")) continue;
            listContainsDateProperty = true;
        }
        System.err.println(attributes);
        Assert.assertFalse((String)"dateProperty should not have been in the attribute list", (boolean)listContainsDateProperty);
        Assert.assertNull((String)"getAttribute(dateProperty) should have returned null", (Object)metadata.getAttribute("dateProperty"));
    }
}

