/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.criteria.EqualPredicate;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.MaterializeOption;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.metadata.MetadataChild;
import org.kuali.rice.krad.data.metadata.impl.DataObjectAttributeRelationshipImpl;
import org.kuali.rice.krad.data.metadata.impl.DataObjectCollectionImpl;
import org.kuali.rice.krad.data.metadata.impl.DataObjectRelationshipImpl;
import org.kuali.rice.krad.data.provider.impl.DataObjectWrapperBase;
import org.kuali.rice.krad.data.util.ReferenceLinker;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.NullValueInNestedPathException;

@RunWith(value=MockitoJUnitRunner.class)
public class DataObjectWrapperBaseTest {
    @Mock
    private DataObjectService dataObjectService;
    @Mock
    private DataObjectMetadata dataObjectMetadata;
    @Mock
    private DataObjectMetadata dataObject2Metadata;
    @Mock
    private DataObjectMetadata dataObject3Metadata;
    @Mock
    private DataObjectMetadata dataObject4Metadata;
    @Mock
    private DataObjectMetadata dataObject5Metadata;
    @Mock
    private ReferenceLinker referenceLinker;
    private DataObject dataObject;
    private DataObject2 dataObject2;
    private DataObject4 dataObject4;
    private DataObjectWrapperBase<DataObject> wrap;

    protected void setUpDataObjectMetadataMocks() {
        Mockito.when((Object)this.dataObjectService.supports(DataObject.class)).thenReturn((Object)true);
        Mockito.when((Object)this.dataObjectMetadata.getType()).thenReturn(DataObject.class);
        Mockito.when((Object)this.dataObjectMetadata.getPrimaryKeyAttributeNames()).thenReturn(Collections.singletonList("id"));
        DataObjectRelationshipImpl dataObject2Relationship = new DataObjectRelationshipImpl();
        dataObject2Relationship.setName("dataObject2");
        dataObject2Relationship.setRelatedType(DataObject2.class);
        dataObject2Relationship.setSavedWithParent(false);
        dataObject2Relationship.setLoadedAtParentLoadTime(false);
        dataObject2Relationship.setLoadedDynamicallyUponUse(true);
        dataObject2Relationship.setAttributeRelationships(Collections.singletonList(new DataObjectAttributeRelationshipImpl("dataObject2sKey", "one")));
        Mockito.when((Object)this.dataObjectMetadata.getRelationship("dataObject2")).thenReturn((Object)dataObject2Relationship);
        DataObjectRelationshipImpl eagerDataObject2Relationship = new DataObjectRelationshipImpl();
        eagerDataObject2Relationship.setName("eagerDataObject2");
        eagerDataObject2Relationship.setRelatedType(DataObject2.class);
        eagerDataObject2Relationship.setSavedWithParent(false);
        eagerDataObject2Relationship.setLoadedAtParentLoadTime(true);
        eagerDataObject2Relationship.setLoadedDynamicallyUponUse(false);
        eagerDataObject2Relationship.setAttributeRelationships(Collections.singletonList(new DataObjectAttributeRelationshipImpl("dataObject2sKey", "one")));
        Mockito.when((Object)this.dataObjectMetadata.getRelationship("eagerDataObject2")).thenReturn((Object)eagerDataObject2Relationship);
        Mockito.when((Object)this.dataObjectMetadata.getRelationships()).thenReturn(Arrays.asList(dataObject2Relationship, eagerDataObject2Relationship));
        DataObjectCollectionImpl dataObject3Relationship = new DataObjectCollectionImpl();
        dataObject3Relationship.setName("dataObject3s");
        dataObject3Relationship.setRelatedType(DataObject3.class);
        dataObject3Relationship.setSavedWithParent(true);
        dataObject3Relationship.setLoadedAtParentLoadTime(false);
        dataObject3Relationship.setLoadedDynamicallyUponUse(true);
        dataObject3Relationship.setAttributeRelationships(Collections.singletonList(new DataObjectAttributeRelationshipImpl("id", "parentId")));
        Mockito.when((Object)this.dataObjectMetadata.getCollections()).thenReturn(Collections.singletonList(dataObject3Relationship));
        Mockito.when((Object)this.dataObjectMetadata.getCollection("dataObject3s")).thenReturn((Object)dataObject3Relationship);
    }

    protected void setUpDataObject2MetadataMocks() {
        Mockito.when((Object)this.dataObjectService.supports(DataObject2.class)).thenReturn((Object)true);
        Mockito.when((Object)this.dataObject2Metadata.getType()).thenReturn(DataObject2.class);
        Mockito.when((Object)this.dataObject2Metadata.getPrimaryKeyAttributeNames()).thenReturn(Collections.singletonList("one"));
        DataObjectRelationshipImpl dataObject4Relationship = new DataObjectRelationshipImpl();
        dataObject4Relationship.setName("dataObject4");
        dataObject4Relationship.setRelatedType(DataObject4.class);
        dataObject4Relationship.setSavedWithParent(false);
        dataObject4Relationship.setLoadedAtParentLoadTime(false);
        dataObject4Relationship.setLoadedDynamicallyUponUse(true);
        dataObject4Relationship.setAttributeRelationships(Collections.singletonList(new DataObjectAttributeRelationshipImpl("two", "pk")));
        Mockito.when((Object)this.dataObject2Metadata.getRelationship("dataObject4")).thenReturn((Object)dataObject4Relationship);
        Mockito.when((Object)this.dataObject2Metadata.getRelationships()).thenReturn(Arrays.asList(dataObject4Relationship));
    }

    protected void setUpDataObject3MetadataMocks() {
        Mockito.when((Object)this.dataObjectService.supports(DataObject3.class)).thenReturn((Object)true);
        Mockito.when((Object)this.dataObject3Metadata.getType()).thenReturn(DataObject3.class);
        Mockito.when((Object)this.dataObject3Metadata.getPrimaryKeyAttributeNames()).thenReturn(Arrays.asList("parentId", "id"));
        DataObjectRelationshipImpl dataObject2Relationship = new DataObjectRelationshipImpl();
        dataObject2Relationship.setName("dataObject2");
        dataObject2Relationship.setRelatedType(DataObject2.class);
        dataObject2Relationship.setSavedWithParent(false);
        dataObject2Relationship.setLoadedAtParentLoadTime(false);
        dataObject2Relationship.setLoadedDynamicallyUponUse(true);
        dataObject2Relationship.setAttributeRelationships(Collections.singletonList(new DataObjectAttributeRelationshipImpl("world", "one")));
        Mockito.when((Object)this.dataObject3Metadata.getRelationship("dataObject2")).thenReturn((Object)dataObject2Relationship);
        Mockito.when((Object)this.dataObject3Metadata.getRelationships()).thenReturn(Arrays.asList(dataObject2Relationship));
    }

    protected void setUpDataObject4MetadataMocks() {
        Mockito.when((Object)this.dataObjectService.supports(DataObject4.class)).thenReturn((Object)true);
        Mockito.when((Object)this.dataObject4Metadata.getType()).thenReturn(DataObject4.class);
        Mockito.when((Object)this.dataObject4Metadata.getPrimaryKeyAttributeNames()).thenReturn(Collections.singletonList("pk"));
    }

    protected void setUpDataObject5MetadataMocks() {
        Mockito.when((Object)this.dataObjectService.supports(DataObject.class)).thenReturn((Object)true);
        Mockito.when((Object)this.dataObject5Metadata.getType()).thenReturn(DataObject.class);
        Mockito.when((Object)this.dataObject5Metadata.getPrimaryKeyAttributeNames()).thenReturn(Collections.singletonList("id"));
        DataObjectRelationshipImpl dataObject2Relationship = new DataObjectRelationshipImpl();
        dataObject2Relationship.setName("dataObject2");
        dataObject2Relationship.setRelatedType(DataObject2.class);
        dataObject2Relationship.setSavedWithParent(false);
        dataObject2Relationship.setLoadedAtParentLoadTime(false);
        dataObject2Relationship.setLoadedDynamicallyUponUse(true);
        dataObject2Relationship.setAttributeRelationships(Collections.singletonList(new DataObjectAttributeRelationshipImpl("dataObject2sKey", null)));
        Mockito.when((Object)this.dataObject5Metadata.getRelationship("dataObject2")).thenReturn((Object)dataObject2Relationship);
        DataObjectRelationshipImpl eagerDataObject2Relationship = new DataObjectRelationshipImpl();
        eagerDataObject2Relationship.setName("eagerDataObject2");
        eagerDataObject2Relationship.setRelatedType(DataObject2.class);
        eagerDataObject2Relationship.setSavedWithParent(false);
        eagerDataObject2Relationship.setLoadedAtParentLoadTime(true);
        eagerDataObject2Relationship.setLoadedDynamicallyUponUse(false);
        eagerDataObject2Relationship.setAttributeRelationships(Collections.singletonList(new DataObjectAttributeRelationshipImpl("dataObject2sKey", "one")));
        Mockito.when((Object)this.dataObject5Metadata.getRelationship("eagerDataObject2")).thenReturn((Object)eagerDataObject2Relationship);
        Mockito.when((Object)this.dataObject5Metadata.getRelationships()).thenReturn(Arrays.asList(dataObject2Relationship, eagerDataObject2Relationship));
        DataObjectCollectionImpl dataObject3Relationship = new DataObjectCollectionImpl();
        dataObject3Relationship.setName("dataObject3s");
        dataObject3Relationship.setRelatedType(DataObject3.class);
        dataObject3Relationship.setSavedWithParent(true);
        dataObject3Relationship.setLoadedAtParentLoadTime(false);
        dataObject3Relationship.setLoadedDynamicallyUponUse(true);
        dataObject3Relationship.setAttributeRelationships(Collections.singletonList(new DataObjectAttributeRelationshipImpl("id", "parentId")));
        Mockito.when((Object)this.dataObject5Metadata.getCollections()).thenReturn(Collections.singletonList(dataObject3Relationship));
        Mockito.when((Object)this.dataObject5Metadata.getCollection("dataObject3s")).thenReturn((Object)dataObject3Relationship);
    }

    protected void configureMocks() {
        this.setUpDataObjectMetadataMocks();
        this.setUpDataObject2MetadataMocks();
        this.setUpDataObject3MetadataMocks();
        this.setUpDataObject4MetadataMocks();
        this.setUpDataObject5MetadataMocks();
        Mockito.when((Object)this.dataObjectService.findMatching((Class)Matchers.any(Class.class), (QueryByCriteria)Matchers.any(QueryByCriteria.class))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) {
                Class dataObjectType = (Class)invocation.getArguments()[0];
                QueryByCriteria criteria = (QueryByCriteria)invocation.getArguments()[1];
                if (DataObject3.class.isAssignableFrom(dataObjectType) && criteria.getPredicate() instanceof EqualPredicate && ((EqualPredicate)criteria.getPredicate()).getPropertyPath().equals("parentId") && ((EqualPredicate)criteria.getPredicate()).getValue().getValue().equals("1")) {
                    GenericQueryResults.Builder builder = GenericQueryResults.Builder.create();
                    builder.setResults(Arrays.asList(new DataObject3("1", "C1", "hello", "world"), new DataObject3("1", "C2", "howdy", "Westeros")));
                    builder.setTotalRowCount(Integer.valueOf(2));
                    return builder.build();
                }
                return GenericQueryResults.Builder.create().build();
            }
        });
        Mockito.when((Object)this.dataObjectService.find((Class)Matchers.any(Class.class), Matchers.any())).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) {
                Class dataObjectType = (Class)invocation.getArguments()[0];
                Object primaryKey = invocation.getArguments()[1];
                if (DataObject2.class.isAssignableFrom(dataObjectType)) {
                    if (primaryKey instanceof String && StringUtils.equals((CharSequence)((String)primaryKey), (CharSequence)"one")) {
                        return DataObjectWrapperBaseTest.this.dataObject2;
                    }
                } else if (DataObject4.class.isAssignableFrom(dataObjectType) && primaryKey instanceof String && StringUtils.equals((CharSequence)((String)primaryKey), (CharSequence)"two")) {
                    return DataObjectWrapperBaseTest.this.dataObject4;
                }
                return null;
            }
        });
        Mockito.when((Object)this.dataObjectService.wrap(Matchers.any())).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) {
                Object object = invocation.getArguments()[0];
                if (object instanceof DataObject) {
                    return new DataObjectWrapperImpl((DataObject)object, DataObjectWrapperBaseTest.this.dataObjectMetadata, DataObjectWrapperBaseTest.this.dataObjectService, DataObjectWrapperBaseTest.this.referenceLinker);
                }
                if (object instanceof DataObject2) {
                    return new DataObjectWrapperImpl((DataObject2)object, DataObjectWrapperBaseTest.this.dataObject2Metadata, DataObjectWrapperBaseTest.this.dataObjectService, DataObjectWrapperBaseTest.this.referenceLinker);
                }
                if (object instanceof DataObject3) {
                    return new DataObjectWrapperImpl((DataObject3)object, DataObjectWrapperBaseTest.this.dataObject3Metadata, DataObjectWrapperBaseTest.this.dataObjectService, DataObjectWrapperBaseTest.this.referenceLinker);
                }
                if (object instanceof DataObject4) {
                    return new DataObjectWrapperImpl((DataObject4)object, DataObjectWrapperBaseTest.this.dataObject4Metadata, DataObjectWrapperBaseTest.this.dataObjectService, DataObjectWrapperBaseTest.this.referenceLinker);
                }
                return new DataObjectWrapperImpl(object, null, DataObjectWrapperBaseTest.this.dataObjectService, DataObjectWrapperBaseTest.this.referenceLinker);
            }
        });
    }

    @Before
    public void setup() throws Exception {
        this.dataObject = new DataObject("1", "FieldOne", 2, "one");
        this.dataObject2 = new DataObject2("one", "two");
        this.dataObject.setDataObject2(this.dataObject2);
        this.dataObject4 = new DataObject4("two", "some other value");
        this.wrap = new DataObjectWrapperImpl<DataObject>(this.dataObject, this.dataObjectMetadata, this.dataObjectService, this.referenceLinker);
        this.configureMocks();
    }

    @Test
    public void testGetForeignKeyAttributeMap_NoNullChildAttributeName() {
        this.wrap = new DataObjectWrapperImpl<DataObject>(this.dataObject, this.dataObject5Metadata, this.dataObjectService, this.referenceLinker);
        Map result = this.wrap.getForeignKeyAttributeMap("dataObject2");
        Assert.assertTrue((result.get(null) == null ? 1 : 0) != 0);
    }

    @Test
    public void testGetType() {
        Assert.assertEquals(DataObject.class, (Object)this.wrap.getWrappedClass());
    }

    @Test
    public void testGetMetadata() {
        Assert.assertEquals((Object)this.dataObjectMetadata, (Object)this.wrap.getMetadata());
    }

    @Test
    public void testGetWrappedInstance() {
        Assert.assertEquals((Object)this.dataObject, (Object)this.wrap.getWrappedInstance());
    }

    @Test
    public void testGetPrimaryKeyValues() {
        Map primaryKeyValues = this.wrap.getPrimaryKeyValues();
        Assert.assertEquals((long)1L, (long)primaryKeyValues.size());
        Assert.assertTrue((boolean)primaryKeyValues.containsKey("id"));
        Assert.assertEquals((Object)"1", primaryKeyValues.get("id"));
        Assert.assertEquals((String)"Mismatch on DataObject2's PKs", Collections.singletonMap("one", "one"), (Object)this.dataObjectService.wrap((Object)this.dataObject2).getPrimaryKeyValues());
    }

    @Test
    public void testEqualsByPrimaryKey() {
        Assert.assertTrue((boolean)this.wrap.equalsByPrimaryKey((Object)this.dataObject));
        Assert.assertTrue((boolean)this.wrap.equalsByPrimaryKey((Object)new DataObject("1", "blah", 500, "one")));
        Assert.assertFalse((boolean)this.wrap.equalsByPrimaryKey((Object)new DataObject("2", "FieldOne", 2, "one")));
        Assert.assertFalse((boolean)this.wrap.equalsByPrimaryKey(null));
        Assert.assertFalse((boolean)this.wrap.equalsByPrimaryKey((Object)new DataObject(null, null, -1, "one")));
    }

    @Test
    public void testGetPropertyType_Nested() {
        Assert.assertEquals(DataObject2.class, (Object)this.wrap.getPropertyType("dataObject2"));
        Assert.assertEquals(String.class, (Object)this.wrap.getPropertyType("dataObject2.one"));
        Assert.assertEquals(String.class, (Object)this.wrap.getPropertyType("dataObject2.two"));
    }

    @Test
    public void testGetPropertyValueNullSafe() {
        DataObject dataObject = new DataObject("a", "b", 3, "one");
        DataObjectWrapperImpl wrap = new DataObjectWrapperImpl(dataObject, this.dataObjectMetadata, this.dataObjectService, this.referenceLinker);
        Assert.assertNull((Object)wrap.getPropertyValue("dataObject2"));
        try {
            wrap.getPropertyValue("dataObject2.dataObject3");
            Assert.fail((String)"NullValueInNestedPathException should have been thrown");
        }
        catch (NullValueInNestedPathException nullValueInNestedPathException) {
            // empty catch block
        }
        Assert.assertNull((Object)wrap.getPropertyValueNullSafe("dataObject2.dataObject3"));
    }

    @Test
    public void testGetPropertyType_Collection() {
        DataObject dataObject = new DataObject("a", "b", 3, "one");
        DataObject3 do3_1 = new DataObject3();
        do3_1.setHello("hi");
        do3_1.setWorld("Earth");
        DataObject3 do3_2 = new DataObject3();
        do3_2.setHello("howdy");
        do3_2.setWorld("Westeros");
        dataObject.getDataObject3s().add(do3_1);
        dataObject.getDataObject3s().add(do3_2);
        DataObjectWrapperImpl wrap = new DataObjectWrapperImpl(dataObject, this.dataObjectMetadata, this.dataObjectService, this.referenceLinker);
        Class type = wrap.getPropertyType("dataObject3s[0].hello");
        Assert.assertEquals(String.class, (Object)type);
        type = wrap.getPropertyType("dataObject3s[1].world");
        Assert.assertEquals(String.class, (Object)type);
        type = wrap.getPropertyType("dataObject3s[2].world");
        Assert.assertNull((Object)type);
    }

    @Test
    public void testMaterializeOptionMatch_Default() {
        Collection childRelationships = this.wrap.getChildrenMatchingOptions(new MaterializeOption[0]);
        Assert.assertNotNull((String)"getChildrenMatchingOptions() shoud not return null", (Object)childRelationships);
        Assert.assertEquals((String)"getChildrenMatchingOptions() returned wrong number of rows", (long)1L, (long)childRelationships.size());
        Assert.assertEquals((String)"getChildrenMatchingOptions() returned wrong type of relationship", DataObjectRelationshipImpl.class, ((MetadataChild)childRelationships.iterator().next()).getClass());
        Assert.assertEquals((String)"getChildrenMatchingOptions() relationship was for wrong property", (Object)"dataObject2", (Object)((MetadataChild)childRelationships.iterator().next()).getName());
        Assert.assertEquals((String)"getChildrenMatchingOptions() relationship was for wrong data type", DataObject2.class, (Object)((MetadataChild)childRelationships.iterator().next()).getRelatedType());
    }

    @Test
    public void testMaterializeOptionMatch_WithEager() {
        Collection childRelationships = this.wrap.getChildrenMatchingOptions(new MaterializeOption[]{MaterializeOption.INCLUDE_EAGER_REFS});
        Assert.assertNotNull((String)"getChildrenMatchingOptions() shoud not return null", (Object)childRelationships);
        Assert.assertEquals((String)"getChildrenMatchingOptions() returned wrong number of rows", (long)2L, (long)childRelationships.size());
    }

    @Test
    public void testMaterializeOptionMatch_CollectionsOnly_NonUpdatable() {
        Collection childRelationships = this.wrap.getChildrenMatchingOptions(new MaterializeOption[]{MaterializeOption.COLLECTIONS});
        Assert.assertNotNull((String)"getChildrenMatchingOptions() shoud not return null", (Object)childRelationships);
        Assert.assertEquals((String)"getChildrenMatchingOptions() returned wrong number of rows", (long)0L, (long)childRelationships.size());
    }

    @Test
    public void testMaterializeOptionMatch_CollectionsOnly_Updatable() {
        Collection childRelationships = this.wrap.getChildrenMatchingOptions(new MaterializeOption[]{MaterializeOption.COLLECTIONS, MaterializeOption.UPDATE_UPDATABLE_REFS});
        Assert.assertNotNull((String)"getChildrenMatchingOptions() shoud not return null", (Object)childRelationships);
        Assert.assertEquals((String)"getChildrenMatchingOptions() returned wrong number of rows", (long)1L, (long)childRelationships.size());
        Assert.assertEquals((String)"getChildrenMatchingOptions() returned wrong type of relationship", DataObjectCollectionImpl.class, ((MetadataChild)childRelationships.iterator().next()).getClass());
        Assert.assertEquals((String)"getChildrenMatchingOptions() relationship was for wrong property", (Object)"dataObject3s", (Object)((MetadataChild)childRelationships.iterator().next()).getName());
        Assert.assertEquals((String)"getChildrenMatchingOptions() relationship was for wrong data type", DataObject3.class, (Object)((MetadataChild)childRelationships.iterator().next()).getRelatedType());
    }

    @Test
    public void testMaterializeOptionMatch_Updatable() {
        Collection childRelationships = this.wrap.getChildrenMatchingOptions(new MaterializeOption[]{MaterializeOption.UPDATE_UPDATABLE_REFS});
        Assert.assertNotNull((String)"getChildrenMatchingOptions() shoud not return null", (Object)childRelationships);
        Assert.assertEquals((String)"getChildrenMatchingOptions() returned wrong number of rows", (long)2L, (long)childRelationships.size());
    }

    @Test
    public void testMaterialize_Default() {
        this.dataObject.setDataObject2(null);
        this.wrap.materializeReferencedObjects(new MaterializeOption[0]);
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService)).supports(DataObject2.class);
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService, (VerificationMode)Mockito.never())).supports(DataObject4.class);
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService)).find(DataObject2.class, (Object)"one");
        Assert.assertNotNull((String)"dataObject2 should have been loaded", (Object)this.dataObject.getDataObject2());
    }

    @Test
    public void testMaterialize_Recursive() {
        this.dataObject.setDataObject2(null);
        this.wrap.materializeReferencedObjectsToDepth(2, new MaterializeOption[0]);
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService, (VerificationMode)Mockito.atLeastOnce())).supports(DataObject2.class);
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService)).find(DataObject2.class, (Object)"one");
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService, (VerificationMode)Mockito.atLeastOnce())).supports(DataObject4.class);
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService)).find(DataObject4.class, (Object)"two");
        Assert.assertNotNull((String)"dataObject2 should have been loaded", (Object)this.dataObject.getDataObject2());
        Assert.assertNotNull((String)"dataObject2.dataObject4 should have been loaded", (Object)this.dataObject.getDataObject2().getDataObject4());
    }

    @Test
    public void testMaterialize_Recursive_WithCollections() {
        this.dataObject.setDataObject2(null);
        this.dataObject.setDataObject3s(null);
        this.wrap.materializeReferencedObjectsToDepth(2, new MaterializeOption[]{MaterializeOption.UPDATE_UPDATABLE_REFS});
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService, (VerificationMode)Mockito.atLeastOnce())).supports(DataObject2.class);
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService, (VerificationMode)Mockito.atLeastOnce())).supports(DataObject3.class);
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService, (VerificationMode)Mockito.atLeastOnce())).supports(DataObject4.class);
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService)).find(DataObject2.class, (Object)"one");
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService)).find(DataObject4.class, (Object)"two");
        Assert.assertNotNull((String)"dataObject2 should have been loaded", (Object)this.dataObject.getDataObject2());
        Assert.assertNotNull((String)"dataObject2.dataObject4 should have been loaded", (Object)this.dataObject.getDataObject2().getDataObject4());
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService)).findMatching(DataObject3.class, QueryByCriteria.Builder.andAttributes(Collections.singletonMap("parentId", "1")).build());
        Assert.assertNotNull((String)"The list of DataObject3 should not have been nulled out", this.dataObject.getDataObject3s());
        Assert.assertEquals((String)"The list of DataObject3 should have had records", (long)2L, (long)this.dataObject.getDataObject3s().size());
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService)).find(DataObject2.class, (Object)"world");
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService)).find(DataObject2.class, (Object)"Westeros");
    }

    @Test
    public void testMaterialize_InvalidCode_DontNullIt() {
        Assert.assertNotNull((String)"dataObject2 should not be null at start of test", (Object)this.dataObject.getDataObject2());
        this.dataObject.setDataObject2sKey("SOMETHING_INVALID");
        this.wrap.materializeReferencedObjects(new MaterializeOption[0]);
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService)).supports(DataObject2.class);
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService)).find(DataObject2.class, (Object)"SOMETHING_INVALID");
        Assert.assertNotNull((String)"dataObject2 should not have been nulled out", (Object)this.dataObject.getDataObject2());
        Assert.assertEquals((String)"The object should be the original, with the originals PK", (Object)"one", (Object)this.dataObject.getDataObject2().getOne());
    }

    @Test
    public void testMaterialize_InvalidCode_PleaseNullIt() {
        Assert.assertNotNull((String)"dataObject2 should not be null at start of test", (Object)this.dataObject.getDataObject2());
        this.dataObject.setDataObject2sKey("SOMETHING_INVALID");
        this.wrap.materializeReferencedObjects(new MaterializeOption[]{MaterializeOption.NULL_INVALID_REFS});
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService)).supports(DataObject2.class);
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService)).find(DataObject2.class, (Object)"SOMETHING_INVALID");
        Assert.assertNull((String)"dataObject2 should have been nulled out", (Object)this.dataObject.getDataObject2());
    }

    @Test
    public void testMaterialize_UpdateUpdatable() {
        this.wrap.materializeReferencedObjects(new MaterializeOption[]{MaterializeOption.UPDATE_UPDATABLE_REFS});
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService)).supports(DataObject2.class);
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService)).supports(DataObject3.class);
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService)).find(DataObject2.class, (Object)"one");
        ((DataObjectService)Mockito.verify((Object)this.dataObjectService)).findMatching(DataObject3.class, QueryByCriteria.Builder.andAttributes(Collections.singletonMap("parentId", "1")).build());
        Assert.assertNotNull((String)"The list of DataObject3 should not have been nulled out", this.dataObject.getDataObject3s());
    }

    public static final class DataObject3 {
        private String parentId;
        private String id;
        private String hello;
        private String world;
        private DataObject2 dataObject2;

        public DataObject3() {
        }

        public DataObject3(String parentId, String id, String hello, String world) {
            this.parentId = parentId;
            this.id = id;
            this.hello = hello;
            this.world = world;
        }

        public String getHello() {
            return this.hello;
        }

        public void setHello(String hello) {
            this.hello = hello;
        }

        public String getWorld() {
            return this.world;
        }

        public void setWorld(String world) {
            this.world = world;
        }

        public String getParentId() {
            return this.parentId;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public DataObject2 getDataObject2() {
            return this.dataObject2;
        }

        public void setDataObject2(DataObject2 dataObject2) {
            this.dataObject2 = dataObject2;
        }
    }

    public static final class DataObject4 {
        private String pk;
        private String notPk;

        public DataObject4(String pk, String notPk) {
            this.pk = pk;
            this.notPk = notPk;
        }

        public String getPk() {
            return this.pk;
        }

        public void setPk(String pk) {
            this.pk = pk;
        }

        public String getNotPk() {
            return this.notPk;
        }

        public void setNotPk(String notPk) {
            this.notPk = notPk;
        }
    }

    public static final class DataObject2 {
        private String one;
        private String two;
        private DataObject4 dataObject4;

        public DataObject2() {
        }

        public DataObject2(String one, String two) {
            this.one = one;
            this.two = two;
        }

        public String getOne() {
            return this.one;
        }

        public void setOne(String one) {
            this.one = one;
        }

        public String getTwo() {
            return this.two;
        }

        public void setTwo(String two) {
            this.two = two;
        }

        public DataObject4 getDataObject4() {
            return this.dataObject4;
        }

        public void setDataObject4(DataObject4 dataObject3) {
            this.dataObject4 = dataObject3;
        }
    }

    public static final class DataObject {
        private String id;
        private String fieldOne;
        private Integer fieldTwo;
        private String dataObject2sKey;
        private DataObject2 dataObject2;
        private DataObject2 eagerDataObject2;
        private List<DataObject3> dataObject3s;

        DataObject(String id, String fieldOne, Integer fieldTwo, String dataObject2sKey) {
            this.id = id;
            this.fieldOne = fieldOne;
            this.fieldTwo = fieldTwo;
            this.dataObject2sKey = dataObject2sKey;
            this.dataObject3s = new ArrayList<DataObject3>();
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getFieldOne() {
            return this.fieldOne;
        }

        public void setFieldOne(String fieldOne) {
            this.fieldOne = fieldOne;
        }

        public Integer getFieldTwo() {
            return this.fieldTwo;
        }

        public void setFieldTwo(Integer fieldTwo) {
            this.fieldTwo = fieldTwo;
        }

        public DataObject2 getDataObject2() {
            return this.dataObject2;
        }

        public void setDataObject2(DataObject2 dataObject2) {
            this.dataObject2 = dataObject2;
        }

        public List<DataObject3> getDataObject3s() {
            return this.dataObject3s;
        }

        public void setDataObject3s(List<DataObject3> dataObject3s) {
            this.dataObject3s = dataObject3s;
        }

        public String getDataObject2sKey() {
            return this.dataObject2sKey;
        }

        public void setDataObject2sKey(String dataObject2sKey) {
            this.dataObject2sKey = dataObject2sKey;
        }

        public DataObject2 getEagerDataObject2() {
            return this.eagerDataObject2;
        }

        public void setEagerDataObject2(DataObject2 eagerDataObject2) {
            this.eagerDataObject2 = eagerDataObject2;
        }
    }

    static final class DataObjectWrapperImpl<T>
    extends DataObjectWrapperBase<T> {
        private DataObjectWrapperImpl(T dataObject, DataObjectMetadata metadata, DataObjectService dataObjectService, ReferenceLinker referenceLinker) {
            super(dataObject, metadata, dataObjectService, referenceLinker);
        }
    }
}

