/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.provider.impl;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.metadata.MetadataRepository;
import org.kuali.rice.krad.data.provider.PersistenceProvider;
import org.kuali.rice.krad.data.provider.ProviderRegistry;
import org.kuali.rice.krad.data.provider.impl.ProviderBasedDataObjectService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

@RunWith(value=MockitoJUnitRunner.class)
public class ProviderBasedDataObjectServiceTest {
    @Mock
    PersistenceProvider mockProvider;
    @Mock
    ProviderRegistry providerRegistry;
    @Mock
    MetadataRepository metadataRepository;
    ProviderBasedDataObjectService service = new ProviderBasedDataObjectService();

    @Before
    public void setup() {
        Mockito.when((Object)this.providerRegistry.getPersistenceProvider((Class)Mockito.any(Class.class))).thenReturn((Object)this.mockProvider);
        this.service.setMetadataRepository(this.metadataRepository);
        this.service.setProviderRegistry(this.providerRegistry);
    }

    @Test
    public void testGetMetadataRepository() {
        Assert.assertSame((Object)this.metadataRepository, (Object)this.service.getMetadataRepository());
    }

    @Test
    public void testFind() {
        Object findResult = new Object();
        Mockito.when((Object)this.mockProvider.find((Class)Mockito.any(Class.class), Mockito.any())).thenReturn(findResult);
        Assert.assertSame((Object)findResult, (Object)this.service.find(Object.class, (Object)"id"));
        ((PersistenceProvider)Mockito.verify((Object)this.mockProvider)).find((Class)Mockito.any(Class.class), Mockito.eq((Object)"id"));
    }

    @Test
    public void testFindUnique_NoResults() {
        QueryByCriteria criteria = QueryByCriteria.Builder.create().build();
        GenericQueryResults emptyResults = GenericQueryResults.Builder.create().build();
        Mockito.when((Object)this.mockProvider.findMatching(Object.class, criteria)).thenReturn((Object)emptyResults);
        Object singleResult = this.service.findUnique(Object.class, criteria);
        Assert.assertNull((Object)singleResult);
    }

    @Test
    public void testFindUnique_OneResult() {
        QueryByCriteria criteria = QueryByCriteria.Builder.create().build();
        Object theResult = new Object();
        GenericQueryResults.Builder resultsBuilder = GenericQueryResults.Builder.create();
        resultsBuilder.setResults((List)Lists.newArrayList((Object[])new Object[]{theResult}));
        GenericQueryResults results = resultsBuilder.build();
        Mockito.when((Object)this.mockProvider.findMatching(Object.class, criteria)).thenReturn((Object)results);
        Object singleResult = this.service.findUnique(Object.class, criteria);
        Assert.assertNotNull((Object)singleResult);
        Assert.assertEquals((Object)theResult, (Object)singleResult);
    }

    @Test(expected=IncorrectResultSizeDataAccessException.class)
    public void testFindUnique_TooManyResults() {
        QueryByCriteria criteria = QueryByCriteria.Builder.create().build();
        Object result1 = new Object();
        Object result2 = new Object();
        GenericQueryResults.Builder resultsBuilder = GenericQueryResults.Builder.create();
        resultsBuilder.setResults((List)Lists.newArrayList((Object[])new Object[]{result1, result2}));
        GenericQueryResults results = resultsBuilder.build();
        Mockito.when((Object)this.mockProvider.findMatching(Object.class, criteria)).thenReturn((Object)results);
        this.service.findUnique(Object.class, criteria);
    }

    @Test
    public void testReduceCompoundKey_Null() {
        Assert.assertNull((Object)this.service.reduceCompoundKey(null));
    }

    @Test
    public void testReduceCompoundKey_NonCompoundKey() {
        Assert.assertEquals((Object)"1234", (Object)this.service.reduceCompoundKey((Object)"1234"));
    }

    @Test
    public void testReduceCompoundKey_CompoundKeyOneValue() {
        HashMap<String, Long> singleKeyMap = new HashMap<String, Long>();
        singleKeyMap.put("myAwesomeId", 123456L);
        CompoundKey singleKey = new CompoundKey(singleKeyMap);
        Assert.assertEquals((Object)123456L, (Object)this.service.reduceCompoundKey((Object)singleKey));
    }

    @Test
    public void testReduceCompoundKey_CompoutKeyMultiValue() {
        HashMap<String, Object> multiKeyMap = new HashMap<String, Object>();
        multiKeyMap.put("myAwesomeId", 123456L);
        multiKeyMap.put("myOtherAwesomeId", "abcdefg");
        CompoundKey multiKey = new CompoundKey(multiKeyMap);
        Assert.assertEquals((Object)multiKey, (Object)this.service.reduceCompoundKey((Object)multiKey));
    }

    @Test
    public void testFindClass() {
        Object findResult = new Object();
        Mockito.when((Object)this.mockProvider.find((Class)Mockito.any(Class.class), Mockito.any())).thenReturn(findResult);
        Assert.assertSame((Object)findResult, (Object)this.service.find(Object.class, (Object)"id"));
        ((PersistenceProvider)Mockito.verify((Object)this.mockProvider)).find((Class)Mockito.any(Class.class), Mockito.eq((Object)"id"));
    }

    @Test
    public void testFindMatching() {
        QueryResults findMatchingResult = (QueryResults)Mockito.mock(QueryResults.class);
        QueryByCriteria query = QueryByCriteria.Builder.create().build();
        Mockito.when((Object)this.mockProvider.findMatching((Class)Mockito.any(Class.class), (QueryByCriteria)Mockito.any(QueryByCriteria.class))).thenReturn((Object)findMatchingResult);
        Assert.assertSame((Object)findMatchingResult, (Object)this.service.findMatching(Object.class, query));
        ((PersistenceProvider)Mockito.verify((Object)this.mockProvider)).findMatching((Class)Mockito.any(Class.class), (QueryByCriteria)Mockito.eq((Object)query));
    }

    @Test
    public void testFindMatchingClass() {
        QueryResults findMatchingResult = (QueryResults)Mockito.mock(QueryResults.class);
        QueryByCriteria query = QueryByCriteria.Builder.create().build();
        Mockito.when((Object)this.mockProvider.findMatching((Class)Mockito.any(Class.class), (QueryByCriteria)Mockito.any(QueryByCriteria.class))).thenReturn((Object)findMatchingResult);
        Assert.assertSame((Object)findMatchingResult, (Object)this.service.findMatching(Object.class, query));
        ((PersistenceProvider)Mockito.verify((Object)this.mockProvider)).findMatching((Class)Mockito.any(Class.class), (QueryByCriteria)Mockito.eq((Object)query));
    }

    @Test
    public void testFindAll() {
        QueryResults allResults = (QueryResults)Mockito.mock(QueryResults.class);
        QueryByCriteria query = QueryByCriteria.Builder.create().build();
        Mockito.when((Object)this.mockProvider.findAll((Class)Mockito.any(Class.class))).thenReturn((Object)allResults);
        Assert.assertSame((Object)allResults, (Object)this.service.findAll(Object.class));
        ((PersistenceProvider)Mockito.verify((Object)this.mockProvider)).findAll((Class)Mockito.any(Class.class));
    }

    @Test
    public void testDelete() {
        Object dataObject = new Object();
        this.service.delete(dataObject);
        ((PersistenceProvider)Mockito.verify((Object)this.mockProvider)).delete(Mockito.eq((Object)dataObject));
    }

    @Test
    public void testDeleteMatching() {
        QueryByCriteria query = QueryByCriteria.Builder.create().build();
        this.service.deleteMatching(Object.class, query);
        ((PersistenceProvider)Mockito.verify((Object)this.mockProvider)).deleteMatching((Class)Mockito.any(Class.class), (QueryByCriteria)Mockito.eq((Object)query));
    }

    @Test
    public void testDeleteAll() {
        this.service.deleteAll(Object.class);
        ((PersistenceProvider)Mockito.verify((Object)this.mockProvider)).deleteAll((Class)Mockito.any(Class.class));
    }

    @Test
    public void testSave() {
        Serializable dataObject = new Serializable(){};
        this.service.save((Object)dataObject, new PersistenceOption[0]);
        ((PersistenceProvider)Mockito.verify((Object)this.mockProvider)).save(Mockito.eq((Object)dataObject), new PersistenceOption[0]);
    }

    @Test
    public void testSupportsSupportedType() {
        Assert.assertTrue((boolean)this.service.supports(String.class));
    }

    @Test
    public void testDoesNotSupportUnsupportedType() {
        Mockito.when((Object)this.providerRegistry.getPersistenceProvider(String.class)).thenReturn(null);
        Assert.assertFalse((boolean)this.service.supports(String.class));
    }
}

