/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.kuali.rice.krad.data.jpa.FilterGenerator;
import org.kuali.rice.krad.data.jpa.FilterOperators;
import org.kuali.rice.krad.data.jpa.FilterValue;

public class Filter {
    private static final Logger LOG = LogManager.getLogger(Filter.class);

    public static void customizeField(List<FilterGenerator> filterGenerators, ClassDescriptor descriptor, String propertyName) {
        OneToOneMapping databaseMapping;
        Expression exp = null;
        OneToOneMapping mapping = null;
        if (OneToOneMapping.class.isAssignableFrom(descriptor.getMappingForAttributeName(propertyName).getClass())) {
            databaseMapping = (OneToOneMapping)descriptor.getMappingForAttributeName(propertyName);
            exp = databaseMapping.buildSelectionCriteria();
            mapping = databaseMapping;
        } else if (OneToManyMapping.class.isAssignableFrom(descriptor.getMappingForAttributeName(propertyName).getClass())) {
            databaseMapping = (OneToManyMapping)descriptor.getMappingForAttributeName(propertyName);
            exp = databaseMapping.buildSelectionCriteria();
            mapping = databaseMapping;
        } else {
            throw new RuntimeException("Mapping type not implemented for query customizer for property " + propertyName);
        }
        for (FilterGenerator filterGenerator : filterGenerators) {
            FilterOperators operator = filterGenerator.operator();
            if (!operator.equals((Object)FilterOperators.EQUAL)) {
                throw new UnsupportedOperationException("Operator " + operator.getValue() + " not supported in Filter");
            }
            String attributeName = filterGenerator.attributeName();
            Object attributeValue = Filter.coerce(mapping.getReferenceClass(), attributeName, filterGenerator.attributeValue());
            Class<?> attributeValueClass = filterGenerator.attributeResolverClass();
            if (exp == null || mapping == null) continue;
            ExpressionBuilder builder = exp.getBuilder();
            if (!attributeValueClass.equals(Void.class)) {
                try {
                    FilterValue filterValue = (FilterValue)attributeValueClass.newInstance();
                    attributeValue = filterValue.getValue();
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot find query customizer attribute class" + attributeValueClass);
                }
            }
            if (attributeValue == null) continue;
            Expression addedExpression = builder.get(attributeName).equal(attributeValue);
            exp = exp.and(addedExpression);
            mapping.setSelectionCriteria(exp);
        }
    }

    private static Object coerce(Class<?> referenceClass, String attributeName, String attributeValue) {
        if (StringUtils.isEmpty((CharSequence)attributeValue)) {
            return attributeValue;
        }
        Field field = null;
        try {
            field = referenceClass.getDeclaredField(attributeName);
        }
        catch (NoSuchFieldException nsfe) {
            LOG.error("Could not locate the field " + attributeName + " in " + referenceClass.getName(), (Throwable)nsfe);
        }
        if (field != null) {
            return Filter.coerceValue(field.getType(), attributeName, attributeValue);
        }
        return attributeValue;
    }

    private static Object coerceValue(Class<?> type, String attributeName, String attributeValue) {
        try {
            if (Character.TYPE.equals(type) || Character.class.isAssignableFrom(type)) {
                return Character.valueOf(attributeValue.charAt(0));
            }
            if (Boolean.TYPE.equals(type) || Boolean.class.isAssignableFrom(type)) {
                return Boolean.valueOf(attributeValue);
            }
            if (Short.TYPE.equals(type) || Short.class.isAssignableFrom(type)) {
                return Short.valueOf(attributeValue);
            }
            if (Integer.TYPE.equals(type) || Integer.class.isAssignableFrom(type)) {
                return Integer.valueOf(attributeValue);
            }
            if (Long.TYPE.equals(type) || Long.class.isAssignableFrom(type)) {
                return Long.valueOf(attributeValue);
            }
            if (Double.TYPE.equals(type) || Double.class.isAssignableFrom(type)) {
                return Double.valueOf(attributeValue);
            }
            if (Float.TYPE.equals(type) || Float.class.isAssignableFrom(type)) {
                return Float.valueOf(attributeValue);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.error("Could not coerce the value " + attributeValue + " for the field " + attributeName, (Throwable)nfe);
        }
        return attributeValue;
    }
}

