/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.devtools.datadictionary;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import no.geosoft.cc.io.FileListener;
import no.geosoft.cc.io.FileMonitor;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.devtools.datadictionary.URLMonitor;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class ReloadingDataDictionary
extends DataDictionary
implements FileListener,
URLMonitor.URLContentChangedListener,
ApplicationContextAware {
    private static final Log LOG = LogFactory.getLog(DataDictionary.class);
    private static final String CLASS_DIR_CONFIG_PARM = "reload.data.dictionary.classes.dir";
    private static final String SOURCE_DIR_CONFIG_PARM = "reload.data.dictionary.source.dir";
    private static final String INTERVAL_CONFIG_PARM = "reload.data.dictionary.interval";
    private Map<String, String> fileToNamespaceMapping;
    private Map<String, String> urlToNamespaceMapping;
    private FileMonitor dictionaryFileMonitor;
    private URLMonitor dictionaryUrlMonitor;

    public void parseDataDictionaryConfigurationFiles(boolean allowConcurrentValidation) {
        ConfigurationService configurationService = CoreApiServiceLocator.getKualiConfigurationService();
        String classesDir = configurationService.getPropertyValueAsString(CLASS_DIR_CONFIG_PARM);
        String sourceDir = configurationService.getPropertyValueAsString(SOURCE_DIR_CONFIG_PARM);
        int reloadInterval = Integer.parseInt(configurationService.getPropertyValueAsString(INTERVAL_CONFIG_PARM));
        this.dictionaryFileMonitor = new FileMonitor((long)reloadInterval);
        this.dictionaryFileMonitor.addListener((FileListener)this);
        this.dictionaryUrlMonitor = new URLMonitor(reloadInterval);
        this.dictionaryUrlMonitor.addListener(this);
        super.parseDataDictionaryConfigurationFiles(allowConcurrentValidation);
        this.fileToNamespaceMapping = new HashMap<String, String>();
        this.urlToNamespaceMapping = new HashMap<String, String>();
        for (Map.Entry moduleDictionary : this.moduleDictionaryFiles.entrySet()) {
            String namespace = (String)moduleDictionary.getKey();
            List configLocations = (List)moduleDictionary.getValue();
            for (String configLocation : configLocations) {
                Resource classFileResource = this.getFileResource(configLocation);
                try {
                    if (classFileResource.getURI().toString().startsWith("jar:")) {
                        LOG.trace((Object)("Monitoring dictionary file at URI: " + classFileResource.getURI().toString()));
                        this.dictionaryUrlMonitor.addURI(classFileResource.getURL());
                        this.urlToNamespaceMapping.put(classFileResource.getURL().toString(), namespace);
                        continue;
                    }
                    String filePathClassesDir = classFileResource.getFile().getAbsolutePath();
                    String sourceFilePath = StringUtils.replace((String)filePathClassesDir, (String)classesDir, (String)sourceDir);
                    File dictionaryFile = new File(filePathClassesDir);
                    if (!dictionaryFile.exists()) continue;
                    LOG.trace((Object)("Monitoring dictionary file: " + dictionaryFile.getName()));
                    this.dictionaryFileMonitor.addFile(dictionaryFile);
                    this.fileToNamespaceMapping.put(dictionaryFile.getAbsolutePath(), namespace);
                }
                catch (Exception e) {
                    LOG.info((Object)("Exception in picking up dictionary file for monitoring:  " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public void fileChanged(File file) {
        LOG.info((Object)("reloading dictionary configuration for " + file.getName()));
        try {
            List<String> beforeReloadBeanNames = Arrays.asList(this.ddBeans.getBeanDefinitionNames());
            FileSystemResource resource = new FileSystemResource(file);
            this.xmlReader.loadBeanDefinitions((Resource)resource);
            List<String> afterReloadBeanNames = Arrays.asList(this.ddBeans.getBeanDefinitionNames());
            List addedBeanNames = ListUtils.removeAll(afterReloadBeanNames, beforeReloadBeanNames);
            String namespace = "KUALI";
            if (this.fileToNamespaceMapping.containsKey(file.getAbsolutePath())) {
                namespace = this.fileToNamespaceMapping.get(file.getAbsolutePath());
            }
            this.ddIndex.addBeanNamesToNamespace(namespace, addedBeanNames);
            this.performDictionaryPostProcessing(true);
        }
        catch (Exception e) {
            LOG.info((Object)("Exception in dictionary hot deploy: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void urlContentChanged(URL url) {
        LOG.info((Object)("reloading dictionary configuration for " + url.toString()));
        try {
            InputStream urlStream = url.openStream();
            InputStreamResource resource = new InputStreamResource(urlStream);
            List<String> beforeReloadBeanNames = Arrays.asList(this.ddBeans.getBeanDefinitionNames());
            int originalValidationMode = this.xmlReader.getValidationMode();
            this.xmlReader.setValidationMode(3);
            this.xmlReader.loadBeanDefinitions((Resource)resource);
            this.xmlReader.setValidationMode(originalValidationMode);
            List<String> afterReloadBeanNames = Arrays.asList(this.ddBeans.getBeanDefinitionNames());
            List addedBeanNames = ListUtils.removeAll(afterReloadBeanNames, beforeReloadBeanNames);
            String namespace = "KUALI";
            if (this.urlToNamespaceMapping.containsKey(url.toString())) {
                namespace = this.urlToNamespaceMapping.get(url.toString());
            }
            this.ddIndex.addBeanNamesToNamespace(namespace, addedBeanNames);
            this.performDictionaryPostProcessing(true);
        }
        catch (Exception e) {
            LOG.info((Object)("Exception in dictionary hot deploy: " + e.getMessage()), (Throwable)e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext context = (ConfigurableApplicationContext)applicationContext;
            context.addApplicationListener((ApplicationListener)new ApplicationListener<ContextClosedEvent>(){

                public void onApplicationEvent(ContextClosedEvent e) {
                    LOG.info((Object)("Context '" + e.getApplicationContext().getDisplayName() + "' closed, shutting down URLMonitor scheduler"));
                    ReloadingDataDictionary.this.dictionaryUrlMonitor.shutdownScheduler();
                }
            });
        }
    }
}

