/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.devtools.datadictionary;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URLMonitor {
    private static final Log LOG = LogFactory.getLog(URLMonitor.class);
    private final LinkedList<URLContentChangedListener> listeners = new LinkedList();
    private final Map<URL, Long> resourceMap = new ConcurrentHashMap<URL, Long>();
    private final int reloadIntervalMilliseconds;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final Runnable urlPoller = new Runnable(){

        @Override
        public void run() {
            for (Map.Entry entry : URLMonitor.this.resourceMap.entrySet()) {
                Long crc = URLMonitor.this.getCRC((URL)entry.getKey());
                if (((Long)entry.getValue()).equals(crc)) continue;
                entry.setValue(crc);
                for (URLContentChangedListener listener : URLMonitor.this.listeners) {
                    listener.urlContentChanged((URL)entry.getKey());
                }
            }
        }
    };

    public URLMonitor(int reloadIntervalMilliseconds) {
        this.reloadIntervalMilliseconds = reloadIntervalMilliseconds;
    }

    public void shutdownScheduler() {
        this.scheduler.shutdown();
    }

    public synchronized void addListener(URLContentChangedListener listener) {
        this.listeners.add(listener);
        if (this.listeners.size() == 1) {
            this.scheduler.scheduleAtFixedRate(this.urlPoller, this.reloadIntervalMilliseconds, this.reloadIntervalMilliseconds, TimeUnit.MILLISECONDS);
        }
    }

    public void addURI(URL zipUrl) {
        this.resourceMap.put(zipUrl, this.getCRC(zipUrl));
    }

    private Long getCRC(URL zipUrl) {
        Long result = -1L;
        try {
            int length;
            CRC32 crc = new CRC32();
            CheckedInputStream cis = new CheckedInputStream(zipUrl.openStream(), crc);
            byte[] buffer = new byte[1024];
            while ((length = cis.read(buffer)) > 0) {
            }
            cis.close();
            result = crc.getValue();
        }
        catch (IOException e) {
            LOG.warn((Object)"Unable to calculate CRC, resource doesn't exist?", (Throwable)e);
        }
        return result;
    }

    public static interface URLContentChangedListener {
        public void urlContentChanged(URL var1);
    }
}

