/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.devtools.maintainablexml;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class EncryptionService {
    public static final String ALGORITHM = "DES/ECB/PKCS5Padding";
    public static final String HASH_ALGORITHM = "SHA";
    private static final String CHARSET = "UTF-8";
    private transient SecretKey desKey;
    private transient SecretKey desKeyOld;
    private boolean isEnabled = false;

    public EncryptionService(String key) throws Exception {
        if (this.desKey != null) {
            throw new RuntimeException("The secret key must be kept secret. Storing it in the Java source code is a really bad idea.");
        }
        if (!StringUtils.isEmpty((String)key)) {
            this.setSecretKey(key);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String encrypt(Object valueToHide) throws GeneralSecurityException {
        this.checkEnabled();
        if (valueToHide == null) {
            return "";
        }
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, this.getDesKey());
        try {
            byte[] cleartext = valueToHide.toString().getBytes(CHARSET);
            byte[] ciphertext = cipher.doFinal(cleartext);
            return new String(Base64.encodeBase64((byte[])ciphertext), CHARSET);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String decrypt(String ciphertext) throws GeneralSecurityException {
        this.checkEnabled();
        if (StringUtils.isBlank((String)ciphertext)) {
            return "";
        }
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, this.getDesKey());
        try {
            byte[] encryptedData = Base64.decodeBase64((byte[])ciphertext.getBytes(CHARSET));
            byte[] cleartext1 = cipher.doFinal(encryptedData);
            return new String(cleartext1, CHARSET);
        }
        catch (Exception e) {
            Cipher cipher2 = Cipher.getInstance(ALGORITHM);
            cipher2.init(2, this.getDesKeyOld());
            try {
                byte[] encryptedData = Base64.decodeBase64((byte[])ciphertext.getBytes(CHARSET));
                byte[] cleartext1 = cipher2.doFinal(encryptedData);
                return new String(cleartext1, CHARSET);
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(e);
            }
        }
    }

    public byte[] encryptBytes(byte[] valueToHide) throws GeneralSecurityException {
        this.checkEnabled();
        if (valueToHide == null) {
            return new byte[0];
        }
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, this.getDesKey());
        byte[] cleartext = valueToHide;
        byte[] ciphertext = cipher.doFinal(cleartext);
        return ciphertext;
    }

    public byte[] decryptBytes(byte[] ciphertext) throws GeneralSecurityException {
        this.checkEnabled();
        if (ciphertext == null) {
            return new byte[0];
        }
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, this.getDesKey());
        byte[] encryptedData = ciphertext;
        byte[] cleartext1 = cipher.doFinal(encryptedData);
        return cleartext1;
    }

    public static String generateEncodedKey() throws Exception {
        KeyGenerator keygen = KeyGenerator.getInstance("DES");
        SecretKey desKey = keygen.generateKey();
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(3, desKey);
        SecretKeyFactory desFactory = SecretKeyFactory.getInstance("DES");
        DESKeySpec desSpec = (DESKeySpec)desFactory.getKeySpec(desKey, DESKeySpec.class);
        byte[] rawDesKey = desSpec.getKey();
        return new String(Base64.encodeBase64((byte[])rawDesKey));
    }

    private SecretKey unwrapEncodedKey(String key) throws Exception {
        KeyGenerator keygen = KeyGenerator.getInstance("DES");
        SecretKey desKey = keygen.generateKey();
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(4, desKey);
        byte[] bytes = Base64.decodeBase64((byte[])key.getBytes());
        SecretKeyFactory desFactory = SecretKeyFactory.getInstance("DES");
        DESKeySpec keyspec = new DESKeySpec(bytes);
        SecretKey k = desFactory.generateSecret(keyspec);
        return k;
    }

    private SecretKey unwrapEncodedKeyOld(String key) throws Exception {
        KeyGenerator keygen = KeyGenerator.getInstance("DES");
        SecretKey desKey = keygen.generateKey();
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(4, desKey);
        byte[] bytes = Base64.decodeBase64((byte[])key.getBytes());
        bytes[6] = 1;
        bytes[7] = 1;
        SecretKeyFactory desFactory = SecretKeyFactory.getInstance("DES");
        DESKeySpec keyspec = new DESKeySpec(bytes);
        SecretKey k = desFactory.generateSecret(keyspec);
        return k;
    }

    public void setSecretKey(String secretKey) throws Exception {
        if (!StringUtils.isEmpty((String)secretKey)) {
            this.desKey = this.unwrapEncodedKey(secretKey);
            this.setDesKeyOld(this.unwrapEncodedKeyOld(secretKey));
            this.isEnabled = true;
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(3, this.getDesKey());
        }
    }

    public String hash(Object valueToHide) throws GeneralSecurityException {
        if (valueToHide == null || StringUtils.isEmpty((String)valueToHide.toString())) {
            return "";
        }
        try {
            MessageDigest md = MessageDigest.getInstance(HASH_ALGORITHM);
            return new String(Base64.encodeBase64((byte[])md.digest(valueToHide.toString().getBytes(CHARSET))), CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    protected void checkEnabled() {
        if (!this.isEnabled()) {
            throw new IllegalStateException("Illegal use of encryption service.  Encryption service is disabled, to enable please configure 'encryption.key'.");
        }
    }

    public SecretKey getDesKey() {
        return this.desKey;
    }

    public SecretKey getDesKeyOld() {
        return this.desKeyOld;
    }

    public void setDesKeyOld(SecretKey desKeyOld) {
        this.desKeyOld = desKeyOld;
    }
}

