/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.travel.dataobject;

import edu.sampleu.travel.options.PostalCountryCode;
import edu.sampleu.travel.options.PostalCountryCodeKeyValuesFinder;
import edu.sampleu.travel.options.PostalStateCode;
import edu.sampleu.travel.options.PostalStateCodeKeyValuesFinder;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.data.provider.annotation.Description;
import org.kuali.rice.krad.data.provider.annotation.KeyValuesFinderClass;
import org.kuali.rice.krad.data.provider.annotation.Label;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViewType;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViews;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHint;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHintType;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHints;
import org.kuali.rice.krad.data.provider.annotation.UifValidCharactersConstraintBeanName;

@Entity
@Table(name="TRVL_DEST_T")
@UifAutoCreateViews(value={UifAutoCreateViewType.INQUIRY, UifAutoCreateViewType.LOOKUP})
public class TravelDestination
extends DataObjectBase
implements MutableInactivatable,
Serializable,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 8448891916448081149L;
    @Id
    @Column(name="TRVL_DEST_ID", length=40)
    @GeneratedValue(generator="TRVL_DEST_ID_S")
    @PortableSequenceGenerator(name="TRVL_DEST_ID_S")
    @Label(value="Id")
    @Description(value="Unique identifier for destination item")
    @UifValidCharactersConstraintBeanName(value="AlphaNumericPatternConstraint")
    private String travelDestinationId;
    @Column(name="DEST_NM", length=40)
    @Label(value="Destination")
    @Description(value="Name of location")
    private String travelDestinationName;
    @Column(name="POSTAL_CNTRY_CD")
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_RESULT), @UifDisplayHint(value=UifDisplayHintType.NO_INQUIRY)})
    @KeyValuesFinderClass(value=PostalCountryCodeKeyValuesFinder.class)
    @Label(value="Country")
    private String countryCd;
    @Transient
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)})
    @Label(value="Country")
    private String countryName;
    @Column(name="POSTAL_STATE_CD")
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_RESULT), @UifDisplayHint(value=UifDisplayHintType.NO_INQUIRY)})
    @KeyValuesFinderClass(value=PostalStateCodeKeyValuesFinder.class)
    @Label(value="State")
    private String stateCd;
    @Transient
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)})
    @Label(value="State")
    private String stateName;
    @Column(name="ACTV_IND", nullable=false, length=1)
    @Convert(converter=BooleanYNConverter.class)
    @Label(value="Active")
    @Description(value="Whether active or inactive")
    private boolean active = Boolean.TRUE;

    public String getTravelDestinationId() {
        return this._persistence_get_travelDestinationId();
    }

    public void setTravelDestinationId(String travelDestinationId) {
        this._persistence_set_travelDestinationId(travelDestinationId);
    }

    public String getTravelDestinationName() {
        return this._persistence_get_travelDestinationName();
    }

    public void setTravelDestinationName(String travelDestinationName) {
        this._persistence_set_travelDestinationName(travelDestinationName);
    }

    public String getCountryCd() {
        return this._persistence_get_countryCd();
    }

    public void setCountryCd(String countryCd) {
        this._persistence_set_countryCd(countryCd);
    }

    public String getCountryName() {
        return PostalCountryCode.valueOf(this._persistence_get_countryCd()).getLabel();
    }

    public String getStateCd() {
        return this._persistence_get_stateCd();
    }

    public void setStateCd(String stateCd) {
        this._persistence_set_stateCd(stateCd);
    }

    public String getStateName() {
        return PostalStateCode.valueOf(this._persistence_get_stateCd()).getLabel();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TravelDestination();
    }

    public Object _persistence_get(String string) {
        if (string == "travelDestinationName") {
            return this.travelDestinationName;
        }
        if (string == "travelDestinationId") {
            return this.travelDestinationId;
        }
        if (string == "countryCd") {
            return this.countryCd;
        }
        if (string == "stateCd") {
            return this.stateCd;
        }
        if (string == "active") {
            return this.active;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "travelDestinationName") {
            this.travelDestinationName = (String)object;
            return;
        }
        if (string == "travelDestinationId") {
            this.travelDestinationId = (String)object;
            return;
        }
        if (string == "countryCd") {
            this.countryCd = (String)object;
            return;
        }
        if (string == "stateCd") {
            this.stateCd = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_travelDestinationName() {
        this._persistence_checkFetched("travelDestinationName");
        return this.travelDestinationName;
    }

    public void _persistence_set_travelDestinationName(String string) {
        this._persistence_checkFetchedForSet("travelDestinationName");
        this._persistence_propertyChange("travelDestinationName", this.travelDestinationName, string);
        this.travelDestinationName = string;
    }

    public String _persistence_get_travelDestinationId() {
        this._persistence_checkFetched("travelDestinationId");
        return this.travelDestinationId;
    }

    public void _persistence_set_travelDestinationId(String string) {
        this._persistence_checkFetchedForSet("travelDestinationId");
        this._persistence_propertyChange("travelDestinationId", this.travelDestinationId, string);
        this.travelDestinationId = string;
    }

    public String _persistence_get_countryCd() {
        this._persistence_checkFetched("countryCd");
        return this.countryCd;
    }

    public void _persistence_set_countryCd(String string) {
        this._persistence_checkFetchedForSet("countryCd");
        this._persistence_propertyChange("countryCd", this.countryCd, string);
        this.countryCd = string;
    }

    public String _persistence_get_stateCd() {
        this._persistence_checkFetched("stateCd");
        return this.stateCd;
    }

    public void _persistence_set_stateCd(String string) {
        this._persistence_checkFetchedForSet("stateCd");
        this._persistence_propertyChange("stateCd", this.stateCd, string);
        this.stateCd = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }
}

