/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.travel.dataobject;

import edu.sampleu.travel.dataobject.TravelDestination;
import edu.sampleu.travel.dataobject.TravelExpenseItem;
import edu.sampleu.travel.dataobject.TravelPerDiemExpense;
import edu.sampleu.travel.dataobject.TravelerDetail;
import edu.sampleu.travel.options.TripTypeKeyValuesFinder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.data.jpa.converters.KualiDecimalConverter;
import org.kuali.rice.krad.data.provider.annotation.Description;
import org.kuali.rice.krad.data.provider.annotation.KeyValuesFinderClass;
import org.kuali.rice.krad.data.provider.annotation.Label;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViewType;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViews;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHint;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHintType;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHints;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.TransactionalDocumentBase;

@Entity
@Table(name="TRVL_AUTH_DOC_T")
@AttributeOverrides(value={@AttributeOverride(name="documentNumber", column=@Column(name="TRVL_AUTH_DOC_ID", insertable=true, updatable=true, length=14))})
@AssociationOverrides(value={@AssociationOverride(name="pessimisticLocks", joinColumns={@JoinColumn(name="TRVL_AUTH_DOC_ID", insertable=false, updatable=false)})})
@UifAutoCreateViews(value={UifAutoCreateViewType.INQUIRY, UifAutoCreateViewType.LOOKUP})
public class TravelAuthorizationDocument
extends TransactionalDocumentBase
implements Copyable,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    private static final long serialVersionUID = -6609385831976630737L;
    @Temporal(value=TemporalType.DATE)
    @Column(name="TRVL_BGN_DT")
    @Label(value="Trip Begin Date")
    private Date tripBegin;
    @Temporal(value=TemporalType.DATE)
    @Column(name="TRVL_END_DT")
    @Label(value="Trip End Date")
    private Date tripEnd;
    @Column(name="TRVL_DESC", length=255)
    @Label(value="Business Purpose")
    private String tripDescription;
    @Column(name="TRVL_DEST_ID", length=40)
    private String tripDestinationId;
    @Transient
    private TravelDestination tripDestination;
    @Column(name="TRAVELER_DTL_ID", length=40)
    private String travelerDetailId;
    @Transient
    private TravelerDetail travelerDetail;
    @Column(name="TRVL_TYP_CD", length=40)
    @Label(value="Travel type code")
    @Description(value="Trip Type")
    @KeyValuesFinderClass(value=TripTypeKeyValuesFinder.class)
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.DROPDOWN), @UifDisplayHint(value=UifDisplayHintType.NO_INQUIRY)})
    private String travelTypeCode;
    @Column(name="EXP_LMT", length=19, precision=2)
    @Label(value="Expense Limit")
    @Convert(converter=KualiDecimalConverter.class)
    @Description(value="Expense limit imposed by department or grant or some other budgetary restrictions on trip.")
    private KualiDecimal expenseLimit;
    @Column(name="CELL_PH_NUM", length=20)
    @Label(value="Contact Number")
    @Description(value="This is the contact phone number during the trip.")
    private String cellPhoneNumber;
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="travelAuthorizationDocument")
    private List<TravelPerDiemExpense> dailyExpenseEstimates = new ArrayList<TravelPerDiemExpense>();
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="travelAuthorizationDocument")
    private List<TravelExpenseItem> actualExpenseItems = new ArrayList<TravelExpenseItem>();

    public Date getTripBegin() {
        return this._persistence_get_tripBegin();
    }

    public void setTripBegin(Date tripBegin) {
        this._persistence_set_tripBegin(tripBegin);
    }

    public Date getTripEnd() {
        return this._persistence_get_tripEnd();
    }

    public void setTripEnd(Date tripEnd) {
        this._persistence_set_tripEnd(tripEnd);
    }

    public String getTripDescription() {
        return this._persistence_get_tripDescription();
    }

    public void setTripDescription(String tripDescription) {
        this._persistence_set_tripDescription(tripDescription);
    }

    public String getTravelerDetailId() {
        return this._persistence_get_travelerDetailId();
    }

    public void setTravelerDetailId(String travelerDetailId) {
        this._persistence_set_travelerDetailId(travelerDetailId);
    }

    public TravelerDetail getTravelerDetail() {
        return this.travelerDetail;
    }

    public void setTravelerDetail(TravelerDetail travelerDetail) {
        this.travelerDetail = travelerDetail;
    }

    public String getCellPhoneNumber() {
        return this._persistence_get_cellPhoneNumber();
    }

    public void setCellPhoneNumber(String cellPhoneNumber) {
        this._persistence_set_cellPhoneNumber(cellPhoneNumber);
    }

    public KualiDecimal getExpenseLimit() {
        return this._persistence_get_expenseLimit();
    }

    public void setExpenseLimit(KualiDecimal expenseLimit) {
        this._persistence_set_expenseLimit(expenseLimit);
    }

    public String getTripDestinationId() {
        return this._persistence_get_tripDestinationId();
    }

    public void setTripDestinationId(String tripDestinationId) {
        this._persistence_set_tripDestinationId(tripDestinationId);
    }

    public TravelDestination getTripDestination() {
        return this.tripDestination;
    }

    public void setTripDestination(TravelDestination tripDestination) {
        this.tripDestination = tripDestination;
    }

    public List<TravelPerDiemExpense> getDailyExpenseEstimates() {
        return this._persistence_get_dailyExpenseEstimates();
    }

    public void setDailyExpenseEstimates(List<TravelPerDiemExpense> dailyExpenseEstimates) {
        this._persistence_set_dailyExpenseEstimates(dailyExpenseEstimates);
    }

    public List<TravelExpenseItem> getActualExpenseItems() {
        return this._persistence_get_actualExpenseItems();
    }

    public void setActualExpenseItems(List<TravelExpenseItem> actualExpenseItems) {
        this._persistence_set_actualExpenseItems(actualExpenseItems);
    }

    public String getTravelTypeCode() {
        return this._persistence_get_travelTypeCode();
    }

    public void setTravelTypeCode(String travelTypeCode) {
        this._persistence_set_travelTypeCode(travelTypeCode);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TravelAuthorizationDocument();
    }

    public Object _persistence_get(String string) {
        if (string == "tripEnd") {
            return this.tripEnd;
        }
        if (string == "tripBegin") {
            return this.tripBegin;
        }
        if (string == "travelTypeCode") {
            return this.travelTypeCode;
        }
        if (string == "expenseLimit") {
            return this.expenseLimit;
        }
        if (string == "tripDescription") {
            return this.tripDescription;
        }
        if (string == "travelerDetailId") {
            return this.travelerDetailId;
        }
        if (string == "dailyExpenseEstimates") {
            return this.dailyExpenseEstimates;
        }
        if (string == "cellPhoneNumber") {
            return this.cellPhoneNumber;
        }
        if (string == "actualExpenseItems") {
            return this.actualExpenseItems;
        }
        if (string == "tripDestinationId") {
            return this.tripDestinationId;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "tripEnd") {
            this.tripEnd = (Date)object;
            return;
        }
        if (string == "tripBegin") {
            this.tripBegin = (Date)object;
            return;
        }
        if (string == "travelTypeCode") {
            this.travelTypeCode = (String)object;
            return;
        }
        if (string == "expenseLimit") {
            this.expenseLimit = (KualiDecimal)object;
            return;
        }
        if (string == "tripDescription") {
            this.tripDescription = (String)object;
            return;
        }
        if (string == "travelerDetailId") {
            this.travelerDetailId = (String)object;
            return;
        }
        if (string == "dailyExpenseEstimates") {
            this.dailyExpenseEstimates = (List)object;
            return;
        }
        if (string == "cellPhoneNumber") {
            this.cellPhoneNumber = (String)object;
            return;
        }
        if (string == "actualExpenseItems") {
            this.actualExpenseItems = (List)object;
            return;
        }
        if (string == "tripDestinationId") {
            this.tripDestinationId = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Date _persistence_get_tripEnd() {
        this._persistence_checkFetched("tripEnd");
        return this.tripEnd;
    }

    public void _persistence_set_tripEnd(Date date) {
        this._persistence_checkFetchedForSet("tripEnd");
        this.tripEnd = date;
    }

    public Date _persistence_get_tripBegin() {
        this._persistence_checkFetched("tripBegin");
        return this.tripBegin;
    }

    public void _persistence_set_tripBegin(Date date) {
        this._persistence_checkFetchedForSet("tripBegin");
        this.tripBegin = date;
    }

    public String _persistence_get_travelTypeCode() {
        this._persistence_checkFetched("travelTypeCode");
        return this.travelTypeCode;
    }

    public void _persistence_set_travelTypeCode(String string) {
        this._persistence_checkFetchedForSet("travelTypeCode");
        this.travelTypeCode = string;
    }

    public KualiDecimal _persistence_get_expenseLimit() {
        this._persistence_checkFetched("expenseLimit");
        return this.expenseLimit;
    }

    public void _persistence_set_expenseLimit(KualiDecimal kualiDecimal) {
        this._persistence_checkFetchedForSet("expenseLimit");
        this.expenseLimit = kualiDecimal;
    }

    public String _persistence_get_tripDescription() {
        this._persistence_checkFetched("tripDescription");
        return this.tripDescription;
    }

    public void _persistence_set_tripDescription(String string) {
        this._persistence_checkFetchedForSet("tripDescription");
        this.tripDescription = string;
    }

    public String _persistence_get_travelerDetailId() {
        this._persistence_checkFetched("travelerDetailId");
        return this.travelerDetailId;
    }

    public void _persistence_set_travelerDetailId(String string) {
        this._persistence_checkFetchedForSet("travelerDetailId");
        this.travelerDetailId = string;
    }

    public List _persistence_get_dailyExpenseEstimates() {
        this._persistence_checkFetched("dailyExpenseEstimates");
        return this.dailyExpenseEstimates;
    }

    public void _persistence_set_dailyExpenseEstimates(List list) {
        this._persistence_checkFetchedForSet("dailyExpenseEstimates");
        this.dailyExpenseEstimates = list;
    }

    public String _persistence_get_cellPhoneNumber() {
        this._persistence_checkFetched("cellPhoneNumber");
        return this.cellPhoneNumber;
    }

    public void _persistence_set_cellPhoneNumber(String string) {
        this._persistence_checkFetchedForSet("cellPhoneNumber");
        this.cellPhoneNumber = string;
    }

    public List _persistence_get_actualExpenseItems() {
        this._persistence_checkFetched("actualExpenseItems");
        return this.actualExpenseItems;
    }

    public void _persistence_set_actualExpenseItems(List list) {
        this._persistence_checkFetchedForSet("actualExpenseItems");
        this.actualExpenseItems = list;
    }

    public String _persistence_get_tripDestinationId() {
        this._persistence_checkFetched("tripDestinationId");
        return this.tripDestinationId;
    }

    public void _persistence_set_tripDestinationId(String string) {
        this._persistence_checkFetchedForSet("tripDestinationId");
        this.tripDestinationId = string;
    }
}

