/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.labs.parameter;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.api.parameter.ParameterKey;
import org.kuali.rice.krad.labs.parameter.ParameterForm;
import org.kuali.rice.krad.web.controller.UifControllerBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/parameter"})
public class ParameterController
extends UifControllerBase {
    protected ParameterForm createInitialForm() {
        return new ParameterForm();
    }

    @RequestMapping(params={"methodToCall=update"})
    public ModelAndView update(@ModelAttribute(value="KualiForm") UifFormBase form) {
        ParameterForm parameterForm = (ParameterForm)form;
        String applicationId = "KUALI";
        String namespaceCode = parameterForm.getNamespaceCode();
        String componentCode = parameterForm.getComponentCode();
        String parameterName = parameterForm.getParameterName();
        Parameter parameter = null;
        if (StringUtils.isNotBlank((String)applicationId) && StringUtils.isNotBlank((String)namespaceCode) && StringUtils.isNotBlank((String)componentCode) && StringUtils.isNotBlank((String)parameterName)) {
            ParameterKey key = ParameterKey.create((String)applicationId, (String)namespaceCode, (String)componentCode, (String)parameterName);
            parameter = CoreServiceApiServiceLocator.getParameterRepositoryService().getParameter(key);
        }
        if (parameter != null) {
            Parameter.Builder builder = Parameter.Builder.create(parameter);
            builder.setValue(parameterForm.getParameterValue());
            CoreServiceApiServiceLocator.getParameterRepositoryService().updateParameter(builder.build());
        }
        return this.getModelAndView(form);
    }
}

