/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.labs;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.provider.annotation.Label;
import org.kuali.rice.krad.data.provider.annotation.NonPersistentProperty;
import org.kuali.rice.krad.data.provider.annotation.ShortLabel;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViewType;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViews;
import org.kuali.rice.krad.data.provider.annotation.UifValidCharactersConstraintBeanName;

@Entity
@Table(name="TRV_ACCT_TYPE")
@UifAutoCreateViews(value={UifAutoCreateViewType.INQUIRY, UifAutoCreateViewType.LOOKUP})
public class LabsEncryptedTravelAccountType
extends DataObjectBase {
    private static final long serialVersionUID = -7663911201081500300L;
    @Id
    @Column(name="ACCT_TYPE", length=3)
    @Label(value="Travel Account Type Code")
    @ShortLabel(value="Code")
    @UifValidCharactersConstraintBeanName(value="AnyCharacterPatternConstraint")
    private String accountTypeCode;
    @Column(name="ACCT_TYPE_NAME", length=40)
    @Label(value="Account Type Name")
    @ShortLabel(value="Name")
    @NotNull
    @UifValidCharactersConstraintBeanName(value="AnyCharacterPatternConstraint")
    private String name;

    public String getAccountTypeCode() {
        return this.accountTypeCode;
    }

    public void setAccountTypeCode(String accountTypeCode) {
        this.accountTypeCode = accountTypeCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @NonPersistentProperty
    @Label(value="Account Type")
    public String getCodeAndDescription() {
        if (this.accountTypeCode != null) {
            return this.accountTypeCode + " - " + this.name;
        }
        return "";
    }
}

