/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.labs.registration.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.io.SerializationUtils;
import org.kuali.rice.krad.labs.registration.form.LabsAdminRegistrationActivity;
import org.kuali.rice.krad.labs.registration.form.LabsAdminRegistrationCourse;
import org.kuali.rice.krad.labs.registration.form.LabsAdminRegistrationForm;
import org.kuali.rice.krad.labs.registration.form.LabsAdminRegistrationIssue;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.web.controller.UifControllerBase;
import org.kuali.rice.krad.web.form.DialogResponse;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/ksworkshop"})
public class LabsAdminRegistrationController
extends UifControllerBase {
    private static String REG_COLL_ID = "KS-AdminRegistration-Registered";
    private static String WAITLIST_COLL_ID = "KS-AdminRegistration-Waitlist";

    protected LabsAdminRegistrationForm createInitialForm() {
        return new LabsAdminRegistrationForm();
    }

    @RequestMapping(params={"methodToCall=refresh"})
    public ModelAndView refresh(UifFormBase form) {
        this.cancelEdits((LabsAdminRegistrationForm)form, form.getUpdateComponentId());
        return this.getRefreshControllerService().refresh(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=getStudentInfo"})
    public ModelAndView getStudentInfo(@ModelAttribute(value="KualiForm") LabsAdminRegistrationForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        form.setStudentName("Allison Glass");
        form.setStanding("Junior");
        form.setProgram("Undergrad");
        form.setDepartment("Arts and Humanites");
        form.setMajor("Psychology");
        form.setCredits("68");
        return this.getModelAndView((UifFormBase)form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=register"})
    public ModelAndView register(@ModelAttribute(value="KualiForm") LabsAdminRegistrationForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        DialogResponse dialogResponse = form.getDialogResponse("KS-AdminRegistration-RegisterDialogResponse");
        if (dialogResponse == null) {
            for (LabsAdminRegistrationCourse course : form.getPendingCourses()) {
                course.setCourseName("Some course name here");
                course.setCredits(Integer.valueOf(3));
                course.setRegDate(new Date());
                course.setRegOptions("reg");
                course.setEffectiveDate(new Date());
                ArrayList<LabsAdminRegistrationActivity> activities = new ArrayList<LabsAdminRegistrationActivity>();
                activities.add(new LabsAdminRegistrationActivity("Lec", "MWF 01:00pm - 02:30pm", "Steve Capriani", "PTX 2391"));
                activities.add(new LabsAdminRegistrationActivity("Lab", "MWF 02:30pm - 03:30pm", "Steve Capriani", "PTX 2391"));
                course.setActivities(activities);
            }
            return this.showDialog("KS-AdminRegistration-RegisterDialogResponse", true, (UifFormBase)form);
        }
        form.getCoursesInProcess().addAll(form.getPendingCourses());
        form.setPendingCourses(new ArrayList());
        form.getPendingCourses().add(new LabsAdminRegistrationCourse());
        return this.getModelAndView((UifFormBase)form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=dropCourse"})
    public ModelAndView dropCourse(@ModelAttribute(value="KualiForm") LabsAdminRegistrationForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String selectedCollectionPath = form.getActionParamaterValue("selectedCollectionPath");
        if (StringUtils.isBlank((String)selectedCollectionPath)) {
            throw new RuntimeException("Selected collection path was not set for collection action");
        }
        String selectedCollectionId = form.getActionParamaterValue("selectedCollectionId");
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        int selectedLineIndex = -1;
        if (StringUtils.isNotBlank((String)selectedLine)) {
            selectedLineIndex = Integer.parseInt(selectedLine);
        }
        DialogResponse dialogResponse = form.getDialogResponse("KS-AdminRegistration-DropRegisteredDialog");
        Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue((Object)form, (String)selectedCollectionPath);
        Object item = ((List)collection).get(selectedLineIndex);
        if (dialogResponse == null) {
            LabsAdminRegistrationCourse pendingDropCourse = new LabsAdminRegistrationCourse();
            pendingDropCourse.setCode(((LabsAdminRegistrationCourse)item).getCode());
            pendingDropCourse.setSection(((LabsAdminRegistrationCourse)item).getSection());
            pendingDropCourse.setDropDate(new Date());
            form.setPendingDropCourse(pendingDropCourse);
            return this.showDialog("KS-AdminRegistration-DropRegisteredDialog", true, (UifFormBase)form);
        }
        ((LabsAdminRegistrationCourse)item).setDropDate(form.getPendingDropCourse().getDropDate());
        this.cancelEdits(form, selectedCollectionId);
        return this.deleteLine((UifFormBase)form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=removeWaitlistCourse"})
    public ModelAndView removeWaitlistCourse(@ModelAttribute(value="KualiForm") LabsAdminRegistrationForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String selectedCollectionId = form.getActionParamaterValue("selectedCollectionId");
        this.cancelEdits(form, selectedCollectionId);
        return this.deleteLine((UifFormBase)form);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=regUpdateQuery"})
    @ResponseBody
    public Map regUpdateQuery(LabsAdminRegistrationForm form) {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        ArrayList<String> updateIds = new ArrayList<String>();
        if (form.getCoursesInProcess().isEmpty()) {
            result.put("stop", Boolean.valueOf(true));
            return result;
        }
        LabsAdminRegistrationForm labsAdminRegistrationForm = form;
        synchronized (labsAdminRegistrationForm) {
            Random generator = new Random();
            int i = generator.nextInt(5);
            if (i == 0 && !form.getCoursesInProcess().isEmpty()) {
                form.getRegisteredCourses().add(form.getCoursesInProcess().get(0));
                form.getCoursesInProcess().remove(0);
                updateIds.add(REG_COLL_ID);
            }
            if ((i = generator.nextInt(5)) == 0 && !form.getCoursesInProcess().isEmpty()) {
                form.getWaitlistedCourses().add(form.getCoursesInProcess().get(0));
                form.getCoursesInProcess().remove(0);
                updateIds.add(WAITLIST_COLL_ID);
            }
            if ((i = generator.nextInt(5)) == 0 && !form.getCoursesInProcess().isEmpty()) {
                LabsAdminRegistrationIssue regIssue = new LabsAdminRegistrationIssue();
                regIssue.setCourse((LabsAdminRegistrationCourse)form.getCoursesInProcess().get(0));
                regIssue.getMessages().add("Some Problem");
                regIssue.getMessages().add("Some Other Problem");
                form.getRegistrationIssues().add(regIssue);
                form.getCoursesInProcess().remove(0);
                updateIds.add("KS-AdminRegistration-Issues");
            }
        }
        if (form.getCoursesInProcess().isEmpty()) {
            result.put("stop", Boolean.valueOf(true));
        }
        result.put("updateIds", updateIds);
        return result;
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=editCourse"})
    public ModelAndView editCourse(@ModelAttribute(value="KualiForm") LabsAdminRegistrationForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String selectedCollectionPath = form.getActionParamaterValue("selectedCollectionPath");
        if (StringUtils.isBlank((String)selectedCollectionPath)) {
            throw new RuntimeException("Selected collection path was not set for collection action");
        }
        String selectedCollectionId = form.getActionParamaterValue("selectedCollectionId");
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        int selectedLineIndex = -1;
        if (StringUtils.isNotBlank((String)selectedLine)) {
            selectedLineIndex = Integer.parseInt(selectedLine);
        }
        Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue((Object)form, (String)selectedCollectionPath);
        Object item = ((List)collection).get(selectedLineIndex);
        this.cancelEdits(form, selectedCollectionId);
        LabsAdminRegistrationCourse tempCourse = (LabsAdminRegistrationCourse)SerializationUtils.clone((Serializable)((LabsAdminRegistrationCourse)item));
        if (selectedCollectionId.equals(REG_COLL_ID)) {
            form.setEditRegisteredIndex(selectedLineIndex);
            form.setTempRegCourseEdit(tempCourse);
        } else if (selectedCollectionId.equals(WAITLIST_COLL_ID)) {
            form.setEditWaitlistedIndex(selectedLineIndex);
            form.setTempWaitlistCourseEdit(tempCourse);
        }
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=saveEdit"})
    public ModelAndView saveEdit(@ModelAttribute(value="KualiForm") LabsAdminRegistrationForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String selectedCollectionId = form.getActionParamaterValue("selectedCollectionId");
        if (selectedCollectionId.equals(REG_COLL_ID)) {
            form.setEditRegisteredIndex(-1);
            form.setTempRegCourseEdit(null);
        } else if (selectedCollectionId.equals(WAITLIST_COLL_ID)) {
            form.setEditWaitlistedIndex(-1);
            form.setTempWaitlistCourseEdit(null);
        }
        return this.refresh((UifFormBase)form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=cancelEdit"})
    public ModelAndView cancelEdit(@ModelAttribute(value="KualiForm") LabsAdminRegistrationForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String selectedCollectionId = form.getActionParamaterValue("selectedCollectionId");
        this.cancelEdits(form, selectedCollectionId);
        return this.refresh((UifFormBase)form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=allowCourse"})
    public ModelAndView allowCourse(@ModelAttribute(value="KualiForm") LabsAdminRegistrationForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String selectedCollectionPath = form.getActionParamaterValue("selectedCollectionPath");
        if (StringUtils.isBlank((String)selectedCollectionPath)) {
            throw new RuntimeException("Selected collection path was not set for collection action");
        }
        String selectedCollectionId = form.getActionParamaterValue("selectedCollectionId");
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        int selectedLineIndex = -1;
        if (StringUtils.isNotBlank((String)selectedLine)) {
            selectedLineIndex = Integer.parseInt(selectedLine);
        }
        Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue((Object)form, (String)selectedCollectionPath);
        Object item = ((List)collection).get(selectedLineIndex);
        form.getRegisteredCourses().add(((LabsAdminRegistrationIssue)item).getCourse());
        ((List)collection).remove(selectedLineIndex);
        return this.getModelAndView((UifFormBase)form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=denyCourse"})
    public ModelAndView denyCourse(@ModelAttribute(value="KualiForm") LabsAdminRegistrationForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteLine((UifFormBase)form);
    }

    private void cancelEdits(LabsAdminRegistrationForm form, String collectionId) {
        if (collectionId == null) {
            return;
        }
        if (form.getEditRegisteredIndex() > -1 && collectionId.equals(REG_COLL_ID)) {
            Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue((Object)form, (String)"registeredCourses");
            ((List)collection).set(form.getEditRegisteredIndex(), form.getTempRegCourseEdit());
            form.setEditRegisteredIndex(-1);
        } else if (form.getEditWaitlistedIndex() > -1 && collectionId.equals(WAITLIST_COLL_ID)) {
            Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue((Object)form, (String)"waitlistedCourses");
            ((List)collection).set(form.getEditWaitlistedIndex(), form.getTempWaitlistCourseEdit());
            form.setEditRegisteredIndex(-1);
        }
    }
}

