/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.labs;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.bo.PersistableAttachment;
import org.kuali.rice.krad.data.provider.annotation.Description;
import org.kuali.rice.krad.data.provider.annotation.Label;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViewType;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViews;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHint;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHintType;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHints;
import org.kuali.rice.krad.data.provider.annotation.UifValidCharactersConstraintBeanName;
import org.kuali.rice.krad.labs.LabsTravelAttachmentGroup;
import org.kuali.rice.krad.uif.util.SessionTransient;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Table(name="trv_att_sample")
@UifAutoCreateViews(value={UifAutoCreateViewType.LOOKUP})
public class LabsTravelAttachment
extends DataObjectBase
implements PersistableAttachment,
Serializable {
    @Id
    @Column(name="ATTACHMENT_ID", length=30)
    @Label(value="Id")
    @Description(value="Unique identifier for the attachment")
    @UifValidCharactersConstraintBeanName(value="AlphaNumericPatternConstraint")
    private String id;
    @ManyToOne
    @JoinColumn(name="ATT_GRP_NUM", insertable=false, updatable=false)
    LabsTravelAttachmentGroup labsTravelAttachmentGroup;
    @Id
    @Column(name="ATT_GRP_NUM", length=10)
    @Label(value="Travel Attachment Group Number")
    @NotNull
    private String travelAttachmentGroupNumber;
    @Column(name="DESCRIPTION", length=100)
    @Label(value="Description")
    @Description(value="Descriptor for the attachment")
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)})
    private String description;
    @Column(name="ATTACHMENT_FILENAME", length=300)
    @Label(value="File Name")
    @Description(value="File name of the attachment")
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_INQUIRY), @UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA), @UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_RESULT)})
    private String fileName;
    @Column(name="ATTACHMENT_FILE_CONTENT_TYPE", length=255)
    @Label(value="Content Type")
    @Description(value="Content Type of the attachment")
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_RESULT)})
    private String contentType;
    @Column(name="ATTACHMENT_FILE")
    @Label(value="Attachment Content")
    @Description(value="Content of the attachment")
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_INQUIRY), @UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA), @UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_RESULT)})
    private byte[] attachmentContent;
    @Label(value="Attachment File")
    @Description(value="File of the attachment")
    @SessionTransient
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA), @UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_RESULT)})
    private transient MultipartFile attachmentFile;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public byte[] getAttachmentContent() {
        return this.attachmentContent;
    }

    public void setAttachmentContent(byte[] attachmentContent) {
        this.attachmentContent = attachmentContent;
    }

    public MultipartFile getAttachmentFile() {
        return this.attachmentFile;
    }

    public void setAttachmentFile(MultipartFile attachmentFile) {
        if (attachmentFile != null) {
            this.setContentType(attachmentFile.getContentType());
            this.setFileName(attachmentFile.getOriginalFilename());
            try {
                this.setAttachmentContent(attachmentFile.getBytes());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public LabsTravelAttachmentGroup getLabsTravelAttachmentGroup() {
        return this.labsTravelAttachmentGroup;
    }

    public void setLabsTravelAttachmentGroup(LabsTravelAttachmentGroup labsTravelAttachmentGroup) {
        this.labsTravelAttachmentGroup = labsTravelAttachmentGroup;
    }

    public String getTravelAttachmentGroupNumber() {
        return this.travelAttachmentGroupNumber;
    }

    public void setTravelAttachmentGroupNumber(String travelAttachmentGroupNumber) {
        this.travelAttachmentGroupNumber = travelAttachmentGroupNumber;
    }
}

