/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.web.health;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.log4j.Logger;
import org.enhydra.jdbc.pool.StandardXAPoolDataSource;

public class DatabaseConnectionPoolMetricSet
implements MetricSet {
    private static final Logger LOG = Logger.getLogger(DatabaseConnectionPoolMetricSet.class);
    public static final String ACTIVE = "pool.active";
    public static final String MIN = "pool.min";
    public static final String MAX = "pool.max";
    public static final String USAGE = "pool.usage";
    private final String namePrefix;
    private final DataSource dataSource;

    public DatabaseConnectionPoolMetricSet(String namePrefix, DataSource dataSource) {
        this.namePrefix = namePrefix;
        this.dataSource = dataSource;
    }

    public Map<String, Metric> getMetrics() {
        boolean success;
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        boolean bl = success = this.tryXAPool(metrics) || this.tryBitronix(metrics) || this.tryDBCP(metrics);
        if (!success) {
            LOG.warn((Object)("Failed to identify the type of connection pool with namePrefix: " + this.namePrefix + " and dataSource class: " + this.dataSource.getClass()));
        }
        return metrics;
    }

    private boolean tryXAPool(Map<String, Metric> metrics) {
        StandardXAPoolDataSource xaPoolDataSource = (StandardXAPoolDataSource)this.tryUnwrap(this.dataSource, StandardXAPoolDataSource.class);
        if (xaPoolDataSource != null) {
            this.installXAPoolMetrics(xaPoolDataSource, metrics);
            return true;
        }
        return false;
    }

    private void installXAPoolMetrics(StandardXAPoolDataSource dataSource, Map<String, Metric> metrics) {
        metrics.put(this.namePrefix + ACTIVE, (Metric)new /* Unavailable Anonymous Inner Class!! */);
        metrics.put(this.namePrefix + MIN, (Metric)new /* Unavailable Anonymous Inner Class!! */);
        metrics.put(this.namePrefix + MAX, (Metric)new /* Unavailable Anonymous Inner Class!! */);
        metrics.put(this.namePrefix + USAGE, (Metric)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean tryBitronix(Map<String, Metric> metrics) {
        PoolingDataSource poolingDataSource = (PoolingDataSource)this.tryUnwrap(this.dataSource, PoolingDataSource.class);
        if (poolingDataSource != null) {
            this.installBitronixMetrics(poolingDataSource, metrics);
            return true;
        }
        return false;
    }

    private void installBitronixMetrics(PoolingDataSource dataSource, Map<String, Metric> metrics) {
        metrics.put(this.namePrefix + ACTIVE, (Metric)new /* Unavailable Anonymous Inner Class!! */);
        metrics.put(this.namePrefix + MIN, (Metric)new /* Unavailable Anonymous Inner Class!! */);
        metrics.put(this.namePrefix + MAX, (Metric)new /* Unavailable Anonymous Inner Class!! */);
        metrics.put(this.namePrefix + USAGE, (Metric)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean tryDBCP(Map<String, Metric> metrics) {
        BasicDataSource basicDataSource = (BasicDataSource)this.tryUnwrap(this.dataSource, BasicDataSource.class);
        if (basicDataSource != null) {
            this.installDBCPMetrics(basicDataSource, metrics);
            return true;
        }
        return false;
    }

    private void installDBCPMetrics(BasicDataSource dataSource, Map<String, Metric> metrics) {
        metrics.put(this.namePrefix + ACTIVE, (Metric)new /* Unavailable Anonymous Inner Class!! */);
        metrics.put(this.namePrefix + MIN, (Metric)new /* Unavailable Anonymous Inner Class!! */);
        metrics.put(this.namePrefix + MAX, (Metric)new /* Unavailable Anonymous Inner Class!! */);
        metrics.put(this.namePrefix + USAGE, (Metric)new /* Unavailable Anonymous Inner Class!! */);
    }

    private <T> T tryUnwrap(DataSource dataSource, Class<T> targetType) {
        if (targetType.isInstance(dataSource)) {
            return targetType.cast(dataSource);
        }
        try {
            if (dataSource.isWrapperFor(targetType)) {
                return dataSource.unwrap(targetType);
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)("Exception when trying to unwrap datasource as " + targetType), (Throwable)e);
        }
        return null;
    }
}

