/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.demo.uif.controller;

import org.kuali.rice.krad.demo.uif.controller.KradSampleAppController;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.form.DialogResponse;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/dialog"})
public class DemoDialogController
extends KradSampleAppController {
    protected static final String DEMO_DUPLICATE_DIALOG = "Demo-DialogGroup-ServerResponse1";
    protected static final String DEMO_DISAPPROVE_CONFIRM = "Demo-DialogGroup-ServerResponse2";
    protected static final String DEMO_DISAPPROVE_SURVEY = "Demo-DialogGroup-ServerResponse3";

    @RequestMapping(params={"methodToCall=save"})
    public ModelAndView save(@ModelAttribute(value="KualiForm") UifFormBase form) throws Exception {
        DialogResponse duplicateDialogResponse = form.getDialogResponse(DEMO_DUPLICATE_DIALOG);
        if (duplicateDialogResponse == null) {
            return this.showDialog(DEMO_DUPLICATE_DIALOG, true, form);
        }
        boolean verifiedDuplicate = duplicateDialogResponse.getResponseAsBoolean();
        if (verifiedDuplicate) {
            GlobalVariables.getMessageMap().putInfoForSectionId("demoDialogEx8", "demo.dialogs.saveConfirmation", new String[0]);
        }
        return this.getModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=disapprove"})
    public ModelAndView disapprove(@ModelAttribute(value="KualiForm") UifFormBase form) throws Exception {
        DialogResponse disapproveConfirm = form.getDialogResponse(DEMO_DISAPPROVE_CONFIRM);
        if (disapproveConfirm == null) {
            return this.showDialog(DEMO_DISAPPROVE_CONFIRM, true, form);
        }
        String disapproveExplanation = disapproveConfirm.getExplanation();
        DialogResponse disapproveSurvey = form.getDialogResponse(DEMO_DISAPPROVE_SURVEY);
        if (disapproveSurvey == null) {
            return this.showDialog(DEMO_DISAPPROVE_SURVEY, false, form);
        }
        String surveyResponse = disapproveSurvey.getResponse();
        GlobalVariables.getMessageMap().putInfoForSectionId("demoDialogEx9", "demo.dialogs.disapprove", new String[]{disapproveExplanation, surveyResponse});
        return this.getModelAndView(form);
    }
}

