/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.dao.impl;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceException;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.krad.dao.BusinessObjectDao;
import org.kuali.rice.krad.dao.DocumentDao;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentAdHocService;
import org.springframework.dao.DataAccessException;

public class DocumentDaoJpa
implements DocumentDao {
    private BusinessObjectDao businessObjectDao;
    private DocumentAdHocService documentAdHocService;
    @PersistenceContext
    private EntityManager entityManager;

    public DocumentDaoJpa(EntityManager entityManager, BusinessObjectDao businessObjectDao, DocumentAdHocService documentAdHocService) {
        this.entityManager = entityManager;
        this.businessObjectDao = businessObjectDao;
        this.documentAdHocService = documentAdHocService;
    }

    @Override
    public <T extends Document> T save(T document) throws DataAccessException {
        Object attachedDoc = this.findByDocumentHeaderId(document.getClass(), document.getDocumentNumber());
        if (attachedDoc == null) {
            this.entityManager.persist((Object)document.getDocumentHeader());
            this.entityManager.persist(document);
            return document;
        }
        OrmUtils.reattach(document, attachedDoc);
        return (T)((Document)this.entityManager.merge(attachedDoc));
    }

    @Override
    public <T extends Document> T findByDocumentHeaderId(Class<T> clazz, String id) {
        return (T)((Document)this.entityManager.find(clazz, (Object)id));
    }

    @Override
    public <T extends Document> List<T> findByDocumentHeaderIds(Class<T> clazz, List<String> idList) {
        Criteria criteria = new Criteria(clazz.getName());
        criteria.in("documentNumber", idList);
        List list = new ArrayList();
        try {
            list = new QueryByCriteria(this.entityManager, criteria).toQuery().getResultList();
        }
        catch (PersistenceException e) {
            e.printStackTrace();
        }
        for (Document doc : list) {
            this.documentAdHocService.addAdHocs(doc);
            this.entityManager.refresh((Object)doc);
        }
        return list;
    }

    @Override
    public BusinessObjectDao getBusinessObjectDao() {
        return this.businessObjectDao;
    }

    public void setBusinessObjectDao(BusinessObjectDao businessObjectDao) {
        this.businessObjectDao = businessObjectDao;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public DocumentAdHocService getDocumentAdHocService() {
        return this.documentAdHocService;
    }

    public void setDocumentAdHocService(DocumentAdHocService dahs) {
        this.documentAdHocService = dahs;
    }
}

