/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.dao.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.krad.dao.MaintenanceDocumentDao;
import org.kuali.rice.krad.maintenance.MaintenanceLock;

public class MaintenanceDocumentDaoJpa
implements MaintenanceDocumentDao {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public String getLockingDocumentNumber(String lockingRepresentation, String documentNumber) {
        MaintenanceLock maintenanceLock;
        String lockingDocNumber = "";
        Criteria criteria = new Criteria(MaintenanceLock.class.getName());
        criteria.eq("lockingRepresentation", (Object)lockingRepresentation);
        if (StringUtils.isNotBlank((String)documentNumber)) {
            criteria.ne("documentNumber", (Object)documentNumber);
        }
        if ((maintenanceLock = (MaintenanceLock)new QueryByCriteria(this.entityManager, criteria).toQuery().getSingleResult()) != null) {
            lockingDocNumber = maintenanceLock.getDocumentNumber();
        }
        return lockingDocNumber;
    }

    @Override
    public void deleteLocks(String documentNumber) {
        Criteria criteria = new Criteria(MaintenanceLock.class.getName());
        criteria.eq("documentNumber", (Object)documentNumber);
        new QueryByCriteria(this.entityManager, criteria, QueryByCriteria.QueryByCriteriaType.DELETE).toQuery().executeUpdate();
    }

    @Override
    public void storeLocks(List<MaintenanceLock> maintenanceLocks) {
        for (MaintenanceLock maintenanceLock : maintenanceLocks) {
            this.entityManager.merge((Object)maintenanceLock);
        }
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

