/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.dao.proxy;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.krad.bo.ModuleConfiguration;
import org.kuali.rice.krad.dao.BusinessObjectDao;
import org.kuali.rice.krad.dao.DocumentDao;
import org.kuali.rice.krad.dao.impl.DocumentDaoJpa;
import org.kuali.rice.krad.dao.impl.DocumentDaoOjb;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentAdHocService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DocumentDaoProxy
implements DocumentDao {
    private DocumentDao documentDaoJpa;
    private DocumentDao documentDaoOjb;
    private static KualiModuleService kualiModuleService;
    private static Map<String, DocumentDao> documentDaoValues;

    private DocumentDao getDao(Class<? extends Document> clazz) {
        ModuleService moduleService = DocumentDaoProxy.getKualiModuleService().getResponsibleModuleService(clazz);
        if (moduleService != null) {
            ModuleConfiguration moduleConfig = moduleService.getModuleConfiguration();
            String dataSourceName = "";
            EntityManager entityManager = null;
            if (moduleConfig != null) {
                dataSourceName = moduleConfig.getDataSourceName();
                entityManager = moduleConfig.getEntityManager();
            }
            if (StringUtils.isNotEmpty((String)dataSourceName)) {
                if (documentDaoValues.get(dataSourceName) != null) {
                    return documentDaoValues.get(dataSourceName);
                }
                if (OrmUtils.isJpaAnnotated(clazz) && (OrmUtils.isJpaEnabled() || OrmUtils.isJpaEnabled((String)"rice.krad"))) {
                    if (entityManager != null) {
                        DocumentDaoJpa documentDaoJpaInstance = new DocumentDaoJpa(entityManager, this.documentDaoJpa.getBusinessObjectDao(), this.documentDaoJpa.getDocumentAdHocService());
                        documentDaoValues.put(dataSourceName, documentDaoJpaInstance);
                        return documentDaoJpaInstance;
                    }
                    throw new ConfigurationException("EntityManager is null. EntityManager must be set in the Module Configuration bean in the appropriate spring beans xml. (see nested exception for details).");
                }
                DocumentDaoOjb documentDaoOjbInstance = new DocumentDaoOjb(this.documentDaoOjb.getBusinessObjectDao(), this.documentDaoOjb.getDocumentAdHocService());
                documentDaoOjbInstance.setJcdAlias(dataSourceName);
                documentDaoValues.put(dataSourceName, documentDaoOjbInstance);
                return documentDaoOjbInstance;
            }
        }
        return OrmUtils.isJpaAnnotated(clazz) && OrmUtils.isJpaEnabled() ? this.documentDaoJpa : this.documentDaoOjb;
    }

    @Override
    public <T extends Document> T save(T document) {
        return this.getDao(document.getClass()).save(document);
    }

    @Override
    public <T extends Document> T findByDocumentHeaderId(Class<T> clazz, String id) {
        return this.getDao(clazz).findByDocumentHeaderId(clazz, id);
    }

    @Override
    public <T extends Document> List<T> findByDocumentHeaderIds(Class<T> clazz, List<String> idList) {
        return this.getDao(clazz).findByDocumentHeaderIds(clazz, idList);
    }

    @Override
    public BusinessObjectDao getBusinessObjectDao() {
        if (OrmUtils.isJpaEnabled()) {
            return this.documentDaoJpa.getBusinessObjectDao();
        }
        return this.documentDaoOjb.getBusinessObjectDao();
    }

    @Override
    public DocumentAdHocService getDocumentAdHocService() {
        if (OrmUtils.isJpaEnabled()) {
            return this.documentDaoJpa.getDocumentAdHocService();
        }
        return this.documentDaoOjb.getDocumentAdHocService();
    }

    public void setDocumentDaoJpa(DocumentDao documentDaoJpa) {
        this.documentDaoJpa = documentDaoJpa;
    }

    public void setDocumentDaoOjb(DocumentDao documentDaoOjb) {
        this.documentDaoOjb = documentDaoOjb;
    }

    private static synchronized KualiModuleService getKualiModuleService() {
        if (kualiModuleService == null) {
            kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return kualiModuleService;
    }

    static {
        documentDaoValues = new ConcurrentHashMap<String, DocumentDao>();
    }
}

