/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.service.PersistenceService;
import org.kuali.rice.krad.service.impl.PersistenceServiceImplBase;
import org.kuali.rice.krad.util.ExternalizableBusinessObjectUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional
public class PersistenceServiceImpl
extends PersistenceServiceImplBase
implements PersistenceService {
    private static Logger LOG = Logger.getLogger(PersistenceServiceImpl.class);
    private KualiModuleService kualiModuleService;
    private PersistenceService persistenceServiceJpa;
    private PersistenceService persistenceServiceOjb;

    public void setPersistenceServiceJpa(PersistenceService persistenceServiceJpa) {
        this.persistenceServiceJpa = persistenceServiceJpa;
    }

    public void setPersistenceServiceOjb(PersistenceService persistenceServiceOjb) {
        this.persistenceServiceOjb = persistenceServiceOjb;
    }

    private PersistenceService getService(Class clazz) {
        return this.isJpaEnabledForKradClass(clazz) ? this.persistenceServiceJpa : this.persistenceServiceOjb;
    }

    public void clearCache() {
        throw new UnsupportedOperationException("This should be called directly from the OJB Impl if needed.");
    }

    public void loadRepositoryDescriptor(String ojbRepositoryFilePath) {
        throw new UnsupportedOperationException("This should be called directly from the OJB Impl if needed.");
    }

    public Object resolveProxy(Object o) {
        return this.getService(o.getClass()).resolveProxy(o);
    }

    public void retrieveNonKeyFields(Object persistableObject) {
        if (persistableObject != null && ExternalizableBusinessObjectUtils.isExternalizableBusinessObject(persistableObject.getClass())) {
            Class clazz;
            ExternalizableBusinessObject freshEbo;
            ModuleService moduleService;
            Map criteria = KRADServiceLocatorWeb.getDataObjectMetaDataService().getPrimaryKeyFieldValues(persistableObject);
            if (!CollectionUtils.isEmpty((Map)criteria) && (moduleService = this.getKualiModuleService().getResponsibleModuleService(persistableObject.getClass())) != null && (freshEbo = moduleService.getExternalizableBusinessObject(clazz = ExternalizableBusinessObjectUtils.determineExternalizableBusinessObjectSubInterface(persistableObject.getClass()), criteria)) != null) {
                BeanUtils.copyProperties((Object)freshEbo, (Object)persistableObject);
            }
        } else {
            this.getService(persistableObject.getClass()).retrieveNonKeyFields(persistableObject);
        }
    }

    public void retrieveReferenceObject(Object persistableObject, String referenceObjectName) {
        this.getService(persistableObject.getClass()).retrieveReferenceObject(persistableObject, referenceObjectName);
    }

    public void retrieveReferenceObjects(Object persistableObject, List referenceObjectNames) {
        this.getService(persistableObject.getClass()).retrieveReferenceObjects(persistableObject, referenceObjectNames);
    }

    public void retrieveReferenceObjects(List persistableObjects, List referenceObjectNames) {
        if (persistableObjects == null) {
            throw new IllegalArgumentException("invalid (null) persistableObjects");
        }
        if (persistableObjects.isEmpty()) {
            throw new IllegalArgumentException("invalid (empty) persistableObjects");
        }
        if (referenceObjectNames == null) {
            throw new IllegalArgumentException("invalid (null) referenceObjectNames");
        }
        if (referenceObjectNames.isEmpty()) {
            throw new IllegalArgumentException("invalid (empty) referenceObjectNames");
        }
        for (Object persistableObject : persistableObjects) {
            this.retrieveReferenceObjects(persistableObject, referenceObjectNames);
        }
    }

    public String getFlattenedPrimaryKeyFieldValues(Object persistableObject) {
        return this.getService(persistableObject.getClass()).getFlattenedPrimaryKeyFieldValues(persistableObject);
    }

    public void linkObjects(Object persistableObject) {
        this.getService(persistableObject.getClass()).linkObjects(persistableObject);
    }

    public boolean allForeignKeyValuesPopulatedForReference(PersistableBusinessObject bo, String referenceName) {
        return this.getService(bo.getClass()).allForeignKeyValuesPopulatedForReference(bo, referenceName);
    }

    public void refreshAllNonUpdatingReferences(PersistableBusinessObject bo) {
        this.getService(bo.getClass()).refreshAllNonUpdatingReferences(bo);
    }

    public boolean isProxied(Object bo) {
        return this.getService(bo.getClass()).isProxied(bo);
    }

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }
}

