/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Timestamp;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.UserSessionUtils;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.bo.SessionDocument;
import org.kuali.rice.krad.dao.SessionDocumentDao;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.SessionDocumentService;
import org.kuali.rice.krad.web.form.DocumentFormBase;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Deprecated
public class SessionDocumentServiceImpl
implements SessionDocumentService {
    private static Logger LOG = Logger.getLogger(SessionDocumentServiceImpl.class);
    protected static final String IP_ADDRESS = "ipAddress";
    protected static final String PRINCIPAL_ID = "principalId";
    protected static final String DOCUMENT_NUMBER = "documentNumber";
    protected static final String SESSION_ID = "sessionId";
    private EncryptionService encryptionService;
    private BusinessObjectService businessObjectService;
    private DataDictionaryService dataDictionaryService;
    private SessionDocumentDao sessionDocumentDao;

    @Deprecated
    public DocumentFormBase getDocumentForm(String documentNumber, String docFormKey, UserSession userSession, String ipAddress) {
        DocumentFormBase documentForm = null;
        LOG.debug((Object)"getDocumentForm DocumentFormBase from db");
        try {
            documentForm = (DocumentFormBase)this.retrieveDocumentForm(userSession, docFormKey, documentNumber, ipAddress);
            WorkflowDocument workflowDocument = documentForm.getDocument().getDocumentHeader().getWorkflowDocument();
            UserSessionUtils.addWorkflowDocument((UserSession)userSession, (WorkflowDocument)workflowDocument);
        }
        catch (Exception e) {
            LOG.error((Object)("getDocumentForm failed for SessId/DocNum/PrinId/IP:" + userSession.getKualiSessionId() + "/" + documentNumber + "/" + userSession.getPrincipalId() + "/" + ipAddress), (Throwable)e);
        }
        return documentForm;
    }

    @Deprecated
    protected Object retrieveDocumentForm(UserSession userSession, String sessionId, String documentNumber, String ipAddress) throws Exception {
        HashMap<String, String> primaryKeys = new HashMap<String, String>(4);
        primaryKeys.put(SESSION_ID, sessionId);
        if (documentNumber != null) {
            primaryKeys.put(DOCUMENT_NUMBER, documentNumber);
        }
        primaryKeys.put(PRINCIPAL_ID, userSession.getPrincipalId());
        primaryKeys.put(IP_ADDRESS, ipAddress);
        SessionDocument sessionDoc = (SessionDocument)this.getBusinessObjectService().findByPrimaryKey(SessionDocument.class, primaryKeys);
        if (sessionDoc != null) {
            byte[] formAsBytes = sessionDoc.getSerializedDocumentForm();
            if (sessionDoc.isEncrypted()) {
                formAsBytes = this.getEncryptionService().decryptBytes(formAsBytes);
            }
            ByteArrayInputStream baip = new ByteArrayInputStream(formAsBytes);
            ObjectInputStream ois = new ObjectInputStream(baip);
            return ois.readObject();
        }
        return null;
    }

    @Deprecated
    public WorkflowDocument getDocumentFromSession(UserSession userSession, String docId) {
        return UserSessionUtils.getWorkflowDocument((UserSession)userSession, (String)docId);
    }

    @Deprecated
    public void addDocumentToUserSession(UserSession userSession, WorkflowDocument document) {
        UserSessionUtils.addWorkflowDocument((UserSession)userSession, (WorkflowDocument)document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void purgeDocumentForm(String documentNumber, String docFormKey, UserSession userSession, String ipAddress) {
        UserSession userSession2 = userSession;
        synchronized (userSession2) {
            LOG.debug((Object)"purge document form from session");
            userSession.removeObject(docFormKey);
            try {
                LOG.debug((Object)"purge document form from database");
                HashMap<String, String> primaryKeys = new HashMap<String, String>(4);
                primaryKeys.put(SESSION_ID, userSession.getKualiSessionId());
                primaryKeys.put(DOCUMENT_NUMBER, documentNumber);
                primaryKeys.put(PRINCIPAL_ID, userSession.getPrincipalId());
                primaryKeys.put(IP_ADDRESS, ipAddress);
                this.getBusinessObjectService().deleteMatching(SessionDocument.class, primaryKeys);
            }
            catch (Exception e) {
                LOG.error((Object)("purgeDocumentForm failed for SessId/DocNum/PrinId/IP:" + userSession.getKualiSessionId() + "/" + documentNumber + "/" + userSession.getPrincipalId() + "/" + ipAddress), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setDocumentForm(DocumentFormBase form, UserSession userSession, String ipAddress) {
        UserSession userSession2 = userSession;
        synchronized (userSession2) {
            String formKey = form.getFormKey();
            String key = userSession.getKualiSessionId() + "-" + formKey;
            String documentNumber = form.getDocument().getDocumentNumber();
            if (StringUtils.isNotBlank((String)formKey)) {
                this.persistDocumentForm(form, userSession, ipAddress, formKey, documentNumber);
            } else {
                LOG.warn((Object)("documentNumber is null on form's document: " + form));
            }
        }
    }

    @Deprecated
    protected void persistDocumentForm(DocumentFormBase form, UserSession userSession, String ipAddress, String sessionId, String documentNumber) {
        try {
            LOG.debug((Object)"set Document Form into database");
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(form);
            byte[] formAsBytes = baos.toByteArray();
            boolean encryptContent = false;
            DocumentEntry documentEntry = this.getDataDictionaryService().getDataDictionary().getDocumentEntry(form.getDocTypeName());
            if (documentEntry != null) {
                encryptContent = documentEntry.isEncryptDocumentDataInPersistentSessionStorage();
            }
            if (encryptContent) {
                formAsBytes = this.getEncryptionService().encryptBytes(formAsBytes);
            }
            HashMap<String, String> primaryKeys = new HashMap<String, String>(4);
            primaryKeys.put(SESSION_ID, sessionId);
            primaryKeys.put(DOCUMENT_NUMBER, documentNumber);
            primaryKeys.put(PRINCIPAL_ID, userSession.getPrincipalId());
            primaryKeys.put(IP_ADDRESS, ipAddress);
            SessionDocument sessionDocument = (SessionDocument)this.getBusinessObjectService().findByPrimaryKey(SessionDocument.class, primaryKeys);
            if (sessionDocument == null) {
                sessionDocument = new SessionDocument();
                sessionDocument.setSessionId(sessionId);
                sessionDocument.setDocumentNumber(documentNumber);
                sessionDocument.setPrincipalId(userSession.getPrincipalId());
                sessionDocument.setIpAddress(ipAddress);
            }
            sessionDocument.setSerializedDocumentForm(formAsBytes);
            sessionDocument.setEncrypted(encryptContent);
            sessionDocument.setLastUpdatedDate(currentTime);
            this.businessObjectService.save((PersistableBusinessObject)sessionDocument);
        }
        catch (Exception e) {
            String className = form != null ? form.getClass().getName() : "null";
            LOG.error((Object)("setDocumentForm failed for SessId/DocNum/PrinId/IP/class:" + userSession.getKualiSessionId() + "/" + documentNumber + "/" + userSession.getPrincipalId() + "/" + ipAddress + "/" + className), (Throwable)e);
        }
    }

    @Deprecated
    public void purgeAllSessionDocuments(Timestamp expirationDate) {
        this.sessionDocumentDao.purgeAllSessionDocuments(expirationDate);
    }

    @Deprecated
    protected SessionDocumentDao getSessionDocumentDao() {
        return this.sessionDocumentDao;
    }

    @Deprecated
    public void setSessionDocumentDao(SessionDocumentDao sessionDocumentDao) {
        this.sessionDocumentDao = sessionDocumentDao;
    }

    @Deprecated
    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    @Deprecated
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Deprecated
    protected EncryptionService getEncryptionService() {
        if (this.encryptionService == null) {
            this.encryptionService = CoreApiServiceLocator.getEncryptionService();
        }
        return this.encryptionService;
    }

    @Deprecated
    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }
}

