/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.state.StateMapping;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ViewAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.rice.krad.service.DictionaryValidationService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ViewValidationService;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.util.GlobalVariables;

public class ViewValidationServiceImpl
implements ViewValidationService {
    protected DictionaryValidationService dictionaryValidationService;

    public DictionaryValidationResult validateView(ViewModel model) {
        return this.validateView(model.getPostedView(), model);
    }

    public DictionaryValidationResult validateView(View view, ViewModel model) {
        return this.validateView(view, model, null);
    }

    public void validateViewSimulation(View view, ViewModel model) {
        this.validateViewSimulation(view, model, null);
    }

    public void validateViewSimulation(View view, ViewModel model, String untilState) {
        StateMapping stateMapping = view.getStateMapping();
        String path = view.getStateObjectBindingPath();
        Object object = StringUtils.isNotBlank((String)path) ? ObjectPropertyUtils.getPropertyValue((Object)model, (String)path) : model;
        if (stateMapping != null && !stateMapping.getStates().isEmpty()) {
            int startIndex = stateMapping.getStates().indexOf(stateMapping.getNextState(object));
            if (startIndex == -1) {
                startIndex = 0;
            }
            for (int i = startIndex; i < stateMapping.getStates().size(); ++i) {
                String state = (String)stateMapping.getStates().get(i);
                this.validateView(view, model, state);
                GlobalVariables.getMessageMap().merge(GlobalVariables.getMessageMap().getErrorMessages(), GlobalVariables.getMessageMap().getWarningMessages());
                GlobalVariables.getMessageMap().clearErrorMessages();
                if (untilState != null && untilState.equals(state)) break;
            }
            this.validateView(view, model, stateMapping.getCurrentState(object));
        } else {
            this.validateView(view, model, null);
        }
    }

    public DictionaryValidationResult validateView(View view, ViewModel model, String forcedValidationState) {
        String path = view.getStateObjectBindingPath();
        Object object = StringUtils.isNotBlank((String)path) ? ObjectPropertyUtils.getPropertyValue((Object)model, (String)path) : model;
        String validationState = null;
        StateMapping stateMapping = view.getStateMapping();
        if (StringUtils.isNotBlank((String)forcedValidationState)) {
            validationState = forcedValidationState;
        } else if (stateMapping != null) {
            validationState = stateMapping.getCurrentState(object);
        }
        return this.getDictionaryValidationService().validate((AttributeValueReader)new ViewAttributeValueReader(view, (Object)model), true, validationState, stateMapping);
    }

    public DictionaryValidationResult validateViewAgainstNextState(View view, ViewModel model) {
        String path = view.getStateObjectBindingPath();
        Object object = StringUtils.isNotBlank((String)path) ? ObjectPropertyUtils.getPropertyValue((Object)model, (String)path) : model;
        String validationState = null;
        StateMapping stateMapping = view.getStateMapping();
        if (stateMapping != null) {
            validationState = stateMapping.getNextState(object);
        }
        return this.getDictionaryValidationService().validate((AttributeValueReader)new ViewAttributeValueReader(view, (Object)model), true, validationState, stateMapping);
    }

    public DictionaryValidationService getDictionaryValidationService() {
        if (this.dictionaryValidationService == null) {
            this.dictionaryValidationService = KRADServiceLocatorWeb.getDictionaryValidationService();
        }
        return this.dictionaryValidationService;
    }

    public void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }
}

