/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.service.SerializerService;
import org.kuali.rice.krad.service.XmlObjectSerializerService;
import org.kuali.rice.krad.service.util.DateTimeConverter;
import org.kuali.rice.krad.util.documentserializer.AlwaysTruePropertySerializibilityEvaluator;
import org.kuali.rice.krad.util.documentserializer.PropertySerializabilityEvaluator;
import org.kuali.rice.krad.util.documentserializer.PropertyType;
import org.kuali.rice.krad.util.documentserializer.SerializationState;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.AutoPopulatingList;

public abstract class SerializerServiceBase
implements SerializerService {
    protected LegacyDataAdapter legacyDataAdapter;
    protected XmlObjectSerializerService xmlObjectSerializerService;
    protected XStream xstream;
    protected ThreadLocal<SerializationState> serializationStates = new ThreadLocal();
    protected ThreadLocal<PropertySerializabilityEvaluator> evaluators = new ThreadLocal();

    public SerializerServiceBase() {
        this.xstream = new XStream((ReflectionProvider)new ProxyAndStateAwareJavaReflectionProvider());
        this.xstream.registerConverter((Converter)new ProxyConverter(this.xstream.getMapper(), this.xstream.getReflectionProvider()));
        try {
            Class<?> objListProxyClass = Class.forName("org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl");
            this.xstream.addDefaultImplementation(ArrayList.class, objListProxyClass);
            this.xstream.addDefaultImplementation(AutoPopulatingList.class, objListProxyClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.xstream.registerConverter((Converter)new AutoPopulatingListConverter(this.xstream.getMapper()));
        this.xstream.registerConverter((SingleValueConverter)new DateTimeConverter());
    }

    public String serializeBusinessObjectToXml(Object businessObject) {
        PropertySerializabilityEvaluator propertySerizabilityEvaluator = this.getPropertySerizabilityEvaluator(businessObject);
        this.evaluators.set(propertySerizabilityEvaluator);
        SerializationState state = new SerializationState();
        this.serializationStates.set(state);
        String xml = propertySerizabilityEvaluator instanceof AlwaysTruePropertySerializibilityEvaluator ? this.getXmlObjectSerializerService().toXml(businessObject) : this.xstream.toXML(businessObject);
        this.evaluators.set(null);
        this.serializationStates.set(null);
        return xml;
    }

    protected boolean ignoreField(Field field) {
        return false;
    }

    protected abstract PropertySerializabilityEvaluator getPropertySerizabilityEvaluator(Object var1);

    protected XmlObjectSerializerService getXmlObjectSerializerService() {
        return this.xmlObjectSerializerService;
    }

    @Required
    public void setXmlObjectSerializerService(XmlObjectSerializerService xmlObjectSerializerService) {
        this.xmlObjectSerializerService = xmlObjectSerializerService;
    }

    protected SerializationState createNewDocumentSerializationState(Document document) {
        return new SerializationState();
    }

    @Required
    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    public class AutoPopulatingListConverter
    extends CollectionConverter {
        public AutoPopulatingListConverter(Mapper mapper) {
            super(mapper);
        }

        public boolean canConvert(Class clazz) {
            return clazz.equals(AutoPopulatingList.class);
        }
    }

    public class ProxyAndStateAwareJavaReflectionProvider
    extends PureJavaReflectionProvider {
        public void visitSerializableFields(Object object, ReflectionProvider.Visitor visitor) {
            SerializationState state = SerializerServiceBase.this.serializationStates.get();
            PropertySerializabilityEvaluator evaluator = SerializerServiceBase.this.evaluators.get();
            Iterator iterator = this.fieldDictionary.serializableFieldsFor(object.getClass());
            while (iterator.hasNext()) {
                Field field = (Field)iterator.next();
                if (!this.fieldModifiersSupported(field) || SerializerServiceBase.this.ignoreField(field)) continue;
                this.validateFieldAccess(field);
                this.initializeField(object, field);
                Object value = null;
                try {
                    value = field.get(object);
                }
                catch (IllegalArgumentException e) {
                    throw new ObjectAccessException("Could not get field " + field.getClass() + "." + field.getName(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ObjectAccessException("Could not get field " + field.getClass() + "." + field.getName(), (Throwable)e);
                }
                if (!evaluator.isPropertySerializable(state, object, field.getName(), value)) continue;
                if (value != null && SerializerServiceBase.this.legacyDataAdapter.isProxied(value)) {
                    value = SerializerServiceBase.this.legacyDataAdapter.resolveProxy(value);
                }
                PropertyType propertyType = evaluator.determinePropertyType(value);
                state.addSerializedProperty(field.getName(), propertyType);
                visitor.visit(field.getName(), field.getType(), field.getDeclaringClass(), value);
                state.removeSerializedProperty();
            }
        }

        protected void initializeField(Object object, Field field) {
        }
    }

    public class ProxyConverter
    extends ReflectionConverter {
        public ProxyConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
            super(mapper, reflectionProvider);
        }

        public boolean canConvert(Class clazz) {
            return clazz.getName().contains("CGLIB") || clazz.getName().equals("org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl");
        }

        public void marshal(Object obj, HierarchicalStreamWriter writer, MarshallingContext context) {
            if (obj.getClass().getName().equals("org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl")) {
                ArrayList copiedList = new ArrayList();
                List proxiedList = (List)obj;
                Iterator iter = proxiedList.iterator();
                while (iter.hasNext()) {
                    copiedList.add(iter.next());
                }
                context.convertAnother(copiedList);
            } else {
                super.marshal(SerializerServiceBase.this.legacyDataAdapter.resolveProxy(obj), writer, context);
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return null;
        }
    }
}

