/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.util.io.SerializationUtils;
import org.kuali.rice.core.framework.persistence.jta.TransactionalNoValidationExceptionRollback;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.exception.DocumentTypeAuthorizationException;
import org.kuali.rice.krad.maintenance.Maintainable;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.maintenance.MaintenanceLock;
import org.kuali.rice.krad.service.DataObjectAuthorizationService;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.service.MaintenanceDocumentService;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.springframework.beans.factory.annotation.Required;

@TransactionalNoValidationExceptionRollback
public class MaintenanceDocumentServiceImpl
implements MaintenanceDocumentService {
    private static final Logger LOG = Logger.getLogger(MaintenanceDocumentServiceImpl.class);
    protected LegacyDataAdapter legacyDataAdapter;
    protected DataObjectService dataObjectService;
    protected DataObjectAuthorizationService dataObjectAuthorizationService;
    protected DocumentService documentService;
    protected DocumentDictionaryService documentDictionaryService;

    public MaintenanceDocument setupNewMaintenanceDocument(String objectClassName, String documentTypeName, String maintenanceAction) {
        if (StringUtils.isEmpty((String)objectClassName) && StringUtils.isEmpty((String)documentTypeName)) {
            throw new IllegalArgumentException("Document type name or bo class not given!");
        }
        if (StringUtils.isEmpty((String)documentTypeName)) {
            try {
                documentTypeName = this.getDocumentDictionaryService().getMaintenanceDocumentTypeName(Class.forName(objectClassName));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (StringUtils.isEmpty((String)documentTypeName)) {
                throw new RuntimeException("documentTypeName is empty; does this Business Object have a maintenance document definition? " + objectClassName);
            }
        }
        if ("New".equals(maintenanceAction) || "Copy".equals(maintenanceAction)) {
            Class boClass = this.getDocumentDictionaryService().getMaintenanceDataObjectClass(documentTypeName);
            boolean allowsNewOrCopy = this.getDataObjectAuthorizationService().canCreate(boClass, GlobalVariables.getUserSession().getPerson(), documentTypeName);
            if (!allowsNewOrCopy) {
                LOG.error((Object)("Document type " + documentTypeName + " does not allow new or copy actions."));
                throw new DocumentTypeAuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "newOrCopy", documentTypeName);
            }
        }
        try {
            return (MaintenanceDocument)this.getDocumentService().getNewDocument(documentTypeName);
        }
        catch (WorkflowException e) {
            LOG.error((Object)("Cannot get new maintenance document instance for doc type: " + documentTypeName), (Throwable)e);
            throw new RuntimeException("Cannot get new maintenance document instance for doc type: " + documentTypeName, e);
        }
    }

    public void setupMaintenanceObject(MaintenanceDocument document, String maintenanceAction, Map<String, String[]> requestParameters) {
        document.getNewMaintainableObject().setMaintenanceAction(maintenanceAction);
        document.getOldMaintainableObject().setMaintenanceAction(maintenanceAction);
        if ("Delete".equals(maintenanceAction)) {
            this.checkMaintenanceActionAuthorization(document, document.getOldMaintainableObject(), maintenanceAction, requestParameters);
        }
        if (!"New".equals(maintenanceAction) && !"newWithExisting".equals(maintenanceAction)) {
            Object oldDataObject = this.retrieveObjectForMaintenance(document, requestParameters);
            Object newDataObject = null;
            newDataObject = this.dataObjectService.supports(oldDataObject.getClass()) ? ("Copy".equals(maintenanceAction) ? this.dataObjectService.copyInstance(oldDataObject, new CopyOption[]{CopyOption.RESET_VERSION_NUMBER, CopyOption.RESET_OBJECT_ID}) : this.dataObjectService.copyInstance(oldDataObject, new CopyOption[0])) : SerializationUtils.deepCopy((Serializable)((Serializable)oldDataObject));
            document.getOldMaintainableObject().setDataObject(oldDataObject);
            document.getNewMaintainableObject().setDataObject(newDataObject);
            if ("Copy".equals(maintenanceAction) && !document.isFieldsClearedOnCopy()) {
                Maintainable maintainable = document.getNewMaintainableObject();
                if (!this.dataObjectService.supports(oldDataObject.getClass())) {
                    if (ObjectPropertyUtils.getWriteMethod(maintainable.getDataObject().getClass(), (String)"versionNumber") != null) {
                        ObjectPropertyUtils.setPropertyValue((Object)maintainable.getDataObject(), (String)"versionNumber", null);
                    }
                    if (ObjectPropertyUtils.getWriteMethod(maintainable.getDataObject().getClass(), (String)"objectId") != null) {
                        ObjectPropertyUtils.setPropertyValue((Object)maintainable.getDataObject(), (String)"objectId", null);
                    }
                }
                this.clearValuesForPropertyNames(newDataObject, maintainable.getDataObjectClass());
                if (!this.getDocumentDictionaryService().getPreserveLockingKeysOnCopy(maintainable.getDataObjectClass())) {
                    this.clearPrimaryKeyFields(newDataObject, maintainable.getDataObjectClass());
                }
            }
            this.checkMaintenanceActionAuthorization(document, oldDataObject, maintenanceAction, requestParameters);
        }
        if ("newWithExisting".equals(maintenanceAction)) {
            Object newBO = document.getNewMaintainableObject().getDataObject();
            Map<String, String> parameters = this.buildKeyMapFromRequest(requestParameters, document.getNewMaintainableObject().getDataObjectClass());
            ObjectPropertyUtils.copyPropertiesToObject(parameters, (Object)newBO);
            if (newBO instanceof PersistableBusinessObject) {
                ((PersistableBusinessObject)newBO).refresh();
            }
            document.getNewMaintainableObject().setupNewFromExisting(document, requestParameters);
        } else if ("New".equals(maintenanceAction)) {
            document.getNewMaintainableObject().processAfterNew(document, requestParameters);
        }
    }

    protected void checkMaintenanceActionAuthorization(MaintenanceDocument document, Object oldBusinessObject, String maintenanceAction, Map<String, String[]> requestParameters) {
        if ("Edit".equals(maintenanceAction)) {
            boolean allowsEdit = this.getDataObjectAuthorizationService().canMaintain(oldBusinessObject, GlobalVariables.getUserSession().getPerson(), document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            if (!allowsEdit) {
                LOG.error((Object)("Document type " + document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName() + " does not allow edit actions."));
                throw new DocumentTypeAuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "edit", document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            }
            document.getNewMaintainableObject().processAfterEdit(document, requestParameters);
        } else if ("Delete".equals(maintenanceAction)) {
            boolean allowsDelete = this.getDataObjectAuthorizationService().canMaintain(oldBusinessObject, GlobalVariables.getUserSession().getPerson(), document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            if (!allowsDelete) {
                LOG.error((Object)("Document type " + document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName() + " does not allow delete actions."));
                throw new DocumentTypeAuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "delete", document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            }
            boolean dataObjectAllowsDelete = this.getDocumentDictionaryService().getAllowsRecordDeletion(document.getOldMaintainableObject().getDataObject().getClass());
            if (!dataObjectAllowsDelete) {
                LOG.error((Object)("Document type " + document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName() + " does not allow delete actions."));
                GlobalVariables.getMessageMap().removeAllWarningMessagesForProperty("GlobalMessages");
                GlobalVariables.getMessageMap().putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "delete.action.not.supported", new String[0]);
            }
        }
    }

    protected Object retrieveObjectForMaintenance(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        Map<String, String> keyMap = this.buildKeyMapFromRequest(requestParameters, document.getNewMaintainableObject().getDataObjectClass());
        Object oldDataObject = document.getNewMaintainableObject().retrieveObjectForEditOrCopy(document, keyMap);
        if (oldDataObject == null && !document.getOldMaintainableObject().isExternalBusinessObject()) {
            throw new RuntimeException("Cannot retrieve old record for maintenance document, incorrect parameters passed on maint url: " + requestParameters);
        }
        if (document.getOldMaintainableObject().isExternalBusinessObject()) {
            if (oldDataObject == null) {
                try {
                    oldDataObject = document.getOldMaintainableObject().getDataObjectClass().newInstance();
                }
                catch (Exception ex) {
                    throw new RuntimeException("External BO maintainable was null and unable to instantiate for old maintainable object.", ex);
                }
            }
            this.populateMaintenanceObjectWithCopyKeyValues(KRADUtils.translateRequestParameterMap(requestParameters), oldDataObject, document.getOldMaintainableObject());
            document.getOldMaintainableObject().prepareExternalBusinessObject((BusinessObject)((PersistableBusinessObject)oldDataObject));
            oldDataObject = document.getOldMaintainableObject().getDataObject();
        }
        return oldDataObject;
    }

    protected void clearPrimaryKeyFields(Object maintenanceObject, Class<?> dataObjectClass) {
        List keyFieldNames = this.legacyDataAdapter.listPrimaryKeyFieldNames(dataObjectClass);
        for (String keyFieldName : keyFieldNames) {
            ObjectPropertyUtils.setPropertyValue((Object)maintenanceObject, (String)keyFieldName, null);
        }
    }

    protected void clearValuesForPropertyNames(Object maintenanceObject, Class<?> dataObjectClass) {
        List clearValueOnCopyPropertyNames = this.getDocumentDictionaryService().getClearValueOnCopyPropertyNames(dataObjectClass);
        for (String clearValueOnCopyPropertyName : clearValueOnCopyPropertyNames) {
            if (!StringUtils.contains((String)clearValueOnCopyPropertyName, (String)".")) {
                if (!ObjectPropertyUtils.isWritableProperty((Object)maintenanceObject, (String)clearValueOnCopyPropertyName)) continue;
                ObjectPropertyUtils.setPropertyValue((Object)maintenanceObject, (String)clearValueOnCopyPropertyName, null);
                continue;
            }
            String objectName = StringUtils.substringBeforeLast((String)clearValueOnCopyPropertyName, (String)".");
            String objectToClear = StringUtils.substringAfterLast((String)clearValueOnCopyPropertyName, (String)".");
            this.clearValuesInNestedObjects(objectName, maintenanceObject, objectToClear);
        }
    }

    private void clearValuesInNestedObjects(String objectName, Object maintenanceObject, String objectToClear) {
        if (objectName.contains(".")) {
            String newObjectName = StringUtils.substringAfter((String)objectName, (String)".");
            if (ObjectPropertyUtils.getPropertyValue((Object)maintenanceObject, (String)(objectName = StringUtils.substringBefore((String)objectName, (String)"."))) instanceof Collection) {
                Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue((Object)maintenanceObject, (String)objectName);
                for (Object object : collection) {
                    this.clearValuesInNestedObjects(newObjectName, object, objectToClear);
                }
            } else {
                Object object = ObjectPropertyUtils.getPropertyValue((Object)maintenanceObject, (String)objectName);
                this.clearValuesInNestedObjects(newObjectName, object, objectToClear);
            }
        } else if (ObjectPropertyUtils.getPropertyValue((Object)maintenanceObject, (String)objectName) instanceof Collection) {
            Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue((Object)maintenanceObject, (String)objectName);
            for (Object object : collection) {
                if (!ObjectPropertyUtils.isWritableProperty(object, (String)objectToClear)) continue;
                ObjectPropertyUtils.setPropertyValue(object, (String)objectToClear, null);
            }
        } else {
            Object object = ObjectPropertyUtils.getPropertyValue((Object)maintenanceObject, (String)objectName);
            if (ObjectPropertyUtils.isWritableProperty((Object)object, (String)objectToClear)) {
                ObjectPropertyUtils.setPropertyValue((Object)object, (String)objectToClear, null);
            }
        }
    }

    protected Map<String, String> buildKeyMapFromRequest(Map<String, String[]> requestParameters, Class<?> dataObjectClass) {
        List<String> keyFieldNames = null;
        Map parameters = KRADUtils.translateRequestParameterMap(requestParameters);
        if (!StringUtils.isBlank((String)((String)parameters.get("overrideKeys")))) {
            String[] overrideKeys = ((String)parameters.get("overrideKeys")).split(",");
            keyFieldNames = Arrays.asList(overrideKeys);
        } else {
            keyFieldNames = this.legacyDataAdapter.listPrimaryKeyFieldNames(dataObjectClass);
        }
        return KRADUtils.getParametersFromRequest((List)keyFieldNames, dataObjectClass, (Map)parameters);
    }

    protected void populateMaintenanceObjectWithCopyKeyValues(Map<String, String> parameters, Object oldBusinessObject, Maintainable oldMaintainableObject) {
        List<String> keyFieldNamesToCopy = null;
        Map parametersToCopy = null;
        if (!StringUtils.isBlank((String)parameters.get("cpKys"))) {
            String[] copyKeys = parameters.get("cpKys").split(",");
            keyFieldNamesToCopy = Arrays.asList(copyKeys);
            parametersToCopy = KRADUtils.getParametersFromRequest(keyFieldNamesToCopy, (Class)oldMaintainableObject.getDataObjectClass(), parameters);
        }
        if (parametersToCopy != null) {
            ObjectPropertyUtils.copyPropertiesToObject(parametersToCopy, (Object)oldBusinessObject);
        }
    }

    public String getLockingDocumentId(MaintenanceDocument document) {
        return this.getLockingDocumentId(document.getNewMaintainableObject(), document.getDocumentNumber());
    }

    public String getLockingDocumentId(Maintainable maintainable, String documentNumber) {
        MaintenanceLock maintenanceLock;
        List maintenanceLocks = maintainable.generateMaintenanceLocks();
        String lockingDocId = null;
        Iterator i$ = maintenanceLocks.iterator();
        while (i$.hasNext() && !StringUtils.isNotBlank((String)(lockingDocId = this.getLockingDocumentNumber((maintenanceLock = (MaintenanceLock)i$.next()).getLockingRepresentation(), documentNumber)))) {
        }
        return lockingDocId;
    }

    protected String getLockingDocumentNumber(String lockingRepresentation, String documentNumber) {
        String lockingDocNumber = "";
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(PredicateFactory.equal((String)"lockingRepresentation", (Object)lockingRepresentation));
        if (StringUtils.isNotBlank((String)documentNumber)) {
            predicates.add(PredicateFactory.notEqual((String)"documentNumber", (Object)documentNumber));
        }
        QueryByCriteria.Builder qbc = QueryByCriteria.Builder.create();
        qbc.setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])predicates.toArray(new Predicate[predicates.size()]))});
        List results = KradDataServiceLocator.getDataObjectService().findMatching(MaintenanceLock.class, qbc.build()).getResults();
        if (results.size() > 1) {
            throw new IllegalStateException("Expected single result querying for MaintenanceLock. LockRep: " + lockingRepresentation);
        }
        if (!results.isEmpty()) {
            lockingDocNumber = ((MaintenanceLock)results.get(0)).getDocumentNumber();
        }
        return lockingDocNumber;
    }

    public void deleteLocks(String documentNumber) {
        this.dataObjectService.deleteMatching(MaintenanceLock.class, QueryByCriteria.Builder.forAttribute((String)"documentNumber", (Object)documentNumber).build());
    }

    public void storeLocks(List<MaintenanceLock> maintenanceLocks) {
        if (maintenanceLocks == null) {
            return;
        }
        for (MaintenanceLock maintenanceLock : maintenanceLocks) {
            this.dataObjectService.save((Object)maintenanceLock, new PersistenceOption[0]);
        }
    }

    protected DataObjectAuthorizationService getDataObjectAuthorizationService() {
        return this.dataObjectAuthorizationService;
    }

    @Required
    public void setDataObjectAuthorizationService(DataObjectAuthorizationService dataObjectAuthorizationService) {
        this.dataObjectAuthorizationService = dataObjectAuthorizationService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    @Required
    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        return this.documentDictionaryService;
    }

    @Required
    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    @Required
    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }
}

