/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.service.impl;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.service.ViewService;
import org.kuali.rice.krad.uif.service.ViewTypeService;
import org.kuali.rice.krad.uif.view.View;

public class ViewServiceImpl
implements ViewService {
    private static final Logger LOG = Logger.getLogger(ViewServiceImpl.class);
    private DataDictionaryService dataDictionaryService;
    private List<ViewTypeService> viewTypeServices;

    public View getViewById(String viewId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("retrieving view instance for id: " + viewId));
        }
        return this.dataDictionaryService.getViewById(viewId);
    }

    public View getViewByType(UifConstants.ViewType viewType, Map<String, String> parameters) {
        ViewTypeService typeService = this.getViewTypeService(viewType);
        if (typeService == null) {
            throw new RuntimeException("Unable to find view type service for view type name: " + viewType);
        }
        Map typeParameters = typeService.getParametersFromRequest(parameters);
        View view = this.dataDictionaryService.getViewByTypeIndex(viewType, typeParameters);
        if (view == null) {
            LOG.warn((Object)("View not found for type: " + viewType));
        }
        return view;
    }

    public String getViewIdForViewType(UifConstants.ViewType viewType, Map<String, String> parameters) {
        ViewTypeService typeService = this.getViewTypeService(viewType);
        if (typeService == null) {
            throw new RuntimeException("Unable to find view type service for view type name: " + viewType);
        }
        Map typeParameters = typeService.getParametersFromRequest(parameters);
        return this.dataDictionaryService.getViewIdByTypeIndex(viewType, typeParameters);
    }

    public ViewTypeService getViewTypeService(UifConstants.ViewType viewType) {
        if (this.viewTypeServices != null) {
            for (ViewTypeService typeService : this.viewTypeServices) {
                if (!viewType.equals((Object)typeService.getViewTypeName())) continue;
                return typeService;
            }
        }
        return null;
    }

    public List<ViewTypeService> getViewTypeServices() {
        return this.viewTypeServices;
    }

    public void setViewTypeServices(List<ViewTypeService> viewTypeServices) {
        this.viewTypeServices = viewTypeServices;
    }

    protected DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

