/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.theme.postprocessor;

import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.SourceFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.theme.postprocessor.ThemeFilesProcessor;
import org.kuali.rice.krad.theme.util.ThemeBuilderUtils;

public class ThemeJsFilesProcessor
extends ThemeFilesProcessor {
    private static final Logger LOG = Logger.getLogger(ThemeJsFilesProcessor.class);

    public ThemeJsFilesProcessor(String themeName, File themeDirectory, Properties themeProperties, Map<String, File> themePluginDirsMap, File workingDir, String projectVersion) {
        super(themeName, themeDirectory, themeProperties, themePluginDirsMap, workingDir, projectVersion);
    }

    @Override
    protected String getFileTypeExtension() {
        return ".js";
    }

    @Override
    protected String getExcludesConfigKey() {
        return "jsExcludes";
    }

    @Override
    protected String getFileTypeDirectoryName() {
        return "scripts";
    }

    @Override
    protected String getFileListingConfigKey() {
        return "themeJsFiles";
    }

    @Override
    protected void addAdditionalFiles(List<File> themeFiles) {
        File kradScriptDir = new File(this.workingDir, "/krad/scripts");
        themeFiles.addAll(ThemeBuilderUtils.getDirectoryFiles(kradScriptDir, this.getFileIncludes(), null));
    }

    @Override
    protected List<File> sortThemeFiles(List<File> pluginFiles, List<File> subDirFiles) {
        List<String> loadJsFirst = this.getThemePropertyValue("jsLoadFirst");
        List<String> loadJsLast = this.getThemePropertyValue("jsLoadLast");
        List<String> pluginJsLoadOrder = this.getThemePropertyValue("pluginJsLoadOrder");
        List<String> jsLoadOrder = this.getThemePropertyValue("themeJsLoadOrder");
        List<String> kradScriptOrder = null;
        try {
            kradScriptOrder = this.retrieveKradScriptLoadOrder();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to pull KRAD load order property key", e);
        }
        if (kradScriptOrder != null) {
            if (jsLoadOrder == null) {
                jsLoadOrder = new ArrayList<String>();
            }
            jsLoadOrder.addAll(0, kradScriptOrder);
        }
        return ThemeBuilderUtils.orderFiles(pluginFiles, subDirFiles, loadJsFirst, loadJsLast, pluginJsLoadOrder, jsLoadOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> retrieveKradScriptLoadOrder() throws IOException {
        List<String> scriptFileNames;
        ArrayList<String> scriptLoadOrder = new ArrayList();
        File kradScriptsDir = new File(this.workingDir, "/krad/scripts");
        File loadPropertiesFile = new File(kradScriptsDir, "load.properties");
        if (!loadPropertiesFile.exists()) {
            throw new RuntimeException("load.properties file not found in KRAD scripts directory");
        }
        Properties loadProperties = null;
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(loadPropertiesFile);
            loadProperties = new Properties();
            loadProperties.load(fileInputStream);
        }
        if (loadProperties.containsKey("scriptLoadOrder")) {
            scriptLoadOrder = ThemeBuilderUtils.getPropertyValueAsList("scriptLoadOrder", loadProperties);
        }
        if ((scriptFileNames = ThemeBuilderUtils.getDirectoryFileNames(kradScriptsDir, null, null)) != null) {
            for (String scriptFileName : scriptFileNames) {
                String baseScriptFileName = StringUtils.substringBeforeLast((String)scriptFileName, (String)".");
                if (scriptLoadOrder.contains(baseScriptFileName)) continue;
                scriptLoadOrder.add(baseScriptFileName);
            }
        }
        return scriptLoadOrder;
    }

    @Override
    protected String processMergeFileContents(String fileContents, File fileToMerge, File mergedFile) throws IOException {
        if (fileContents != null && !fileContents.matches("(?s).*;\\s*$")) {
            fileContents = fileContents + ";";
        }
        return fileContents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void minify(File mergedFile, File minifiedFile) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        OutputStreamWriter writer = null;
        InputStreamReader reader = null;
        LOG.info((Object)("Populating minified JS file: " + minifiedFile.getPath()));
        try {
            out = new FileOutputStream(minifiedFile);
            writer = new OutputStreamWriter(out);
            in = new FileInputStream(mergedFile);
            reader = new InputStreamReader(in);
            CompilerOptions options = new CompilerOptions();
            CompilationLevel.WHITESPACE_ONLY.setOptionsForCompilationLevel(options);
            options.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT6);
            options.setExtraAnnotationNames(this.ignoredAnnotations());
            SourceFile input = SourceFile.fromInputStream((String)mergedFile.getName(), (InputStream)in);
            List externs = Collections.emptyList();
            Compiler compiler = new Compiler();
            compiler.compile(externs, Arrays.asList(input), options);
            writer.append(compiler.toSource());
            writer.flush();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    protected Set<String> ignoredAnnotations() {
        HashSet<String> annotations = new HashSet<String>();
        annotations.add("dtopt");
        annotations.add("result");
        annotations.add("cat");
        annotations.add("parm");
        return annotations;
    }
}

