/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.theme.util;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.theme.util.ThemeBuilderUtils;

public class ThemeBuilderUtilsTest {
    @Test
    public void testCalculatePathToFile() {
        File fromFile = new File("/basedir/subDir1/foo.css");
        File toFile = new File("/basedir/subDir2/foo.css");
        String path = ThemeBuilderUtils.calculatePathToFile((File)fromFile, (File)toFile);
        Assert.assertEquals((String)"Path incorrect for up one dir", (Object)"../subDir2/", (Object)path);
        fromFile = new File("/basedir/subDir1/foo.css");
        toFile = new File("/basedir/subDir1/foo.css");
        path = ThemeBuilderUtils.calculatePathToFile((File)fromFile, (File)toFile);
        Assert.assertEquals((String)"Path incorrect for same dir", (Object)"", (Object)path);
        fromFile = new File("/basedir/dir1/subDir1/foo.css");
        toFile = new File("/basedir/dir2/subDir2/foo.css");
        path = ThemeBuilderUtils.calculatePathToFile((File)fromFile, (File)toFile);
        Assert.assertEquals((String)"Path incorrect for up two dir", (Object)"../../dir2/subDir2/", (Object)path);
        fromFile = new File("/basedir/subDir1/foo.css");
        toFile = new File("/basedir/subDir1/moreDir/foo.css");
        path = ThemeBuilderUtils.calculatePathToFile((File)fromFile, (File)toFile);
        Assert.assertEquals((String)"Path incorrect for sub dir", (Object)"moreDir/", (Object)path);
    }

    @Test
    public void testAddStringToArray() {
        String[] array1 = new String[]{"a1", "a2"};
        String stringToAdd = "b1";
        String[] combinedArray = ThemeBuilderUtils.addToArray((String[])array1, (String)stringToAdd);
        Assert.assertEquals((String)"Combined array length is not correct", (long)3L, (long)combinedArray.length);
        Assert.assertEquals((Object)"a1", (Object)combinedArray[0]);
        Assert.assertEquals((Object)"a2", (Object)combinedArray[1]);
        Assert.assertEquals((Object)"b1", (Object)combinedArray[2]);
    }

    @Test
    public void testAddArrayToArray() {
        String[] array1 = new String[]{"a1", "a2"};
        String[] array2 = new String[]{"b1", "b2", "b3"};
        String[] combinedArray = ThemeBuilderUtils.addToArray((String[])array1, (String[])array2);
        Assert.assertEquals((String)"Combined array length is not correct", (long)5L, (long)combinedArray.length);
        Assert.assertEquals((Object)"a1", (Object)combinedArray[0]);
        Assert.assertEquals((Object)"a2", (Object)combinedArray[1]);
        Assert.assertEquals((Object)"b1", (Object)combinedArray[2]);
        Assert.assertEquals((Object)"b2", (Object)combinedArray[3]);
        Assert.assertEquals((Object)"b3", (Object)combinedArray[4]);
        array2 = null;
        combinedArray = ThemeBuilderUtils.addToArray((String[])array1, (String[])array2);
        Assert.assertEquals((String)"Combined array length is not correct", (long)2L, (long)combinedArray.length);
        Assert.assertEquals((Object)"a1", (Object)combinedArray[0]);
        Assert.assertEquals((Object)"a2", (Object)combinedArray[1]);
        array1 = null;
        array2 = new String[]{"b1", "b2", "b3"};
        combinedArray = ThemeBuilderUtils.addToArray((String[])array1, (String[])array2);
        Assert.assertEquals((String)"Combined array length is not correct", (long)3L, (long)combinedArray.length);
        Assert.assertEquals((Object)"b1", (Object)combinedArray[0]);
        Assert.assertEquals((Object)"b2", (Object)combinedArray[1]);
        Assert.assertEquals((Object)"b3", (Object)combinedArray[2]);
    }
}

