/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.theme;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.common.util.Assert;
import org.kuali.common.util.execute.Executable;
import org.kuali.rice.krad.theme.ThemeBuilderOverlays;
import org.kuali.rice.krad.theme.postprocessor.ThemeCssFilesProcessor;
import org.kuali.rice.krad.theme.postprocessor.ThemeFilesProcessor;
import org.kuali.rice.krad.theme.postprocessor.ThemeJsFilesProcessor;
import org.kuali.rice.krad.theme.preprocessor.ThemePreProcessor;
import org.kuali.rice.krad.theme.util.NonHiddenDirectoryFilter;
import org.kuali.rice.krad.theme.util.ThemeBuilderUtils;

public class ThemeBuilder
implements Executable {
    private static final Logger LOG = Logger.getLogger(ThemeBuilder.class);
    private String webappSourceDir;
    private String themeBuilderOutputDir;
    private List<String> themeExcludes;
    private List<String> additionalThemeDirectories;
    private List<String> additionalPluginDirectories;
    private String projectVersion;
    private List<ThemePreProcessor> themePreProcessors;
    private Map<String, String> themeNamePathMapping;
    private Map<String, Properties> themeNamePropertiesMapping;
    private Map<String, String> pluginNamePathMapping;
    private boolean skipThemeProcessing;

    public void execute() {
        Assert.hasText((String)this.webappSourceDir, (String)"Webapp source directory not set");
        LOG.info((Object)("View builder executed on " + this.webappSourceDir));
        try {
            ThemeBuilderOverlays.copyAssetsToWorkingDir(this.webappSourceDir, this.themeBuilderOutputDir, this.additionalThemeDirectories, this.additionalPluginDirectories);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to copy assets to working directory", e);
        }
        List<File> themeDirectories = this.getThemeDirectories();
        List<File> pluginDirectories = this.getPluginDirectories();
        try {
            this.buildMappings(themeDirectories, pluginDirectories);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to build theme mappings", e);
        }
        List<String> orderedThemes = this.orderThemesForBuilding();
        if (this.themeExcludes != null) {
            for (String themeToExclude : this.themeExcludes) {
                if (orderedThemes.contains(themeToExclude = themeToExclude.toLowerCase())) {
                    orderedThemes.remove(themeToExclude);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Skipping build for theme " + themeToExclude));
            }
        }
        for (String themeName : orderedThemes) {
            this.copyParentThemeConfig(themeName);
            Properties themeProperties = this.themeNamePropertiesMapping.get(themeName);
            String themePath = this.themeNamePathMapping.get(themeName);
            File themeDirectory = new File(themePath);
            ThemeBuilderOverlays.overlayParentAssets(themeName, themeDirectory, themeProperties, this.themeNamePathMapping);
            ThemeBuilderOverlays.overlayAdditionalDirs(themeDirectory, themeProperties, this.webappSourceDir, this.themeBuilderOutputDir);
        }
        if (this.skipThemeProcessing) {
            LOG.info((Object)"Skipping theme processing");
            return;
        }
        for (String themeName : orderedThemes) {
            this.processThemeAssets(themeName);
        }
    }

    protected List<File> getThemeDirectories() {
        ArrayList<File> themeDirectories = new ArrayList();
        String defaultThemesDirectoryPath = this.themeBuilderOutputDir + "/themes";
        File defaultThemesDirectory = new File(defaultThemesDirectoryPath);
        File[] defaultThemeDirectories = defaultThemesDirectory.listFiles(new NonHiddenDirectoryFilter());
        if (defaultThemeDirectories != null) {
            themeDirectories = Arrays.asList(defaultThemeDirectories);
        }
        if (this.additionalThemeDirectories != null) {
            List<File> additionalThemeDirs = ThemeBuilderUtils.getSubDirectories(new File(this.themeBuilderOutputDir), this.additionalThemeDirectories);
            themeDirectories.addAll(additionalThemeDirs);
        }
        ThemeBuilderUtils.validateFileExistence(themeDirectories, "Invalid theme directory.");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found theme directories: " + StringUtils.join(themeDirectories, (String)",")));
        }
        return themeDirectories;
    }

    protected List<File> getPluginDirectories() {
        ArrayList<File> pluginDirectories = new ArrayList();
        String defaultPluginsDirectoryPath = this.themeBuilderOutputDir + "/plugins";
        File defaultPluginsDirectory = new File(defaultPluginsDirectoryPath);
        File[] pluginDirs = defaultPluginsDirectory.listFiles(new NonHiddenDirectoryFilter());
        if (pluginDirs != null) {
            pluginDirectories = Arrays.asList(pluginDirs);
        }
        if (this.additionalPluginDirectories != null) {
            List<File> additionalPluginDirs = ThemeBuilderUtils.getSubDirectories(new File(this.themeBuilderOutputDir), this.additionalPluginDirectories);
            pluginDirectories.addAll(additionalPluginDirs);
        }
        ThemeBuilderUtils.validateFileExistence(pluginDirectories, "Invalid plugin directory.");
        return pluginDirectories;
    }

    protected void buildMappings(List<File> themeDirectories, List<File> pluginDirectories) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Building mappings");
        }
        this.themeNamePathMapping = new HashMap<String, String>();
        this.themeNamePropertiesMapping = new HashMap<String, Properties>();
        for (File themeDirectory : themeDirectories) {
            String themeName = themeDirectory.getName().toLowerCase();
            this.themeNamePathMapping.put(themeName, themeDirectory.getPath());
            Properties themeProperties = ThemeBuilderUtils.retrieveThemeProperties(themeDirectory.getPath());
            if (themeProperties == null) {
                themeProperties = new Properties();
            }
            this.themeNamePropertiesMapping.put(themeName, themeProperties);
        }
        this.pluginNamePathMapping = new HashMap<String, String>();
        for (File pluginDirectory : pluginDirectories) {
            String pluginName = pluginDirectory.getName().toLowerCase();
            this.pluginNamePathMapping.put(pluginName, pluginDirectory.getPath());
        }
    }

    protected List<String> orderThemesForBuilding() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Ordering themes for building");
        }
        ArrayList<String> orderedThemes = new ArrayList<String>();
        for (String themeName : this.themeNamePathMapping.keySet()) {
            String themePath = this.themeNamePathMapping.get(themeName);
            if (orderedThemes.contains(themeName)) continue;
            List<String> themeParents = this.getAllThemeParents(themeName, new ArrayList<String>());
            for (String themeParent : themeParents) {
                if (orderedThemes.contains(themeParent)) continue;
                orderedThemes.add(themeParent);
            }
            orderedThemes.add(themeName);
        }
        return orderedThemes;
    }

    protected List<String> getAllThemeParents(String themeName, List<String> themeParents) {
        Properties themeProperties = this.themeNamePropertiesMapping.get(themeName);
        if (themeProperties.containsKey("parent")) {
            String parentThemeName = themeProperties.getProperty("parent");
            if (StringUtils.isBlank((String)parentThemeName)) {
                return themeParents;
            }
            if (!this.themeNamePropertiesMapping.containsKey(parentThemeName)) {
                throw new RuntimeException("Invalid theme name for parent property: " + parentThemeName);
            }
            if (themeParents.contains(parentThemeName)) {
                throw new RuntimeException("Circular reference found for parent: " + parentThemeName);
            }
            themeParents.addAll(this.getAllThemeParents(parentThemeName, themeParents));
            themeParents.add(parentThemeName);
        }
        return themeParents;
    }

    protected void copyParentThemeConfig(String themeName) {
        String[] propertiesToCopy;
        Properties themeProperties = this.themeNamePropertiesMapping.get(themeName);
        if (!themeProperties.containsKey("parent")) {
            return;
        }
        String parentThemeName = themeProperties.getProperty("parent");
        Properties parentThemeProperties = this.themeNamePropertiesMapping.get(parentThemeName);
        for (String propertyKey : propertiesToCopy = new String[]{"lessIncludes", "lessExcludes", "pluginIncludes", "pluginExcludes", "pluginFileExcludes", "additionalOverlays", "cssLoadFirst", "cssLoadLast", "pluginJsLoadOrder", "pluginCssLoadOrder", "themeJsLoadOrder", "themeCssLoadOrder", "jsLoadFirst", "jsLoadLast", "devJsIncludes"}) {
            ThemeBuilderUtils.copyProperty(propertyKey, parentThemeProperties, themeProperties);
        }
    }

    protected void processThemeAssets(String themeName) {
        Properties themeProperties = this.themeNamePropertiesMapping.get(themeName);
        String themePath = this.themeNamePathMapping.get(themeName);
        File themeDirectory = new File(themePath);
        LOG.info((Object)("Processing assets for theme: " + themeName));
        if (this.themePreProcessors != null) {
            for (ThemePreProcessor preProcessor : this.themePreProcessors) {
                preProcessor.processTheme(themeName, themeDirectory, themeProperties);
            }
        }
        File workingDir = new File(this.themeBuilderOutputDir);
        Map<String, File> themePluginDirsMap = this.collectThemePluginDirs(themeProperties);
        ThemeFilesProcessor filesProcessor = new ThemeCssFilesProcessor(themeName, themeDirectory, themeProperties, themePluginDirsMap, workingDir, this.projectVersion);
        filesProcessor.process();
        filesProcessor = new ThemeJsFilesProcessor(themeName, themeDirectory, themeProperties, themePluginDirsMap, workingDir, this.projectVersion);
        filesProcessor.process();
        try {
            ThemeBuilderUtils.storeThemeProperties(themePath, themeProperties);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to update theme.properties file", e);
        }
    }

    protected Map<String, File> collectThemePluginDirs(Properties themeProperties) {
        HashMap<String, File> themePluginDirs = new HashMap<String, File>();
        String[] pluginIncludes = ThemeBuilderUtils.getPropertyValueAsArray("pluginIncludes", themeProperties);
        String[] pluginExcludes = ThemeBuilderUtils.getPropertyValueAsArray("pluginExcludes", themeProperties);
        for (Map.Entry<String, String> pluginMapping : this.pluginNamePathMapping.entrySet()) {
            String pluginName = pluginMapping.getKey();
            if (ThemeBuilderUtils.inExcludeList(pluginName, pluginExcludes) || !ThemeBuilderUtils.inIncludeList(pluginName, pluginIncludes)) continue;
            themePluginDirs.put(pluginName, new File(pluginMapping.getValue()));
        }
        themeProperties.put("themePluginNames", StringUtils.join(themePluginDirs.keySet(), (String)","));
        return themePluginDirs;
    }

    protected Map<String, String> getThemeNamePathMapping() {
        return this.themeNamePathMapping;
    }

    protected Map<String, Properties> getThemeNamePropertiesMapping() {
        return this.themeNamePropertiesMapping;
    }

    public String getWebappSourceDir() {
        return this.webappSourceDir;
    }

    public void setWebappSourceDir(String webappSourceDir) {
        if (StringUtils.isNotBlank((String)webappSourceDir) && (webappSourceDir.endsWith(File.separator) || webappSourceDir.endsWith("/"))) {
            webappSourceDir = webappSourceDir.substring(0, webappSourceDir.length() - 1);
        }
        this.webappSourceDir = webappSourceDir;
    }

    public String getThemeBuilderOutputDir() {
        return this.themeBuilderOutputDir;
    }

    public void setThemeBuilderOutputDir(String themeBuilderOutputDir) {
        if (StringUtils.isNotBlank((String)themeBuilderOutputDir) && (themeBuilderOutputDir.endsWith(File.separator) || themeBuilderOutputDir.endsWith("/"))) {
            themeBuilderOutputDir = themeBuilderOutputDir.substring(0, themeBuilderOutputDir.length() - 1);
        }
        this.themeBuilderOutputDir = themeBuilderOutputDir;
    }

    public List<String> getThemeExcludes() {
        return this.themeExcludes;
    }

    public void setThemeExcludes(List<String> themeExcludes) {
        this.themeExcludes = themeExcludes;
    }

    public void setThemeExcludesStr(String themeExcludes) {
        if (StringUtils.isNotBlank((String)themeExcludes)) {
            String[] themeExcludesArray = themeExcludes.split(",");
            this.themeExcludes = Arrays.asList(themeExcludesArray);
        }
    }

    public List<String> getAdditionalThemeDirectories() {
        return this.additionalThemeDirectories;
    }

    public void setAdditionalThemeDirectories(List<String> additionalThemeDirectories) {
        this.additionalThemeDirectories = additionalThemeDirectories;
    }

    public void setAdditionalThemeDirectoriesStr(String additionalThemeDirectories) {
        if (StringUtils.isNotBlank((String)additionalThemeDirectories)) {
            String[] additionalThemeDirectoriesArray = additionalThemeDirectories.split(",");
            this.additionalThemeDirectories = Arrays.asList(additionalThemeDirectoriesArray);
        }
    }

    public List<String> getAdditionalPluginDirectories() {
        return this.additionalPluginDirectories;
    }

    public void setAdditionalPluginDirectories(List<String> additionalPluginDirectories) {
        this.additionalPluginDirectories = additionalPluginDirectories;
    }

    public void setAdditionalPluginDirectoriesStr(String additionalPluginDirectories) {
        if (StringUtils.isNotBlank((String)additionalPluginDirectories)) {
            String[] additionalPluginDirectoriesArray = additionalPluginDirectories.split(",");
            this.additionalPluginDirectories = Arrays.asList(additionalPluginDirectoriesArray);
        }
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public List<ThemePreProcessor> getThemePreProcessors() {
        return this.themePreProcessors;
    }

    public void setThemePreProcessors(List<ThemePreProcessor> themePreProcessors) {
        this.themePreProcessors = themePreProcessors;
    }

    public boolean isSkipThemeProcessing() {
        return this.skipThemeProcessing;
    }

    public void setSkipThemeProcessing(boolean skipThemeProcessing) {
        this.skipThemeProcessing = skipThemeProcessing;
    }
}

