/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.theme.postprocessor;

import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.theme.postprocessor.ThemeFilesProcessor;
import org.kuali.rice.krad.theme.util.ThemeBuilderUtils;

public class ThemeCssFilesProcessor
extends ThemeFilesProcessor {
    private static final Logger LOG = Logger.getLogger(ThemeCssFilesProcessor.class);
    protected int linebreak = -1;

    public ThemeCssFilesProcessor(String themeName, File themeDirectory, Properties themeProperties, Map<String, File> themePluginDirsMap, File workingDir, String projectVersion) {
        super(themeName, themeDirectory, themeProperties, themePluginDirsMap, workingDir, projectVersion);
    }

    @Override
    protected String getFileTypeExtension() {
        return ".css";
    }

    @Override
    protected String getExcludesConfigKey() {
        return "cssExcludes";
    }

    @Override
    protected String getFileTypeDirectoryName() {
        return "stylesheets";
    }

    @Override
    protected String getFileListingConfigKey() {
        return "themeCssFiles";
    }

    @Override
    protected void addAdditionalFiles(List<File> themeFiles) {
    }

    @Override
    protected List<File> sortThemeFiles(List<File> pluginFiles, List<File> subDirFiles) {
        List<String> loadCssFirst = this.getThemePropertyValue("cssLoadFirst");
        List<String> loadCssLast = this.getThemePropertyValue("cssLoadLast");
        List<String> pluginCssLoadOrder = this.getThemePropertyValue("pluginCssLoadOrder");
        List<String> cssLoadOrder = this.getThemePropertyValue("themeCssLoadOrder");
        return ThemeBuilderUtils.orderFiles(pluginFiles, subDirFiles, loadCssFirst, loadCssLast, pluginCssLoadOrder, cssLoadOrder);
    }

    @Override
    protected String processMergeFileContents(String fileContents, File fileToMerge, File mergedFile) throws IOException {
        return this.rewriteCssUrls(fileContents, fileToMerge, mergedFile);
    }

    protected String rewriteCssUrls(String css, File mergeFile, File mergedFile) throws IOException {
        String urlAdjustment = ThemeBuilderUtils.calculatePathToFile(mergedFile, mergeFile);
        if (StringUtils.isBlank((String)urlAdjustment)) {
            return css;
        }
        Pattern urlPattern = Pattern.compile("(?is)src\\b\\s*=\\s*['\"](.*?)['\"]|url\\b\\s*\\(\\s*['\"]?(.*?)['\"]?\\s*\\)");
        Matcher matcher = urlPattern.matcher(css);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String cssStatement = matcher.group();
            String cssUrl = null;
            cssUrl = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            if (cssUrl == null) continue;
            String modifiedUrl = cssUrl;
            if (!cssUrl.startsWith("/")) {
                modifiedUrl = urlAdjustment + cssUrl;
            }
            String modifiedStatement = Matcher.quoteReplacement(cssStatement.replace(cssUrl, modifiedUrl));
            matcher.appendReplacement(sb, modifiedStatement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void minify(File mergedFile, File minifiedFile) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        OutputStreamWriter writer = null;
        InputStreamReader reader = null;
        LOG.info((Object)("Populating minified CSS file: " + minifiedFile.getPath()));
        try {
            out = new FileOutputStream(minifiedFile);
            writer = new OutputStreamWriter(out);
            in = new FileInputStream(mergedFile);
            reader = new InputStreamReader(in);
            CssCompressor compressor = new CssCompressor((Reader)reader);
            compressor.compress((Writer)writer, this.linebreak);
            writer.flush();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }
}

