/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.agenda;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinitionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="agenda")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="AgendaType", propOrder={"id", "name", "typeId", "contextId", "active", "firstItemId", "attributes", "versionNumber", "_futureElements"})
public final class AgendaDefinition
extends AbstractDataTransferObject
implements AgendaDefinitionContract {
    private static final long serialVersionUID = 2783959459503209577L;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="typeId", required=false)
    private final String typeId;
    @XmlElement(name="contextId", required=true)
    private final String contextId;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="firstItemId", required=false)
    private final String firstItemId;
    @XmlElement(name="attributes", required=false)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> attributes;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private AgendaDefinition() {
        this.id = null;
        this.name = null;
        this.typeId = null;
        this.contextId = null;
        this.active = true;
        this.firstItemId = null;
        this.attributes = null;
        this.versionNumber = null;
    }

    private AgendaDefinition(Builder builder) {
        this.id = builder.getId();
        this.name = builder.getName();
        this.typeId = builder.getTypeId();
        this.contextId = builder.getContextId();
        this.active = builder.isActive();
        this.firstItemId = builder.getFirstItemId();
        this.attributes = builder.getAttributes() != null ? Collections.unmodifiableMap(new HashMap<String, String>(builder.getAttributes())) : null;
        this.versionNumber = builder.getVersionNumber();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    @Override
    public String getContextId() {
        return this.contextId;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public String getFirstItemId() {
        return this.firstItemId;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/krms/v2_0/AgendaType";
    }

    public static class Elements {
        static final String AGENDA_ID = "id";
        static final String NAME = "name";
        static final String TYPE_ID = "typeId";
        static final String CONTEXT_ID = "contextId";
        static final String ACTIVE = "active";
        static final String FIRST_ITEM_ID = "firstItemId";
        static final String ATTRIBUTES = "attributes";
        static final String ATTRIBUTE = "attribute";
    }

    public static class Constants {
        static final String ROOT_ELEMENT_NAME = "agenda";
        static final String TYPE_NAME = "AgendaType";
        static final String[] HASH_CODE_EQUALS_EXCLUDE = new String[]{"_futureElements"};
        public static final String EVENT = "Event";
    }

    public static class Builder
    implements AgendaDefinitionContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = -8862851720709537839L;
        private String id;
        private String name;
        private String typeId;
        private String contextId;
        private boolean active;
        private String firstItemId;
        private Map<String, String> attributes;
        private Long versionNumber;

        private Builder(String id, String name, String typeId, String contextId) {
            this.setId(id);
            this.setName(name);
            this.setTypeId(typeId);
            this.setContextId(contextId);
            this.setActive(true);
            this.setAttributes(new HashMap<String, String>());
        }

        public static Builder create(String id, String name, String typeId, String contextId) {
            return new Builder(id, name, typeId, contextId);
        }

        public static Builder create(AgendaDefinitionContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract is null");
            }
            Builder builder = new Builder(contract.getId(), contract.getName(), contract.getTypeId(), contract.getContextId());
            builder.setActive(contract.isActive());
            builder.setFirstItemId(contract.getFirstItemId());
            if (contract.getAttributes() != null) {
                builder.setAttributes(new HashMap<String, String>(contract.getAttributes()));
            }
            builder.setVersionNumber(contract.getVersionNumber());
            return builder;
        }

        public void setId(String agendaId) {
            if (agendaId != null && StringUtils.isBlank((String)agendaId)) {
                throw new IllegalArgumentException("agenda ID must be null or non-blank");
            }
            this.id = agendaId;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name is blank");
            }
            this.name = name;
        }

        public void setTypeId(String typeId) {
            this.typeId = typeId;
        }

        public void setContextId(String contextId) {
            if (StringUtils.isBlank((String)contextId)) {
                throw new IllegalArgumentException("context id is blank");
            }
            this.contextId = contextId;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setFirstItemId(String firstItemId) {
            this.firstItemId = firstItemId;
        }

        public void setAttributes(Map<String, String> attributes) {
            if (attributes == null) {
                this.attributes = Collections.emptyMap();
            }
            this.attributes = Collections.unmodifiableMap(attributes);
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTypeId() {
            return this.typeId;
        }

        @Override
        public String getContextId() {
            return this.contextId;
        }

        public boolean isActive() {
            return this.active;
        }

        @Override
        public String getFirstItemId() {
            return this.firstItemId;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public AgendaDefinition build() {
            return new AgendaDefinition(this);
        }
    }
}

