/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.proposition;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterContract;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterType;
import org.w3c.dom.Element;

@XmlRootElement(name="PropositionParameter")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="PropositionParameterType", propOrder={"id", "propId", "value", "parameterType", "sequenceNumber", "versionNumber", "_futureElements"})
public final class PropositionParameter
extends AbstractDataTransferObject
implements PropositionParameterContract {
    private static final long serialVersionUID = 2783959459503209577L;
    @XmlElement(name="id", required=true)
    private String id;
    @XmlElement(name="propId", required=true)
    private String propId;
    @XmlElement(name="value", required=true)
    private String value;
    @XmlElement(name="parameterType", required=true)
    private String parameterType;
    @XmlElement(name="sequenceNumber", required=true)
    private Integer sequenceNumber;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private PropositionParameter() {
        this.id = null;
        this.propId = null;
        this.value = null;
        this.parameterType = null;
        this.sequenceNumber = null;
        this.versionNumber = null;
    }

    private PropositionParameter(Builder builder) {
        this.id = builder.getId();
        this.propId = builder.getPropId();
        this.value = builder.getValue();
        this.parameterType = builder.getParameterType();
        this.sequenceNumber = builder.getSequenceNumber();
        this.versionNumber = builder.getVersionNumber();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getPropId() {
        return this.propId;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getParameterType() {
        return this.parameterType;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static class Elements {
        static final String ID = "id";
        static final String PROP_ID = "propId";
        static final String VALUE = "value";
        static final String PARM_TYPE = "parameterType";
        static final String SEQUENCE = "sequenceNumber";
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "PropositionParameter";
        static final String TYPE_NAME = "PropositionParameterType";

        Constants() {
        }
    }

    public static class Builder
    implements PropositionParameterContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = -6889320709850568900L;
        private String id;
        private String propId;
        private String value;
        private String parameterType;
        private Integer sequenceNumber;
        private Long versionNumber;
        private PropositionDefinition.Builder proposition;

        private Builder(String id, String propId, String value, String parameterType, Integer sequenceNumber) {
            this.setId(id);
            this.setPropId(propId);
            this.setValue(value);
            this.setParameterType(parameterType);
            this.setSequenceNumber(sequenceNumber);
        }

        public static Builder create(String id, String propId, String value, String parameterType, Integer sequenceNumber) {
            return new Builder(id, propId, value, parameterType, sequenceNumber);
        }

        public static Builder create(PropositionParameterContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract is null");
            }
            Builder builder = new Builder(contract.getId(), contract.getPropId(), contract.getValue(), contract.getParameterType(), contract.getSequenceNumber());
            builder.setVersionNumber(contract.getVersionNumber());
            return builder;
        }

        public void setId(String id) {
            if (id != null && StringUtils.isBlank((String)id)) {
                throw new IllegalArgumentException("id must not be null or blank");
            }
            this.id = id;
        }

        public void setPropId(String propId) {
            if (null != propId && StringUtils.isBlank((String)propId)) {
                throw new IllegalArgumentException("propId must be not be null or blank");
            }
            this.propId = propId;
        }

        public void setValue(String value) {
            if (value != null && "".equals(value.trim())) {
                throw new IllegalArgumentException("value must contain non-whitespace characters");
            }
            this.value = value;
        }

        public void setParameterType(String parameterType) {
            if (StringUtils.isBlank((String)parameterType)) {
                throw new IllegalArgumentException("parameter type is null or blank");
            }
            if (!PropositionParameterType.VALID_TYPE_CODES.contains(parameterType)) {
                throw new IllegalArgumentException("parameter type is invalid");
            }
            this.parameterType = parameterType;
        }

        public void setSequenceNumber(Integer sequenceNumber) {
            if (sequenceNumber == null) {
                throw new IllegalArgumentException("sequenceNumber type is blank");
            }
            this.sequenceNumber = sequenceNumber;
        }

        public void setProposition(PropositionDefinition.Builder proposition) {
            if (proposition != null && !StringUtils.isBlank((String)proposition.getId())) {
                this.setPropId(proposition.getId());
            }
            this.proposition = proposition;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getPropId() {
            return this.propId;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getParameterType() {
            return this.parameterType;
        }

        @Override
        public Integer getSequenceNumber() {
            return this.sequenceNumber;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public PropositionParameter build() {
            if (this.proposition == null && StringUtils.isBlank((String)this.propId)) {
                throw new IllegalStateException("either proposition must be non-null or propId must be non-blank");
            }
            return new PropositionParameter(this);
        }
    }
}

