/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinitionContract;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameter;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterContract;
import org.kuali.rice.krms.api.repository.term.TermDefinition;

public class PropositionTest
implements GroovyObject {
    private static final String PROP_ID = "2001";
    private static final String DESCRIPTION = "is Campus Bloomington";
    private static final String RULE_ID;
    private static final String TYPE_ID;
    private static final String PROPOSITION_TYPE_CD_S;
    private static final String PROPOSITION_TYPE_CD_C;
    private static final String PROPOSITION_TYPE_CD_BAD;
    private static final List<PropositionParameter.Builder> EMPTY_PARM_LIST;
    private static final List<PropositionParameter.Builder> PARM_LIST_1;
    private static final List<PropositionParameter.Builder> PARM_LIST_A;
    private static final List<PropositionParameter.Builder> PARM_LIST_B;
    private static final PropositionDefinition.Builder PROP_A_BUILDER;
    private static final PropositionDefinition.Builder PROP_B_BUILDER;
    private static final Integer SEQUENCE_NUMBER_1;
    private static final String SIMPLE_PROP_XML = "\n\t\t<proposition xmlns=\"http://rice.kuali.org/krms/v2_0\">\n\t\t\t<id>2001</id>\n\t\t\t<description>is Campus Bloomington</description>\n            <ruleId>1</ruleId>\n\t\t\t<typeId>1</typeId>\n\t\t\t<propositionTypeCode>S</propositionTypeCode>\n\t\t\t<parameters>\n\t\t\t\t<parameter>\n\t\t\t\t\t<id>1000</id>\n\t\t\t\t\t<propId>2001</propId>\n\t\t\t\t\t<value>campusCode</value>\n\t\t\t\t\t<parameterType>T</parameterType>\n\t\t\t\t\t<sequenceNumber>0</sequenceNumber>\n\t\t\t\t\t<versionNumber>1</versionNumber>\n\t\t\t\t</parameter>\n\t\t\t\t<parameter>\n\t\t\t\t\t<id>1001</id>\n\t\t\t\t\t<propId>2001</propId>\n\t\t\t\t\t<value>BL</value>\n\t\t\t\t\t<parameterType>C</parameterType>\n\t\t\t\t\t<sequenceNumber>1</sequenceNumber>\n\t\t\t\t\t<versionNumber>1</versionNumber>\n\t\t\t\t</parameter>\n\t\t\t\t<parameter>\n\t\t\t\t\t<id>1003</id>\n\t\t\t\t\t<propId>2001</propId>\n\t\t\t\t\t<value>EQUALS</value>\n\t\t\t\t\t<parameterType>F</parameterType>\n\t\t\t\t\t<sequenceNumber>2</sequenceNumber>\n\t\t\t\t\t<versionNumber>1</versionNumber>\n\t\t\t\t</parameter>\n                                <compoundSequenceNumber>1</compoundSequenceNumber>\n\t\t\t</parameters>\n\t\t\t<versionNumber>1</versionNumber>\n\t\t</proposition>\n\t\t";
    private static final String COMPOUND_PROP_XML = "\n\t\t<proposition xmlns=\"http://rice.kuali.org/krms/v2_0\">\n\t\t\t<id>111</id>\n\t\t\t<description>Compound: Campus is Muir or Thurgood Marshall</description>\n            <ruleId>1</ruleId>\n\t\t\t<typeId>1</typeId>\n\t\t\t<propositionTypeCode>C</propositionTypeCode>\n\t\t\t<parameters/>\n\t\t\t<compoundOpCode>|</compoundOpCode>\n\t\t\t<compoundComponents>\n\t\t\t\t<proposition>\n\t\t\t\t\t<id>100</id>\n\t\t\t\t\t<description>Is campus type = Muir</description>\n\t\t\t\t\t<ruleId>1</ruleId>\n\t\t\t\t\t<typeId>1</typeId>\n\t\t\t\t\t<propositionTypeCode>S</propositionTypeCode>\n\t\t\t\t\t<parameters>\n\t\t\t\t\t\t<parameter>\n\t\t\t\t\t\t\t<id>2000</id>\n\t\t\t\t\t\t\t<propId>100</propId>\n\t\t\t\t\t\t\t<value>campusCode</value>\n\t\t\t\t\t\t\t<parameterType>T</parameterType>\n\t\t\t\t\t\t\t<sequenceNumber>0</sequenceNumber>\n\t\t\t\t\t\t\t<versionNumber>1</versionNumber>\n\t\t\t\t\t\t</parameter>\n\t\t\t\t\t\t<parameter>\n\t\t\t\t\t\t\t<id>2001</id>\n\t\t\t\t\t\t\t<propId>100</propId>\n\t\t\t\t\t\t\t<value>Muir</value>\n\t\t\t\t\t\t\t<parameterType>C</parameterType>\n\t\t\t\t\t\t\t<sequenceNumber>1</sequenceNumber>\n\t\t\t\t\t\t\t<versionNumber>1</versionNumber>\n\t\t\t\t\t\t</parameter>\n\t\t\t\t\t\t<parameter>\n\t\t\t\t\t\t\t<id>2002</id>\n\t\t\t\t\t\t\t<propId>100</propId>\n\t\t\t\t\t\t\t<value>EQUALS</value>\n\t\t\t\t\t\t\t<parameterType>F</parameterType>\n\t\t\t\t\t\t\t<sequenceNumber>2</sequenceNumber>\n\t\t\t\t\t\t\t<versionNumber>1</versionNumber>\n\t\t\t\t\t\t</parameter>\n\t\t\t\t\t</parameters>\n\t\t\t\t\t<compoundSequenceNumber>1</compoundSequenceNumber>\n\t\t\t\t\t<compoundComponents/>\n\t\t\t\t\t<versionNumber>1</versionNumber>\n\t\t\t\t</proposition>\n\t\t\t\t<proposition>\n\t\t\t\t\t<id>101</id>\n\t\t\t\t\t<description>Is campus type = Thurgood Marshall</description>\n\t\t\t\t\t<ruleId>1</ruleId>\n\t\t\t\t\t<typeId>1</typeId>\n\t\t\t\t\t<propositionTypeCode>S</propositionTypeCode>\n\t\t\t\t\t<parameters>\n\t\t\t\t\t\t<parameter>\n\t\t\t\t\t\t\t<id>2010</id>\n\t\t\t\t\t\t\t<propId>101</propId>\n\t\t\t\t\t\t\t<value>campusCode</value>\n\t\t\t\t\t\t\t<parameterType>T</parameterType>\n\t\t\t\t\t\t\t<sequenceNumber>0</sequenceNumber>\n\t\t\t\t\t\t\t<versionNumber>1</versionNumber>\n\t\t\t\t\t\t</parameter>\n\t\t\t\t\t\t<parameter>\n\t\t\t\t\t\t\t<id>2011</id>\n\t\t\t\t\t\t\t<propId>101</propId>\n\t\t\t\t\t\t\t<value>Thurgood Marshall</value>\n\t\t\t\t\t\t\t<parameterType>C</parameterType>\n\t\t\t\t\t\t\t<sequenceNumber>1</sequenceNumber>\n\t\t\t\t\t\t\t<versionNumber>1</versionNumber>\n\t\t\t\t\t \t</parameter>\n\t\t\t\t\t\t<parameter>\n\t\t\t\t\t\t\t<id>2012</id>\n\t\t\t\t\t\t\t<propId>101</propId>\n\t\t\t\t\t\t\t<value>EQUALS</value>\n\t\t\t\t\t\t\t<parameterType>F</parameterType>\n\t\t\t\t\t\t\t<sequenceNumber>2</sequenceNumber>\n\t\t\t\t\t\t\t<versionNumber>1</versionNumber>\n\t\t\t\t\t\t</parameter>\n\t\t\t\t\t</parameters>\n\t\t\t\t\t<compoundSequenceNumber>1</compoundSequenceNumber>\n\t\t\t\t\t<compoundComponents/>\n\t\t\t\t\t<versionNumber>1</versionNumber>\n\t\t\t\t</proposition>\n\t\t\t</compoundComponents>\n\t\t    <versionNumber>1</versionNumber>\n\t\t</proposition>\n\t";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1467112448917;
    private static /* synthetic */ SoftReference $callSiteArray;
    private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition;
    private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest;
    private static /* synthetic */ Class $class$javax$xml$bind$Marshaller;
    private static /* synthetic */ Class $class$java$util$ArrayList;
    private static /* synthetic */ Class $class$javax$xml$bind$JAXBContext;
    private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter;
    private static /* synthetic */ Class $class$java$lang$Long;
    private static /* synthetic */ Class $class$javax$xml$bind$Unmarshaller;
    private static /* synthetic */ Class $class$java$io$StringWriter;
    private static /* synthetic */ Class $class$java$util$Iterator;
    private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder;
    private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder;
    private static /* synthetic */ Class $class$java$io$StringReader;
    private static /* synthetic */ Class $class$java$lang$String;
    private static /* synthetic */ Class $class$org$junit$Assert;
    private static /* synthetic */ Class $class$java$util$Collections;
    private static /* synthetic */ Class $class$java$lang$Integer;
    private static /* synthetic */ Class $class$java$util$List;

    public PropositionTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_all_null() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        callSiteArray[0].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), ArrayUtil.createArray(null, null, null, null, null));
    }

    public void test_Builder_create_fail_null_prop_id() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        callSiteArray[1].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), ArrayUtil.createArray(null, (Object)PROPOSITION_TYPE_CD_S, (Object)RULE_ID, (Object)TYPE_ID, PARM_LIST_1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_empty_prop_id() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        callSiteArray[2].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), ArrayUtil.createArray((Object)"", (Object)PROPOSITION_TYPE_CD_S, (Object)RULE_ID, (Object)TYPE_ID, PARM_LIST_1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_whitespace_prop_id() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        callSiteArray[3].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), ArrayUtil.createArray((Object)"    ", (Object)PROPOSITION_TYPE_CD_S, (Object)RULE_ID, (Object)TYPE_ID, PARM_LIST_1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_null_proposition_type() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        callSiteArray[4].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), ArrayUtil.createArray((Object)PROP_ID, null, (Object)RULE_ID, (Object)TYPE_ID, PARM_LIST_1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_empty_proposition_type() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        callSiteArray[5].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), ArrayUtil.createArray((Object)PROP_ID, (Object)"", (Object)RULE_ID, (Object)TYPE_ID, PARM_LIST_1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_whitespace_proposition_type() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        callSiteArray[6].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), ArrayUtil.createArray((Object)PROP_ID, (Object)"    ", (Object)RULE_ID, (Object)TYPE_ID, PARM_LIST_1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_invalid_proposition_type() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        callSiteArray[7].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), ArrayUtil.createArray((Object)PROP_ID, (Object)PROPOSITION_TYPE_CD_BAD, (Object)RULE_ID, (Object)TYPE_ID, PARM_LIST_1));
    }

    @Test
    public void test_Builder_create_null_parameter_list() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        callSiteArray[8].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), ArrayUtil.createArray((Object)PROP_ID, (Object)PROPOSITION_TYPE_CD_S, (Object)RULE_ID, (Object)TYPE_ID, null));
    }

    @Test
    public void test_Builder_create_empty_parameter_list() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        callSiteArray[9].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), ArrayUtil.createArray((Object)PROP_ID, (Object)PROPOSITION_TYPE_CD_S, (Object)RULE_ID, (Object)TYPE_ID, EMPTY_PARM_LIST));
    }

    @Test
    public void test_Builder_create_simple_proposition_success() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        callSiteArray[10].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), ArrayUtil.createArray((Object)PROP_ID, (Object)PROPOSITION_TYPE_CD_S, (Object)RULE_ID, (Object)TYPE_ID, PARM_LIST_1));
    }

    @Test
    public void test_Builder_create_and_build_simple_proposition_success() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        callSiteArray[11].call(callSiteArray[12].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), ArrayUtil.createArray((Object)PROP_ID, (Object)PROPOSITION_TYPE_CD_S, (Object)RULE_ID, (Object)TYPE_ID, PARM_LIST_1)));
    }

    @Test
    public void test_Builder_create_compound_proposition_sucess() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        callSiteArray[13].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), (Object)new PropositionDefinitionContract(this){
            private String id;
            private String description;
            private String ruleId;
            private String typeId;
            private String propositionTypeCode;
            private Integer compoundSequenceNumber;
            private List<? extends PropositionParameterContract> parameters;
            private String compoundOpCode;
            private List<? extends PropositionDefinition> compoundComponents;
            private Long versionNumber;
            public /* synthetic */ PropositionTest this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$java$util$Arrays;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest;
            private static /* synthetic */ Class $class$java$util$ArrayList;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest$1;
            private static /* synthetic */ Class $class$java$lang$String;
            private static /* synthetic */ Class $class$java$lang$Long;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$LogicalOperator;
            private static /* synthetic */ Class $class$java$lang$Integer;
            private static /* synthetic */ Class $class$java$util$List;
            {
                MetaClass metaClass;
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                PropositionTest propositionTest;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0 = propositionTest = p0;
                this.id = string5 = "111";
                this.description = string4 = "Compound: Campus is Muir or Thurgood Marshall";
                this.ruleId = string3 = "1";
                this.typeId = string2 = "1";
                this.propositionTypeCode = string = "C";
                Object object = callSiteArray[0].callConstructor((Object)1.$get$$class$java$lang$Integer(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.compoundSequenceNumber = (Integer)ScriptBytecodeAdapter.castToType((Object)object, (Class)1.$get$$class$java$lang$Integer());
                Object object2 = callSiteArray[1].callConstructor((Object)1.$get$$class$java$util$ArrayList());
                this.parameters = (List)ScriptBytecodeAdapter.castToType((Object)object2, (Class)1.$get$$class$java$util$List());
                Object object3 = callSiteArray[2].call(callSiteArray[3].callGetProperty((Object)1.$get$$class$org$kuali$rice$krms$api$repository$LogicalOperator()));
                this.compoundOpCode = (String)ScriptBytecodeAdapter.castToType((Object)object3, (Class)1.$get$$class$java$lang$String());
                Object object4 = callSiteArray[4].call((Object)1.$get$$class$java$util$Arrays(), callSiteArray[5].callGetProperty((Object)1.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()), callSiteArray[6].callGetProperty((Object)1.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()));
                this.compoundComponents = (List)ScriptBytecodeAdapter.castToType((Object)object4, (Class)1.$get$$class$java$util$List());
                Object object5 = callSiteArray[7].callConstructor((Object)1.$get$$class$java$lang$Long(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.versionNumber = (Long)ScriptBytecodeAdapter.castToType((Object)object5, (Class)1.$get$$class$java$lang$Long());
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)1.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$1(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)1.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectField((Object)object, (Class)1.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$1(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)1.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getGroovyObjectField((Class)1.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$1(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)1.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0.this$dist$set$1(name, val);
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$get$1(name);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$1()) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                1.__$swapInit();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public String getDescription() {
                return this.description;
            }

            public void setDescription(String string) {
                this.description = string;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public void setRuleId(String string) {
                this.ruleId = string;
            }

            public String getTypeId() {
                return this.typeId;
            }

            public void setTypeId(String string) {
                this.typeId = string;
            }

            public String getPropositionTypeCode() {
                return this.propositionTypeCode;
            }

            public void setPropositionTypeCode(String string) {
                this.propositionTypeCode = string;
            }

            public Integer getCompoundSequenceNumber() {
                return this.compoundSequenceNumber;
            }

            public void setCompoundSequenceNumber(Integer n) {
                this.compoundSequenceNumber = n;
            }

            public List<? extends PropositionParameterContract> getParameters() {
                return this.parameters;
            }

            public void setParameters(List<? extends PropositionParameterContract> list) {
                this.parameters = list;
            }

            public String getCompoundOpCode() {
                return this.compoundOpCode;
            }

            public void setCompoundOpCode(String string) {
                this.compoundOpCode = string;
            }

            public List<? extends PropositionDefinition> getCompoundComponents() {
                return this.compoundComponents;
            }

            public void setCompoundComponents(List<? extends PropositionDefinition> list) {
                this.compoundComponents = list;
            }

            public Long getVersionNumber() {
                return this.versionNumber;
            }

            public void setVersionNumber(Long l) {
                this.versionNumber = l;
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "<$constructor$>";
                stringArray[2] = "getCode";
                stringArray[3] = "OR";
                stringArray[4] = "asList";
                stringArray[5] = "PROP_A_BUILDER";
                stringArray[6] = "PROP_B_BUILDER";
                stringArray[7] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(1.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$1(), stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$java$util$Arrays() {
                Class clazz = $class$java$util$Arrays;
                if (clazz == null) {
                    clazz = $class$java$util$Arrays = 1.class$("java.util.Arrays");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest = 1.class$("org.kuali.rice.krms.api.repository.PropositionTest");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$util$ArrayList() {
                Class clazz = $class$java$util$ArrayList;
                if (clazz == null) {
                    clazz = $class$java$util$ArrayList = 1.class$("java.util.ArrayList");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest$1() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$1;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$1 = 1.class$("org.kuali.rice.krms.api.repository.PropositionTest$1");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$String() {
                Class clazz = $class$java$lang$String;
                if (clazz == null) {
                    clazz = $class$java$lang$String = 1.class$("java.lang.String");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Long() {
                Class clazz = $class$java$lang$Long;
                if (clazz == null) {
                    clazz = $class$java$lang$Long = 1.class$("java.lang.Long");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$LogicalOperator() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$LogicalOperator;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$LogicalOperator = 1.class$("org.kuali.rice.krms.api.repository.LogicalOperator");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Integer() {
                Class clazz = $class$java$lang$Integer;
                if (clazz == null) {
                    clazz = $class$java$lang$Integer = 1.class$("java.lang.Integer");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$util$List() {
                Class clazz = $class$java$util$List;
                if (clazz == null) {
                    clazz = $class$java$util$List = 1.class$("java.util.List");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    @Test
    public void test_Builder_create_and_build_compound_proposition_success() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        callSiteArray[14].call(callSiteArray[15].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), (Object)new PropositionDefinitionContract(this){
            private String id;
            private String description;
            private String ruleId;
            private String typeId;
            private String propositionTypeCode;
            private Integer compoundSequenceNumber;
            private List<? extends PropositionParameterContract> parameters;
            private String compoundOpCode;
            private List<? extends PropositionDefinition> compoundComponents;
            private Long versionNumber;
            public /* synthetic */ PropositionTest this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$java$util$Arrays;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest;
            private static /* synthetic */ Class $class$java$util$ArrayList;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest$2;
            private static /* synthetic */ Class $class$java$lang$String;
            private static /* synthetic */ Class $class$java$lang$Long;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$LogicalOperator;
            private static /* synthetic */ Class $class$java$lang$Integer;
            private static /* synthetic */ Class $class$java$util$List;
            {
                MetaClass metaClass;
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                PropositionTest propositionTest;
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                this.this$0 = propositionTest = p0;
                this.id = string5 = "111";
                this.description = string4 = "Compound: Campus is Muir or Thurgood Marshall";
                this.ruleId = string3 = "1";
                this.typeId = string2 = "1";
                this.propositionTypeCode = string = "C";
                Object object = callSiteArray[0].callConstructor((Object)2.$get$$class$java$lang$Integer(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.compoundSequenceNumber = (Integer)ScriptBytecodeAdapter.castToType((Object)object, (Class)2.$get$$class$java$lang$Integer());
                Object object2 = callSiteArray[1].callConstructor((Object)2.$get$$class$java$util$ArrayList());
                this.parameters = (List)ScriptBytecodeAdapter.castToType((Object)object2, (Class)2.$get$$class$java$util$List());
                Object object3 = callSiteArray[2].call(callSiteArray[3].callGetProperty((Object)2.$get$$class$org$kuali$rice$krms$api$repository$LogicalOperator()));
                this.compoundOpCode = (String)ScriptBytecodeAdapter.castToType((Object)object3, (Class)2.$get$$class$java$lang$String());
                Object object4 = callSiteArray[4].call((Object)2.$get$$class$java$util$Arrays(), callSiteArray[5].callGetProperty((Object)2.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()), callSiteArray[6].callGetProperty((Object)2.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()));
                this.compoundComponents = (List)ScriptBytecodeAdapter.castToType((Object)object4, (Class)2.$get$$class$java$util$List());
                Object object5 = callSiteArray[7].callConstructor((Object)2.$get$$class$java$lang$Long(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.versionNumber = (Long)ScriptBytecodeAdapter.castToType((Object)object5, (Class)2.$get$$class$java$lang$Long());
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)2.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$2(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)2.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectField((Object)object, (Class)2.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$2(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)2.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                return ScriptBytecodeAdapter.getGroovyObjectField((Class)2.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$2(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)2.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                this.this$0.this$dist$set$1(name, val);
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                return this.this$0.this$dist$get$1(name);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 2.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$2()) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                2.__$swapInit();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public String getDescription() {
                return this.description;
            }

            public void setDescription(String string) {
                this.description = string;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public void setRuleId(String string) {
                this.ruleId = string;
            }

            public String getTypeId() {
                return this.typeId;
            }

            public void setTypeId(String string) {
                this.typeId = string;
            }

            public String getPropositionTypeCode() {
                return this.propositionTypeCode;
            }

            public void setPropositionTypeCode(String string) {
                this.propositionTypeCode = string;
            }

            public Integer getCompoundSequenceNumber() {
                return this.compoundSequenceNumber;
            }

            public void setCompoundSequenceNumber(Integer n) {
                this.compoundSequenceNumber = n;
            }

            public List<? extends PropositionParameterContract> getParameters() {
                return this.parameters;
            }

            public void setParameters(List<? extends PropositionParameterContract> list) {
                this.parameters = list;
            }

            public String getCompoundOpCode() {
                return this.compoundOpCode;
            }

            public void setCompoundOpCode(String string) {
                this.compoundOpCode = string;
            }

            public List<? extends PropositionDefinition> getCompoundComponents() {
                return this.compoundComponents;
            }

            public void setCompoundComponents(List<? extends PropositionDefinition> list) {
                this.compoundComponents = list;
            }

            public Long getVersionNumber() {
                return this.versionNumber;
            }

            public void setVersionNumber(Long l) {
                this.versionNumber = l;
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "<$constructor$>";
                stringArray[2] = "getCode";
                stringArray[3] = "OR";
                stringArray[4] = "asList";
                stringArray[5] = "PROP_A_BUILDER";
                stringArray[6] = "PROP_B_BUILDER";
                stringArray[7] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(2.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$2(), stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$java$util$Arrays() {
                Class clazz = $class$java$util$Arrays;
                if (clazz == null) {
                    clazz = $class$java$util$Arrays = 2.class$("java.util.Arrays");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest = 2.class$("org.kuali.rice.krms.api.repository.PropositionTest");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$util$ArrayList() {
                Class clazz = $class$java$util$ArrayList;
                if (clazz == null) {
                    clazz = $class$java$util$ArrayList = 2.class$("java.util.ArrayList");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest$2() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$2;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$2 = 2.class$("org.kuali.rice.krms.api.repository.PropositionTest$2");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$String() {
                Class clazz = $class$java$lang$String;
                if (clazz == null) {
                    clazz = $class$java$lang$String = 2.class$("java.lang.String");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Long() {
                Class clazz = $class$java$lang$Long;
                if (clazz == null) {
                    clazz = $class$java$lang$Long = 2.class$("java.lang.Long");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$LogicalOperator() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$LogicalOperator;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$LogicalOperator = 2.class$("org.kuali.rice.krms.api.repository.LogicalOperator");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Integer() {
                Class clazz = $class$java$lang$Integer;
                if (clazz == null) {
                    clazz = $class$java$lang$Integer = 2.class$("java.lang.Integer");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$util$List() {
                Class clazz = $class$java$util$List;
                if (clazz == null) {
                    clazz = $class$java$util$List = 2.class$("java.util.List");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }));
    }

    @Test
    public void testXmlMarshaling_simple_proposition() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        PropositionDefinition.Builder myPropBuilder = (PropositionDefinition.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), ArrayUtil.createArray((Object)PROP_ID, (Object)PROPOSITION_TYPE_CD_S, (Object)RULE_ID, (Object)TYPE_ID, PARM_LIST_1)), (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder());
        callSiteArray[17].call((Object)myPropBuilder, (Object)DESCRIPTION);
        callSiteArray[18].call((Object)myPropBuilder, callSiteArray[19].callConstructor((Object)PropositionTest.$get$$class$java$lang$Long(), (Object)((Integer)DefaultTypeTransformation.box((int)1))));
        PropositionDefinition myProp = (PropositionDefinition)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].call((Object)myPropBuilder), (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition());
        JAXBContext jc = (JAXBContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].call((Object)PropositionTest.$get$$class$javax$xml$bind$JAXBContext(), (Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition(), (Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter()), (Class)PropositionTest.$get$$class$javax$xml$bind$JAXBContext());
        Marshaller marshaller = (Marshaller)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].call((Object)jc), (Class)PropositionTest.$get$$class$javax$xml$bind$Marshaller());
        callSiteArray[23].call((Object)marshaller, callSiteArray[24].callGetProperty((Object)PropositionTest.$get$$class$javax$xml$bind$Marshaller()), (Object)((Boolean)DefaultTypeTransformation.box((boolean)true)));
        StringWriter sw = (StringWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].callConstructor((Object)PropositionTest.$get$$class$java$io$StringWriter()), (Class)PropositionTest.$get$$class$java$io$StringWriter());
        callSiteArray[26].call((Object)marshaller, (Object)myProp, (Object)sw);
        String xml = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].call((Object)sw), (Class)PropositionTest.$get$$class$java$lang$String());
        Unmarshaller unmarshaller = (Unmarshaller)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].call((Object)jc), (Class)PropositionTest.$get$$class$javax$xml$bind$Unmarshaller());
        Object actual = callSiteArray[29].call((Object)unmarshaller, callSiteArray[30].callConstructor((Object)PropositionTest.$get$$class$java$io$StringReader(), (Object)xml));
        Object expected = callSiteArray[31].call((Object)unmarshaller, callSiteArray[32].callConstructor((Object)PropositionTest.$get$$class$java$io$StringReader(), (Object)SIMPLE_PROP_XML));
        callSiteArray[33].call((Object)PropositionTest.$get$$class$org$junit$Assert(), expected, actual);
    }

    @Test
    public void testXmlUnmarshal_simple_proposition() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        JAXBContext jc = (JAXBContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].call((Object)PropositionTest.$get$$class$javax$xml$bind$JAXBContext(), (Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition(), (Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter()), (Class)PropositionTest.$get$$class$javax$xml$bind$JAXBContext());
        Unmarshaller unmarshaller = (Unmarshaller)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].call((Object)jc), (Class)PropositionTest.$get$$class$javax$xml$bind$Unmarshaller());
        PropositionDefinition myProp = (PropositionDefinition)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].call((Object)unmarshaller, callSiteArray[37].callConstructor((Object)PropositionTest.$get$$class$java$io$StringReader(), (Object)SIMPLE_PROP_XML)), (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition());
        callSiteArray[38].call((Object)PropositionTest.$get$$class$org$junit$Assert(), (Object)PROP_ID, callSiteArray[39].callGetProperty((Object)myProp));
        callSiteArray[40].call((Object)PropositionTest.$get$$class$org$junit$Assert(), (Object)DESCRIPTION, callSiteArray[41].callGetProperty((Object)myProp));
        callSiteArray[42].call((Object)PropositionTest.$get$$class$org$junit$Assert(), (Object)TYPE_ID, callSiteArray[43].callGetProperty((Object)myProp));
        callSiteArray[44].call((Object)PropositionTest.$get$$class$org$junit$Assert(), (Object)PROPOSITION_TYPE_CD_S, callSiteArray[45].callGetProperty((Object)myProp));
        List pList = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].callConstructor((Object)PropositionTest.$get$$class$java$util$ArrayList()), (Class)PropositionTest.$get$$class$java$util$List());
        Object pb = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].call(PARM_LIST_1), (Class)PropositionTest.$get$$class$java$util$Iterator());
        while (iterator.hasNext()) {
            pb = iterator.next();
            callSiteArray[48].call((Object)pList, callSiteArray[49].call(pb));
        }
        callSiteArray[50].call((Object)PropositionTest.$get$$class$org$junit$Assert(), (Object)pList, callSiteArray[51].callGetProperty((Object)myProp));
    }

    @Test
    public void testXmlMarshaling_compound_proposition() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        PropositionDefinition myProp = (PropositionDefinition)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].call(callSiteArray[53].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), (Object)new PropositionDefinitionContract(this){
            private String id;
            private String description;
            private String ruleId;
            private String typeId;
            private String propositionTypeCode;
            private Integer compoundSequenceNumber;
            private List<? extends PropositionParameterContract> parameters;
            private String compoundOpCode;
            private List<? extends PropositionDefinition> compoundComponents;
            private Long versionNumber;
            public /* synthetic */ PropositionTest this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$java$util$Arrays;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest;
            private static /* synthetic */ Class $class$java$util$ArrayList;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest$3;
            private static /* synthetic */ Class $class$java$lang$String;
            private static /* synthetic */ Class $class$java$lang$Long;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$LogicalOperator;
            private static /* synthetic */ Class $class$java$lang$Integer;
            private static /* synthetic */ Class $class$java$util$List;
            {
                MetaClass metaClass;
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                PropositionTest propositionTest;
                CallSite[] callSiteArray = 3.$getCallSiteArray();
                this.this$0 = propositionTest = p0;
                this.id = string5 = "111";
                this.description = string4 = "Compound: Campus is Muir or Thurgood Marshall";
                this.ruleId = string3 = "1";
                this.typeId = string2 = "1";
                this.propositionTypeCode = string = "C";
                Object var9_9 = null;
                this.compoundSequenceNumber = (Integer)ScriptBytecodeAdapter.castToType(var9_9, (Class)3.$get$$class$java$lang$Integer());
                Object object = callSiteArray[0].callConstructor((Object)3.$get$$class$java$util$ArrayList());
                this.parameters = (List)ScriptBytecodeAdapter.castToType((Object)object, (Class)3.$get$$class$java$util$List());
                Object object2 = callSiteArray[1].call(callSiteArray[2].callGetProperty((Object)3.$get$$class$org$kuali$rice$krms$api$repository$LogicalOperator()));
                this.compoundOpCode = (String)ScriptBytecodeAdapter.castToType((Object)object2, (Class)3.$get$$class$java$lang$String());
                Object object3 = callSiteArray[3].call((Object)3.$get$$class$java$util$Arrays(), callSiteArray[4].callGetProperty((Object)3.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()), callSiteArray[5].callGetProperty((Object)3.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()));
                this.compoundComponents = (List)ScriptBytecodeAdapter.castToType((Object)object3, (Class)3.$get$$class$java$util$List());
                Object object4 = callSiteArray[6].callConstructor((Object)3.$get$$class$java$lang$Long(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.versionNumber = (Long)ScriptBytecodeAdapter.castToType((Object)object4, (Class)3.$get$$class$java$lang$Long());
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                CallSite[] callSiteArray = 3.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)3.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$3(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)3.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                CallSite[] callSiteArray = 3.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectField((Object)object, (Class)3.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$3(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)3.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                CallSite[] callSiteArray = 3.$getCallSiteArray();
                return ScriptBytecodeAdapter.getGroovyObjectField((Class)3.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$3(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)3.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 3.$getCallSiteArray();
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 3.$getCallSiteArray();
                this.this$0.this$dist$set$1(name, val);
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 3.$getCallSiteArray();
                return this.this$0.this$dist$get$1(name);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 3.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$3()) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = 3.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                3.__$swapInit();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public String getDescription() {
                return this.description;
            }

            public void setDescription(String string) {
                this.description = string;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public void setRuleId(String string) {
                this.ruleId = string;
            }

            public String getTypeId() {
                return this.typeId;
            }

            public void setTypeId(String string) {
                this.typeId = string;
            }

            public String getPropositionTypeCode() {
                return this.propositionTypeCode;
            }

            public void setPropositionTypeCode(String string) {
                this.propositionTypeCode = string;
            }

            public Integer getCompoundSequenceNumber() {
                return this.compoundSequenceNumber;
            }

            public void setCompoundSequenceNumber(Integer n) {
                this.compoundSequenceNumber = n;
            }

            public List<? extends PropositionParameterContract> getParameters() {
                return this.parameters;
            }

            public void setParameters(List<? extends PropositionParameterContract> list) {
                this.parameters = list;
            }

            public String getCompoundOpCode() {
                return this.compoundOpCode;
            }

            public void setCompoundOpCode(String string) {
                this.compoundOpCode = string;
            }

            public List<? extends PropositionDefinition> getCompoundComponents() {
                return this.compoundComponents;
            }

            public void setCompoundComponents(List<? extends PropositionDefinition> list) {
                this.compoundComponents = list;
            }

            public Long getVersionNumber() {
                return this.versionNumber;
            }

            public void setVersionNumber(Long l) {
                this.versionNumber = l;
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "getCode";
                stringArray[2] = "OR";
                stringArray[3] = "asList";
                stringArray[4] = "PROP_A_BUILDER";
                stringArray[5] = "PROP_B_BUILDER";
                stringArray[6] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(3.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$3(), stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$java$util$Arrays() {
                Class clazz = $class$java$util$Arrays;
                if (clazz == null) {
                    clazz = $class$java$util$Arrays = 3.class$("java.util.Arrays");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest = 3.class$("org.kuali.rice.krms.api.repository.PropositionTest");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$util$ArrayList() {
                Class clazz = $class$java$util$ArrayList;
                if (clazz == null) {
                    clazz = $class$java$util$ArrayList = 3.class$("java.util.ArrayList");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest$3() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$3;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$3 = 3.class$("org.kuali.rice.krms.api.repository.PropositionTest$3");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$String() {
                Class clazz = $class$java$lang$String;
                if (clazz == null) {
                    clazz = $class$java$lang$String = 3.class$("java.lang.String");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Long() {
                Class clazz = $class$java$lang$Long;
                if (clazz == null) {
                    clazz = $class$java$lang$Long = 3.class$("java.lang.Long");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$LogicalOperator() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$LogicalOperator;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$LogicalOperator = 3.class$("org.kuali.rice.krms.api.repository.LogicalOperator");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Integer() {
                Class clazz = $class$java$lang$Integer;
                if (clazz == null) {
                    clazz = $class$java$lang$Integer = 3.class$("java.lang.Integer");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$util$List() {
                Class clazz = $class$java$util$List;
                if (clazz == null) {
                    clazz = $class$java$util$List = 3.class$("java.util.List");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        })), (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition());
        JAXBContext jc = (JAXBContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].call((Object)PropositionTest.$get$$class$javax$xml$bind$JAXBContext(), (Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition(), (Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter()), (Class)PropositionTest.$get$$class$javax$xml$bind$JAXBContext());
        Marshaller marshaller = (Marshaller)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].call((Object)jc), (Class)PropositionTest.$get$$class$javax$xml$bind$Marshaller());
        StringWriter sw = (StringWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].callConstructor((Object)PropositionTest.$get$$class$java$io$StringWriter()), (Class)PropositionTest.$get$$class$java$io$StringWriter());
        callSiteArray[57].call((Object)marshaller, callSiteArray[58].callGetProperty((Object)PropositionTest.$get$$class$javax$xml$bind$Marshaller()), (Object)((Boolean)DefaultTypeTransformation.box((boolean)true)));
        callSiteArray[59].call((Object)marshaller, (Object)myProp, (Object)sw);
        String xml = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].call((Object)sw), (Class)PropositionTest.$get$$class$java$lang$String());
        callSiteArray[61].callCurrent((GroovyObject)this, (Object)xml);
        Unmarshaller unmarshaller = (Unmarshaller)ScriptBytecodeAdapter.castToType((Object)callSiteArray[62].call((Object)jc), (Class)PropositionTest.$get$$class$javax$xml$bind$Unmarshaller());
        Object actual = callSiteArray[63].call((Object)unmarshaller, callSiteArray[64].callConstructor((Object)PropositionTest.$get$$class$java$io$StringReader(), (Object)xml));
        Object expected = callSiteArray[65].call((Object)unmarshaller, callSiteArray[66].callConstructor((Object)PropositionTest.$get$$class$java$io$StringReader(), (Object)COMPOUND_PROP_XML));
        callSiteArray[67].call((Object)PropositionTest.$get$$class$org$junit$Assert(), expected, actual);
    }

    @Test
    public void testXmlUnmarshal_compound_proposition() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        JAXBContext jc = (JAXBContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[68].call((Object)PropositionTest.$get$$class$javax$xml$bind$JAXBContext(), (Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition(), (Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter()), (Class)PropositionTest.$get$$class$javax$xml$bind$JAXBContext());
        Unmarshaller unmarshaller = (Unmarshaller)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].call((Object)jc), (Class)PropositionTest.$get$$class$javax$xml$bind$Unmarshaller());
        PropositionDefinition myProp = (PropositionDefinition)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].call((Object)unmarshaller, callSiteArray[71].callConstructor((Object)PropositionTest.$get$$class$java$io$StringReader(), (Object)COMPOUND_PROP_XML)), (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition());
        callSiteArray[72].call((Object)PropositionTest.$get$$class$org$junit$Assert(), (Object)"111", callSiteArray[73].callGetProperty((Object)myProp));
        callSiteArray[74].call((Object)PropositionTest.$get$$class$org$junit$Assert(), (Object)"Compound: Campus is Muir or Thurgood Marshall", callSiteArray[75].callGetProperty((Object)myProp));
        callSiteArray[76].call((Object)PropositionTest.$get$$class$org$junit$Assert(), (Object)"1", callSiteArray[77].callGetProperty((Object)myProp));
        callSiteArray[78].call((Object)PropositionTest.$get$$class$org$junit$Assert(), (Object)PROPOSITION_TYPE_CD_C, callSiteArray[79].callGetProperty((Object)myProp));
        callSiteArray[80].call((Object)PropositionTest.$get$$class$org$junit$Assert(), (Object)"|", callSiteArray[81].callGetProperty((Object)myProp));
        callSiteArray[82].call((Object)PropositionTest.$get$$class$org$junit$Assert(), (Object)((Integer)DefaultTypeTransformation.box((int)2)), callSiteArray[83].call(callSiteArray[84].callGetProperty((Object)myProp)));
        List pList = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[85].callConstructor((Object)PropositionTest.$get$$class$java$util$ArrayList()), (Class)PropositionTest.$get$$class$java$util$List());
        Object pb = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[86].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{PROP_A_BUILDER, PROP_B_BUILDER})), (Class)PropositionTest.$get$$class$java$util$Iterator());
        while (iterator.hasNext()) {
            pb = iterator.next();
            callSiteArray[87].call((Object)pList, callSiteArray[88].call(pb));
        }
        callSiteArray[89].call((Object)PropositionTest.$get$$class$org$junit$Assert(), callSiteArray[90].callGetProperty(callSiteArray[91].call((Object)pList, (Object)((Integer)DefaultTypeTransformation.box((int)0)))), callSiteArray[92].callGetProperty(callSiteArray[93].call(callSiteArray[94].callGetProperty((Object)myProp), (Object)((Integer)DefaultTypeTransformation.box((int)0)))));
        callSiteArray[95].call((Object)PropositionTest.$get$$class$org$junit$Assert(), callSiteArray[96].callGetProperty(callSiteArray[97].call((Object)pList, (Object)((Integer)DefaultTypeTransformation.box((int)0)))), callSiteArray[98].callGetProperty(callSiteArray[99].call(callSiteArray[100].callGetProperty((Object)myProp), (Object)((Integer)DefaultTypeTransformation.box((int)0)))));
        callSiteArray[101].call((Object)PropositionTest.$get$$class$org$junit$Assert(), callSiteArray[102].callGetProperty(callSiteArray[103].call((Object)pList, (Object)((Integer)DefaultTypeTransformation.box((int)0)))), callSiteArray[104].callGetProperty(callSiteArray[105].call(callSiteArray[106].callGetProperty((Object)myProp), (Object)((Integer)DefaultTypeTransformation.box((int)0)))));
        callSiteArray[107].call((Object)PropositionTest.$get$$class$org$junit$Assert(), callSiteArray[108].callGetProperty(callSiteArray[109].call((Object)pList, (Object)((Integer)DefaultTypeTransformation.box((int)0)))), callSiteArray[110].callGetProperty(callSiteArray[111].call(callSiteArray[112].callGetProperty((Object)myProp), (Object)((Integer)DefaultTypeTransformation.box((int)0)))));
        callSiteArray[113].call((Object)PropositionTest.$get$$class$org$junit$Assert(), callSiteArray[114].callGetProperty(callSiteArray[115].call((Object)pList, (Object)((Integer)DefaultTypeTransformation.box((int)1)))), callSiteArray[116].callGetProperty(callSiteArray[117].call(callSiteArray[118].callGetProperty((Object)myProp), (Object)((Integer)DefaultTypeTransformation.box((int)1)))));
        callSiteArray[119].call((Object)PropositionTest.$get$$class$org$junit$Assert(), callSiteArray[120].callGetProperty(callSiteArray[121].call((Object)pList, (Object)((Integer)DefaultTypeTransformation.box((int)1)))), callSiteArray[122].callGetProperty(callSiteArray[123].call(callSiteArray[124].callGetProperty((Object)myProp), (Object)((Integer)DefaultTypeTransformation.box((int)1)))));
        callSiteArray[125].call((Object)PropositionTest.$get$$class$org$junit$Assert(), callSiteArray[126].callGetProperty(callSiteArray[127].call((Object)pList, (Object)((Integer)DefaultTypeTransformation.box((int)1)))), callSiteArray[128].callGetProperty(callSiteArray[129].call(callSiteArray[130].callGetProperty((Object)myProp), (Object)((Integer)DefaultTypeTransformation.box((int)1)))));
        callSiteArray[131].call((Object)PropositionTest.$get$$class$org$junit$Assert(), callSiteArray[132].callGetProperty(callSiteArray[133].call((Object)pList, (Object)((Integer)DefaultTypeTransformation.box((int)1)))), callSiteArray[134].callGetProperty(callSiteArray[135].call(callSiteArray[136].callGetProperty((Object)myProp), (Object)((Integer)DefaultTypeTransformation.box((int)1)))));
        callSiteArray[137].call((Object)PropositionTest.$get$$class$org$junit$Assert(), callSiteArray[138].callGetProperty(callSiteArray[139].call((Object)pList, (Object)((Integer)DefaultTypeTransformation.box((int)0)))), callSiteArray[140].callGetProperty(callSiteArray[141].call(callSiteArray[142].callGetProperty((Object)myProp), (Object)((Integer)DefaultTypeTransformation.box((int)0)))));
        callSiteArray[143].call((Object)PropositionTest.$get$$class$org$junit$Assert(), callSiteArray[144].callGetProperty(callSiteArray[145].call((Object)pList, (Object)((Integer)DefaultTypeTransformation.box((int)1)))), callSiteArray[146].callGetProperty(callSiteArray[147].call(callSiteArray[148].callGetProperty((Object)myProp), (Object)((Integer)DefaultTypeTransformation.box((int)1)))));
        callSiteArray[149].call((Object)PropositionTest.$get$$class$org$junit$Assert(), callSiteArray[150].callGetProperty(callSiteArray[151].call((Object)pList, (Object)((Integer)DefaultTypeTransformation.box((int)0)))), callSiteArray[152].callGetProperty(callSiteArray[153].call(callSiteArray[154].callGetProperty((Object)myProp), (Object)((Integer)DefaultTypeTransformation.box((int)0)))));
        callSiteArray[155].call((Object)PropositionTest.$get$$class$org$junit$Assert(), callSiteArray[156].callGetProperty(callSiteArray[157].call((Object)pList, (Object)((Integer)DefaultTypeTransformation.box((int)1)))), callSiteArray[158].callGetProperty(callSiteArray[159].call(callSiteArray[160].callGetProperty((Object)myProp), (Object)((Integer)DefaultTypeTransformation.box((int)1)))));
    }

    private static Object createPropositionParametersSet1() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        List propParms = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[161].callConstructor((Object)PropositionTest.$get$$class$java$util$ArrayList()), (Class)PropositionTest.$get$$class$java$util$List());
        PropositionParameter.Builder ppBuilder1 = (PropositionParameter.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[162].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder(), (Object)new PropositionParameterContract(PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()){
            private String id;
            private String propId;
            private String value;
            private String parameterType;
            private Integer sequenceNumber;
            private Long versionNumber;
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest$4;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
            private static /* synthetic */ Class $class$java$lang$Long;
            private static /* synthetic */ Class $class$java$lang$String;
            private static /* synthetic */ Class $class$java$lang$Integer;
            {
                MetaClass metaClass;
                String string;
                String string2;
                String string3;
                String string4;
                Class clazz;
                CallSite[] callSiteArray = 4.$getCallSiteArray();
                this.this$0 = clazz = p0;
                this.id = string4 = "1000";
                this.propId = string3 = PropositionTest.PROP_ID;
                this.value = string2 = "campusCode";
                this.parameterType = string = "T";
                Object object = callSiteArray[0].callConstructor((Object)4.$get$$class$java$lang$Integer(), (Object)((Integer)DefaultTypeTransformation.box((int)0)));
                this.sequenceNumber = (Integer)ScriptBytecodeAdapter.castToType((Object)object, (Class)4.$get$$class$java$lang$Integer());
                Object object2 = callSiteArray[1].callConstructor((Object)4.$get$$class$java$lang$Long(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.versionNumber = (Long)ScriptBytecodeAdapter.castToType((Object)object2, (Class)4.$get$$class$java$lang$Long());
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public TermDefinition getTermValue() {
                CallSite[] callSiteArray = 4.$getCallSiteArray();
                return (TermDefinition)ScriptBytecodeAdapter.castToType(null, (Class)4.$get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition());
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                CallSite[] callSiteArray = 4.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)4.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$4(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)4.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                CallSite[] callSiteArray = 4.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectField((Object)object, (Class)4.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$4(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)4.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                CallSite[] callSiteArray = 4.$getCallSiteArray();
                return ScriptBytecodeAdapter.getGroovyObjectField((Class)4.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$4(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)4.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 4.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN((Class)4.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$4(), (Object)4.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)4.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 4.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setField((Object)object, (Class)4.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$4(), (Object)4.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)4.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 4.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField((Class)4.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$4(), (Object)4.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)4.$get$$class$java$lang$String())));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 4.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$4()) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = 4.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                4.__$swapInit();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public String getPropId() {
                return this.propId;
            }

            public void setPropId(String string) {
                this.propId = string;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String string) {
                this.value = string;
            }

            public String getParameterType() {
                return this.parameterType;
            }

            public void setParameterType(String string) {
                this.parameterType = string;
            }

            public Integer getSequenceNumber() {
                return this.sequenceNumber;
            }

            public void setSequenceNumber(Integer n) {
                this.sequenceNumber = n;
            }

            public Long getVersionNumber() {
                return this.versionNumber;
            }

            public void setVersionNumber(Long l) {
                this.versionNumber = l;
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(4.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$4(), stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest$4() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$4;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$4 = 4.class$("org.kuali.rice.krms.api.repository.PropositionTest$4");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest = 4.class$("org.kuali.rice.krms.api.repository.PropositionTest");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition = 4.class$("org.kuali.rice.krms.api.repository.term.TermDefinition");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Long() {
                Class clazz = $class$java$lang$Long;
                if (clazz == null) {
                    clazz = $class$java$lang$Long = 4.class$("java.lang.Long");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$String() {
                Class clazz = $class$java$lang$String;
                if (clazz == null) {
                    clazz = $class$java$lang$String = 4.class$("java.lang.String");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Integer() {
                Class clazz = $class$java$lang$Integer;
                if (clazz == null) {
                    clazz = $class$java$lang$Integer = 4.class$("java.lang.Integer");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder());
        PropositionParameter.Builder ppBuilder2 = (PropositionParameter.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[163].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder(), (Object)new PropositionParameterContract(PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()){
            private String id;
            private String propId;
            private String value;
            private String parameterType;
            private Integer sequenceNumber;
            private Long versionNumber;
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest$5;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
            private static /* synthetic */ Class $class$java$lang$Long;
            private static /* synthetic */ Class $class$java$lang$String;
            private static /* synthetic */ Class $class$java$lang$Integer;
            {
                MetaClass metaClass;
                String string;
                String string2;
                String string3;
                String string4;
                Class clazz;
                CallSite[] callSiteArray = 5.$getCallSiteArray();
                this.this$0 = clazz = p0;
                this.id = string4 = "1001";
                this.propId = string3 = PropositionTest.PROP_ID;
                this.value = string2 = "BL";
                this.parameterType = string = "C";
                Object object = callSiteArray[0].callConstructor((Object)5.$get$$class$java$lang$Integer(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.sequenceNumber = (Integer)ScriptBytecodeAdapter.castToType((Object)object, (Class)5.$get$$class$java$lang$Integer());
                Object object2 = callSiteArray[1].callConstructor((Object)5.$get$$class$java$lang$Long(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.versionNumber = (Long)ScriptBytecodeAdapter.castToType((Object)object2, (Class)5.$get$$class$java$lang$Long());
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public TermDefinition getTermValue() {
                CallSite[] callSiteArray = 5.$getCallSiteArray();
                return (TermDefinition)ScriptBytecodeAdapter.castToType(null, (Class)5.$get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition());
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                CallSite[] callSiteArray = 5.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)5.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$5(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)5.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                CallSite[] callSiteArray = 5.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectField((Object)object, (Class)5.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$5(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)5.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                CallSite[] callSiteArray = 5.$getCallSiteArray();
                return ScriptBytecodeAdapter.getGroovyObjectField((Class)5.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$5(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)5.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 5.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN((Class)5.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$5(), (Object)5.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)5.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 5.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setField((Object)object, (Class)5.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$5(), (Object)5.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)5.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 5.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField((Class)5.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$5(), (Object)5.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)5.$get$$class$java$lang$String())));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 5.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$5()) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = 5.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                5.__$swapInit();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public String getPropId() {
                return this.propId;
            }

            public void setPropId(String string) {
                this.propId = string;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String string) {
                this.value = string;
            }

            public String getParameterType() {
                return this.parameterType;
            }

            public void setParameterType(String string) {
                this.parameterType = string;
            }

            public Integer getSequenceNumber() {
                return this.sequenceNumber;
            }

            public void setSequenceNumber(Integer n) {
                this.sequenceNumber = n;
            }

            public Long getVersionNumber() {
                return this.versionNumber;
            }

            public void setVersionNumber(Long l) {
                this.versionNumber = l;
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(5.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$5(), stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest$5() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$5;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$5 = 5.class$("org.kuali.rice.krms.api.repository.PropositionTest$5");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest = 5.class$("org.kuali.rice.krms.api.repository.PropositionTest");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition = 5.class$("org.kuali.rice.krms.api.repository.term.TermDefinition");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Long() {
                Class clazz = $class$java$lang$Long;
                if (clazz == null) {
                    clazz = $class$java$lang$Long = 5.class$("java.lang.Long");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$String() {
                Class clazz = $class$java$lang$String;
                if (clazz == null) {
                    clazz = $class$java$lang$String = 5.class$("java.lang.String");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Integer() {
                Class clazz = $class$java$lang$Integer;
                if (clazz == null) {
                    clazz = $class$java$lang$Integer = 5.class$("java.lang.Integer");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder());
        PropositionParameter.Builder ppBuilder3 = (PropositionParameter.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[164].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder(), (Object)new PropositionParameterContract(PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()){
            private String id;
            private String propId;
            private String value;
            private String parameterType;
            private Integer sequenceNumber;
            private Long versionNumber;
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest$6;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
            private static /* synthetic */ Class $class$java$lang$Long;
            private static /* synthetic */ Class $class$java$lang$String;
            private static /* synthetic */ Class $class$java$lang$Integer;
            {
                MetaClass metaClass;
                String string;
                String string2;
                String string3;
                String string4;
                Class clazz;
                CallSite[] callSiteArray = 6.$getCallSiteArray();
                this.this$0 = clazz = p0;
                this.id = string4 = "1003";
                this.propId = string3 = PropositionTest.PROP_ID;
                this.value = string2 = "EQUALS";
                this.parameterType = string = "F";
                Object object = callSiteArray[0].callConstructor((Object)6.$get$$class$java$lang$Integer(), (Object)((Integer)DefaultTypeTransformation.box((int)2)));
                this.sequenceNumber = (Integer)ScriptBytecodeAdapter.castToType((Object)object, (Class)6.$get$$class$java$lang$Integer());
                Object object2 = callSiteArray[1].callConstructor((Object)6.$get$$class$java$lang$Long(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.versionNumber = (Long)ScriptBytecodeAdapter.castToType((Object)object2, (Class)6.$get$$class$java$lang$Long());
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public TermDefinition getTermValue() {
                CallSite[] callSiteArray = 6.$getCallSiteArray();
                return (TermDefinition)ScriptBytecodeAdapter.castToType(null, (Class)6.$get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition());
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                CallSite[] callSiteArray = 6.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)6.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$6(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)6.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                CallSite[] callSiteArray = 6.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectField((Object)object, (Class)6.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$6(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)6.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                CallSite[] callSiteArray = 6.$getCallSiteArray();
                return ScriptBytecodeAdapter.getGroovyObjectField((Class)6.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$6(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)6.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 6.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN((Class)6.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$6(), (Object)6.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)6.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 6.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setField((Object)object, (Class)6.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$6(), (Object)6.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)6.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 6.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField((Class)6.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$6(), (Object)6.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)6.$get$$class$java$lang$String())));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 6.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$6()) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = 6.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                6.__$swapInit();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public String getPropId() {
                return this.propId;
            }

            public void setPropId(String string) {
                this.propId = string;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String string) {
                this.value = string;
            }

            public String getParameterType() {
                return this.parameterType;
            }

            public void setParameterType(String string) {
                this.parameterType = string;
            }

            public Integer getSequenceNumber() {
                return this.sequenceNumber;
            }

            public void setSequenceNumber(Integer n) {
                this.sequenceNumber = n;
            }

            public Long getVersionNumber() {
                return this.versionNumber;
            }

            public void setVersionNumber(Long l) {
                this.versionNumber = l;
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(6.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$6(), stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest$6() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$6;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$6 = 6.class$("org.kuali.rice.krms.api.repository.PropositionTest$6");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest = 6.class$("org.kuali.rice.krms.api.repository.PropositionTest");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition = 6.class$("org.kuali.rice.krms.api.repository.term.TermDefinition");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Long() {
                Class clazz = $class$java$lang$Long;
                if (clazz == null) {
                    clazz = $class$java$lang$Long = 6.class$("java.lang.Long");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$String() {
                Class clazz = $class$java$lang$String;
                if (clazz == null) {
                    clazz = $class$java$lang$String = 6.class$("java.lang.String");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Integer() {
                Class clazz = $class$java$lang$Integer;
                if (clazz == null) {
                    clazz = $class$java$lang$Integer = 6.class$("java.lang.Integer");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder());
        Object ppb = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[165].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{ppBuilder1, ppBuilder2, ppBuilder3})), (Class)PropositionTest.$get$$class$java$util$Iterator());
        while (iterator.hasNext()) {
            ppb = iterator.next();
            callSiteArray[166].call((Object)propParms, ppb);
        }
        return propParms;
    }

    private static Object createPropositionParametersSet2() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        List propParms = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[167].callConstructor((Object)PropositionTest.$get$$class$java$util$ArrayList()), (Class)PropositionTest.$get$$class$java$util$List());
        PropositionParameter.Builder ppBuilder1 = (PropositionParameter.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[168].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder(), (Object)new PropositionParameterContract(PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()){
            private String id;
            private String propId;
            private String value;
            private String parameterType;
            private Integer sequenceNumber;
            private Long versionNumber;
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest$7;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
            private static /* synthetic */ Class $class$java$lang$Long;
            private static /* synthetic */ Class $class$java$lang$String;
            private static /* synthetic */ Class $class$java$lang$Integer;
            {
                MetaClass metaClass;
                String string;
                String string2;
                String string3;
                String string4;
                Class clazz;
                CallSite[] callSiteArray = 7.$getCallSiteArray();
                this.this$0 = clazz = p0;
                this.id = string4 = "2000";
                this.propId = string3 = "100";
                this.value = string2 = "campusCode";
                this.parameterType = string = "T";
                Object object = callSiteArray[0].callConstructor((Object)7.$get$$class$java$lang$Integer(), (Object)((Integer)DefaultTypeTransformation.box((int)0)));
                this.sequenceNumber = (Integer)ScriptBytecodeAdapter.castToType((Object)object, (Class)7.$get$$class$java$lang$Integer());
                Object object2 = callSiteArray[1].callConstructor((Object)7.$get$$class$java$lang$Long(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.versionNumber = (Long)ScriptBytecodeAdapter.castToType((Object)object2, (Class)7.$get$$class$java$lang$Long());
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public TermDefinition getTermValue() {
                CallSite[] callSiteArray = 7.$getCallSiteArray();
                return (TermDefinition)ScriptBytecodeAdapter.castToType(null, (Class)7.$get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition());
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                CallSite[] callSiteArray = 7.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)7.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$7(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)7.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                CallSite[] callSiteArray = 7.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectField((Object)object, (Class)7.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$7(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)7.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                CallSite[] callSiteArray = 7.$getCallSiteArray();
                return ScriptBytecodeAdapter.getGroovyObjectField((Class)7.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$7(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)7.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 7.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN((Class)7.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$7(), (Object)7.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)7.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 7.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setField((Object)object, (Class)7.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$7(), (Object)7.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)7.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 7.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField((Class)7.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$7(), (Object)7.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)7.$get$$class$java$lang$String())));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 7.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$7()) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = 7.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                7.__$swapInit();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public String getPropId() {
                return this.propId;
            }

            public void setPropId(String string) {
                this.propId = string;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String string) {
                this.value = string;
            }

            public String getParameterType() {
                return this.parameterType;
            }

            public void setParameterType(String string) {
                this.parameterType = string;
            }

            public Integer getSequenceNumber() {
                return this.sequenceNumber;
            }

            public void setSequenceNumber(Integer n) {
                this.sequenceNumber = n;
            }

            public Long getVersionNumber() {
                return this.versionNumber;
            }

            public void setVersionNumber(Long l) {
                this.versionNumber = l;
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(7.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$7(), stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest$7() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$7;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$7 = 7.class$("org.kuali.rice.krms.api.repository.PropositionTest$7");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest = 7.class$("org.kuali.rice.krms.api.repository.PropositionTest");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition = 7.class$("org.kuali.rice.krms.api.repository.term.TermDefinition");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Long() {
                Class clazz = $class$java$lang$Long;
                if (clazz == null) {
                    clazz = $class$java$lang$Long = 7.class$("java.lang.Long");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$String() {
                Class clazz = $class$java$lang$String;
                if (clazz == null) {
                    clazz = $class$java$lang$String = 7.class$("java.lang.String");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Integer() {
                Class clazz = $class$java$lang$Integer;
                if (clazz == null) {
                    clazz = $class$java$lang$Integer = 7.class$("java.lang.Integer");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder());
        PropositionParameter.Builder ppBuilder2 = (PropositionParameter.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[169].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder(), (Object)new PropositionParameterContract(PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()){
            private String id;
            private String propId;
            private String value;
            private String parameterType;
            private Integer sequenceNumber;
            private Long versionNumber;
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
            private static /* synthetic */ Class $class$java$lang$Long;
            private static /* synthetic */ Class $class$java$lang$String;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest$8;
            private static /* synthetic */ Class $class$java$lang$Integer;
            {
                MetaClass metaClass;
                String string;
                String string2;
                String string3;
                String string4;
                Class clazz;
                CallSite[] callSiteArray = 8.$getCallSiteArray();
                this.this$0 = clazz = p0;
                this.id = string4 = PropositionTest.PROP_ID;
                this.propId = string3 = "100";
                this.value = string2 = "Muir";
                this.parameterType = string = "C";
                Object object = callSiteArray[0].callConstructor((Object)8.$get$$class$java$lang$Integer(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.sequenceNumber = (Integer)ScriptBytecodeAdapter.castToType((Object)object, (Class)8.$get$$class$java$lang$Integer());
                Object object2 = callSiteArray[1].callConstructor((Object)8.$get$$class$java$lang$Long(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.versionNumber = (Long)ScriptBytecodeAdapter.castToType((Object)object2, (Class)8.$get$$class$java$lang$Long());
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public TermDefinition getTermValue() {
                CallSite[] callSiteArray = 8.$getCallSiteArray();
                return (TermDefinition)ScriptBytecodeAdapter.castToType(null, (Class)8.$get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition());
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                CallSite[] callSiteArray = 8.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)8.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$8(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)8.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                CallSite[] callSiteArray = 8.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectField((Object)object, (Class)8.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$8(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)8.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                CallSite[] callSiteArray = 8.$getCallSiteArray();
                return ScriptBytecodeAdapter.getGroovyObjectField((Class)8.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$8(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)8.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 8.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN((Class)8.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$8(), (Object)8.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)8.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 8.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setField((Object)object, (Class)8.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$8(), (Object)8.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)8.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 8.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField((Class)8.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$8(), (Object)8.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)8.$get$$class$java$lang$String())));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 8.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$8()) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = 8.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                8.__$swapInit();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public String getPropId() {
                return this.propId;
            }

            public void setPropId(String string) {
                this.propId = string;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String string) {
                this.value = string;
            }

            public String getParameterType() {
                return this.parameterType;
            }

            public void setParameterType(String string) {
                this.parameterType = string;
            }

            public Integer getSequenceNumber() {
                return this.sequenceNumber;
            }

            public void setSequenceNumber(Integer n) {
                this.sequenceNumber = n;
            }

            public Long getVersionNumber() {
                return this.versionNumber;
            }

            public void setVersionNumber(Long l) {
                this.versionNumber = l;
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                8.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(8.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$8(), stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest = 8.class$("org.kuali.rice.krms.api.repository.PropositionTest");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition = 8.class$("org.kuali.rice.krms.api.repository.term.TermDefinition");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Long() {
                Class clazz = $class$java$lang$Long;
                if (clazz == null) {
                    clazz = $class$java$lang$Long = 8.class$("java.lang.Long");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$String() {
                Class clazz = $class$java$lang$String;
                if (clazz == null) {
                    clazz = $class$java$lang$String = 8.class$("java.lang.String");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest$8() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$8;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$8 = 8.class$("org.kuali.rice.krms.api.repository.PropositionTest$8");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Integer() {
                Class clazz = $class$java$lang$Integer;
                if (clazz == null) {
                    clazz = $class$java$lang$Integer = 8.class$("java.lang.Integer");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder());
        PropositionParameter.Builder ppBuilder3 = (PropositionParameter.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[170].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder(), (Object)new PropositionParameterContract(PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()){
            private String id;
            private String propId;
            private String value;
            private String parameterType;
            private Integer sequenceNumber;
            private Long versionNumber;
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
            private static /* synthetic */ Class $class$java$lang$Long;
            private static /* synthetic */ Class $class$java$lang$String;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest$9;
            private static /* synthetic */ Class $class$java$lang$Integer;
            {
                MetaClass metaClass;
                String string;
                String string2;
                String string3;
                String string4;
                Class clazz;
                CallSite[] callSiteArray = 9.$getCallSiteArray();
                this.this$0 = clazz = p0;
                this.id = string4 = "2002";
                this.propId = string3 = "100";
                this.value = string2 = "EQUALS";
                this.parameterType = string = "F";
                Object object = callSiteArray[0].callConstructor((Object)9.$get$$class$java$lang$Integer(), (Object)((Integer)DefaultTypeTransformation.box((int)2)));
                this.sequenceNumber = (Integer)ScriptBytecodeAdapter.castToType((Object)object, (Class)9.$get$$class$java$lang$Integer());
                Object object2 = callSiteArray[1].callConstructor((Object)9.$get$$class$java$lang$Long(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.versionNumber = (Long)ScriptBytecodeAdapter.castToType((Object)object2, (Class)9.$get$$class$java$lang$Long());
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public TermDefinition getTermValue() {
                CallSite[] callSiteArray = 9.$getCallSiteArray();
                return (TermDefinition)ScriptBytecodeAdapter.castToType(null, (Class)9.$get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition());
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                CallSite[] callSiteArray = 9.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)9.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$9(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)9.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                CallSite[] callSiteArray = 9.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectField((Object)object, (Class)9.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$9(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)9.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                CallSite[] callSiteArray = 9.$getCallSiteArray();
                return ScriptBytecodeAdapter.getGroovyObjectField((Class)9.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$9(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)9.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 9.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN((Class)9.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$9(), (Object)9.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)9.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 9.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setField((Object)object, (Class)9.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$9(), (Object)9.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)9.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 9.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField((Class)9.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$9(), (Object)9.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)9.$get$$class$java$lang$String())));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 9.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$9()) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = 9.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                9.__$swapInit();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public String getPropId() {
                return this.propId;
            }

            public void setPropId(String string) {
                this.propId = string;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String string) {
                this.value = string;
            }

            public String getParameterType() {
                return this.parameterType;
            }

            public void setParameterType(String string) {
                this.parameterType = string;
            }

            public Integer getSequenceNumber() {
                return this.sequenceNumber;
            }

            public void setSequenceNumber(Integer n) {
                this.sequenceNumber = n;
            }

            public Long getVersionNumber() {
                return this.versionNumber;
            }

            public void setVersionNumber(Long l) {
                this.versionNumber = l;
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                9.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(9.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$9(), stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest = 9.class$("org.kuali.rice.krms.api.repository.PropositionTest");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition = 9.class$("org.kuali.rice.krms.api.repository.term.TermDefinition");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Long() {
                Class clazz = $class$java$lang$Long;
                if (clazz == null) {
                    clazz = $class$java$lang$Long = 9.class$("java.lang.Long");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$String() {
                Class clazz = $class$java$lang$String;
                if (clazz == null) {
                    clazz = $class$java$lang$String = 9.class$("java.lang.String");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest$9() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$9;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$9 = 9.class$("org.kuali.rice.krms.api.repository.PropositionTest$9");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Integer() {
                Class clazz = $class$java$lang$Integer;
                if (clazz == null) {
                    clazz = $class$java$lang$Integer = 9.class$("java.lang.Integer");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder());
        Object ppb = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[171].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{ppBuilder1, ppBuilder2, ppBuilder3})), (Class)PropositionTest.$get$$class$java$util$Iterator());
        while (iterator.hasNext()) {
            ppb = iterator.next();
            callSiteArray[172].call((Object)propParms, ppb);
        }
        return propParms;
    }

    private static Object createPropositionParametersSet3() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        List propParms = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[173].callConstructor((Object)PropositionTest.$get$$class$java$util$ArrayList()), (Class)PropositionTest.$get$$class$java$util$List());
        PropositionParameter.Builder ppBuilder1 = (PropositionParameter.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[174].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder(), (Object)new PropositionParameterContract(PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()){
            private String id;
            private String propId;
            private String value;
            private String parameterType;
            private Integer sequenceNumber;
            private Long versionNumber;
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest$10;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
            private static /* synthetic */ Class $class$java$lang$Long;
            private static /* synthetic */ Class $class$java$lang$String;
            private static /* synthetic */ Class $class$java$lang$Integer;
            {
                MetaClass metaClass;
                String string;
                String string2;
                String string3;
                String string4;
                Class clazz;
                CallSite[] callSiteArray = 10.$getCallSiteArray();
                this.this$0 = clazz = p0;
                this.id = string4 = "2010";
                this.propId = string3 = "101";
                this.value = string2 = "campusCode";
                this.parameterType = string = "T";
                Object object = callSiteArray[0].callConstructor((Object)10.$get$$class$java$lang$Integer(), (Object)"0");
                this.sequenceNumber = (Integer)ScriptBytecodeAdapter.castToType((Object)object, (Class)10.$get$$class$java$lang$Integer());
                Object object2 = callSiteArray[1].callConstructor((Object)10.$get$$class$java$lang$Long(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.versionNumber = (Long)ScriptBytecodeAdapter.castToType((Object)object2, (Class)10.$get$$class$java$lang$Long());
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public TermDefinition getTermValue() {
                CallSite[] callSiteArray = 10.$getCallSiteArray();
                return (TermDefinition)ScriptBytecodeAdapter.castToType(null, (Class)10.$get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition());
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                CallSite[] callSiteArray = 10.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)10.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$10(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)10.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                CallSite[] callSiteArray = 10.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectField((Object)object, (Class)10.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$10(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)10.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                CallSite[] callSiteArray = 10.$getCallSiteArray();
                return ScriptBytecodeAdapter.getGroovyObjectField((Class)10.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$10(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)10.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 10.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN((Class)10.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$10(), (Object)10.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)10.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 10.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setField((Object)object, (Class)10.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$10(), (Object)10.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)10.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 10.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField((Class)10.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$10(), (Object)10.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)10.$get$$class$java$lang$String())));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 10.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$10()) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = 10.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                10.__$swapInit();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public String getPropId() {
                return this.propId;
            }

            public void setPropId(String string) {
                this.propId = string;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String string) {
                this.value = string;
            }

            public String getParameterType() {
                return this.parameterType;
            }

            public void setParameterType(String string) {
                this.parameterType = string;
            }

            public Integer getSequenceNumber() {
                return this.sequenceNumber;
            }

            public void setSequenceNumber(Integer n) {
                this.sequenceNumber = n;
            }

            public Long getVersionNumber() {
                return this.versionNumber;
            }

            public void setVersionNumber(Long l) {
                this.versionNumber = l;
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                10.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(10.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$10(), stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest = 10.class$("org.kuali.rice.krms.api.repository.PropositionTest");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest$10() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$10;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$10 = 10.class$("org.kuali.rice.krms.api.repository.PropositionTest$10");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition = 10.class$("org.kuali.rice.krms.api.repository.term.TermDefinition");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Long() {
                Class clazz = $class$java$lang$Long;
                if (clazz == null) {
                    clazz = $class$java$lang$Long = 10.class$("java.lang.Long");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$String() {
                Class clazz = $class$java$lang$String;
                if (clazz == null) {
                    clazz = $class$java$lang$String = 10.class$("java.lang.String");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Integer() {
                Class clazz = $class$java$lang$Integer;
                if (clazz == null) {
                    clazz = $class$java$lang$Integer = 10.class$("java.lang.Integer");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder());
        PropositionParameter.Builder ppBuilder2 = (PropositionParameter.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[175].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder(), (Object)new PropositionParameterContract(PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()){
            private String id;
            private String propId;
            private String value;
            private String parameterType;
            private Integer sequenceNumber;
            private Long versionNumber;
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
            private static /* synthetic */ Class $class$java$lang$Long;
            private static /* synthetic */ Class $class$java$lang$String;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest$11;
            private static /* synthetic */ Class $class$java$lang$Integer;
            {
                MetaClass metaClass;
                String string;
                String string2;
                String string3;
                String string4;
                Class clazz;
                CallSite[] callSiteArray = 11.$getCallSiteArray();
                this.this$0 = clazz = p0;
                this.id = string4 = "2011";
                this.propId = string3 = "101";
                this.value = string2 = "Thurgood Marshall";
                this.parameterType = string = "C";
                Object object = callSiteArray[0].callConstructor((Object)11.$get$$class$java$lang$Integer(), (Object)"1");
                this.sequenceNumber = (Integer)ScriptBytecodeAdapter.castToType((Object)object, (Class)11.$get$$class$java$lang$Integer());
                Object object2 = callSiteArray[1].callConstructor((Object)11.$get$$class$java$lang$Long(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.versionNumber = (Long)ScriptBytecodeAdapter.castToType((Object)object2, (Class)11.$get$$class$java$lang$Long());
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public TermDefinition getTermValue() {
                CallSite[] callSiteArray = 11.$getCallSiteArray();
                return (TermDefinition)ScriptBytecodeAdapter.castToType(null, (Class)11.$get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition());
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                CallSite[] callSiteArray = 11.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)11.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$11(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)11.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                CallSite[] callSiteArray = 11.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectField((Object)object, (Class)11.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$11(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)11.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                CallSite[] callSiteArray = 11.$getCallSiteArray();
                return ScriptBytecodeAdapter.getGroovyObjectField((Class)11.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$11(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)11.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 11.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN((Class)11.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$11(), (Object)11.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)11.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 11.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setField((Object)object, (Class)11.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$11(), (Object)11.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)11.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 11.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField((Class)11.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$11(), (Object)11.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)11.$get$$class$java$lang$String())));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 11.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$11()) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = 11.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                11.__$swapInit();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public String getPropId() {
                return this.propId;
            }

            public void setPropId(String string) {
                this.propId = string;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String string) {
                this.value = string;
            }

            public String getParameterType() {
                return this.parameterType;
            }

            public void setParameterType(String string) {
                this.parameterType = string;
            }

            public Integer getSequenceNumber() {
                return this.sequenceNumber;
            }

            public void setSequenceNumber(Integer n) {
                this.sequenceNumber = n;
            }

            public Long getVersionNumber() {
                return this.versionNumber;
            }

            public void setVersionNumber(Long l) {
                this.versionNumber = l;
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                11.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(11.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$11(), stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest = 11.class$("org.kuali.rice.krms.api.repository.PropositionTest");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition = 11.class$("org.kuali.rice.krms.api.repository.term.TermDefinition");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Long() {
                Class clazz = $class$java$lang$Long;
                if (clazz == null) {
                    clazz = $class$java$lang$Long = 11.class$("java.lang.Long");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$String() {
                Class clazz = $class$java$lang$String;
                if (clazz == null) {
                    clazz = $class$java$lang$String = 11.class$("java.lang.String");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest$11() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$11;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$11 = 11.class$("org.kuali.rice.krms.api.repository.PropositionTest$11");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Integer() {
                Class clazz = $class$java$lang$Integer;
                if (clazz == null) {
                    clazz = $class$java$lang$Integer = 11.class$("java.lang.Integer");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder());
        PropositionParameter.Builder ppBuilder3 = (PropositionParameter.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[176].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder(), (Object)new PropositionParameterContract(PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()){
            private String id;
            private String propId;
            private String value;
            private String parameterType;
            private Integer sequenceNumber;
            private Long versionNumber;
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
            private static /* synthetic */ Class $class$java$lang$Long;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest$12;
            private static /* synthetic */ Class $class$java$lang$String;
            private static /* synthetic */ Class $class$java$lang$Integer;
            {
                MetaClass metaClass;
                String string;
                String string2;
                String string3;
                String string4;
                Class clazz;
                CallSite[] callSiteArray = 12.$getCallSiteArray();
                this.this$0 = clazz = p0;
                this.id = string4 = "2012";
                this.propId = string3 = "101";
                this.value = string2 = "EQUALS";
                this.parameterType = string = "F";
                Object object = callSiteArray[0].callConstructor((Object)12.$get$$class$java$lang$Integer(), (Object)"2");
                this.sequenceNumber = (Integer)ScriptBytecodeAdapter.castToType((Object)object, (Class)12.$get$$class$java$lang$Integer());
                Object object2 = callSiteArray[1].callConstructor((Object)12.$get$$class$java$lang$Long(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.versionNumber = (Long)ScriptBytecodeAdapter.castToType((Object)object2, (Class)12.$get$$class$java$lang$Long());
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public TermDefinition getTermValue() {
                CallSite[] callSiteArray = 12.$getCallSiteArray();
                return (TermDefinition)ScriptBytecodeAdapter.castToType(null, (Class)12.$get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition());
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                CallSite[] callSiteArray = 12.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)12.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$12(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)12.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                CallSite[] callSiteArray = 12.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectField((Object)object, (Class)12.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$12(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)12.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                CallSite[] callSiteArray = 12.$getCallSiteArray();
                return ScriptBytecodeAdapter.getGroovyObjectField((Class)12.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$12(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)12.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 12.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN((Class)12.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$12(), (Object)12.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)12.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 12.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setField((Object)object, (Class)12.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$12(), (Object)12.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)12.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 12.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField((Class)12.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$12(), (Object)12.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)12.$get$$class$java$lang$String())));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 12.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$12()) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = 12.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                12.__$swapInit();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public String getPropId() {
                return this.propId;
            }

            public void setPropId(String string) {
                this.propId = string;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String string) {
                this.value = string;
            }

            public String getParameterType() {
                return this.parameterType;
            }

            public void setParameterType(String string) {
                this.parameterType = string;
            }

            public Integer getSequenceNumber() {
                return this.sequenceNumber;
            }

            public void setSequenceNumber(Integer n) {
                this.sequenceNumber = n;
            }

            public Long getVersionNumber() {
                return this.versionNumber;
            }

            public void setVersionNumber(Long l) {
                this.versionNumber = l;
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                12.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(12.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$12(), stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest = 12.class$("org.kuali.rice.krms.api.repository.PropositionTest");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$term$TermDefinition() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$term$TermDefinition = 12.class$("org.kuali.rice.krms.api.repository.term.TermDefinition");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Long() {
                Class clazz = $class$java$lang$Long;
                if (clazz == null) {
                    clazz = $class$java$lang$Long = 12.class$("java.lang.Long");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest$12() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$12;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$12 = 12.class$("org.kuali.rice.krms.api.repository.PropositionTest$12");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$String() {
                Class clazz = $class$java$lang$String;
                if (clazz == null) {
                    clazz = $class$java$lang$String = 12.class$("java.lang.String");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Integer() {
                Class clazz = $class$java$lang$Integer;
                if (clazz == null) {
                    clazz = $class$java$lang$Integer = 12.class$("java.lang.Integer");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder());
        Object ppb = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[177].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{ppBuilder1, ppBuilder2, ppBuilder3})), (Class)PropositionTest.$get$$class$java$util$Iterator());
        while (iterator.hasNext()) {
            ppb = iterator.next();
            callSiteArray[178].call((Object)propParms, ppb);
        }
        return propParms;
    }

    private static Object createPropositionABuilder() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        return callSiteArray[179].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), (Object)new PropositionDefinitionContract(PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()){
            private String id;
            private String description;
            private String ruleId;
            private String typeId;
            private String propositionTypeCode;
            private Integer compoundSequenceNumber;
            private List<? extends PropositionParameterContract> parameters;
            private String compoundOpCode;
            private List<? extends PropositionDefinition> compoundComponents;
            private Long versionNumber;
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest;
            private static /* synthetic */ Class $class$java$util$ArrayList;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest$13;
            private static /* synthetic */ Class $class$java$lang$String;
            private static /* synthetic */ Class $class$java$lang$Long;
            private static /* synthetic */ Class $class$java$lang$Integer;
            private static /* synthetic */ Class $class$java$util$List;
            {
                MetaClass metaClass;
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                Class clazz;
                CallSite[] callSiteArray = 13.$getCallSiteArray();
                this.this$0 = clazz = p0;
                this.id = string5 = "100";
                this.description = string4 = "Is campus type = Muir";
                this.ruleId = string3 = "1";
                this.typeId = string2 = "1";
                this.propositionTypeCode = string = "S";
                Object object = callSiteArray[0].callConstructor((Object)13.$get$$class$java$lang$Integer(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.compoundSequenceNumber = (Integer)ScriptBytecodeAdapter.castToType((Object)object, (Class)13.$get$$class$java$lang$Integer());
                Object object2 = callSiteArray[1].callGetProperty((Object)13.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest());
                this.parameters = (List)ScriptBytecodeAdapter.castToType((Object)object2, (Class)13.$get$$class$java$util$List());
                Object var11_11 = null;
                this.compoundOpCode = (String)ScriptBytecodeAdapter.castToType(var11_11, (Class)13.$get$$class$java$lang$String());
                Object object3 = callSiteArray[2].callConstructor((Object)13.$get$$class$java$util$ArrayList());
                this.compoundComponents = (List)ScriptBytecodeAdapter.castToType((Object)object3, (Class)13.$get$$class$java$util$List());
                Object object4 = callSiteArray[3].callConstructor((Object)13.$get$$class$java$lang$Long(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.versionNumber = (Long)ScriptBytecodeAdapter.castToType((Object)object4, (Class)13.$get$$class$java$lang$Long());
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                CallSite[] callSiteArray = 13.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)13.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$13(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)13.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                CallSite[] callSiteArray = 13.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectField((Object)object, (Class)13.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$13(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)13.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                CallSite[] callSiteArray = 13.$getCallSiteArray();
                return ScriptBytecodeAdapter.getGroovyObjectField((Class)13.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$13(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)13.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 13.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN((Class)13.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$13(), (Object)13.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)13.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 13.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setField((Object)object, (Class)13.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$13(), (Object)13.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)13.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 13.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField((Class)13.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$13(), (Object)13.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)13.$get$$class$java$lang$String())));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 13.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$13()) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = 13.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                13.__$swapInit();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public String getDescription() {
                return this.description;
            }

            public void setDescription(String string) {
                this.description = string;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public void setRuleId(String string) {
                this.ruleId = string;
            }

            public String getTypeId() {
                return this.typeId;
            }

            public void setTypeId(String string) {
                this.typeId = string;
            }

            public String getPropositionTypeCode() {
                return this.propositionTypeCode;
            }

            public void setPropositionTypeCode(String string) {
                this.propositionTypeCode = string;
            }

            public Integer getCompoundSequenceNumber() {
                return this.compoundSequenceNumber;
            }

            public void setCompoundSequenceNumber(Integer n) {
                this.compoundSequenceNumber = n;
            }

            public List<? extends PropositionParameterContract> getParameters() {
                return this.parameters;
            }

            public void setParameters(List<? extends PropositionParameterContract> list) {
                this.parameters = list;
            }

            public String getCompoundOpCode() {
                return this.compoundOpCode;
            }

            public void setCompoundOpCode(String string) {
                this.compoundOpCode = string;
            }

            public List<? extends PropositionDefinition> getCompoundComponents() {
                return this.compoundComponents;
            }

            public void setCompoundComponents(List<? extends PropositionDefinition> list) {
                this.compoundComponents = list;
            }

            public Long getVersionNumber() {
                return this.versionNumber;
            }

            public void setVersionNumber(Long l) {
                this.versionNumber = l;
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "PARM_LIST_A";
                stringArray[2] = "<$constructor$>";
                stringArray[3] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                13.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(13.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$13(), stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest = 13.class$("org.kuali.rice.krms.api.repository.PropositionTest");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$util$ArrayList() {
                Class clazz = $class$java$util$ArrayList;
                if (clazz == null) {
                    clazz = $class$java$util$ArrayList = 13.class$("java.util.ArrayList");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest$13() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$13;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$13 = 13.class$("org.kuali.rice.krms.api.repository.PropositionTest$13");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$String() {
                Class clazz = $class$java$lang$String;
                if (clazz == null) {
                    clazz = $class$java$lang$String = 13.class$("java.lang.String");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Long() {
                Class clazz = $class$java$lang$Long;
                if (clazz == null) {
                    clazz = $class$java$lang$Long = 13.class$("java.lang.Long");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Integer() {
                Class clazz = $class$java$lang$Integer;
                if (clazz == null) {
                    clazz = $class$java$lang$Integer = 13.class$("java.lang.Integer");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$util$List() {
                Class clazz = $class$java$util$List;
                if (clazz == null) {
                    clazz = $class$java$util$List = 13.class$("java.util.List");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    private static Object createPropositionBBuilder() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        return callSiteArray[180].call((Object)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder(), (Object)new PropositionDefinitionContract(PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()){
            private String id;
            private String description;
            private String ruleId;
            private String typeId;
            private String propositionTypeCode;
            private Integer compoundSequenceNumber;
            private List<? extends PropositionParameterContract> parameters;
            private String compoundOpCode;
            private List<? extends PropositionDefinition> compoundComponents;
            private Long versionNumber;
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest;
            private static /* synthetic */ Class $class$java$util$ArrayList;
            private static /* synthetic */ Class $class$org$kuali$rice$krms$api$repository$PropositionTest$14;
            private static /* synthetic */ Class $class$java$lang$String;
            private static /* synthetic */ Class $class$java$lang$Long;
            private static /* synthetic */ Class $class$java$lang$Integer;
            private static /* synthetic */ Class $class$java$util$List;
            {
                MetaClass metaClass;
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                Class clazz;
                CallSite[] callSiteArray = 14.$getCallSiteArray();
                this.this$0 = clazz = p0;
                this.id = string5 = "101";
                this.description = string4 = "Is campus type = Thurgood Marshall";
                this.ruleId = string3 = "1";
                this.typeId = string2 = "1";
                this.propositionTypeCode = string = "S";
                Object object = callSiteArray[0].callConstructor((Object)14.$get$$class$java$lang$Integer(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.compoundSequenceNumber = (Integer)ScriptBytecodeAdapter.castToType((Object)object, (Class)14.$get$$class$java$lang$Integer());
                Object object2 = callSiteArray[1].callGetProperty((Object)14.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest());
                this.parameters = (List)ScriptBytecodeAdapter.castToType((Object)object2, (Class)14.$get$$class$java$util$List());
                Object var11_11 = null;
                this.compoundOpCode = (String)ScriptBytecodeAdapter.castToType(var11_11, (Class)14.$get$$class$java$lang$String());
                Object object3 = callSiteArray[2].callConstructor((Object)14.$get$$class$java$util$ArrayList());
                this.compoundComponents = (List)ScriptBytecodeAdapter.castToType((Object)object3, (Class)14.$get$$class$java$util$List());
                Object object4 = callSiteArray[3].callConstructor((Object)14.$get$$class$java$lang$Long(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
                this.versionNumber = (Long)ScriptBytecodeAdapter.castToType((Object)object4, (Class)14.$get$$class$java$lang$Long());
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                CallSite[] callSiteArray = 14.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)14.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$14(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)14.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                CallSite[] callSiteArray = 14.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectField((Object)object, (Class)14.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$14(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)14.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                CallSite[] callSiteArray = 14.$getCallSiteArray();
                return ScriptBytecodeAdapter.getGroovyObjectField((Class)14.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$14(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)14.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 14.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN((Class)14.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$14(), (Object)14.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)14.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 14.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setField((Object)object, (Class)14.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$14(), (Object)14.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)14.$get$$class$java$lang$String())));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 14.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField((Class)14.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$14(), (Object)14.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)14.$get$$class$java$lang$String())));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 14.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$14()) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = 14.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                14.__$swapInit();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String string) {
                this.id = string;
            }

            public String getDescription() {
                return this.description;
            }

            public void setDescription(String string) {
                this.description = string;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public void setRuleId(String string) {
                this.ruleId = string;
            }

            public String getTypeId() {
                return this.typeId;
            }

            public void setTypeId(String string) {
                this.typeId = string;
            }

            public String getPropositionTypeCode() {
                return this.propositionTypeCode;
            }

            public void setPropositionTypeCode(String string) {
                this.propositionTypeCode = string;
            }

            public Integer getCompoundSequenceNumber() {
                return this.compoundSequenceNumber;
            }

            public void setCompoundSequenceNumber(Integer n) {
                this.compoundSequenceNumber = n;
            }

            public List<? extends PropositionParameterContract> getParameters() {
                return this.parameters;
            }

            public void setParameters(List<? extends PropositionParameterContract> list) {
                this.parameters = list;
            }

            public String getCompoundOpCode() {
                return this.compoundOpCode;
            }

            public void setCompoundOpCode(String string) {
                this.compoundOpCode = string;
            }

            public List<? extends PropositionDefinition> getCompoundComponents() {
                return this.compoundComponents;
            }

            public void setCompoundComponents(List<? extends PropositionDefinition> list) {
                this.compoundComponents = list;
            }

            public Long getVersionNumber() {
                return this.versionNumber;
            }

            public void setVersionNumber(Long l) {
                this.versionNumber = l;
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "PARM_LIST_B";
                stringArray[2] = "<$constructor$>";
                stringArray[3] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                14.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(14.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest$14(), stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest = 14.class$("org.kuali.rice.krms.api.repository.PropositionTest");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$util$ArrayList() {
                Class clazz = $class$java$util$ArrayList;
                if (clazz == null) {
                    clazz = $class$java$util$ArrayList = 14.class$("java.util.ArrayList");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest$14() {
                Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$14;
                if (clazz == null) {
                    clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest$14 = 14.class$("org.kuali.rice.krms.api.repository.PropositionTest$14");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$String() {
                Class clazz = $class$java$lang$String;
                if (clazz == null) {
                    clazz = $class$java$lang$String = 14.class$("java.lang.String");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Long() {
                Class clazz = $class$java$lang$Long;
                if (clazz == null) {
                    clazz = $class$java$lang$Long = 14.class$("java.lang.Long");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$lang$Integer() {
                Class clazz = $class$java$lang$Integer;
                if (clazz == null) {
                    clazz = $class$java$lang$Integer = 14.class$("java.lang.Integer");
                }
                return clazz;
            }

            private static /* synthetic */ Class $get$$class$java$util$List() {
                Class clazz = $class$java$util$List;
                if (clazz == null) {
                    clazz = $class$java$util$List = 14.class$("java.util.List");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)PropositionTest.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)PropositionTest.$get$$class$java$lang$String())));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectField((Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)PropositionTest.$get$$class$java$lang$String())));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest()) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        CallSite[] callSiteArray = PropositionTest.$getCallSiteArray();
        $callSiteArray = null;
    }

    static {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        PropositionTest.__$swapInit();
        Long l = (Long)DefaultTypeTransformation.box((long)0L);
        __timeStamp__239_neverHappen1467112448917 = l;
        Long l2 = (Long)DefaultTypeTransformation.box((long)1467112448917L);
        __timeStamp = l2;
        PROPOSITION_TYPE_CD_BAD = string5 = "X";
        PROPOSITION_TYPE_CD_C = string4 = "C";
        PROPOSITION_TYPE_CD_S = string3 = "S";
        TYPE_ID = string2 = "1";
        RULE_ID = string = "1";
        Object object = PropositionTest.$getCallSiteArray()[181].call((Object)PropositionTest.$get$$class$java$util$Collections(), PropositionTest.$getCallSiteArray()[182].callConstructor((Object)PropositionTest.$get$$class$java$util$ArrayList()));
        EMPTY_PARM_LIST = (List)ScriptBytecodeAdapter.castToType((Object)object, (Class)PropositionTest.$get$$class$java$util$List());
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = PropositionTest.$getCallSiteArray()[183].callStatic(PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest());
            PARM_LIST_1 = (List)ScriptBytecodeAdapter.castToType((Object)object2, (Class)PropositionTest.$get$$class$java$util$List());
        } else {
            Object object3 = PropositionTest.createPropositionParametersSet1();
            PARM_LIST_1 = (List)ScriptBytecodeAdapter.castToType((Object)object3, (Class)PropositionTest.$get$$class$java$util$List());
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object4 = PropositionTest.$getCallSiteArray()[184].callStatic(PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest());
            PARM_LIST_A = (List)ScriptBytecodeAdapter.castToType((Object)object4, (Class)PropositionTest.$get$$class$java$util$List());
        } else {
            Object object5 = PropositionTest.createPropositionParametersSet2();
            PARM_LIST_A = (List)ScriptBytecodeAdapter.castToType((Object)object5, (Class)PropositionTest.$get$$class$java$util$List());
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object6 = PropositionTest.$getCallSiteArray()[185].callStatic(PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest());
            PARM_LIST_B = (List)ScriptBytecodeAdapter.castToType((Object)object6, (Class)PropositionTest.$get$$class$java$util$List());
        } else {
            Object object7 = PropositionTest.createPropositionParametersSet3();
            PARM_LIST_B = (List)ScriptBytecodeAdapter.castToType((Object)object7, (Class)PropositionTest.$get$$class$java$util$List());
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object8 = PropositionTest.$getCallSiteArray()[186].callStatic(PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest());
            PROP_A_BUILDER = (PropositionDefinition.Builder)ScriptBytecodeAdapter.castToType((Object)object8, (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder());
        } else {
            Object object9 = PropositionTest.createPropositionABuilder();
            PROP_A_BUILDER = (PropositionDefinition.Builder)ScriptBytecodeAdapter.castToType((Object)object9, (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder());
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object10 = PropositionTest.$getCallSiteArray()[187].callStatic(PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest());
            PROP_B_BUILDER = (PropositionDefinition.Builder)ScriptBytecodeAdapter.castToType((Object)object10, (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder());
        } else {
            Object object11 = PropositionTest.createPropositionBBuilder();
            PROP_B_BUILDER = (PropositionDefinition.Builder)ScriptBytecodeAdapter.castToType((Object)object11, (Class)PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder());
        }
        Object object12 = PropositionTest.$getCallSiteArray()[188].callConstructor((Object)PropositionTest.$get$$class$java$lang$Integer(), (Object)((Integer)DefaultTypeTransformation.box((int)1)));
        SEQUENCE_NUMBER_1 = (Integer)ScriptBytecodeAdapter.castToType((Object)object12, (Class)PropositionTest.$get$$class$java$lang$Integer());
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "create";
        stringArray[1] = "create";
        stringArray[2] = "create";
        stringArray[3] = "create";
        stringArray[4] = "create";
        stringArray[5] = "create";
        stringArray[6] = "create";
        stringArray[7] = "create";
        stringArray[8] = "create";
        stringArray[9] = "create";
        stringArray[10] = "create";
        stringArray[11] = "build";
        stringArray[12] = "create";
        stringArray[13] = "create";
        stringArray[14] = "build";
        stringArray[15] = "create";
        stringArray[16] = "create";
        stringArray[17] = "setDescription";
        stringArray[18] = "setVersionNumber";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "build";
        stringArray[21] = "newInstance";
        stringArray[22] = "createMarshaller";
        stringArray[23] = "setProperty";
        stringArray[24] = "JAXB_FORMATTED_OUTPUT";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "marshal";
        stringArray[27] = "toString";
        stringArray[28] = "createUnmarshaller";
        stringArray[29] = "unmarshal";
        stringArray[30] = "<$constructor$>";
        stringArray[31] = "unmarshal";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "assertEquals";
        stringArray[34] = "newInstance";
        stringArray[35] = "createUnmarshaller";
        stringArray[36] = "unmarshal";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "assertEquals";
        stringArray[39] = "id";
        stringArray[40] = "assertEquals";
        stringArray[41] = "description";
        stringArray[42] = "assertEquals";
        stringArray[43] = "typeId";
        stringArray[44] = "assertEquals";
        stringArray[45] = "propositionTypeCode";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "iterator";
        stringArray[48] = "add";
        stringArray[49] = "build";
        stringArray[50] = "assertEquals";
        stringArray[51] = "parameters";
        stringArray[52] = "build";
        stringArray[53] = "create";
        stringArray[54] = "newInstance";
        stringArray[55] = "createMarshaller";
        stringArray[56] = "<$constructor$>";
        stringArray[57] = "setProperty";
        stringArray[58] = "JAXB_FORMATTED_OUTPUT";
        stringArray[59] = "marshal";
        stringArray[60] = "toString";
        stringArray[61] = "print";
        stringArray[62] = "createUnmarshaller";
        stringArray[63] = "unmarshal";
        stringArray[64] = "<$constructor$>";
        stringArray[65] = "unmarshal";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "assertEquals";
        stringArray[68] = "newInstance";
        stringArray[69] = "createUnmarshaller";
        stringArray[70] = "unmarshal";
        stringArray[71] = "<$constructor$>";
        stringArray[72] = "assertEquals";
        stringArray[73] = "id";
        stringArray[74] = "assertEquals";
        stringArray[75] = "description";
        stringArray[76] = "assertEquals";
        stringArray[77] = "typeId";
        stringArray[78] = "assertEquals";
        stringArray[79] = "propositionTypeCode";
        stringArray[80] = "assertEquals";
        stringArray[81] = "compoundOpCode";
        stringArray[82] = "assertEquals";
        stringArray[83] = "size";
        stringArray[84] = "compoundComponents";
        stringArray[85] = "<$constructor$>";
        stringArray[86] = "iterator";
        stringArray[87] = "add";
        stringArray[88] = "build";
        stringArray[89] = "assertEquals";
        stringArray[90] = "id";
        stringArray[91] = "get";
        stringArray[92] = "id";
        stringArray[93] = "get";
        stringArray[94] = "compoundComponents";
        stringArray[95] = "assertEquals";
        stringArray[96] = "description";
        stringArray[97] = "get";
        stringArray[98] = "description";
        stringArray[99] = "get";
        stringArray[100] = "compoundComponents";
        stringArray[101] = "assertEquals";
        stringArray[102] = "typeId";
        stringArray[103] = "get";
        stringArray[104] = "typeId";
        stringArray[105] = "get";
        stringArray[106] = "compoundComponents";
        stringArray[107] = "assertEquals";
        stringArray[108] = "propositionTypeCode";
        stringArray[109] = "get";
        stringArray[110] = "propositionTypeCode";
        stringArray[111] = "get";
        stringArray[112] = "compoundComponents";
        stringArray[113] = "assertEquals";
        stringArray[114] = "id";
        stringArray[115] = "get";
        stringArray[116] = "id";
        stringArray[117] = "get";
        stringArray[118] = "compoundComponents";
        stringArray[119] = "assertEquals";
        stringArray[120] = "description";
        stringArray[121] = "get";
        stringArray[122] = "description";
        stringArray[123] = "get";
        stringArray[124] = "compoundComponents";
        stringArray[125] = "assertEquals";
        stringArray[126] = "typeId";
        stringArray[127] = "get";
        stringArray[128] = "typeId";
        stringArray[129] = "get";
        stringArray[130] = "compoundComponents";
        stringArray[131] = "assertEquals";
        stringArray[132] = "propositionTypeCode";
        stringArray[133] = "get";
        stringArray[134] = "propositionTypeCode";
        stringArray[135] = "get";
        stringArray[136] = "compoundComponents";
        stringArray[137] = "assertEquals";
        stringArray[138] = "compoundSequenceNumber";
        stringArray[139] = "get";
        stringArray[140] = "compoundSequenceNumber";
        stringArray[141] = "get";
        stringArray[142] = "compoundComponents";
        stringArray[143] = "assertEquals";
        stringArray[144] = "compoundSequenceNumber";
        stringArray[145] = "get";
        stringArray[146] = "compoundSequenceNumber";
        stringArray[147] = "get";
        stringArray[148] = "compoundComponents";
        stringArray[149] = "assertEquals";
        stringArray[150] = "parameters";
        stringArray[151] = "get";
        stringArray[152] = "parameters";
        stringArray[153] = "get";
        stringArray[154] = "compoundComponents";
        stringArray[155] = "assertEquals";
        stringArray[156] = "parameters";
        stringArray[157] = "get";
        stringArray[158] = "parameters";
        stringArray[159] = "get";
        stringArray[160] = "compoundComponents";
        stringArray[161] = "<$constructor$>";
        stringArray[162] = "create";
        stringArray[163] = "create";
        stringArray[164] = "create";
        stringArray[165] = "iterator";
        stringArray[166] = "add";
        stringArray[167] = "<$constructor$>";
        stringArray[168] = "create";
        stringArray[169] = "create";
        stringArray[170] = "create";
        stringArray[171] = "iterator";
        stringArray[172] = "add";
        stringArray[173] = "<$constructor$>";
        stringArray[174] = "create";
        stringArray[175] = "create";
        stringArray[176] = "create";
        stringArray[177] = "iterator";
        stringArray[178] = "add";
        stringArray[179] = "create";
        stringArray[180] = "create";
        stringArray[181] = "unmodifiableList";
        stringArray[182] = "<$constructor$>";
        stringArray[183] = "createPropositionParametersSet1";
        stringArray[184] = "createPropositionParametersSet2";
        stringArray[185] = "createPropositionParametersSet3";
        stringArray[186] = "createPropositionABuilder";
        stringArray[187] = "createPropositionBBuilder";
        stringArray[188] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[189];
        PropositionTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(PropositionTest.$get$$class$org$kuali$rice$krms$api$repository$PropositionTest(), stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = PropositionTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition() {
        Class clazz = $class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition;
        if (clazz == null) {
            clazz = $class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition = PropositionTest.class$("org.kuali.rice.krms.api.repository.proposition.PropositionDefinition");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$PropositionTest() {
        Class clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest;
        if (clazz == null) {
            clazz = $class$org$kuali$rice$krms$api$repository$PropositionTest = PropositionTest.class$("org.kuali.rice.krms.api.repository.PropositionTest");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$javax$xml$bind$Marshaller() {
        Class clazz = $class$javax$xml$bind$Marshaller;
        if (clazz == null) {
            clazz = $class$javax$xml$bind$Marshaller = PropositionTest.class$("javax.xml.bind.Marshaller");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$ArrayList() {
        Class clazz = $class$java$util$ArrayList;
        if (clazz == null) {
            clazz = $class$java$util$ArrayList = PropositionTest.class$("java.util.ArrayList");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$javax$xml$bind$JAXBContext() {
        Class clazz = $class$javax$xml$bind$JAXBContext;
        if (clazz == null) {
            clazz = $class$javax$xml$bind$JAXBContext = PropositionTest.class$("javax.xml.bind.JAXBContext");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter() {
        Class clazz = $class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter;
        if (clazz == null) {
            clazz = $class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter = PropositionTest.class$("org.kuali.rice.krms.api.repository.proposition.PropositionParameter");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$lang$Long() {
        Class clazz = $class$java$lang$Long;
        if (clazz == null) {
            clazz = $class$java$lang$Long = PropositionTest.class$("java.lang.Long");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$javax$xml$bind$Unmarshaller() {
        Class clazz = $class$javax$xml$bind$Unmarshaller;
        if (clazz == null) {
            clazz = $class$javax$xml$bind$Unmarshaller = PropositionTest.class$("javax.xml.bind.Unmarshaller");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$io$StringWriter() {
        Class clazz = $class$java$io$StringWriter;
        if (clazz == null) {
            clazz = $class$java$io$StringWriter = PropositionTest.class$("java.io.StringWriter");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$Iterator() {
        Class clazz = $class$java$util$Iterator;
        if (clazz == null) {
            clazz = $class$java$util$Iterator = PropositionTest.class$("java.util.Iterator");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder() {
        Class clazz = $class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder;
        if (clazz == null) {
            clazz = $class$org$kuali$rice$krms$api$repository$proposition$PropositionDefinition$Builder = PropositionTest.class$("org.kuali.rice.krms.api.repository.proposition.PropositionDefinition$Builder");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder() {
        Class clazz = $class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder;
        if (clazz == null) {
            clazz = $class$org$kuali$rice$krms$api$repository$proposition$PropositionParameter$Builder = PropositionTest.class$("org.kuali.rice.krms.api.repository.proposition.PropositionParameter$Builder");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$io$StringReader() {
        Class clazz = $class$java$io$StringReader;
        if (clazz == null) {
            clazz = $class$java$io$StringReader = PropositionTest.class$("java.io.StringReader");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$lang$String() {
        Class clazz = $class$java$lang$String;
        if (clazz == null) {
            clazz = $class$java$lang$String = PropositionTest.class$("java.lang.String");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$junit$Assert() {
        Class clazz = $class$org$junit$Assert;
        if (clazz == null) {
            clazz = $class$org$junit$Assert = PropositionTest.class$("org.junit.Assert");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$Collections() {
        Class clazz = $class$java$util$Collections;
        if (clazz == null) {
            clazz = $class$java$util$Collections = PropositionTest.class$("java.util.Collections");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$lang$Integer() {
        Class clazz = $class$java$lang$Integer;
        if (clazz == null) {
            clazz = $class$java$lang$Integer = PropositionTest.class$("java.lang.Integer");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$List() {
        Class clazz = $class$java$util$List;
        if (clazz == null) {
            clazz = $class$java$util$List = PropositionTest.class$("java.util.List");
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

