/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.reference.ReferenceObjectBinding;

public final class ReferenceObjectBindingGenTest {
    private static final String XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<referenceObjectBinding xmlns=\"http://rice.kuali.org/krms/v2_0\">\n    <krmsDiscriminatorType>KRMS_DISCRIMINATOR_TYPE</krmsDiscriminatorType>\n    <krmsObjectId>KRMS_OBJECT_ID</krmsObjectId>\n    <namespace>NAMESPACE</namespace>\n    <referenceDiscriminatorType>REFERENCE_DISCRIMINATOR_TYPE</referenceDiscriminatorType>\n    <referenceObjectId>REFERENCE_OBJECT_ID</referenceObjectId>\n    <id>ID</id>\n    <active>false</active>\n</referenceObjectBinding>";
    private static final boolean ACTIVE = false;
    private static final String COLLECTION_NAME = "COLLECTION_NAME";
    private static final String ID = "ID";
    private static final String KRMS_DISCRIMINATOR_TYPE = "KRMS_DISCRIMINATOR_TYPE";
    private static final String KRMS_OBJECT_ID = "KRMS_OBJECT_ID";
    private static final String NAMESPACE = "NAMESPACE";
    private static final String REFERENCE_DISCRIMINATOR_TYPE = "REFERENCE_DISCRIMINATOR_TYPE";
    private static final String REFERENCE_OBJECT_ID = "REFERENCE_OBJECT_ID";
    private static final Long VERSION_NUMBER = 0L;

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_Builder_create_fail_all_null() {
        ReferenceObjectBinding.Builder.create(null, null, null, null, null);
    }

    @Test
    public void test_ReferenceObjectBinding_set_validation_id_success_null() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_set_validation_id_fail_empty() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setId("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_set_validation_id_fail_whitespace() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setId("    ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_set_validation_krmsDiscriminatorType_fail_null() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setKrmsDiscriminatorType(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_set_validation_krmsDiscriminatorType_fail_empty() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setKrmsDiscriminatorType("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_set_validation_krmsDiscriminatorType_fail_whitespace() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setKrmsDiscriminatorType("    ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_set_validation_krmsObjectId_fail_null() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setKrmsObjectId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_set_validation_krmsObjectId_fail_empty() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setKrmsObjectId("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_set_validation_krmsObjectId_fail_whitespace() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setKrmsObjectId("    ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_set_validation_namespace_fail_null() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setNamespace(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_set_validation_namespace_fail_empty() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setNamespace("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_set_validation_namespace_fail_whitespace() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setNamespace("    ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_set_validation_referenceDiscriminatorType_fail_null() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setReferenceDiscriminatorType(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_set_validation_referenceDiscriminatorType_fail_empty() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setReferenceDiscriminatorType("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_set_validation_referenceDiscriminatorType_fail_whitespace() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setReferenceDiscriminatorType("    ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_set_validation_referenceObjectId_fail_null() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setReferenceObjectId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_set_validation_referenceObjectId_fail_empty() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setReferenceObjectId("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ReferenceObjectBinding_set_validation_referenceObjectId_fail_whitespace() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setReferenceObjectId("    ");
    }

    @Test
    public void test_ReferenceObjectBinding_Builder_create() {
        ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
    }

    @Test
    public void test_ReferenceObjectBinding_Builder_create_and_build() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.build();
    }

    @Test
    public void test_ReferenceObjectBinding_xml_marshaling() throws Exception {
        ReferenceObjectBinding referenceObjectBinding = ReferenceObjectBindingGenTest.buildFullReferenceObjectBinding();
        this.assertXmlMarshaling(referenceObjectBinding, XML);
    }

    public void assertXmlMarshaling(Object referenceObjectBinding, String expectedXml) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ReferenceObjectBinding.class});
        Marshaller marshaller = jc.createMarshaller();
        StringWriter stringWriter = new StringWriter();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal(referenceObjectBinding, (Writer)stringWriter);
        String xml = stringWriter.toString();
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        Object actual = unmarshaller.unmarshal((Reader)new StringReader(xml));
        Object expected = unmarshaller.unmarshal((Reader)new StringReader(expectedXml));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static ReferenceObjectBinding buildFullReferenceObjectBinding() {
        ReferenceObjectBinding.Builder builder = ReferenceObjectBinding.Builder.create((String)KRMS_DISCRIMINATOR_TYPE, (String)KRMS_OBJECT_ID, (String)NAMESPACE, (String)REFERENCE_DISCRIMINATOR_TYPE, (String)REFERENCE_OBJECT_ID);
        builder.setId(ID);
        ReferenceObjectBinding referenceObjectBinding = builder.build();
        return referenceObjectBinding;
    }
}

