/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.agenda;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeEntryDefinitionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="agendaTreeRuleEntry")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="AgendaTreeRuleEntryType", propOrder={"agendaItemId", "ruleId", "ifTrue", "ifFalse", "_futureElements"})
public final class AgendaTreeRuleEntry
extends AbstractDataTransferObject
implements AgendaTreeEntryDefinitionContract {
    private static final long serialVersionUID = 8594116503548506936L;
    @XmlElement(name="agendaItemId", required=true)
    private final String agendaItemId;
    @XmlElement(name="ruleId", required=true)
    private final String ruleId;
    @XmlElement(name="ifTrue", required=false)
    private final AgendaTreeDefinition ifTrue;
    @XmlElement(name="ifFalse", required=false)
    private final AgendaTreeDefinition ifFalse;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private AgendaTreeRuleEntry() {
        this.agendaItemId = null;
        this.ruleId = null;
        this.ifTrue = null;
        this.ifFalse = null;
    }

    private AgendaTreeRuleEntry(Builder builder) {
        this.agendaItemId = builder.getAgendaItemId();
        this.ruleId = builder.getRuleId();
        this.ifTrue = builder.getIfTrue() == null ? null : builder.getIfTrue().build();
        this.ifFalse = builder.getIfFalse() == null ? null : builder.getIfFalse().build();
    }

    @Override
    public String getAgendaItemId() {
        return this.agendaItemId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public AgendaTreeDefinition getIfTrue() {
        return this.ifTrue;
    }

    public AgendaTreeDefinition getIfFalse() {
        return this.ifFalse;
    }

    static class Elements {
        static final String AGENDA_ITEM_ID = "agendaItemId";
        static final String RULE_ID = "ruleId";
        static final String IF_TRUE = "ifTrue";
        static final String IF_FALSE = "ifFalse";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "agendaTreeRuleEntry";
        static final String TYPE_NAME = "AgendaTreeRuleEntryType";

        Constants() {
        }
    }

    public static class Builder
    implements AgendaTreeEntryDefinitionContract,
    Serializable {
        private static final long serialVersionUID = 3548736700798501429L;
        private String agendaItemId;
        private String ruleId;
        private AgendaTreeDefinition.Builder ifTrue;
        private AgendaTreeDefinition.Builder ifFalse;

        private Builder(String agendaItemId, String ruleId) {
            this.setAgendaItemId(agendaItemId);
            this.setRuleId(ruleId);
        }

        public static Builder create(String agendaItemId, String ruleId) {
            return new Builder(agendaItemId, ruleId);
        }

        @Override
        public String getAgendaItemId() {
            return this.agendaItemId;
        }

        public String getRuleId() {
            return this.ruleId;
        }

        public AgendaTreeDefinition.Builder getIfTrue() {
            return this.ifTrue;
        }

        public AgendaTreeDefinition.Builder getIfFalse() {
            return this.ifFalse;
        }

        public void setAgendaItemId(String agendaItemId) {
            if (StringUtils.isBlank((String)agendaItemId)) {
                throw new IllegalArgumentException("agendaItemId was null or blank");
            }
            this.agendaItemId = agendaItemId;
        }

        public void setRuleId(String ruleId) {
            if (StringUtils.isBlank((String)ruleId)) {
                throw new IllegalArgumentException("ruleId was null or blank");
            }
            this.ruleId = ruleId;
        }

        public void setIfTrue(AgendaTreeDefinition.Builder ifTrue) {
            this.ifTrue = ifTrue;
        }

        public void setIfFalse(AgendaTreeDefinition.Builder ifFalse) {
            this.ifFalse = ifFalse;
        }

        public AgendaTreeRuleEntry build() {
            return new AgendaTreeRuleEntry(this);
        }
    }
}

