/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeDefinition;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.context.ContextSelectionCriteria;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.springframework.cache.annotation.Cacheable;

@WebService(name="ruleRepositoryService", targetNamespace="http://rice.kuali.org/krms/v2_0")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public interface RuleRepositoryService {
    @WebMethod(operationName="selectContext")
    @WebResult(name="contextDefinition")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/ContextDefinitionType"}, key="'contextSelectionCriteria=' + #p0.getNamespaceCode() + #p0.getName()")
    public ContextDefinition selectContext(@WebParam(name="contextSelectionCriteria") ContextSelectionCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAgendaTree")
    @WebResult(name="agendaTree")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/AgendaTreeDefinition"}, key="'agendaId=' + #p0")
    public AgendaTreeDefinition getAgendaTree(@WebParam(name="agendaId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAgendaTrees")
    @XmlElementWrapper(name="agendaTrees", required=true)
    @XmlElement(name="agendaTree", required=false)
    @WebResult(name="agendaTrees")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/AgendaTreeDefinition"}, key="'agendaIds=' + #p0.toString()")
    public List<AgendaTreeDefinition> getAgendaTrees(@WebParam(name="agendaIds") List<String> var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRule")
    @WebResult(name="rule")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/RuleType"}, key="'ruleId=' + #p0")
    public RuleDefinition getRule(@WebParam(name="ruleId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRules")
    @XmlElementWrapper(name="rules", required=true)
    @XmlElement(name="rule", required=false)
    @WebResult(name="rules")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/RuleType"}, key="'ruleIds=' + #p0.toString()")
    public List<RuleDefinition> getRules(@WebParam(name="ruleIds") List<String> var1) throws RiceIllegalArgumentException;
}

