/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.engine;

import org.kuali.rice.core.api.exception.RiceRuntimeException;

public class IncompatibleTypeException
extends RiceRuntimeException {
    private static final long serialVersionUID = -8359509154258982033L;
    private final Object value;
    private final Class<?>[] validTypes;

    public IncompatibleTypeException(Object value, Class<?> ... validTypes) {
        this(null, value, validTypes);
    }

    public IncompatibleTypeException(String additionalMessage, Object value, Class<?> ... validTypes) {
        super(IncompatibleTypeException.constructMessage(additionalMessage, value, validTypes));
        this.value = value;
        this.validTypes = validTypes;
    }

    private static String constructMessage(String additionalMessage, Object value, Class<?> ... validTypes) {
        StringBuilder message = new StringBuilder();
        if (additionalMessage != null) {
            message.append(additionalMessage);
        }
        if (message.length() > 0) {
            message.append(" -> ");
        }
        if (validTypes != null && validTypes.length > 0) {
            message.append("Type should have been one of [");
            for (Class<?> validType : validTypes) {
                message.append(validType.getName()).append(", ");
            }
            message.delete(message.length() - 2, message.length());
            message.append("] but was ").append(value == null ? "null" : value.getClass().getName());
        } else {
            message.append("Type was ").append(value == null ? "null" : value.getClass().getName());
        }
        return message.toString();
    }

    public Object getValue() {
        return this.value;
    }

    public Class<?>[] getValidTypes() {
        return this.validTypes;
    }
}

