/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.krms.api.repository.BaseAttributeContract;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.w3c.dom.Element;

@XmlTransient
public abstract class BaseAttribute
extends AbstractDataTransferObject
implements BaseAttributeContract {
    private static final long serialVersionUID = -6126133049308968098L;
    @XmlElement(name="id", required=true)
    private final String id;
    @XmlElement(name="attributeDefinitionId", required=false)
    private final String attributeDefinitionId;
    @XmlElement(name="value", required=false)
    private final String value;
    @XmlElement(name="attributeDefinition", required=false)
    private final KrmsAttributeDefinition attributeDefinition;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    protected BaseAttribute() {
        this.id = null;
        this.attributeDefinitionId = null;
        this.value = null;
        this.attributeDefinition = null;
    }

    protected BaseAttribute(Builder builder) {
        this.id = builder.getId();
        this.attributeDefinitionId = builder.getAttributeDefinitionId();
        this.value = builder.getValue();
        this.attributeDefinition = builder.getAttributeDefinition() != null ? builder.getAttributeDefinition().build() : null;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getAttributeDefinitionId() {
        return this.attributeDefinitionId;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public KrmsAttributeDefinition getAttributeDefinition() {
        return this.attributeDefinition;
    }

    public static class Elements {
        public static final String ID = "id";
        public static final String ATTR_DEFN_ID = "attributeDefinitionId";
        public static final String VALUE = "value";
        public static final String ATTR_DEFN = "attributeDefinition";
    }

    public static abstract class Builder
    implements BaseAttributeContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = 5799994031051731535L;
        private String id;
        private String attributeDefinitionId;
        private String value;
        private KrmsAttributeDefinition.Builder attributeDefinition;

        protected Builder(String id, String attributeDefinitionId, String value) {
            this.setId(id);
            this.setAttributeDefinitionId(attributeDefinitionId);
            this.setValue(value);
        }

        protected Builder(BaseAttributeContract attr) {
            this(attr.getId(), attr.getAttributeDefinitionId(), attr.getValue());
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setAttributeDefinitionId(String attributeDefinitionId) {
            if (StringUtils.isBlank((String)attributeDefinitionId)) {
                throw new IllegalArgumentException("the attribute definition id is blank");
            }
            this.attributeDefinitionId = attributeDefinitionId;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setAttributeDefinition(KrmsAttributeDefinition.Builder attributeDefinition) {
            this.attributeDefinition = attributeDefinition;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getAttributeDefinitionId() {
            return this.attributeDefinitionId;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public KrmsAttributeDefinition.Builder getAttributeDefinition() {
            return this.attributeDefinition;
        }
    }
}

