/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.term;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.term.TermDefinition;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;

@WebService(name="termRepositoryService", targetNamespace="http://rice.kuali.org/krms/v2_0")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public interface TermRepositoryService {
    @WebMethod(operationName="findTermResolversByNamespace")
    @XmlElementWrapper(name="termResolvers", required=true)
    @XmlElement(name="termResolver", required=false)
    @WebResult(name="termResolvers")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/termResolverDefinitionType"}, key="'namespace=' + #p0")
    public List<TermResolverDefinition> findTermResolversByNamespace(@WebParam(name="namespace") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getTerm")
    @WebResult(name="term")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/termDefinitionType"}, key="'id=' + #p0")
    public TermDefinition getTerm(@WebParam(name="termId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getTermSpecificationById")
    @WebResult(name="termSpecification")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/TermSpecificationType"}, key="'id=' + #p0")
    public TermSpecificationDefinition getTermSpecificationById(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="createTermSpecification")
    @WebResult(name="termSpecification")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/TermSpecificationType", "http://rice.kuali.org/krms/v2_0/termDefinitionType"}, allEntries=true)
    public TermSpecificationDefinition createTermSpecification(@WebParam(name="termSpec") TermSpecificationDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="updateTermSpecification")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/TermSpecificationType", "http://rice.kuali.org/krms/v2_0/termDefinitionType"}, allEntries=true)
    public void updateTermSpecification(@WebParam(name="termSpec") TermSpecificationDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="deleteTermSpecification")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/TermSpecificationType", "http://rice.kuali.org/krms/v2_0/termDefinitionType"}, allEntries=true)
    public void deleteTermSpecification(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="createTerm")
    @WebResult(name="term")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/termDefinitionType"}, allEntries=true)
    public TermDefinition createTerm(@WebParam(name="termDef") TermDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="updateTerm")
    @WebResult(name="term")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/termDefinitionType"}, allEntries=true)
    public void updateTerm(@WebParam(name="termDef") TermDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="deleteTerm")
    @WebResult(name="term")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/termDefinitionType"}, allEntries=true)
    public void deleteTerm(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getTermResolverById")
    @WebResult(name="termResolver")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/termResolverDefinitionType"}, key="'id=' + #p0")
    public TermResolverDefinition getTermResolverById(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findTermResolversByOutputId")
    @XmlElementWrapper(name="termResolvers", required=true)
    @XmlElement(name="termResolver", required=false)
    @WebResult(name="termResolvers")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/termResolverDefinitionType"}, key="'id=' + #p0 + '|' + 'namespace=' + #p1")
    public List<TermResolverDefinition> findTermResolversByOutputId(@WebParam(name="id") String var1, @WebParam(name="namespace") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="createTermResolver")
    @WebResult(name="termResolver")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/termResolverDefinitionType", "http://rice.kuali.org/krms/v2_0/termDefinitionType"}, allEntries=true)
    public TermResolverDefinition createTermResolver(@WebParam(name="termResolver") TermResolverDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="updateTermResolver")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/termResolverDefinitionType", "http://rice.kuali.org/krms/v2_0/termDefinitionType"}, allEntries=true)
    public void updateTermResolver(@WebParam(name="termResolver") TermResolverDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="deleteTermResolver")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/termResolverDefinitionType", "http://rice.kuali.org/krms/v2_0/termDefinitionType"}, allEntries=true)
    public void deleteTermResolver(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getTermResolverByNameAndNamespace")
    @WebResult(name="termResolver")
    public TermResolverDefinition getTermResolverByNameAndNamespace(@WebParam(name="name") String var1, @WebParam(name="namespace") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getTermSpecificationByNameAndNamespace")
    @WebResult(name="termSpecification")
    public TermSpecificationDefinition getTermSpecificationByNameAndNamespace(@WebParam(name="name") String var1, @WebParam(name="namespace") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findAllTermSpecificationsByContextId")
    @XmlElementWrapper(name="termSpecifications", required=true)
    @XmlElement(name="termSpecification", required=false)
    @WebResult(name="termSpecifications")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/TermSpecificationType"}, key="'id=' + #p0")
    public List<TermSpecificationDefinition> findAllTermSpecificationsByContextId(@WebParam(name="contextId") String var1) throws RiceIllegalArgumentException;
}

