/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplateContract;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.NaturalLanguageTemplateAttributeBo;

public class NaturalLanguageTemplateBo
extends PersistableBusinessObjectBase
implements NaturalLanguageTemplateContract {
    private Map<String, String> attributes;
    private String languageCode;
    private String naturalLanguageUsageId;
    private String typeId;
    private String template;
    private String id;
    private boolean active;
    private Long versionNumber;
    private SequenceAccessorService sequenceAccessorService;
    private Set<NaturalLanguageTemplateAttributeBo> attributeBos;
    private static KrmsAttributeDefinitionService attributeDefinitionService;
    private static KrmsTypeRepositoryService typeRepositoryService;

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String getNaturalLanguageUsageId() {
        return this.naturalLanguageUsageId;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public void setNaturalLanguageUsageId(String naturalLanguageUsageId) {
        this.naturalLanguageUsageId = naturalLanguageUsageId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setVersionNumber(Long versionNumber) {
        this.versionNumber = versionNumber;
    }

    public void setAttributeBos(List<NaturalLanguageTemplateAttributeBo> attributeBos) {
        this.attributeBos = new HashSet<NaturalLanguageTemplateAttributeBo>(attributeBos);
    }

    public void setAttributeBos(Set<NaturalLanguageTemplateAttributeBo> attributeBos) {
        this.attributeBos = new HashSet<NaturalLanguageTemplateAttributeBo>(attributeBos);
    }

    public static NaturalLanguageTemplate to(NaturalLanguageTemplateBo naturalLanguageTemplateBo) {
        if (naturalLanguageTemplateBo == null) {
            return null;
        }
        return NaturalLanguageTemplate.Builder.create((NaturalLanguageTemplateContract)naturalLanguageTemplateBo).build();
    }

    public static NaturalLanguageTemplateBo from(NaturalLanguageTemplate naturalLanguageTemplate) {
        if (naturalLanguageTemplate == null) {
            return null;
        }
        NaturalLanguageTemplateBo naturalLanguageTemplateBo = new NaturalLanguageTemplateBo();
        naturalLanguageTemplateBo.setLanguageCode(naturalLanguageTemplate.getLanguageCode());
        naturalLanguageTemplateBo.setNaturalLanguageUsageId(naturalLanguageTemplate.getNaturalLanguageUsageId());
        naturalLanguageTemplateBo.setTypeId(naturalLanguageTemplate.getTypeId());
        naturalLanguageTemplateBo.setTemplate(naturalLanguageTemplate.getTemplate());
        naturalLanguageTemplateBo.setId(naturalLanguageTemplate.getId());
        naturalLanguageTemplateBo.setActive(naturalLanguageTemplate.isActive());
        naturalLanguageTemplateBo.setVersionNumber(naturalLanguageTemplate.getVersionNumber());
        naturalLanguageTemplateBo.setAttributeBos(NaturalLanguageTemplateBo.buildAttributeBoSet(naturalLanguageTemplate));
        return naturalLanguageTemplateBo;
    }

    private String getNewId(String table, Class clazz) {
        if (this.sequenceAccessorService == null) {
            this.sequenceAccessorService = KRADServiceLocator.getSequenceAccessorService();
        }
        Long id = this.sequenceAccessorService.getNextAvailableSequenceNumber(table, clazz);
        return id.toString();
    }

    public void setSequenceAccessorService(SequenceAccessorService sas) {
        this.sequenceAccessorService = sas;
    }

    public SequenceAccessorService getSequenceAccessorService() {
        return this.sequenceAccessorService;
    }

    public Map<String, String> getAttributes() {
        if (this.attributeBos == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> attributes = new HashMap<String, String>(this.attributeBos.size());
        for (NaturalLanguageTemplateAttributeBo attr : this.attributeBos) {
            attributes.put(attr.getAttributeDefinition().getName(), attr.getValue());
        }
        return attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributeBos = new HashSet<NaturalLanguageTemplateAttributeBo>();
        if (!StringUtils.isBlank((String)this.typeId)) {
            List<KrmsAttributeDefinition> attributeDefinitions = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService().findAttributeDefinitionsByType(this.getTypeId());
            HashMap<String, KrmsAttributeDefinition> attributeDefinitionsByName = new HashMap<String, KrmsAttributeDefinition>(attributeDefinitions.size());
            if (attributeDefinitions != null) {
                for (KrmsAttributeDefinition krmsAttributeDefinition : attributeDefinitions) {
                    attributeDefinitionsByName.put(krmsAttributeDefinition.getName(), krmsAttributeDefinition);
                }
            }
            for (Map.Entry entry : attributes.entrySet()) {
                KrmsAttributeDefinition attributeDefinition = (KrmsAttributeDefinition)attributeDefinitionsByName.get(entry.getKey());
                NaturalLanguageTemplateAttributeBo attributeBo = new NaturalLanguageTemplateAttributeBo();
                attributeBo.setNaturalLanguageTemplateId(this.getId());
                attributeBo.setAttributeDefinitionId(attributeDefinition == null ? null : attributeDefinition.getId());
                attributeBo.setValue((String)entry.getValue());
                attributeBo.setAttributeDefinition(KrmsAttributeDefinitionBo.from(attributeDefinition));
                this.attributeBos.add(attributeBo);
            }
        }
    }

    private static Collection<NaturalLanguageTemplateAttributeBo> buildAttributes(NaturalLanguageTemplate im, Collection<NaturalLanguageTemplateAttributeBo> attributes) {
        KrmsTypeDefinition krmsTypeDefinition = NaturalLanguageTemplateBo.getTypeRepositoryService().getTypeById(im.getTypeId());
        if (im.getAttributes() != null) {
            for (Map.Entry entry : im.getAttributes().entrySet()) {
                KrmsAttributeDefinition attrDef = NaturalLanguageTemplateBo.getAttributeDefinitionService().getAttributeDefinitionByNameAndNamespace((String)entry.getKey(), krmsTypeDefinition.getNamespace());
                if (attrDef != null) {
                    NaturalLanguageTemplateAttributeBo attributeBo = new NaturalLanguageTemplateAttributeBo();
                    attributeBo.setNaturalLanguageTemplateId(im.getId());
                    attributeBo.setAttributeDefinitionId(attrDef.getId());
                    attributeBo.setValue((String)entry.getValue());
                    attributeBo.setAttributeDefinition(KrmsAttributeDefinitionBo.from(attrDef));
                    attributes.add(attributeBo);
                    continue;
                }
                throw new RiceIllegalStateException("there is no attribute definition with the name '" + (String)entry.getKey() + "' that is valid for the naturalLanguageTemplate type with id = '" + im.getTypeId() + "'");
            }
        }
        return attributes;
    }

    private static Set<NaturalLanguageTemplateAttributeBo> buildAttributeBoSet(NaturalLanguageTemplate im) {
        HashSet<NaturalLanguageTemplateAttributeBo> attributes = new HashSet<NaturalLanguageTemplateAttributeBo>();
        return (Set)NaturalLanguageTemplateBo.buildAttributes(im, attributes);
    }

    private static List<NaturalLanguageTemplateAttributeBo> buildAttributeBoList(NaturalLanguageTemplate im) {
        LinkedList<NaturalLanguageTemplateAttributeBo> attributes = new LinkedList<NaturalLanguageTemplateAttributeBo>();
        return (List)NaturalLanguageTemplateBo.buildAttributes(im, attributes);
    }

    public static void setAttributeDefinitionService(KrmsAttributeDefinitionService attributeDefinitionService) {
        NaturalLanguageTemplateBo.attributeDefinitionService = attributeDefinitionService;
    }

    public static KrmsTypeRepositoryService getTypeRepositoryService() {
        if (typeRepositoryService == null) {
            typeRepositoryService = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService();
        }
        return typeRepositoryService;
    }

    public static void setTypeRepositoryService(KrmsTypeRepositoryService typeRepositoryService) {
        NaturalLanguageTemplateBo.typeRepositoryService = typeRepositoryService;
    }

    public static KrmsAttributeDefinitionService getAttributeDefinitionService() {
        if (attributeDefinitionService == null) {
            attributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        }
        return attributeDefinitionService;
    }
}

