/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinitionContract;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.impl.repository.ActionAttributeBo;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.PropositionBo;
import org.kuali.rice.krms.impl.repository.RuleAttributeBo;
import org.kuali.rice.krms.impl.repository.RuleBo;
import org.kuali.rice.krms.impl.repository.RuleBoService;

public final class RuleBoServiceImpl
implements RuleBoService {
    private BusinessObjectService businessObjectService;
    private KrmsAttributeDefinitionService attributeDefinitionService;

    @Override
    public RuleDefinition createRule(RuleDefinition rule) {
        String namespaceKey;
        if (rule == null) {
            throw new IllegalArgumentException("rule is null");
        }
        String nameKey = rule.getName();
        RuleDefinition existing = this.getRuleByNameAndNamespace(nameKey, namespaceKey = rule.getNamespace());
        if (existing != null) {
            throw new IllegalStateException("the rule to create already exists: " + rule);
        }
        RuleBo ruleBo = RuleBo.from(rule);
        this.businessObjectService.save((PersistableBusinessObject)ruleBo);
        return RuleBo.to(ruleBo);
    }

    @Override
    public void updateRule(RuleDefinition rule) {
        RuleDefinition toUpdate;
        if (rule == null) {
            throw new IllegalArgumentException("rule is null");
        }
        String ruleIdKey = rule.getId();
        RuleBo existing = (RuleBo)this.businessObjectService.findBySinglePrimaryKey(RuleBo.class, (Object)ruleIdKey);
        if (existing == null) {
            throw new IllegalStateException("the rule does not exist: " + rule);
        }
        if (!existing.getId().equals(rule.getId())) {
            RuleDefinition.Builder builder = RuleDefinition.Builder.create((RuleDefinitionContract)rule);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = rule;
        }
        RuleBo boToUpdate = RuleBo.from(toUpdate);
        this.updateActionAttributes(boToUpdate.getActions());
        HashMap<String, String> fields = new HashMap<String, String>(1);
        fields.put("ruleId", toUpdate.getId());
        this.businessObjectService.deleteMatching(RuleAttributeBo.class, fields);
        this.businessObjectService.save((PersistableBusinessObject)boToUpdate);
    }

    @Override
    public void deleteRule(String ruleId) {
        if (ruleId == null) {
            throw new IllegalArgumentException("ruleId is null");
        }
        RuleDefinition existing = this.getRuleByRuleId(ruleId);
        if (existing == null) {
            throw new IllegalStateException("the Rule to delete does not exists: " + ruleId);
        }
        this.businessObjectService.delete((PersistableBusinessObject)this.from(existing));
    }

    @Override
    public RuleDefinition getRuleByRuleId(String ruleId) {
        if (StringUtils.isBlank((String)ruleId)) {
            throw new IllegalArgumentException("rule id is null");
        }
        RuleBo bo = (RuleBo)this.businessObjectService.findBySinglePrimaryKey(RuleBo.class, (Object)ruleId);
        return RuleBo.to(bo);
    }

    @Override
    public RuleDefinition getRuleByNameAndNamespace(String name, String namespace) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is null or blank");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("namespace", namespace);
        RuleBo myRule = (RuleBo)this.businessObjectService.findByPrimaryKey(RuleBo.class, Collections.unmodifiableMap(map));
        return RuleBo.to(myRule);
    }

    public RuleAttributeBo getRuleAttributeById(String attrId) {
        if (StringUtils.isBlank((String)attrId)) {
            return null;
        }
        RuleAttributeBo bo = (RuleAttributeBo)this.businessObjectService.findBySinglePrimaryKey(RuleAttributeBo.class, (Object)attrId);
        return bo;
    }

    public RuleBo from(RuleDefinition rule) {
        if (rule == null) {
            return null;
        }
        RuleBo ruleBo = new RuleBo();
        ruleBo.setName(rule.getName());
        ruleBo.setDescription(rule.getDescription());
        ruleBo.setNamespace(rule.getNamespace());
        ruleBo.setTypeId(rule.getTypeId());
        ruleBo.setPropId(rule.getPropId());
        ruleBo.setProposition(PropositionBo.from(rule.getProposition()));
        ruleBo.setId(rule.getId());
        ruleBo.setActive(rule.isActive());
        ruleBo.setVersionNumber(rule.getVersionNumber());
        ruleBo.setActions(this.buildActionBoList(rule));
        ruleBo.setAttributeBos(this.buildAttributeBoList(rule));
        return ruleBo;
    }

    private Set<RuleAttributeBo> buildAttributeBo(RuleDefinition im) {
        HashSet<RuleAttributeBo> attributes = new HashSet<RuleAttributeBo>();
        HashMap<String, KrmsAttributeDefinition> attributeDefinitionMap = new HashMap<String, KrmsAttributeDefinition>();
        List<KrmsAttributeDefinition> attributeDefinitions = this.getAttributeDefinitionService().findAttributeDefinitionsByType(im.getTypeId());
        for (KrmsAttributeDefinition krmsAttributeDefinition : attributeDefinitions) {
            attributeDefinitionMap.put(krmsAttributeDefinition.getName(), krmsAttributeDefinition);
        }
        if (im.getAttributes() != null) {
            for (Map.Entry entry : im.getAttributes().entrySet()) {
                KrmsAttributeDefinition attrDef = (KrmsAttributeDefinition)attributeDefinitionMap.get(entry.getKey());
                if (attrDef != null) {
                    RuleAttributeBo attributeBo = new RuleAttributeBo();
                    attributeBo.setRuleId(im.getId());
                    attributeBo.setAttributeDefinitionId(attrDef.getId());
                    attributeBo.setValue((String)entry.getValue());
                    attributeBo.setAttributeDefinition(KrmsAttributeDefinitionBo.from(attrDef));
                    attributes.add(attributeBo);
                    continue;
                }
                throw new RiceIllegalStateException("there is no attribute definition with the name '" + (String)entry.getKey() + "' that is valid for the rule type with id = '" + im.getTypeId() + "'");
            }
        }
        return attributes;
    }

    private List<RuleAttributeBo> buildAttributeBoList(RuleDefinition im) {
        LinkedList<RuleAttributeBo> attributes = new LinkedList<RuleAttributeBo>();
        HashMap<String, KrmsAttributeDefinition> attributeDefinitionMap = new HashMap<String, KrmsAttributeDefinition>();
        List<KrmsAttributeDefinition> attributeDefinitions = this.getAttributeDefinitionService().findAttributeDefinitionsByType(im.getTypeId());
        for (KrmsAttributeDefinition krmsAttributeDefinition : attributeDefinitions) {
            attributeDefinitionMap.put(krmsAttributeDefinition.getName(), krmsAttributeDefinition);
        }
        if (im.getAttributes() != null) {
            for (Map.Entry entry : im.getAttributes().entrySet()) {
                KrmsAttributeDefinition attrDef = (KrmsAttributeDefinition)attributeDefinitionMap.get(entry.getKey());
                if (attrDef != null) {
                    RuleAttributeBo attributeBo = new RuleAttributeBo();
                    attributeBo.setRuleId(im.getId());
                    attributeBo.setAttributeDefinitionId(attrDef.getId());
                    attributeBo.setValue((String)entry.getValue());
                    attributeBo.setAttributeDefinition(KrmsAttributeDefinitionBo.from(attrDef));
                    attributes.add(attributeBo);
                    continue;
                }
                throw new RiceIllegalStateException("there is no attribute definition with the name '" + (String)entry.getKey() + "' that is valid for the rule type with id = '" + im.getTypeId() + "'");
            }
        }
        return attributes;
    }

    private List<ActionBo> buildActionBoList(RuleDefinition im) {
        LinkedList<ActionBo> actions = new LinkedList<ActionBo>();
        for (ActionDefinition actionDefinition : im.getActions()) {
            actions.add(ActionBo.from(actionDefinition));
        }
        this.updateActionAttributes(actions);
        return actions;
    }

    private void updateActionAttributes(List<ActionBo> actionBos) {
        for (ActionBo action : actionBos) {
            for (ActionAttributeBo aa : action.getAttributeBos()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("actionId", action.getId());
                Collection aaBos = this.businessObjectService.findMatching(ActionAttributeBo.class, map);
                for (ActionAttributeBo aaBo : aaBos) {
                    if (!aaBo.getAttributeDefinitionId().equals(aa.getAttributeDefinitionId())) continue;
                    aa.setId(aaBo.getId());
                    aa.setVersionNumber(aaBo.getVersionNumber());
                }
            }
        }
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public List<RuleDefinition> convertListOfBosToImmutables(Collection<RuleBo> ruleBos) {
        ArrayList<RuleDefinition> rules = new ArrayList<RuleDefinition>();
        for (RuleBo bo : ruleBos) {
            RuleDefinition rule = RuleBo.to(bo);
            rules.add(rule);
        }
        return Collections.unmodifiableList(rules);
    }

    protected KrmsAttributeDefinitionService getAttributeDefinitionService() {
        if (this.attributeDefinitionService == null) {
            this.attributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        }
        return this.attributeDefinitionService;
    }
}

